/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.db.TableSchema;
import org.apache.nifi.processors.standard.db.impl.OracleDatabaseAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOracleDatabaseAdapter {
    private final DatabaseAdapter db = new OracleDatabaseAdapter();

    @Test
    public void testGeneration() {
        String sql1 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "", null, null);
        String expected1 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename";
        Assertions.assertEquals((Object)expected1, (Object)sql1);
        String sql2 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "that='some\"' value'", "", null, null);
        String expected2 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE that='some\"' value'";
        Assertions.assertEquals((Object)expected2, (Object)sql2);
        String sql3 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "that='some\"' value'", "might DESC", null, null);
        String expected3 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE that='some\"' value' ORDER BY might DESC";
        Assertions.assertEquals((Object)expected3, (Object)sql3);
        String sql4 = this.db.getSelectStatement("database.tablename", "", "that='some\"' value'", "might DESC", null, null);
        String expected4 = "SELECT * FROM database.tablename WHERE that='some\"' value' ORDER BY might DESC";
        Assertions.assertEquals((Object)expected4, (Object)sql4);
    }

    @Test
    public void testNoTableName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.db.getSelectStatement("", "some(set),of(columns),that,might,contain,methods,a.*", "", "", null, null));
    }

    @Test
    public void testPagingQuery() {
        String sql1 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "contain", Long.valueOf(100L), Long.valueOf(0L));
        String expected1 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM (SELECT a.*, ROWNUM rnum FROM (SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename ORDER BY contain) a WHERE ROWNUM <= 100) WHERE rnum > 0";
        Assertions.assertEquals((Object)expected1, (Object)sql1);
        String sql2 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "contain", Long.valueOf(10000L), Long.valueOf(123456L));
        String expected2 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM (SELECT a.*, ROWNUM rnum FROM (SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename ORDER BY contain) a WHERE ROWNUM <= 133456) WHERE rnum > 123456";
        Assertions.assertEquals((Object)expected2, (Object)sql2);
        String sql3 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "methods='strange'", "contain", Long.valueOf(10000L), Long.valueOf(123456L));
        String expected3 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM (SELECT a.*, ROWNUM rnum FROM (SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE methods='strange' ORDER BY contain) a WHERE ROWNUM <= 133456) WHERE rnum > 123456";
        Assertions.assertEquals((Object)expected3, (Object)sql3);
        String sql4 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "", Long.valueOf(100L), null);
        String expected4 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM (SELECT a.*, ROWNUM rnum FROM (SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename) a WHERE ROWNUM <= 100) WHERE rnum > 0";
        Assertions.assertEquals((Object)expected4, (Object)sql4);
    }

    @Test
    public void testPagingQueryUsingColumnValuesForPartitioning() {
        String sql1 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "1=1", "contain", Long.valueOf(100L), Long.valueOf(0L), "contain");
        String expected1 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE 1=1 AND contain >= 0 AND contain < 100";
        Assertions.assertEquals((Object)expected1, (Object)sql1);
        String sql2 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "1=1", "contain", Long.valueOf(10000L), Long.valueOf(123456L), "contain");
        String expected2 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE 1=1 AND contain >= 123456 AND contain < 133456";
        Assertions.assertEquals((Object)expected2, (Object)sql2);
        String sql3 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "methods='strange'", "contain", Long.valueOf(10000L), Long.valueOf(123456L), "contain");
        String expected3 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE methods='strange' AND contain >= 123456 AND contain < 133456";
        Assertions.assertEquals((Object)expected3, (Object)sql3);
        String sql4 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "", Long.valueOf(100L), null, "contain");
        String expected4 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename";
        Assertions.assertEquals((Object)expected4, (Object)sql4);
    }

    @Test
    public void testGetCreateTableStatement() {
        Assertions.assertTrue((boolean)this.db.supportsCreateTableIfNotExists());
        List<ColumnDescription> columns = Arrays.asList(new ColumnDescription("col1", 4, true, Integer.valueOf(4), false), new ColumnDescription("col2", 12, false, Integer.valueOf(2000), true));
        TableSchema tableSchema = new TableSchema("USERS", null, "TEST_TABLE", columns, true, Collections.singleton("COL1"), this.db.getColumnQuoteString());
        String expectedStatement = "DECLARE\n\tsql_stmt long;\nBEGIN\n\tsql_stmt:='CREATE TABLE \"USERS\".\"TEST_TABLE\" (\"col1\" INTEGER NOT NULL, \"col2\" VARCHAR2(2000))';\nEXECUTE IMMEDIATE sql_stmt;\nEXCEPTION\n\tWHEN OTHERS THEN\n\t\tIF SQLCODE = -955 THEN\n\t\t\tNULL;\n\t\tELSE\n\t\t\tRAISE;\n\t\tEND IF;\nEND;";
        String actualStatement = this.db.getCreateTableStatement(tableSchema, true, true);
        Assertions.assertEquals((Object)expectedStatement, (Object)actualStatement);
    }
}

