/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processors.standard.SplitJson;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestSplitJson {
    private static final Path JSON_SNIPPET = Paths.get("src/test/resources/TestJson/json-sample.json", new String[0]);
    private static final Path XML_SNIPPET = Paths.get("src/test/resources/TestXml/xml-snippet.xml", new String[0]);

    @Test
    public void testInvalidJsonPath() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$..");
        testRunner.assertNotValid();
    }

    @Test
    public void testInvalidJsonDocument() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(SplitJson.REL_FAILURE, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_FAILURE).get(0);
        out.assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testSplit_nonArrayResult() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$[0]._id");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        Relationship expectedRel = SplitJson.REL_FAILURE;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0);
        out.assertContentEquals(JSON_SNIPPET);
    }

    @Test
    public void testSplit_arrayResult_oneValue() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$[0].range[?(@ == 0)]");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        testRunner.assertTransferCount(SplitJson.REL_ORIGINAL, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        testRunner.assertTransferCount(SplitJson.REL_SPLIT, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_ORIGINAL).get(0)).assertContentEquals(JSON_SNIPPET);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_SPLIT).get(0)).assertContentEquals("0");
    }

    @Test
    public void testSplit_arrayResult_multipleValues() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$[0].range");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        int numSplitsExpected = 10;
        testRunner.assertTransferCount(SplitJson.REL_ORIGINAL, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), String.valueOf(numSplitsExpected));
        testRunner.assertTransferCount(SplitJson.REL_SPLIT, numSplitsExpected);
        MockFlowFile originalOut = (MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_ORIGINAL).get(0);
        originalOut.assertContentEquals(JSON_SNIPPET);
    }

    @Test
    public void testSplit_change_jsonpath() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$[0].range");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        int numSplitsExpected = 10;
        testRunner.assertTransferCount(SplitJson.REL_ORIGINAL, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), String.valueOf(numSplitsExpected));
        testRunner.assertTransferCount(SplitJson.REL_SPLIT, numSplitsExpected);
        MockFlowFile originalOut = (MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_ORIGINAL).get(0);
        originalOut.assertContentEquals(JSON_SNIPPET);
        testRunner.clearTransferState();
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$[*].name");
        testRunner.enqueue(JSON_SNIPPET, Collections.singletonMap(CoreAttributes.FILENAME.key(), "test.json"));
        testRunner.run();
        testRunner.assertTransferCount(SplitJson.REL_ORIGINAL, 1);
        MockFlowFile originalFlowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_ORIGINAL).get(0);
        originalFlowFile.assertAttributeExists(FragmentAttributes.FRAGMENT_ID.key());
        originalFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "7");
        originalFlowFile.assertContentEquals(JSON_SNIPPET);
        testRunner.assertTransferCount(SplitJson.REL_SPLIT, 7);
        MockFlowFile flowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_SPLIT).get(0);
        flowFile.assertContentEquals("{\"first\":\"Shaffer\",\"last\":\"Pearson\"}");
    }

    @Test
    public void testSplit_arrayResult_nonScalarValues() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$[*].name");
        testRunner.enqueue(JSON_SNIPPET, (Map)new HashMap<String, String>(){
            {
                this.put(CoreAttributes.FILENAME.key(), "test.json");
            }
        });
        testRunner.run();
        testRunner.assertTransferCount(SplitJson.REL_ORIGINAL, 1);
        MockFlowFile originalFlowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_ORIGINAL).get(0);
        originalFlowFile.assertAttributeExists(FragmentAttributes.FRAGMENT_ID.key());
        originalFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "7");
        originalFlowFile.assertContentEquals(JSON_SNIPPET);
        testRunner.assertTransferCount(SplitJson.REL_SPLIT, 7);
        MockFlowFile flowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_SPLIT).get(0);
        flowFile.assertContentEquals("{\"first\":\"Shaffer\",\"last\":\"Pearson\"}");
        flowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "7");
        flowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "0");
        flowFile.assertAttributeEquals(FragmentAttributes.SEGMENT_ORIGINAL_FILENAME.key(), "test.json");
        flowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_SPLIT).get(6);
        flowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "7");
        flowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "6");
        flowFile.assertAttributeEquals(FragmentAttributes.SEGMENT_ORIGINAL_FILENAME.key(), "test.json");
    }

    @Test
    public void testSplit_pathNotFound() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$.nonexistent");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        testRunner.assertTransferCount(SplitJson.REL_FAILURE, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_FAILURE).get(0)).assertContentEquals(JSON_SNIPPET);
    }

    @Test
    public void testSplit_pathToNullValue() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$.nullField");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.write(ff, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                try (BufferedOutputStream outputStream = new BufferedOutputStream(out);){
                    ((OutputStream)outputStream).write("{\"stringField\": \"String Value\", \"nullField\": null}".getBytes(StandardCharsets.UTF_8));
                }
            }
        });
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        testRunner.assertTransferCount(SplitJson.REL_FAILURE, 1);
    }

    @Test
    public void testSplit_pathToArrayWithNulls_emptyStringRepresentation() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$.arrayOfNulls");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.write(ff, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                try (BufferedOutputStream outputStream = new BufferedOutputStream(out);){
                    ((OutputStream)outputStream).write("{\"stringField\": \"String Value\", \"arrayOfNulls\": [null, null, null]}".getBytes(StandardCharsets.UTF_8));
                }
            }
        });
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        int expectedFiles = 3;
        testRunner.assertTransferCount(SplitJson.REL_SPLIT, expectedFiles);
        for (int i = 0; i < expectedFiles; ++i) {
            ((MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_SPLIT).get(i)).assertContentEquals("");
        }
    }

    @Test
    public void testSplit_pathToArrayWithNulls_nullStringRepresentation() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$.arrayOfNulls");
        testRunner.setProperty(SplitJson.NULL_VALUE_DEFAULT_REPRESENTATION, "the string 'null'");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.write(ff, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                try (BufferedOutputStream outputStream = new BufferedOutputStream(out);){
                    ((OutputStream)outputStream).write("{\"stringField\": \"String Value\", \"arrayOfNulls\": [null, null, null]}".getBytes(StandardCharsets.UTF_8));
                }
            }
        });
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        int expectedFiles = 3;
        testRunner.assertTransferCount(SplitJson.REL_SPLIT, expectedFiles);
        for (int i = 0; i < expectedFiles; ++i) {
            ((MockFlowFile)testRunner.getFlowFilesForRelationship(SplitJson.REL_SPLIT).get(i)).assertContentEquals("null");
        }
    }

    @Test
    public void testSplit_pathToInputStringNullValue() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SplitJson());
        testRunner.setProperty(SplitJson.ARRAY_JSON_PATH_EXPRESSION, "$.*");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.write(ff, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                try (BufferedOutputStream outputStream = new BufferedOutputStream(out);){
                    ((OutputStream)outputStream).write("null".getBytes(StandardCharsets.UTF_8));
                }
            }
        });
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        testRunner.assertTransferCount(SplitJson.REL_FAILURE, 1);
    }
}

