/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Arrays;
import java.util.List;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.standard.AbstractExecuteSQL;
import org.apache.nifi.processors.standard.sql.SqlWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAbstractExecuteSQL {
    private AbstractExecuteSQL testSubject;

    @BeforeEach
    public void setUp() throws Exception {
        this.testSubject = new AbstractExecuteSQL(){

            protected SqlWriter configureSqlWriter(ProcessSession session, ProcessContext context, FlowFile fileToProcess) {
                return null;
            }
        };
    }

    @Test
    public void testGetQueries() {
        String queriesString = "SOME kind of PRE-QUERY statement;\nAND another PRE-QUERY statment;";
        List<String> expected = Arrays.asList("SOME kind of PRE-QUERY statement", "AND another PRE-QUERY statment");
        List actual = this.testSubject.getQueries(queriesString);
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testGetQueriesWithEscapedSemicolon() {
        String queriesString = "SET COMPLEX_KEY = 'KEYPART_1=value1\\;KEYPART_2=<valuePart2>\\;\u2019 FOR SESSION;\nSOME other PRE-QUERY statement;\nAND another PRE-QUERY statment;";
        List<String> expected = Arrays.asList("SET COMPLEX_KEY = 'KEYPART_1=value1;KEYPART_2=<valuePart2>;\u2019 FOR SESSION", "SOME other PRE-QUERY statement", "AND another PRE-QUERY statment");
        List actual = this.testSubject.getQueries(queriesString);
        Assertions.assertEquals(expected, (Object)actual);
    }
}

