/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.frame;

import org.apache.nifi.processors.standard.relp.frame.RELPFrame;
import org.apache.nifi.processors.standard.relp.frame.RELPFrameException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRELPFrame {
    @Test
    public void testInvalidTxnr() {
        Assertions.assertThrows(RELPFrameException.class, () -> new RELPFrame.Builder().command("command").dataLength(5).data(new byte[5]).build());
    }

    @Test
    public void testInvalidCommand() {
        Assertions.assertThrows(RELPFrameException.class, () -> new RELPFrame.Builder().txnr(1L).dataLength(5).data(new byte[5]).build());
    }

    @Test
    public void testBlankCommand() {
        Assertions.assertThrows(RELPFrameException.class, () -> new RELPFrame.Builder().txnr(1L).command("  ").dataLength(5).data(new byte[5]).build());
    }

    @Test
    public void testInvalidDataLength() {
        Assertions.assertThrows(RELPFrameException.class, () -> new RELPFrame.Builder().txnr(1L).command("command").data(new byte[5]).build());
    }

    @Test
    public void testInvalidData() {
        Assertions.assertThrows(RELPFrameException.class, () -> new RELPFrame.Builder().txnr(1L).command("command").dataLength(5).data(null).build());
    }
}

