/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.processors.standard.DuplicateFlowFile;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestDuplicateFlowFile {
    @Test
    public void test() {
        int numCopies = 100;
        TestRunner runner = TestRunners.newTestRunner(DuplicateFlowFile.class);
        runner.setProperty(DuplicateFlowFile.NUM_COPIES, Integer.toString(100));
        runner.enqueue("hello".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(DuplicateFlowFile.REL_SUCCESS, 101);
        List flowFiles = runner.getFlowFilesForRelationship(DuplicateFlowFile.REL_SUCCESS);
        for (int i = 1; i <= 100; ++i) {
            ((MockFlowFile)flowFiles.get(i - 1)).assertAttributeEquals("copy.index", Integer.toString(i));
        }
        ((MockFlowFile)flowFiles.get(100)).assertAttributeEquals("copy.index", "0");
    }

    @Test
    public void testNumberOfCopiesEL() {
        TestRunner runner = TestRunners.newTestRunner(DuplicateFlowFile.class);
        runner.setProperty(DuplicateFlowFile.NUM_COPIES, "${num.copies}");
        runner.enqueue("hello".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("num.copies", "100");
            }
        });
        runner.run();
        runner.assertAllFlowFilesTransferred(DuplicateFlowFile.REL_SUCCESS, 101);
    }
}

