/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.AbstractDatabaseFetchProcessor;
import org.apache.nifi.processors.standard.GenerateTableFetch;
import org.apache.nifi.processors.standard.db.impl.DerbyDatabaseAdapter;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockProcessSession;
import org.apache.nifi.util.MockSessionFactory;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.util.file.FileUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestGenerateTableFetch {
    TestRunner runner;
    GenerateTableFetch processor;
    DBCPServiceSimpleImpl dbcp;
    private static final String DB_LOCATION = "target/db_gtf";

    @BeforeAll
    public static void setupBeforeClass() {
        System.setProperty("derby.stream.error.file", "target/derby.log");
        File dbLocation = new File(DB_LOCATION);
        try {
            FileUtils.deleteFile((File)dbLocation, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @AfterAll
    public static void cleanUpAfterClass() throws Exception {
        try {
            DriverManager.getConnection("jdbc:derby:target/db_gtf;shutdown=true");
        }
        catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
            // empty catch block
        }
        File dbLocation = new File(DB_LOCATION);
        try {
            FileUtils.deleteFile((File)dbLocation, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.clearProperty("derby.stream.error.file");
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.processor = new GenerateTableFetch();
        this.dbcp = (DBCPServiceSimpleImpl)((Object)Mockito.spy((Object)((Object)new DBCPServiceSimpleImpl())));
        HashMap dbcpProperties = new HashMap();
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        this.runner.addControllerService("dbcp", (ControllerService)this.dbcp, dbcpProperties);
        this.runner.enableControllerService((ControllerService)this.dbcp);
        this.runner.setProperty(GenerateTableFetch.DBCP_SERVICE, "dbcp");
        this.runner.setProperty(AbstractDatabaseFetchProcessor.DB_TYPE, new DerbyDatabaseAdapter().getName());
    }

    @Test
    public void testAddedRows() throws SQLException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.run();
        MockSessionFactory runnerSessionFactory = (MockSessionFactory)this.runner.getProcessSessionFactory();
        Set sessions = runnerSessionFactory.getCreatedSessions();
        for (MockProcessSession session : sessions) {
            session.assertCommitted();
        }
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID <= 2 ORDER BY ID FETCH NEXT 10000 ROWS ONLY", (Object)query);
        flowFile.assertAttributeEquals(AbstractDatabaseFetchProcessor.FRAGMENT_INDEX, "0");
        flowFile.assertAttributeEquals(AbstractDatabaseFetchProcessor.FRAGMENT_COUNT, "1");
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (3, 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (4, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (5, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        List resultFFs = this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS);
        MockFlowFile ff1 = (MockFlowFile)resultFFs.get(0);
        MockFlowFile ff2 = (MockFlowFile)resultFFs.get(1);
        Assertions.assertEquals((Object)ff1.getAttribute(AbstractDatabaseFetchProcessor.FRAGMENT_ID), (Object)ff2.getAttribute(AbstractDatabaseFetchProcessor.FRAGMENT_ID));
        Assertions.assertEquals((Object)ff1.getAttribute(AbstractDatabaseFetchProcessor.FRAGMENT_INDEX), (Object)"0");
        Assertions.assertEquals((Object)ff1.getAttribute(AbstractDatabaseFetchProcessor.FRAGMENT_COUNT), (Object)"2");
        Assertions.assertEquals((Object)ff2.getAttribute(AbstractDatabaseFetchProcessor.FRAGMENT_INDEX), (Object)"1");
        Assertions.assertEquals((Object)ff2.getAttribute(AbstractDatabaseFetchProcessor.FRAGMENT_COUNT), (Object)"2");
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 2 AND ID <= 5 ORDER BY ID FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 2 AND ID <= 5 ORDER BY ID OFFSET 2 ROWS FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (6, 'Mr. NiFi', 1.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 5 AND ID <= 6 ORDER BY ID FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "name");
        this.runner.setProperty(GenerateTableFetch.COLUMN_NAMES, "id, name, scale, created_on");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 4);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"SELECT id, name, scale, created_on FROM TEST_QUERY_DB_TABLE WHERE name <= 'Mr. NiFi' ORDER BY name FETCH NEXT 2 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        Assertions.assertEquals((Object)"SELECT id, name, scale, created_on FROM TEST_QUERY_DB_TABLE WHERE name <= 'Mr. NiFi' ORDER BY name OFFSET 2 ROWS FETCH NEXT 2 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(2);
        Assertions.assertEquals((Object)"SELECT id, name, scale, created_on FROM TEST_QUERY_DB_TABLE WHERE name <= 'Mr. NiFi' ORDER BY name OFFSET 4 ROWS FETCH NEXT 2 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(3);
        Assertions.assertEquals((Object)"SELECT id, name, scale, created_on FROM TEST_QUERY_DB_TABLE WHERE name <= 'Mr. NiFi' ORDER BY name OFFSET 6 ROWS FETCH NEXT 2 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("generatetablefetch.tableName"));
        Assertions.assertEquals((Object)"id, name, scale, created_on", (Object)flowFile.getAttribute("generatetablefetch.columnNames"));
        Assertions.assertEquals((Object)"name <= 'Mr. NiFi'", (Object)flowFile.getAttribute("generatetablefetch.whereClause"));
        Assertions.assertEquals((Object)"name", (Object)flowFile.getAttribute("generatetablefetch.maxColumnNames"));
        Assertions.assertEquals((Object)"2", (Object)flowFile.getAttribute("generatetablefetch.limit"));
        Assertions.assertEquals((Object)"6", (Object)flowFile.getAttribute("generatetablefetch.offset"));
        this.runner.clearTransferState();
    }

    @Test
    public void testAddedRowsTwoTables() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID <= 2 ORDER BY ID FETCH NEXT 10000 ROWS ONLY", (Object)query);
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("create table TEST_QUERY_DB_TABLE2 (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE2 WHERE ID <= 2 ORDER BY ID FETCH NEXT 10000 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (3, 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (4, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (5, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE2 WHERE ID > 2 AND ID <= 5 ORDER BY ID FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE2 WHERE ID > 2 AND ID <= 5 ORDER BY ID OFFSET 2 ROWS FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
    }

    @Test
    public void testAddedRowsRightBounded() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID <= 2 ORDER BY ID FETCH NEXT 10000 ROWS ONLY", (Object)query);
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (3, 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (4, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (5, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 2 AND ID <= 5 ORDER BY ID FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 2 AND ID <= 5 ORDER BY ID OFFSET 2 ROWS FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (6, 'Mr. NiFi', 1.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 5 AND ID <= 6 ORDER BY ID FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "name");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 4);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE name <= 'Mr. NiFi' ORDER BY name FETCH NEXT 2 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE name <= 'Mr. NiFi' ORDER BY name OFFSET 2 ROWS FETCH NEXT 2 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(2);
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE name <= 'Mr. NiFi' ORDER BY name OFFSET 4 ROWS FETCH NEXT 2 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(3);
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE name <= 'Mr. NiFi' ORDER BY name OFFSET 6 ROWS FETCH NEXT 2 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        this.runner.clearTransferState();
    }

    @Test
    public void testAddedRowsTimestampRightBounded() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "created_on");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE created_on <= '2010-01-01 00:00:00.0' ORDER BY created_on FETCH NEXT 10000 ROWS ONLY", (Object)query);
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (3, 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (4, 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (5, 'Marty Johnson', 15.0, '2011-01-01 02:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (6, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (7, 'James Johnson', 16.0, '2011-01-01 04:23:34.236')");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE created_on > '2010-01-01 00:00:00.0' AND created_on <= '2011-01-01 04:23:34.236' ORDER BY created_on FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE created_on > '2010-01-01 00:00:00.0' AND created_on <= '2011-01-01 04:23:34.236' ORDER BY created_on OFFSET 2 ROWS FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (8, 'Mr. NiFi', 1.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE created_on > '2011-01-01 04:23:34.236' AND created_on <= '2012-01-01 03:23:34.234' ORDER BY created_on FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
    }

    @Test
    public void testOnePartition() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (0, 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (1, 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (2, 0)");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "0");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(GenerateTableFetch.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(GenerateTableFetch.REL_SUCCESS).get(0);
        flowFile.assertContentEquals("SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID <= 2");
        flowFile.assertAttributeExists("generatetablefetch.limit");
        flowFile.assertAttributeEquals("generatetablefetch.limit", null);
        this.runner.clearTransferState();
    }

    @Test
    public void testFlowFileGeneratedOnZeroResults() throws SQLException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, bucket integer not null)");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.COLUMN_NAMES, "ID,BUCKET");
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "1");
        this.runner.setProperty(GenerateTableFetch.OUTPUT_EMPTY_FLOWFILE_ON_ZERO_RESULTS, "false");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(GenerateTableFetch.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        this.runner.setProperty(GenerateTableFetch.OUTPUT_EMPTY_FLOWFILE_ON_ZERO_RESULTS, "true");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(GenerateTableFetch.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(GenerateTableFetch.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("generatetablefetch.tableName"));
        Assertions.assertEquals((Object)"ID,BUCKET", (Object)flowFile.getAttribute("generatetablefetch.columnNames"));
        Assertions.assertEquals((Object)"1=1", (Object)flowFile.getAttribute("generatetablefetch.whereClause"));
        Assertions.assertEquals((Object)"ID", (Object)flowFile.getAttribute("generatetablefetch.maxColumnNames"));
        Assertions.assertNull((Object)flowFile.getAttribute("generatetablefetch.limit"));
        Assertions.assertNull((Object)flowFile.getAttribute("generatetablefetch.offset"));
        Assertions.assertEquals((Object)"0", (Object)flowFile.getAttribute("fragment.index"));
        Assertions.assertEquals((Object)"0", (Object)flowFile.getAttribute("fragment.count"));
    }

    @Test
    public void testMultiplePartitions() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (0, 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (1, 0)");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID, BUCKET");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "1");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(GenerateTableFetch.REL_SUCCESS, 2);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (2, 0)");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(GenerateTableFetch.REL_SUCCESS, 1);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (3, 1)");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(GenerateTableFetch.REL_SUCCESS, 1);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (4, 0)");
        this.runner.run();
        this.runner.assertTransferCount(GenerateTableFetch.REL_SUCCESS, 0);
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (5, 1)");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(GenerateTableFetch.REL_SUCCESS, 1);
        this.runner.clearTransferState();
    }

    @Test
    public void testMultiplePartitionsIncomingFlowFiles() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE1");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE1 (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE1 (id, bucket) VALUES (0, 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE1 (id, bucket) VALUES (1, 0)");
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE2 (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, bucket) VALUES (0, 0)");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "${tableName}");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "${partSize}");
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE1");
                this.put("partSize", "1");
            }
        });
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE2");
                this.put("partSize", "2");
            }
        });
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE3");
                this.put("partSize", "1");
            }
        });
        this.runner.run(3);
        this.runner.assertTransferCount(AbstractDatabaseFetchProcessor.REL_SUCCESS, 3);
        Assertions.assertEquals((long)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).stream().filter(ff -> "TEST_QUERY_DB_TABLE1".equals(ff.getAttribute("tableName"))).count(), (long)2L);
        Assertions.assertEquals((long)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).stream().filter(ff -> "TEST_QUERY_DB_TABLE2".equals(ff.getAttribute("tableName"))).count(), (long)1L);
        this.runner.assertTransferCount(GenerateTableFetch.REL_FAILURE, 1);
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE1");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testBackwardsCompatibilityStateKeyStaticTableDynamicMaxValues() throws Exception {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (0, 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (1, 0)");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "${maxValueCol}");
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("maxValueCol", "id");
            }
        });
        MockStateManager stateManager = this.runner.getStateManager();
        stateManager.setState((Map)new HashMap<String, String>(){
            {
                this.put("id", "0");
            }
        }, Scope.CLUSTER);
        this.processor.columnTypeMap.put("id", 4);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE id > 0 AND id <= 1 ORDER BY id FETCH NEXT 10000 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
    }

    @Test
    public void testBackwardsCompatibilityStateKeyDynamicTableDynamicMaxValues() throws Exception {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (0, 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (1, 0)");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "${tableName}");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "${maxValueCol}");
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE");
                this.put("maxValueCol", "id");
            }
        });
        MockStateManager stateManager = this.runner.getStateManager();
        stateManager.setState((Map)new HashMap<String, String>(){
            {
                this.put("id", "0");
            }
        }, Scope.CLUSTER);
        this.processor.columnTypeMap.put("id", 4);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE id <= 1 ORDER BY id FETCH NEXT 10000 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("generatetablefetch.tableName"));
        Assertions.assertEquals(null, (Object)flowFile.getAttribute("generatetablefetch.columnNames"));
        Assertions.assertEquals((Object)"id <= 1", (Object)flowFile.getAttribute("generatetablefetch.whereClause"));
        Assertions.assertEquals((Object)"id", (Object)flowFile.getAttribute("generatetablefetch.maxColumnNames"));
        Assertions.assertEquals((Object)"10000", (Object)flowFile.getAttribute("generatetablefetch.limit"));
        Assertions.assertEquals((Object)"0", (Object)flowFile.getAttribute("generatetablefetch.offset"));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (2, 0)");
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE");
                this.put("maxValueCol", "id");
            }
        });
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE id > 1 AND id <= 2 ORDER BY id FETCH NEXT 10000 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("generatetablefetch.tableName"));
        Assertions.assertEquals(null, (Object)flowFile.getAttribute("generatetablefetch.columnNames"));
        Assertions.assertEquals((Object)"id > 1 AND id <= 2", (Object)flowFile.getAttribute("generatetablefetch.whereClause"));
        Assertions.assertEquals((Object)"id", (Object)flowFile.getAttribute("generatetablefetch.maxColumnNames"));
        Assertions.assertEquals((Object)"10000", (Object)flowFile.getAttribute("generatetablefetch.limit"));
        Assertions.assertEquals((Object)"0", (Object)flowFile.getAttribute("generatetablefetch.offset"));
    }

    @Test
    public void testBackwardsCompatibilityStateKeyDynamicTableStaticMaxValues() throws Exception {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (0, 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (1, 0)");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "${tableName}");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "id");
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE");
            }
        });
        MockStateManager stateManager = this.runner.getStateManager();
        stateManager.setState((Map)new HashMap<String, String>(){
            {
                this.put("id", "0");
            }
        }, Scope.CLUSTER);
        this.processor.columnTypeMap.put("id", 4);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE id <= 1 ORDER BY id FETCH NEXT 10000 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (2, 0)");
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE");
                this.put("maxValueCol", "id");
            }
        });
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE id > 1 AND id <= 2 ORDER BY id FETCH NEXT 10000 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
    }

    @Test
    public void testBackwardsCompatibilityStateKeyVariableRegistry() throws Exception {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (0, 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (1, 0)");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "${tableName}");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "${maxValueCol}");
        this.runner.setVariable("tableName", "TEST_QUERY_DB_TABLE");
        this.runner.setVariable("maxValueCol", "id");
        MockStateManager stateManager = this.runner.getStateManager();
        stateManager.setState((Map)new HashMap<String, String>(){
            {
                this.put("id", "0");
            }
        }, Scope.CLUSTER);
        this.processor.columnTypeMap.put("id", 4);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE id <= 1 ORDER BY id FETCH NEXT 10000 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
    }

    @Test
    public void testRidiculousRowCount() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        long rowCount = Long.parseLong(Integer.toString(Integer.MAX_VALUE)) + 100L;
        int partitionSize = 1000000;
        int expectedFileCount = (int)(rowCount / (long)partitionSize) + 1;
        Connection conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.dbcp.getConnection()).thenReturn((Object)conn);
        Statement st = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)conn.createStatement()).thenReturn((Object)st);
        ((Statement)Mockito.doNothing().when((Object)st)).close();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)st.executeQuery(ArgumentMatchers.anyString())).thenReturn((Object)rs);
        Mockito.when((Object)rs.next()).thenReturn((Object)true);
        Mockito.when((Object)rs.getInt(1)).thenReturn((Object)((int)rowCount));
        Mockito.when((Object)rs.getLong(1)).thenReturn((Object)rowCount);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)rs.getMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)resultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)resultSetMetaData.getTableName(1)).thenReturn((Object)"");
        Mockito.when((Object)resultSetMetaData.getColumnType(1)).thenReturn((Object)4);
        Mockito.when((Object)resultSetMetaData.getColumnName(1)).thenReturn((Object)"COUNT");
        Mockito.when((Object)resultSetMetaData.getColumnType(2)).thenReturn((Object)4);
        Mockito.when((Object)resultSetMetaData.getColumnName(2)).thenReturn((Object)"ID");
        Mockito.when((Object)rs.getInt(2)).thenReturn((Object)1000);
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, Integer.toString(partitionSize));
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, expectedFileCount);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE 1=1 ORDER BY ID FETCH NEXT 1000000 ROWS ONLY", (Object)query);
        this.runner.clearTransferState();
    }

    @Test
    public void testInitialMaxValue() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty("initial.maxvalue.ID", "1");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 1 AND ID <= 2 ORDER BY ID FETCH NEXT 10000 ROWS ONLY", (Object)query);
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (3, 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (4, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (5, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "2");
        this.runner.setProperty("initial.maxvalue.ID", "5");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 2 AND ID <= 5 ORDER BY ID FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 2 AND ID <= 5 ORDER BY ID OFFSET 2 ROWS FETCH NEXT 2 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
    }

    @Test
    public void testInitialMaxValueWithEL() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty("initial.maxvalue.ID", "${maxval.id}");
        this.runner.setVariable("maxval.id", "1");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 1 AND ID <= 2 ORDER BY ID FETCH NEXT 10000 ROWS ONLY", (Object)query);
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
    }

    @Test
    public void testInitialMaxValueWithELAndIncoming() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty("initial.maxvalue.ID", "${maxval.id}");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("maxval.id", "1");
            }
        };
        this.runner.setIncomingConnection(true);
        this.runner.enqueue(new byte[0], (Map)attrs);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 1 AND ID <= 2 ORDER BY ID FETCH NEXT 10000 ROWS ONLY", (Object)query);
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.enqueue(new byte[0], (Map)attrs);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
    }

    @Test
    public void testInitialMaxValueWithELAndMultipleTables() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "${table.name}");
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty("initial.maxvalue.ID", "${maxval.id}");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("maxval.id", "1");
                this.put("table.name", "TEST_QUERY_DB_TABLE");
            }
        };
        this.runner.setIncomingConnection(true);
        this.runner.enqueue(new byte[0], (Map)attrs);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 1 AND ID <= 2 ORDER BY ID FETCH NEXT 10000 ROWS ONLY", (Object)query);
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.enqueue(new byte[0], (Map)attrs);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE2 (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        attrs.put("table.name", "TEST_QUERY_DB_TABLE2");
        this.runner.enqueue(new byte[0], (Map)attrs);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE2 WHERE ID > 1 AND ID <= 2 ORDER BY ID FETCH NEXT 10000 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.enqueue(new byte[0], (Map)attrs);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
    }

    @Test
    public void testNoDuplicateWithRightBounded() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (3, 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (4, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (5, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        ResultSet resultSet = stmt.executeQuery(query);
        int numberRecordsFirstExecution = 0;
        while (resultSet.next()) {
            ++numberRecordsFirstExecution;
        }
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        resultSet = stmt.executeQuery(query);
        int numberRecordsSecondExecution = 0;
        while (resultSet.next()) {
            ++numberRecordsSecondExecution;
        }
        Assertions.assertEquals((int)(numberRecordsFirstExecution + numberRecordsSecondExecution), (int)6);
        this.runner.clearTransferState();
    }

    @Test
    public void testAddedRowsWithCustomWhereClause() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, type varchar(20), name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (0, 'male', 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (1, 'female', 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (2, NULL, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setProperty(GenerateTableFetch.WHERE_CLAUSE, "type = 'male' OR type IS NULL");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE (type = 'male' OR type IS NULL) AND ID <= 2 ORDER BY ID FETCH NEXT 10000 ROWS ONLY", (Object)query);
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (3, 'female', 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (4, 'male', 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (5, 'male', 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "1");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 2 AND (type = 'male' OR type IS NULL) AND ID <= 5 ORDER BY ID FETCH NEXT 1 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 2 AND (type = 'male' OR type IS NULL) AND ID <= 5 ORDER BY ID OFFSET 1 ROWS FETCH NEXT 1 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (6, 'male', 'Mr. NiFi', 1.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 5 AND (type = 'male' OR type IS NULL) AND ID <= 6 ORDER BY ID FETCH NEXT 1 ROWS ONLY", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "name");
        this.runner.setProperty(GenerateTableFetch.COLUMN_NAMES, "id, type, name, scale, created_on");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 5);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"SELECT id, type, name, scale, created_on FROM TEST_QUERY_DB_TABLE WHERE (type = 'male' OR type IS NULL) AND name <= 'Mr. NiFi' ORDER BY name FETCH NEXT 1 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        Assertions.assertEquals((Object)"SELECT id, type, name, scale, created_on FROM TEST_QUERY_DB_TABLE WHERE (type = 'male' OR type IS NULL) AND name <= 'Mr. NiFi' ORDER BY name OFFSET 1 ROWS FETCH NEXT 1 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(2);
        Assertions.assertEquals((Object)"SELECT id, type, name, scale, created_on FROM TEST_QUERY_DB_TABLE WHERE (type = 'male' OR type IS NULL) AND name <= 'Mr. NiFi' ORDER BY name OFFSET 2 ROWS FETCH NEXT 1 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(3);
        Assertions.assertEquals((Object)"SELECT id, type, name, scale, created_on FROM TEST_QUERY_DB_TABLE WHERE (type = 'male' OR type IS NULL) AND name <= 'Mr. NiFi' ORDER BY name OFFSET 3 ROWS FETCH NEXT 1 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(4);
        Assertions.assertEquals((Object)"SELECT id, type, name, scale, created_on FROM TEST_QUERY_DB_TABLE WHERE (type = 'male' OR type IS NULL) AND name <= 'Mr. NiFi' ORDER BY name OFFSET 4 ROWS FETCH NEXT 1 ROWS ONLY", (Object)new String(flowFile.toByteArray()));
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("generatetablefetch.tableName"));
        Assertions.assertEquals((Object)"id, type, name, scale, created_on", (Object)flowFile.getAttribute("generatetablefetch.columnNames"));
        Assertions.assertEquals((Object)"(type = 'male' OR type IS NULL) AND name <= 'Mr. NiFi'", (Object)flowFile.getAttribute("generatetablefetch.whereClause"));
        Assertions.assertEquals((Object)"name", (Object)flowFile.getAttribute("generatetablefetch.maxColumnNames"));
        Assertions.assertEquals((Object)"1", (Object)flowFile.getAttribute("generatetablefetch.limit"));
        Assertions.assertEquals((Object)"4", (Object)flowFile.getAttribute("generatetablefetch.offset"));
        this.runner.clearTransferState();
    }

    @Test
    public void testColumnTypeMissing() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (0, 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (1, 0)");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "${tableName}");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "${maxValueCol}");
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE");
                this.put("maxValueCol", "id");
            }
        });
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE id <= 1 ORDER BY id FETCH NEXT 10000 ROWS ONLY", (Object)query);
        this.runner.clearTransferState();
        this.processor.columnTypeMap.clear();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (2, 0)");
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE");
                this.put("maxValueCol", "id");
            }
        });
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE id > 1 AND id <= 2 ORDER BY id FETCH NEXT 10000 ROWS ONLY", (Object)query);
        this.runner.clearTransferState();
    }

    @Test
    public void testMultipleColumnTypeMissing() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
            stmt.execute("drop table TEST_QUERY_DB_TABLE_2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (1, 0)");
        stmt.execute("create table TEST_QUERY_DB_TABLE_2 (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE_2 (id, bucket) VALUES (1, 0)");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "${tableName}");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "${maxValueCol}");
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE");
                this.put("maxValueCol", "id");
            }
        });
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE_2");
                this.put("maxValueCol", "id");
            }
        });
        this.runner.run(2);
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        Assertions.assertEquals((int)2, (int)this.processor.columnTypeMap.size());
        this.runner.clearTransferState();
        Map.Entry entry = this.processor.columnTypeMap.entrySet().iterator().next();
        String key = (String)entry.getKey();
        this.processor.columnTypeMap.remove(key);
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (2, 0)");
        this.runner.enqueue("".getBytes(), (Map)new HashMap<String, String>(){
            {
                this.put("tableName", "TEST_QUERY_DB_TABLE");
                this.put("maxValueCol", "id");
            }
        });
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 1);
        Assertions.assertEquals((int)2, (int)this.processor.columnTypeMap.size());
        this.runner.clearTransferState();
    }

    @Test
    public void testUseColumnValuesForPartitioning() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (10, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (11, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (12, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(GenerateTableFetch.COLUMN_FOR_VALUE_PARTITIONING, "ID");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID <= 12 AND ID >= 10 AND ID < 12", (Object)query);
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID <= 12 AND ID >= 12 AND ID < 14", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (20, 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (21, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (24, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 3);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 12 AND ID <= 24 AND ID >= 20 AND ID < 22", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 12 AND ID <= 24 AND ID >= 22 AND ID < 24", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(2);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID > 12 AND ID <= 24 AND ID >= 24 AND ID < 26", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
    }

    @Test
    public void testUseColumnValuesForPartitioningNoMaxValueColumn() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (10, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (11, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (12, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.COLUMN_FOR_VALUE_PARTITIONING, "ID");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE 1=1 AND ID >= 10 AND ID < 12", (Object)query);
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE ID <= 12 AND ID >= 12", (Object)query);
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        this.runner.clearTransferState();
    }

    @Test
    public void testCustomOrderByColumn() throws SQLException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(GenerateTableFetch.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(GenerateTableFetch.CUSTOM_ORDERBY_COLUMN, "SCALE");
        this.runner.setProperty(GenerateTableFetch.PARTITION_SIZE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractDatabaseFetchProcessor.REL_SUCCESS, 2);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(0);
        String query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE 1=1 ORDER BY SCALE FETCH NEXT 2 ROWS ONLY", (Object)query);
        flowFile.assertAttributeEquals(AbstractDatabaseFetchProcessor.FRAGMENT_INDEX, "0");
        flowFile.assertAttributeEquals(AbstractDatabaseFetchProcessor.FRAGMENT_COUNT, "2");
        ResultSet resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractDatabaseFetchProcessor.REL_SUCCESS).get(1);
        query = new String(flowFile.toByteArray());
        Assertions.assertEquals((Object)"SELECT * FROM TEST_QUERY_DB_TABLE WHERE 1=1 ORDER BY SCALE OFFSET 2 ROWS FETCH NEXT 2 ROWS ONLY", (Object)query);
        flowFile.assertAttributeEquals(AbstractDatabaseFetchProcessor.FRAGMENT_INDEX, "1");
        flowFile.assertAttributeEquals(AbstractDatabaseFetchProcessor.FRAGMENT_COUNT, "2");
        resultSet = stmt.executeQuery(query);
        Assertions.assertTrue((boolean)resultSet.next());
        Assertions.assertFalse((boolean)resultSet.next());
        this.runner.clearTransferState();
    }

    private class DBCPServiceSimpleImpl
    extends AbstractControllerService
    implements DBCPService {
        private DBCPServiceSimpleImpl() {
        }

        public String getIdentifier() {
            return "dbcp";
        }

        public Connection getConnection() throws ProcessException {
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                return DriverManager.getConnection("jdbc:derby:target/db_gtf;create=true");
            }
            catch (Exception e) {
                throw new ProcessException("getConnection failed: " + e);
            }
        }
    }
}

