/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processors.standard.CompressContent;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCompressContent {
    @Test
    public void testSnappyCompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "compress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "snappy");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/x-snappy");
        flowFile.assertAttributeEquals("filename", "SampleFile.txt.snappy");
    }

    @Test
    public void testSnappyDecompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "snappy");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt.snappy", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt");
    }

    @Test
    public void testSnappyHadoopCompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "compress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "snappy-hadoop");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/x-snappy-hadoop");
        flowFile.assertAttributeEquals("filename", "SampleFile.txt.snappy");
    }

    @Test
    public void testSnappyHadoopDecompress() {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "snappy-hadoop");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.assertNotValid();
    }

    @Test
    public void testSnappyFramedCompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "compress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "snappy framed");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/x-snappy-framed");
        flowFile.assertAttributeEquals("filename", "SampleFile.txt.sz");
    }

    @Test
    public void testSnappyFramedDecompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "snappy framed");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt.sz", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt");
    }

    @Test
    public void testBzip2DecompressConcatenated() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "bzip2");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "false");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFileConcat.txt.bz2", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFileConcat.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFileConcat.txt.bz2");
    }

    @Test
    public void testBzip2Decompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "bzip2");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt.bz2", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt");
        runner.clearTransferState();
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile1.txt.bz2", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile1.txt");
    }

    @Test
    public void testProperMimeTypeFromBzip2() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "compress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "bzip2");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "false");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals("mime.type", "application/x-bzip2");
    }

    @Test
    public void testBzip2DecompressWithBothMimeTypes() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "use mime.type attribute");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("mime.type", "application/x-bzip2");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt.bz2", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt");
        runner.clearTransferState();
        attributes.put("mime.type", "application/bzip2");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile1.txt.bz2", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile1.txt");
    }

    @Test
    public void testGzipDecompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "gzip");
        Assertions.assertTrue((boolean)runner.setProperty(CompressContent.UPDATE_FILENAME, "true").isValid());
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt.gz", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt");
        runner.clearTransferState();
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile1.txt.gz", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile1.txt");
        runner.clearTransferState();
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "use mime.type attribute");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.MIME_TYPE.key(), "application/x-gzip");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt.gz", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt");
    }

    @Test
    public void testDeflateDecompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "deflate");
        Assertions.assertTrue((boolean)runner.setProperty(CompressContent.UPDATE_FILENAME, "true").isValid());
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt.zlib", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        System.err.println(new String(flowFile.toByteArray()));
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt");
    }

    @Test
    public void testDeflateCompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "compress");
        runner.setProperty(CompressContent.COMPRESSION_LEVEL, "6");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "deflate");
        Assertions.assertTrue((boolean)runner.setProperty(CompressContent.UPDATE_FILENAME, "true").isValid());
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt.zlib", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt.zlib");
    }

    @Test
    public void testFilenameUpdatedOnCompress() throws IOException {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "compress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "gzip");
        Assertions.assertTrue((boolean)runner.setProperty(CompressContent.UPDATE_FILENAME, "true").isValid());
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals("filename", "SampleFile.txt.gz");
    }

    @Test
    public void testDecompressFailure() throws IOException {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "gzip");
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        runner.enqueue(data);
        Assertions.assertTrue((boolean)runner.setProperty(CompressContent.UPDATE_FILENAME, "true").isValid());
        runner.run();
        runner.assertQueueEmpty();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_FAILURE, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_FAILURE).get(0)).assertContentEquals(data);
    }

    @Test
    public void testLz4FramedCompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "compress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "lz4-framed");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/x-lz4-framed");
        flowFile.assertAttributeEquals("filename", "SampleFile.txt.lz4");
    }

    @Test
    public void testLz4FramedDecompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "lz4-framed");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt.lz4", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt");
    }

    @Test
    public void testZstdCompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "compress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "zstd");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/zstd");
        flowFile.assertAttributeEquals("filename", "SampleFile.txt.zst");
    }

    @Test
    public void testZstdDecompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "zstd");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt.zst", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt");
    }

    @Test
    public void testBrotliCompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "compress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "brotli");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/x-brotli");
        flowFile.assertAttributeEquals("filename", "SampleFile.txt.br");
    }

    @Test
    public void testBrotliDecompress() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(CompressContent.class);
        runner.setProperty(CompressContent.MODE, "decompress");
        runner.setProperty(CompressContent.COMPRESSION_FORMAT, "brotli");
        runner.setProperty(CompressContent.UPDATE_FILENAME, "true");
        runner.enqueue(Paths.get("src/test/resources/CompressedData/SampleFile.txt.br", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(CompressContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CompressContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(Paths.get("src/test/resources/CompressedData/SampleFile.txt", new String[0]));
        flowFile.assertAttributeEquals("filename", "SampleFile.txt");
    }
}

