/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.pattern.RollbackOnFailure;
import org.apache.nifi.processors.standard.DBCPServiceSimpleImpl;
import org.apache.nifi.processors.standard.PutDatabaseRecord;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.TableSchema;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.MockRecordFailureType;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.util.file.FileUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class PutDatabaseRecordTest {
    private static final String CONNECTION_FAILED = "Connection Failed";
    private static final String PARSER_ID = MockRecordParser.class.getSimpleName();
    private static final String TABLE_NAME = "PERSONS";
    private static final String createPersons = "CREATE TABLE PERSONS (id integer primary key, name varchar(100), code integer CONSTRAINT CODE_RANGE CHECK (code >= 0 AND code < 1000), dt date)";
    private static final String createPersonsSchema1 = "CREATE TABLE SCHEMA1.PERSONS (id integer primary key, name varchar(100), code integer CONSTRAINT CODE_RANGE CHECK (code >= 0 AND code < 1000), dt date)";
    private static final String createPersonsSchema2 = "CREATE TABLE SCHEMA2.PERSONS (id2 integer primary key, name varchar(100), code integer CONSTRAINT CODE_RANGE CHECK (code >= 0 AND code < 1000), dt date)";
    private static final String DB_LOCATION = "target/db_pdr";
    TestRunner runner;
    PutDatabaseRecord processor;
    DBCPServiceSimpleImpl dbcp;

    @BeforeAll
    public static void setDatabaseLocation() {
        System.setProperty("derby.stream.error.file", "target/derby.log");
        File dbLocation = new File(DB_LOCATION);
        try {
            FileUtils.deleteFile((File)dbLocation, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @AfterAll
    public static void shutdownDatabase() throws Exception {
        try {
            DriverManager.getConnection("jdbc:derby:target/db_pdr;shutdown=true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        File dbLocation = new File(DB_LOCATION);
        try {
            FileUtils.deleteFile((File)dbLocation, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.clearProperty("derby.stream.error.file");
    }

    @BeforeEach
    public void setRunner() throws Exception {
        this.processor = new PutDatabaseRecord();
        this.dbcp = (DBCPServiceSimpleImpl)((Object)Mockito.spy((Object)((Object)new DBCPServiceSimpleImpl(DB_LOCATION))));
        HashMap dbcpProperties = new HashMap();
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        this.runner.addControllerService("dbcp", (ControllerService)this.dbcp, dbcpProperties);
        this.runner.enableControllerService((ControllerService)this.dbcp);
        this.runner.setProperty(PutDatabaseRecord.DBCP_SERVICE, "dbcp");
    }

    @Test
    public void testGetConnectionFailure() throws InitializationException {
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService(PARSER_ID, (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, PARSER_ID);
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        Mockito.when((Object)this.dbcp.getConnection(ArgumentMatchers.anyMap())).thenThrow(new Throwable[]{new ProcessException(CONNECTION_FAILED)});
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDatabaseRecord.REL_FAILURE);
    }

    @Test
    public void testInsertNonRequiredColumnsUnmatchedField() throws InitializationException, ProcessException {
        this.processor = new PutDatabaseRecordUnmatchedField();
        this.dbcp = (DBCPServiceSimpleImpl)((Object)Mockito.spy((Object)((Object)new DBCPServiceSimpleImpl(DB_LOCATION))));
        HashMap dbcpProperties = new HashMap();
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        this.runner.addControllerService("dbcp", (ControllerService)this.dbcp, dbcpProperties);
        this.runner.enableControllerService((ControllerService)this.dbcp);
        this.runner.setProperty(PutDatabaseRecord.DBCP_SERVICE, "dbcp");
        this.recreateTable();
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService(PARSER_ID, (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("extra", RecordFieldType.STRING);
        parser.addSchemaField("dt", RecordFieldType.DATE);
        LocalDate testDate1 = LocalDate.of(2021, 1, 26);
        Date nifiDate1 = new Date(testDate1.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli());
        LocalDate testDate2 = LocalDate.of(2021, 7, 26);
        Date nifiDate2 = new Date(testDate2.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli());
        parser.addRecord(new Object[]{1, "rec1", "test", nifiDate1});
        parser.addRecord(new Object[]{2, "rec2", "test", nifiDate2});
        parser.addRecord(new Object[]{3, "rec3", "test", null});
        parser.addRecord(new Object[]{4, "rec4", "test", null});
        parser.addRecord(new Object[]{5, null, null, null});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, PARSER_ID);
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.setProperty(PutDatabaseRecord.UNMATCHED_FIELD_BEHAVIOR, PutDatabaseRecord.FAIL_UNMATCHED_FIELD);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_RETRY, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_FAILURE, 1);
    }

    @Test
    void testGeneratePreparedStatements() throws SQLException, MalformedRecordException {
        List<RecordField> fields = Arrays.asList(new RecordField("id", RecordFieldType.INT.getDataType()), new RecordField("name", RecordFieldType.STRING.getDataType()), new RecordField("code", RecordFieldType.INT.getDataType()), new RecordField("non_existing", RecordFieldType.BOOLEAN.getDataType()));
        SimpleRecordSchema schema = new SimpleRecordSchema(fields);
        TableSchema tableSchema = new TableSchema(TABLE_NAME, Arrays.asList(new ColumnDescription("id", 4, true, Integer.valueOf(2), false), new ColumnDescription("name", 12, true, Integer.valueOf(255), true), new ColumnDescription("code", 4, true, Integer.valueOf(10), true)), false, new HashSet<String>(Arrays.asList("id")), "");
        this.runner.setProperty(PutDatabaseRecord.TRANSLATE_FIELD_NAMES, "false");
        this.runner.setProperty(PutDatabaseRecord.UNMATCHED_FIELD_BEHAVIOR, PutDatabaseRecord.IGNORE_UNMATCHED_FIELD);
        this.runner.setProperty(PutDatabaseRecord.UNMATCHED_COLUMN_BEHAVIOR, PutDatabaseRecord.IGNORE_UNMATCHED_COLUMN);
        this.runner.setProperty(PutDatabaseRecord.QUOTE_IDENTIFIERS, "false");
        this.runner.setProperty(PutDatabaseRecord.QUOTE_TABLE_IDENTIFIER, "false");
        PutDatabaseRecord.DMLSettings settings = new PutDatabaseRecord.DMLSettings(this.runner.getProcessContext());
        Assertions.assertEquals((Object)"INSERT INTO PERSONS (id, name, code) VALUES (?,?,?)", (Object)this.processor.generateInsert((RecordSchema)schema, TABLE_NAME, tableSchema, settings).getSql());
        Assertions.assertEquals((Object)"UPDATE PERSONS SET name = ?, code = ? WHERE id = ?", (Object)this.processor.generateUpdate((RecordSchema)schema, TABLE_NAME, null, tableSchema, settings).getSql());
        Assertions.assertEquals((Object)"DELETE FROM PERSONS WHERE (id = ?) AND (name = ? OR (name is null AND ? is null)) AND (code = ? OR (code is null AND ? is null))", (Object)this.processor.generateDelete((RecordSchema)schema, TABLE_NAME, tableSchema, settings).getSql());
    }

    @Test
    void testGeneratePreparedStatementsFailUnmatchedField() {
        List<RecordField> fields = Arrays.asList(new RecordField("id", RecordFieldType.INT.getDataType()), new RecordField("name", RecordFieldType.STRING.getDataType()), new RecordField("code", RecordFieldType.INT.getDataType()), new RecordField("non_existing", RecordFieldType.BOOLEAN.getDataType()));
        SimpleRecordSchema schema = new SimpleRecordSchema(fields);
        TableSchema tableSchema = new TableSchema(TABLE_NAME, Arrays.asList(new ColumnDescription("id", 4, true, Integer.valueOf(2), false), new ColumnDescription("name", 12, true, Integer.valueOf(255), true), new ColumnDescription("code", 4, true, Integer.valueOf(10), true)), false, new HashSet<String>(Arrays.asList("id")), "");
        this.runner.setProperty(PutDatabaseRecord.TRANSLATE_FIELD_NAMES, "false");
        this.runner.setProperty(PutDatabaseRecord.UNMATCHED_FIELD_BEHAVIOR, PutDatabaseRecord.FAIL_UNMATCHED_FIELD);
        this.runner.setProperty(PutDatabaseRecord.UNMATCHED_COLUMN_BEHAVIOR, PutDatabaseRecord.IGNORE_UNMATCHED_COLUMN);
        this.runner.setProperty(PutDatabaseRecord.QUOTE_IDENTIFIERS, "false");
        this.runner.setProperty(PutDatabaseRecord.QUOTE_TABLE_IDENTIFIER, "false");
        PutDatabaseRecord.DMLSettings settings = new PutDatabaseRecord.DMLSettings(this.runner.getProcessContext());
        SQLDataException e = (SQLDataException)Assertions.assertThrows(SQLDataException.class, () -> this.lambda$testGeneratePreparedStatementsFailUnmatchedField$0((RecordSchema)schema, tableSchema, settings), (String)"generateInsert should fail with unmatched fields");
        Assertions.assertEquals((Object)"Cannot map field 'non_existing' to any column in the database\nColumns: id,name,code", (Object)e.getMessage());
        e = (SQLDataException)Assertions.assertThrows(SQLDataException.class, () -> this.lambda$testGeneratePreparedStatementsFailUnmatchedField$1((RecordSchema)schema, tableSchema, settings), (String)"generateUpdate should fail with unmatched fields");
        Assertions.assertEquals((Object)"Cannot map field 'non_existing' to any column in the database\nColumns: id,name,code", (Object)e.getMessage());
        e = (SQLDataException)Assertions.assertThrows(SQLDataException.class, () -> this.lambda$testGeneratePreparedStatementsFailUnmatchedField$2((RecordSchema)schema, tableSchema, settings), (String)"generateDelete should fail with unmatched fields");
        Assertions.assertEquals((Object)"Cannot map field 'non_existing' to any column in the database\nColumns: id,name,code", (Object)e.getMessage());
    }

    @Test
    void testInsert() throws InitializationException, ProcessException, SQLException, IOException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addSchemaField("dt", RecordFieldType.DATE);
        LocalDate testDate1 = LocalDate.of(2021, 1, 26);
        Date jdbcDate1 = Date.valueOf(testDate1);
        LocalDate testDate2 = LocalDate.of(2021, 7, 26);
        Date jdbcDate2 = Date.valueOf(testDate2);
        parser.addRecord(new Object[]{1, "rec1", 101, jdbcDate1});
        parser.addRecord(new Object[]{2, "rec2", 102, jdbcDate2});
        parser.addRecord(new Object[]{3, "rec3", 103, null});
        parser.addRecord(new Object[]{4, "rec4", 104, null});
        parser.addRecord(new Object[]{5, null, 105, null});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)101, (int)rs.getInt(3));
        Assertions.assertEquals((Object)jdbcDate1.toString(), (Object)rs.getDate(4).toString());
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)102, (int)rs.getInt(3));
        Assertions.assertEquals((Object)jdbcDate2.toString(), (Object)rs.getDate(4).toString());
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)3, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec3", (Object)rs.getString(2));
        Assertions.assertEquals((int)103, (int)rs.getInt(3));
        Assertions.assertNull((Object)rs.getDate(4));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)4, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec4", (Object)rs.getString(2));
        Assertions.assertEquals((int)104, (int)rs.getInt(3));
        Assertions.assertNull((Object)rs.getDate(4));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)5, (int)rs.getInt(1));
        Assertions.assertNull((Object)rs.getString(2));
        Assertions.assertEquals((int)105, (int)rs.getInt(3));
        Assertions.assertNull((Object)rs.getDate(4));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertNonRequiredColumns() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("dt", RecordFieldType.DATE);
        LocalDate testDate1 = LocalDate.of(2021, 1, 26);
        Date jdbcDate1 = Date.valueOf(testDate1);
        LocalDate testDate2 = LocalDate.of(2021, 7, 26);
        Date jdbcDate2 = Date.valueOf(testDate2);
        parser.addRecord(new Object[]{1, "rec1", jdbcDate1});
        parser.addRecord(new Object[]{2, "rec2", jdbcDate2});
        parser.addRecord(new Object[]{3, "rec3", null});
        parser.addRecord(new Object[]{4, "rec4", null});
        parser.addRecord(new Object[]{5, null, null});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)0, (int)rs.getInt(3));
        Assertions.assertEquals((Object)jdbcDate1.toString(), (Object)rs.getDate(4).toString());
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)0, (int)rs.getInt(3));
        Assertions.assertEquals((Object)jdbcDate2.toString(), (Object)rs.getDate(4).toString());
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)3, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec3", (Object)rs.getString(2));
        Assertions.assertEquals((int)0, (int)rs.getInt(3));
        Assertions.assertNull((Object)rs.getDate(4));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)4, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec4", (Object)rs.getString(2));
        Assertions.assertEquals((int)0, (int)rs.getInt(3));
        Assertions.assertNull((Object)rs.getDate(4));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)5, (int)rs.getInt(1));
        Assertions.assertNull((Object)rs.getString(2));
        Assertions.assertEquals((int)0, (int)rs.getInt(3));
        Assertions.assertNull((Object)rs.getDate(4));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertBatchUpdateException() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 101});
        parser.addRecord(new Object[]{2, "rec2", 102});
        parser.addRecord(new Object[]{3, "rec3", 1000});
        parser.addRecord(new Object[]{4, "rec4", 104});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDatabaseRecord.REL_FAILURE, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertBatchUpdateExceptionRollbackOnFailure() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 101});
        parser.addRecord(new Object[]{2, "rec2", 102});
        parser.addRecord(new Object[]{3, "rec3", 1000});
        parser.addRecord(new Object[]{4, "rec4", 104});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.setProperty(RollbackOnFailure.ROLLBACK_ON_FAILURE, "true");
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertNoTableSpecified() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 101});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, "${not.a.real.attr}");
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_FAILURE, 1);
    }

    @Test
    void testInsertNoTableExists() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 101});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, "PERSONS2");
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_FAILURE, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(PutDatabaseRecord.REL_FAILURE).get(0);
        String errorMessage = flowFile.getAttribute("putdatabaserecord.error");
        Assertions.assertTrue((boolean)errorMessage.contains("PERSONS2"));
    }

    @Test
    void testInsertViaSqlStatementType() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("sql", RecordFieldType.STRING);
        parser.addRecord(new Object[]{"INSERT INTO PERSONS (id, name, code) VALUES (1, 'rec1',101)"});
        parser.addRecord(new Object[]{"INSERT INTO PERSONS (id, name, code) VALUES (2, 'rec2',102)"});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "Use statement.type Attribute");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.setProperty(PutDatabaseRecord.FIELD_CONTAINING_SQL, "sql");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("statement.type", "sql");
        this.runner.enqueue(new byte[0], attrs);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)101, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)102, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testMultipleInsertsViaSqlStatementType() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("sql", RecordFieldType.STRING);
        parser.addRecord(new Object[]{"INSERT INTO PERSONS (id, name, code) VALUES (1, 'rec1',101);INSERT INTO PERSONS (id, name, code) VALUES (2, 'rec2',102)"});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "Use statement.type Attribute");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.setProperty(PutDatabaseRecord.FIELD_CONTAINING_SQL, "sql");
        this.runner.setProperty(PutDatabaseRecord.ALLOW_MULTIPLE_STATEMENTS, "true");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("statement.type", "sql");
        this.runner.enqueue(new byte[0], attrs);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)101, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)102, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testMultipleInsertsViaSqlStatementTypeBadSQL() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("sql", RecordFieldType.STRING);
        parser.addRecord(new Object[]{"INSERT INTO PERSONS (id, name, code) VALUES (1, 'rec1',101);INSERT INTO PERSONS (id, name, code) VALUES (2, 'rec2',102);INSERT INTO PERSONS2 (id, name, code) VALUES (2, 'rec2',102);"});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "Use statement.type Attribute");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.setProperty(PutDatabaseRecord.FIELD_CONTAINING_SQL, "sql");
        this.runner.setProperty(PutDatabaseRecord.ALLOW_MULTIPLE_STATEMENTS, "true");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("statement.type", "sql");
        this.runner.enqueue(new byte[0], attrs);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_FAILURE, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testInvalidData() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 101});
        parser.addRecord(new Object[]{2, "rec2", 102});
        parser.addRecord(new Object[]{3, "rec3", 104});
        parser.failAfter(1);
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDatabaseRecord.REL_FAILURE, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testIOExceptionOnReadData() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 101});
        parser.addRecord(new Object[]{2, "rec2", 102});
        parser.addRecord(new Object[]{3, "rec3", 104});
        parser.failAfter(1, MockRecordFailureType.IO_EXCEPTION);
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDatabaseRecord.REL_FAILURE, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testSqlStatementTypeNoValue() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("sql", RecordFieldType.STRING);
        parser.addRecord(new Object[]{""});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "Use statement.type Attribute");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.setProperty(PutDatabaseRecord.FIELD_CONTAINING_SQL, "sql");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("statement.type", "sql");
        this.runner.enqueue(new byte[0], attrs);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_FAILURE, 1);
    }

    @Test
    void testSqlStatementTypeNoValueRollbackOnFailure() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("sql", RecordFieldType.STRING);
        parser.addRecord(new Object[]{""});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "Use statement.type Attribute");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.setProperty(PutDatabaseRecord.FIELD_CONTAINING_SQL, "sql");
        this.runner.setProperty(RollbackOnFailure.ROLLBACK_ON_FAILURE, "true");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("statement.type", "sql");
        this.runner.enqueue(new byte[0], attrs);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_FAILURE, 0);
    }

    @Test
    void testUpdate() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 201});
        parser.addRecord(new Object[]{2, "rec2", 202});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "UPDATE");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("INSERT INTO PERSONS VALUES (1,'x1',101, null)");
        stmt.execute("INSERT INTO PERSONS VALUES (2,'x2',102, null)");
        stmt.close();
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)201, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)202, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testUpdatePkNotFirst() throws InitializationException, ProcessException, SQLException {
        this.recreateTable("CREATE TABLE PERSONS (name varchar(100), id integer primary key, code integer)");
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{"rec1", 1, 201});
        parser.addRecord(new Object[]{"rec2", 2, 202});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "UPDATE");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("INSERT INTO PERSONS VALUES ('x1', 1, 101)");
        stmt.execute("INSERT INTO PERSONS VALUES ('x2', 2, 102)");
        stmt.close();
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(1));
        Assertions.assertEquals((int)1, (int)rs.getInt(2));
        Assertions.assertEquals((int)201, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(1));
        Assertions.assertEquals((int)2, (int)rs.getInt(2));
        Assertions.assertEquals((int)202, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testUpdateMultipleSchemas() throws InitializationException, ProcessException, SQLException {
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create schema SCHEMA1");
        stmt.execute("create schema SCHEMA2");
        stmt.execute(createPersonsSchema1);
        stmt.execute(createPersonsSchema2);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 201});
        parser.addRecord(new Object[]{2, "rec2", 202});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "UPDATE");
        this.runner.setProperty(PutDatabaseRecord.SCHEMA_NAME, "SCHEMA1");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        stmt.execute("INSERT INTO SCHEMA1.PERSONS VALUES (1,'x1',101,null)");
        stmt.execute("INSERT INTO SCHEMA2.PERSONS VALUES (2,'x2',102,null)");
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        ResultSet rs = stmt.executeQuery("SELECT * FROM SCHEMA1.PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)201, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("SELECT * FROM SCHEMA2.PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"x2", (Object)rs.getString(2));
        Assertions.assertEquals((int)102, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.execute("drop table SCHEMA1.PERSONS");
        stmt.execute("drop table SCHEMA2.PERSONS");
        stmt.execute("drop schema SCHEMA1 RESTRICT");
        stmt.execute("drop schema SCHEMA2 RESTRICT");
        stmt.close();
        rs = conn.getMetaData().getSchemas();
        ArrayList<String> schemas = new ArrayList<String>();
        while (rs.next()) {
            schemas.add(rs.getString(1));
        }
        Assertions.assertFalse((boolean)schemas.contains("SCHEMA1"));
        Assertions.assertFalse((boolean)schemas.contains("SCHEMA2"));
        conn.close();
    }

    @Test
    void testUpdateAfterInsert() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 101});
        parser.addRecord(new Object[]{2, "rec2", 102});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)101, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)102, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        this.runner.clearTransferState();
        parser.addRecord(new Object[]{1, "rec1", 201});
        parser.addRecord(new Object[]{2, "rec2", 202});
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "UPDATE");
        this.runner.enqueue(new byte[0]);
        this.runner.run(1, true, false);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        stmt = conn.createStatement();
        rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)201, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)202, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testUpdateNoPrimaryKeys() throws InitializationException, ProcessException, SQLException {
        this.recreateTable("CREATE TABLE PERSONS (id integer, name varchar(100), code integer)");
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "UPDATE");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        parser.addRecord(new Object[]{1, "rec1", 201});
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_FAILURE, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(PutDatabaseRecord.REL_FAILURE).get(0);
        Assertions.assertEquals((Object)"Table 'PERSONS' not found or does not have a Primary Key and no Update Keys were specified", (Object)flowFile.getAttribute("putdatabaserecord.error"));
    }

    @Test
    void testUpdateSpecifyUpdateKeys() throws InitializationException, ProcessException, SQLException {
        this.recreateTable("CREATE TABLE PERSONS (id integer, name varchar(100), code integer)");
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 201});
        parser.addRecord(new Object[]{2, "rec2", 202});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "UPDATE");
        this.runner.setProperty(PutDatabaseRecord.UPDATE_KEYS, "id");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("INSERT INTO PERSONS VALUES (1,'x1',101)");
        stmt.execute("INSERT INTO PERSONS VALUES (2,'x2',102)");
        stmt.close();
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)201, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)202, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testUpdateSpecifyUpdateKeysNotFirst() throws InitializationException, ProcessException, SQLException {
        this.recreateTable("CREATE TABLE PERSONS (id integer, name varchar(100), code integer)");
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 201});
        parser.addRecord(new Object[]{2, "rec2", 202});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "UPDATE");
        this.runner.setProperty(PutDatabaseRecord.UPDATE_KEYS, "code");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("INSERT INTO PERSONS VALUES (10,'x1',201)");
        stmt.execute("INSERT INTO PERSONS VALUES (12,'x2',202)");
        stmt.close();
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)201, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)202, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testUpdateSpecifyQuotedUpdateKeys() throws InitializationException, ProcessException, SQLException {
        this.recreateTable("CREATE TABLE PERSONS (\"id\" integer, name varchar(100), code integer)");
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{1, "rec1", 201});
        parser.addRecord(new Object[]{2, "rec2", 202});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "UPDATE");
        this.runner.setProperty(PutDatabaseRecord.UPDATE_KEYS, "${updateKey}");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.setProperty(PutDatabaseRecord.QUOTE_IDENTIFIERS, "true");
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("INSERT INTO PERSONS VALUES (1,'x1',101)");
        stmt.execute("INSERT INTO PERSONS VALUES (2,'x2',102)");
        stmt.close();
        this.runner.enqueue(new byte[0], Collections.singletonMap("updateKey", "id"));
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)201, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)202, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testDelete() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("INSERT INTO PERSONS VALUES (1, 'rec1', 101, null)");
        stmt.execute("INSERT INTO PERSONS VALUES (2, 'rec2', 102, null)");
        stmt.execute("INSERT INTO PERSONS VALUES (3, 'rec3', 103, null)");
        stmt.close();
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{2, "rec2", 102});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "DELETE");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)101, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)3, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec3", (Object)rs.getString(2));
        Assertions.assertEquals((int)103, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testDeleteWithNulls() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("INSERT INTO PERSONS VALUES (1, 'rec1', 101, null)");
        stmt.execute("INSERT INTO PERSONS VALUES (2, 'rec2', null, null)");
        stmt.execute("INSERT INTO PERSONS VALUES (3, 'rec3', 103, null)");
        stmt.close();
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{2, "rec2", null});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "DELETE");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)101, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)3, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec3", (Object)rs.getString(2));
        Assertions.assertEquals((int)103, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testRecordPathOptions() throws InitializationException, SQLException {
        this.recreateTable("CREATE TABLE PERSONS (id integer, name varchar(100), code integer)");
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        ArrayList<RecordField> dataFields = new ArrayList<RecordField>();
        dataFields.add(new RecordField("id", RecordFieldType.INT.getDataType()));
        dataFields.add(new RecordField("name", RecordFieldType.STRING.getDataType()));
        dataFields.add(new RecordField("code", RecordFieldType.INT.getDataType()));
        SimpleRecordSchema dataSchema = new SimpleRecordSchema(dataFields);
        parser.addSchemaField("operation", RecordFieldType.STRING);
        parser.addSchemaField(new RecordField("data", RecordFieldType.RECORD.getRecordDataType((RecordSchema)dataSchema)));
        parser.addRecord(new Object[]{"INSERT", new MapRecord((RecordSchema)dataSchema, this.createValues(1, "John Doe", 55))});
        parser.addRecord(new Object[]{"INSERT", new MapRecord((RecordSchema)dataSchema, this.createValues(2, "Jane Doe", 44))});
        parser.addRecord(new Object[]{"INSERT", new MapRecord((RecordSchema)dataSchema, this.createValues(3, "Jim Doe", 2))});
        parser.addRecord(new Object[]{"DELETE", new MapRecord((RecordSchema)dataSchema, this.createValues(2, "Jane Doe", 44))});
        parser.addRecord(new Object[]{"UPDATE", new MapRecord((RecordSchema)dataSchema, this.createValues(1, "John Doe", 201))});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "Use Record Path");
        this.runner.setProperty(PutDatabaseRecord.DATA_RECORD_PATH, "/data");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE_RECORD_PATH, "/operation");
        this.runner.setProperty(PutDatabaseRecord.UPDATE_KEYS, "id");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"John Doe", (Object)rs.getString(2));
        Assertions.assertEquals((int)201, (int)rs.getInt(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)3, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"Jim Doe", (Object)rs.getString(2));
        Assertions.assertEquals((int)2, (int)rs.getInt(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertWithMaxBatchSize() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        for (int i = 1; i < 12; ++i) {
            parser.addRecord(new Object[]{i, String.format("rec%s", i), 100 + i});
        }
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.setProperty(PutDatabaseRecord.MAX_BATCH_SIZE, "5");
        Supplier<PreparedStatement> spyStmt = this.createPreparedStatementSpy();
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Assertions.assertEquals((int)11, (int)this.getTableSize());
        Assertions.assertNotNull((Object)spyStmt.get());
        ((PreparedStatement)Mockito.verify((Object)spyStmt.get(), (VerificationMode)Mockito.times((int)3))).executeBatch();
    }

    @Test
    void testInsertWithDefaultMaxBatchSize() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        for (int i = 1; i < 12; ++i) {
            parser.addRecord(new Object[]{i, String.format("rec%s", i), 100 + i});
        }
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        Supplier<PreparedStatement> spyStmt = this.createPreparedStatementSpy();
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Assertions.assertEquals((int)11, (int)this.getTableSize());
        Assertions.assertNotNull((Object)spyStmt.get());
        ((PreparedStatement)Mockito.verify((Object)spyStmt.get(), (VerificationMode)Mockito.times((int)1))).executeBatch();
    }

    @Test
    void testGenerateTableName() throws Exception {
        List<RecordField> fields = Arrays.asList(new RecordField("id", RecordFieldType.INT.getDataType()), new RecordField("name", RecordFieldType.STRING.getDataType()), new RecordField("code", RecordFieldType.INT.getDataType()), new RecordField("non_existing", RecordFieldType.BOOLEAN.getDataType()));
        SimpleRecordSchema schema = new SimpleRecordSchema(fields);
        TableSchema tableSchema = new TableSchema(TABLE_NAME, Arrays.asList(new ColumnDescription("id", 4, true, Integer.valueOf(2), false), new ColumnDescription("name", 12, true, Integer.valueOf(255), true), new ColumnDescription("code", 4, true, Integer.valueOf(10), true)), false, new HashSet<String>(Arrays.asList("id")), "");
        this.runner.setProperty(PutDatabaseRecord.TRANSLATE_FIELD_NAMES, "false");
        this.runner.setProperty(PutDatabaseRecord.UNMATCHED_FIELD_BEHAVIOR, PutDatabaseRecord.IGNORE_UNMATCHED_FIELD);
        this.runner.setProperty(PutDatabaseRecord.UNMATCHED_COLUMN_BEHAVIOR, PutDatabaseRecord.IGNORE_UNMATCHED_COLUMN);
        this.runner.setProperty(PutDatabaseRecord.QUOTE_IDENTIFIERS, "true");
        this.runner.setProperty(PutDatabaseRecord.QUOTE_TABLE_IDENTIFIER, "true");
        PutDatabaseRecord.DMLSettings settings = new PutDatabaseRecord.DMLSettings(this.runner.getProcessContext());
        Assertions.assertEquals((Object)"test_catalog.test_schema.test_table", (Object)this.processor.generateTableName(settings, "test_catalog", "test_schema", "test_table", tableSchema));
    }

    @Test
    void testInsertMismatchedCompatibleDataTypes() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addSchemaField("dt", RecordFieldType.BIGINT);
        LocalDate testDate1 = LocalDate.of(2021, 1, 26);
        Date jdbcDate1 = Date.valueOf(testDate1);
        BigInteger nifiDate1 = BigInteger.valueOf(jdbcDate1.getTime());
        LocalDate testDate2 = LocalDate.of(2021, 7, 26);
        Date jdbcDate2 = Date.valueOf(testDate2);
        BigInteger nifiDate2 = BigInteger.valueOf(jdbcDate2.getTime());
        parser.addRecord(new Object[]{1, "rec1", 101, nifiDate1});
        parser.addRecord(new Object[]{2, "rec2", 102, nifiDate2});
        parser.addRecord(new Object[]{3, "rec3", 103, null});
        parser.addRecord(new Object[]{4, "rec4", 104, null});
        parser.addRecord(new Object[]{5, null, 105, null});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertEquals((int)101, (int)rs.getInt(3));
        Assertions.assertEquals((Object)jdbcDate1.toString(), (Object)rs.getDate(4).toString());
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertEquals((int)102, (int)rs.getInt(3));
        Assertions.assertEquals((Object)jdbcDate2.toString(), (Object)rs.getDate(4).toString());
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)3, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec3", (Object)rs.getString(2));
        Assertions.assertEquals((int)103, (int)rs.getInt(3));
        Assertions.assertNull((Object)rs.getDate(4));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)4, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec4", (Object)rs.getString(2));
        Assertions.assertEquals((int)104, (int)rs.getInt(3));
        Assertions.assertNull((Object)rs.getDate(4));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)5, (int)rs.getInt(1));
        Assertions.assertNull((Object)rs.getString(2));
        Assertions.assertEquals((int)105, (int)rs.getInt(3));
        Assertions.assertNull((Object)rs.getDate(4));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertMismatchedNotCompatibleDataTypes() throws InitializationException, ProcessException, SQLException {
        this.recreateTable(createPersons);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.STRING);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addSchemaField("dt", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.FLOAT.getDataType()).getFieldType());
        LocalDate testDate1 = LocalDate.of(2021, 1, 26);
        LocalDate testDate2 = LocalDate.of(2021, 7, 26);
        parser.addRecord(new Object[]{"1", "rec1", 101, Arrays.asList(1.0, 2.0)});
        parser.addRecord(new Object[]{"2", "rec2", 102, Arrays.asList(3.0, 4.0)});
        parser.addRecord(new Object[]{"3", "rec3", 103, null});
        parser.addRecord(new Object[]{"4", "rec4", 104, null});
        parser.addRecord(new Object[]{"5", null, 105, null});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_FAILURE, 1);
    }

    @Test
    void testLongVarchar() throws InitializationException, ProcessException, SQLException {
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("DROP TABLE TEMP");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stmt.execute("CREATE TABLE TEMP (id integer primary key, name long varchar)");
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addRecord(new Object[]{1, "rec1"});
        parser.addRecord(new Object[]{2, "rec2"});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, "TEMP");
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        ResultSet rs = stmt.executeQuery("SELECT * FROM TEMP");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(2));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(2));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertWithDifferentColumnOrdering() throws InitializationException, ProcessException, SQLException {
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("DROP TABLE TEMP");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stmt.execute("CREATE TABLE TEMP (id integer primary key, code integer, name long varchar)");
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addRecord(new Object[]{"rec1", 1, 101});
        parser.addRecord(new Object[]{"rec2", 2, 102});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, "TEMP");
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        ResultSet rs = stmt.executeQuery("SELECT * FROM TEMP");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((int)101, (int)rs.getInt(2));
        Assertions.assertEquals((Object)"rec1", (Object)rs.getString(3));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((int)102, (int)rs.getInt(2));
        Assertions.assertEquals((Object)"rec2", (Object)rs.getString(3));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertWithBlobClob() throws Exception {
        String createTableWithBlob = "CREATE TABLE PERSONS (id integer primary key, name clob,content blob, code integer CONSTRAINT CODE_RANGE CHECK (code >= 0 AND code < 1000))";
        this.recreateTable(createTableWithBlob);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        byte[] bytes = "BLOB".getBytes();
        Byte[] blobRecordValue = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            blobRecordValue[i] = bytes[i];
        }
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addSchemaField("content", RecordFieldType.ARRAY);
        parser.addRecord(new Object[]{1, "rec1", 101, blobRecordValue});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Clob clob = rs.getClob(2);
        Assertions.assertNotNull((Object)clob);
        char[] clobText = new char[5];
        int numBytes = clob.getCharacterStream().read(clobText);
        Assertions.assertEquals((int)4, (int)numBytes);
        Assertions.assertEquals((Object)"rec1", (Object)new String(clobText).substring(0, 4));
        Blob blob = rs.getBlob(3);
        Assertions.assertEquals((Object)"BLOB", (Object)new String(blob.getBytes(1L, (int)blob.length())));
        Assertions.assertEquals((int)101, (int)rs.getInt(4));
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertWithBlobClobObjectArraySource() throws Exception {
        String createTableWithBlob = "CREATE TABLE PERSONS (id integer primary key, name clob,content blob, code integer CONSTRAINT CODE_RANGE CHECK (code >= 0 AND code < 1000))";
        this.recreateTable(createTableWithBlob);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        byte[] bytes = "BLOB".getBytes();
        Object[] blobRecordValue = new Object[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            blobRecordValue[i] = bytes[i];
        }
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addSchemaField("content", RecordFieldType.ARRAY);
        parser.addRecord(new Object[]{1, "rec1", 101, blobRecordValue});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Clob clob = rs.getClob(2);
        Assertions.assertNotNull((Object)clob);
        char[] clobText = new char[5];
        int numBytes = clob.getCharacterStream().read(clobText);
        Assertions.assertEquals((int)4, (int)numBytes);
        Assertions.assertEquals((Object)"rec1", (Object)new String(clobText).substring(0, 4));
        Blob blob = rs.getBlob(3);
        Assertions.assertEquals((Object)"BLOB", (Object)new String(blob.getBytes(1L, (int)blob.length())));
        Assertions.assertEquals((int)101, (int)rs.getInt(4));
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertWithBlobStringSource() throws Exception {
        String createTableWithBlob = "CREATE TABLE PERSONS (id integer primary key, name clob,content blob, code integer CONSTRAINT CODE_RANGE CHECK (code >= 0 AND code < 1000))";
        this.recreateTable(createTableWithBlob);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addSchemaField("content", RecordFieldType.STRING);
        parser.addRecord(new Object[]{1, "rec1", 101, "BLOB"});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM PERSONS");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Clob clob = rs.getClob(2);
        Assertions.assertNotNull((Object)clob);
        char[] clobText = new char[5];
        int numBytes = clob.getCharacterStream().read(clobText);
        Assertions.assertEquals((int)4, (int)numBytes);
        Assertions.assertEquals((Object)"rec1", (Object)new String(clobText).substring(0, 4));
        Blob blob = rs.getBlob(3);
        Assertions.assertEquals((Object)"BLOB", (Object)new String(blob.getBytes(1L, (int)blob.length())));
        Assertions.assertEquals((int)101, (int)rs.getInt(4));
        stmt.close();
        conn.close();
    }

    @Test
    void testInsertWithBlobIntegerArraySource() throws Exception {
        String createTableWithBlob = "CREATE TABLE PERSONS (id integer primary key, name clob,content blob, code integer CONSTRAINT CODE_RANGE CHECK (code >= 0 AND code < 1000))";
        this.recreateTable(createTableWithBlob);
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.INT);
        parser.addSchemaField("content", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.INT.getDataType()).getFieldType());
        parser.addRecord(new Object[]{1, "rec1", 101, new Integer[]{1, 2, 3}});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, TABLE_NAME);
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_RETRY, 0);
        this.runner.assertTransferCount(PutDatabaseRecord.REL_FAILURE, 1);
    }

    @Test
    void testInsertEnum() throws InitializationException, ProcessException, SQLException, IOException {
        this.dbcp = (DBCPServiceSimpleImpl)((Object)Mockito.spy((Object)((Object)new DBCPServiceSimpleImpl(DB_LOCATION, false))));
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        this.runner.addControllerService("dbcp", (ControllerService)this.dbcp, new HashMap());
        this.runner.enableControllerService((ControllerService)this.dbcp);
        this.runner.setProperty(PutDatabaseRecord.DBCP_SERVICE, "dbcp");
        try (Connection conn = this.dbcp.getConnection();){
            conn.createStatement().executeUpdate("DROP TABLE IF EXISTS ENUM_TEST");
        }
        this.recreateTable("CREATE TABLE IF NOT EXISTS ENUM_TEST (id integer primary key, suit ENUM('clubs', 'diamonds', 'hearts', 'spades'))");
        MockRecordParser parser = new MockRecordParser();
        this.runner.addControllerService("parser", (ControllerService)parser);
        this.runner.enableControllerService((ControllerService)parser);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("suit", RecordFieldType.ENUM.getEnumDataType(Arrays.asList("clubs", "diamonds", "hearts", "spades")).getFieldType());
        parser.addRecord(new Object[]{1, "diamonds"});
        parser.addRecord(new Object[]{2, "hearts"});
        this.runner.setProperty(PutDatabaseRecord.RECORD_READER_FACTORY, "parser");
        this.runner.setProperty(PutDatabaseRecord.STATEMENT_TYPE, "INSERT");
        this.runner.setProperty(PutDatabaseRecord.TABLE_NAME, "ENUM_TEST");
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PutDatabaseRecord.REL_SUCCESS, 1);
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM ENUM_TEST");
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"diamonds", (Object)rs.getString(2));
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)2, (int)rs.getInt(1));
        Assertions.assertEquals((Object)"hearts", (Object)rs.getString(2));
        Assertions.assertFalse((boolean)rs.next());
        stmt.close();
        conn.close();
    }

    private void recreateTable() throws ProcessException {
        try (Connection conn = this.dbcp.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute("drop table PERSONS");
            stmt.execute(createPersons);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private int getTableSize() throws SQLException {
        try (Connection connection = this.dbcp.getConnection();){
            int n;
            block12: {
                Statement stmt = connection.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery("SELECT count(*) FROM PERSONS");
                    Assertions.assertTrue((boolean)rs.next());
                    n = rs.getInt(1);
                    if (stmt == null) break block12;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return n;
        }
    }

    private void recreateTable(String createSQL) throws ProcessException, SQLException {
        Connection conn = this.dbcp.getConnection();
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("drop table PERSONS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute(createSQL);
        stmt.close();
        conn.close();
    }

    private Map<String, Object> createValues(int id, String name, int code) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("id", id);
        values.put("name", name);
        values.put("code", code);
        return values;
    }

    private Supplier<PreparedStatement> createPreparedStatementSpy() {
        final PreparedStatement[] spyStmt = new PreparedStatement[1];
        Answer answer = inv -> new DelegatingConnection((Connection)inv.callRealMethod()){

            public PreparedStatement prepareStatement(String sql) throws SQLException {
                spyStmt[0] = (PreparedStatement)Mockito.spy((Object)this.getDelegate().prepareStatement(sql));
                return spyStmt[0];
            }
        };
        ((DBCPServiceSimpleImpl)((Object)Mockito.doAnswer((Answer)answer).when((Object)this.dbcp))).getConnection(ArgumentMatchers.anyMap());
        return () -> spyStmt[0];
    }

    private /* synthetic */ void lambda$testGeneratePreparedStatementsFailUnmatchedField$2(RecordSchema schema, TableSchema tableSchema, PutDatabaseRecord.DMLSettings settings) throws Throwable {
        this.processor.generateDelete(schema, TABLE_NAME, tableSchema, settings);
    }

    private /* synthetic */ void lambda$testGeneratePreparedStatementsFailUnmatchedField$1(RecordSchema schema, TableSchema tableSchema, PutDatabaseRecord.DMLSettings settings) throws Throwable {
        this.processor.generateUpdate(schema, TABLE_NAME, null, tableSchema, settings);
    }

    private /* synthetic */ void lambda$testGeneratePreparedStatementsFailUnmatchedField$0(RecordSchema schema, TableSchema tableSchema, PutDatabaseRecord.DMLSettings settings) throws Throwable {
        this.processor.generateInsert(schema, TABLE_NAME, tableSchema, settings);
    }

    static class PutDatabaseRecordUnmatchedField
    extends PutDatabaseRecord {
        PutDatabaseRecordUnmatchedField() {
        }

        PutDatabaseRecord.SqlAndIncludedColumns generateInsert(RecordSchema recordSchema, String tableName, TableSchema tableSchema, PutDatabaseRecord.DMLSettings settings) throws IllegalArgumentException {
            return new PutDatabaseRecord.SqlAndIncludedColumns("INSERT INTO PERSONS VALUES (?,?,?,?)", Arrays.asList(0, 1, 2, 3));
        }
    }
}

