/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockPropertyValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSFTPTransfer {
    private SFTPTransfer createSftpTransfer(ProcessContext processContext, final SFTPClient sftpClient) {
        ComponentLog componentLog = (ComponentLog)Mockito.mock(ComponentLog.class);
        return new SFTPTransfer((PropertyContext)processContext, componentLog){

            protected SFTPClient getSFTPClient(FlowFile flowFile) {
                return sftpClient;
            }
        };
    }

    @Test
    public void testEnsureDirectoryExistsAlreadyExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsFailedToStat() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        Mockito.when((Object)sftpClient.stat("/dir1/dir2/dir3")).thenThrow(new Throwable[]{new SFTPException(Response.StatusCode.FAILURE, "Failure")});
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir));
        Assertions.assertEquals((Object)"Failed to determine if remote directory exists at /dir1/dir2/dir3 due to 4: Failure", (Object)e.getMessage());
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsNotExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        Mockito.when((Object)sftpClient.stat("/dir1/dir2/dir3")).thenThrow(new Throwable[]{new SFTPException(Response.StatusCode.NO_SUCH_FILE, "No such file")});
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsParentNotExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        Mockito.when((Object)sftpClient.stat("/dir1/dir2/dir3")).thenThrow(new Throwable[]{new SFTPException(Response.StatusCode.NO_SUCH_FILE, "No such file")});
        Mockito.when((Object)sftpClient.stat("/dir1/dir2")).thenThrow(new Throwable[]{new SFTPException(Response.StatusCode.NO_SUCH_FILE, "No such file")});
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsNotExistedFailedToCreate() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        Mockito.when((Object)sftpClient.stat("/dir1/dir2/dir3")).thenThrow(new Throwable[]{new SFTPException(Response.StatusCode.NO_SUCH_FILE, "No such file")});
        ((SFTPClient)Mockito.doThrow((Throwable[])new Throwable[]{new SFTPException(Response.StatusCode.FAILURE, "Failed")}).when((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir));
        Assertions.assertEquals((Object)"Failed to create remote directory /dir1/dir2/dir3 due to 4: Failed", (Object)e.getMessage());
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsBlindlyNotExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        Mockito.when((Object)processContext.getProperty(SFTPTransfer.DISABLE_DIRECTORY_LISTING)).thenReturn((Object)new MockPropertyValue("true"));
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient, (VerificationMode)Mockito.times((int)0))).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsBlindlyParentNotExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        Mockito.when((Object)processContext.getProperty(SFTPTransfer.DISABLE_DIRECTORY_LISTING)).thenReturn((Object)new MockPropertyValue("true"));
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        AtomicInteger mkdirCount = new AtomicInteger(0);
        ((SFTPClient)Mockito.doAnswer(invocation -> {
            int cnt = mkdirCount.getAndIncrement();
            if (cnt == 0) {
                throw new SFTPException(Response.StatusCode.NO_SUCH_FILE, "Failure");
            }
            return true;
        }).when((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient, (VerificationMode)Mockito.times((int)0))).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient, (VerificationMode)Mockito.times((int)2))).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2"));
    }

    @Test
    public void testEnsureDirectoryExistsBlindlyAlreadyExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        Mockito.when((Object)processContext.getProperty(SFTPTransfer.DISABLE_DIRECTORY_LISTING)).thenReturn((Object)new MockPropertyValue("true"));
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        ((SFTPClient)Mockito.doThrow((Throwable[])new Throwable[]{new SFTPException(Response.StatusCode.FAILURE, "Failure")}).when((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient, (VerificationMode)Mockito.times((int)0))).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsBlindlyFailed() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        Mockito.when((Object)processContext.getProperty(SFTPTransfer.DISABLE_DIRECTORY_LISTING)).thenReturn((Object)new MockPropertyValue("true"));
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        ((SFTPClient)Mockito.doThrow((Throwable[])new Throwable[]{new SFTPException(Response.StatusCode.PERMISSION_DENIED, "Permission denied")}).when((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir));
        Assertions.assertEquals((Object)"Could not blindly create remote directory due to Permission denied", (Object)e.getMessage());
        ((SFTPClient)Mockito.verify((Object)sftpClient, (VerificationMode)Mockito.times((int)0))).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }
}

