/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.standard.ValidateJson;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

class TestValidateJson {
    private static final String JSON = TestValidateJson.getFileContent("simple-example.json");
    private static final String NON_JSON = "Not JSON";
    private static final String SCHEMA_VERSION = ValidateJson.SchemaVersion.DRAFT_7.getValue();
    private TestRunner runner;

    TestValidateJson() {
    }

    @BeforeEach
    public void setUp() {
        this.runner = TestRunners.newTestRunner(ValidateJson.class);
    }

    @Test
    void testPassSchema() {
        String schemaPath = TestValidateJson.getFilePath("schema-simple-example.json");
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, schemaPath);
        this.runner.setProperty(ValidateJson.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 1);
        this.assertValidationErrors(ValidateJson.REL_VALID, false);
    }

    @Test
    void testEmptySchema() {
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, "{}");
        this.runner.setProperty(ValidateJson.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 1);
        this.assertValidationErrors(ValidateJson.REL_VALID, false);
    }

    @Test
    void testAllUnknownKeywordsSchema() {
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, "{\"fruit\": \"Apple\", \"size\": \"Large\", \"color\": \"Red\"}");
        this.runner.setProperty(ValidateJson.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 1);
        this.assertValidationErrors(ValidateJson.REL_VALID, false);
    }

    @Test
    void testPatternSchemaCheck() {
        String schemaPath = TestValidateJson.getFilePath("schema-simple-example-unmatched-pattern.json");
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, schemaPath);
        this.runner.setProperty(ValidateJson.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 0);
        this.assertValidationErrors(ValidateJson.REL_INVALID, true);
    }

    @Test
    void testMissingRequiredValue() {
        String schema = TestValidateJson.getFileContent("schema-simple-example-missing-required.json");
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, schema);
        this.runner.setProperty(ValidateJson.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 0);
        this.assertValidationErrors(ValidateJson.REL_INVALID, true);
    }

    @Test
    void testInvalidJson() {
        String schema = TestValidateJson.getFileContent("schema-simple-example.json");
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, schema);
        this.runner.setProperty(ValidateJson.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(NON_JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 1);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 0);
        this.assertValidationErrors(ValidateJson.REL_FAILURE, false);
    }

    @Test
    void testNonExistingSchema() {
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, "not-found.json");
        this.runner.setProperty(ValidateJson.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        Assertions.assertThrows(AssertionFailedError.class, () -> this.runner.run());
    }

    @Test
    void testBadSchema() {
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, NON_JSON);
        this.runner.setProperty(ValidateJson.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        Assertions.assertThrows(AssertionFailedError.class, () -> this.runner.run());
    }

    private void assertValidationErrors(Relationship relationship, boolean expected) {
        Map attributes = ((MockFlowFile)this.runner.getFlowFilesForRelationship(relationship).get(0)).getAttributes();
        if (expected) {
            Assertions.assertFalse((boolean)((String)attributes.get("json.validation.errors")).isEmpty());
        } else {
            Assertions.assertNull(attributes.get("json.validation.errors"));
        }
    }

    private static String getFilePath(String filename) {
        String path = TestValidateJson.getRelativeResourcePath(filename);
        URL url = Objects.requireNonNull(TestValidateJson.class.getResource(path), "Resource not found");
        return url.getPath();
    }

    private static String getFileContent(String filename) {
        String string;
        block8: {
            String path = TestValidateJson.getRelativeResourcePath(filename);
            InputStream inputStream = TestValidateJson.class.getResourceAsStream(path);
            try {
                Objects.requireNonNull(inputStream, "Resource not found");
                string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static String getRelativeResourcePath(String filename) {
        return String.format("/%s/%s", TestValidateJson.class.getSimpleName(), filename);
    }
}

