/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.SplitXml;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestSplitXml {
    SAXParserFactory factory;
    SAXParser saxParser;

    @BeforeEach
    public void setUp() throws Exception {
        this.factory = SAXParserFactory.newInstance();
        this.saxParser = this.factory.newSAXParser();
    }

    @Test
    public void testDepthOf0() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitXml());
        runner.setProperty(SplitXml.SPLIT_DEPTH, "0");
        runner.enqueue(Paths.get("src/test/resources/TestXml/xml-bundle-1", new String[0]));
        Assertions.assertThrows(AssertionError.class, () -> runner.run());
    }

    @Test
    public void testDepthOf1() throws Exception {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitXml());
        runner.enqueue(Paths.get("src/test/resources/TestXml/xml-bundle-1", new String[0]), (Map)new HashMap<String, String>(){
            {
                this.put(CoreAttributes.FILENAME.key(), "test.xml");
            }
        });
        runner.run();
        runner.assertTransferCount(SplitXml.REL_ORIGINAL, 1);
        MockFlowFile originalFlowFile = (MockFlowFile)runner.getFlowFilesForRelationship(SplitXml.REL_ORIGINAL).get(0);
        originalFlowFile.assertAttributeExists(FragmentAttributes.FRAGMENT_ID.key());
        originalFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "6");
        runner.assertTransferCount(SplitXml.REL_SPLIT, 6);
        this.parseFlowFiles(runner.getFlowFilesForRelationship(SplitXml.REL_ORIGINAL));
        this.parseFlowFiles(runner.getFlowFilesForRelationship(SplitXml.REL_SPLIT));
        Arrays.asList(0, 1, 2, 3, 4, 5).forEach(index -> {
            MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(SplitXml.REL_SPLIT).get((int)index);
            flowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), Integer.toString(index));
            flowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "6");
            flowFile.assertAttributeEquals(FragmentAttributes.SEGMENT_ORIGINAL_FILENAME.key(), "test.xml");
        });
    }

    @Test
    public void testDepthOf2() throws Exception {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitXml());
        runner.setProperty(SplitXml.SPLIT_DEPTH, "2");
        runner.enqueue(Paths.get("src/test/resources/TestXml/xml-bundle-1", new String[0]));
        runner.run();
        runner.assertTransferCount(SplitXml.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitXml.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "12");
        runner.assertTransferCount(SplitXml.REL_SPLIT, 12);
        this.parseFlowFiles(runner.getFlowFilesForRelationship(SplitXml.REL_ORIGINAL));
        this.parseFlowFiles(runner.getFlowFilesForRelationship(SplitXml.REL_SPLIT));
    }

    @Test
    public void testDepthOf3() throws Exception {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitXml());
        runner.setProperty(SplitXml.SPLIT_DEPTH, "3");
        runner.enqueue(Paths.get("src/test/resources/TestXml/xml-bundle-1", new String[0]));
        runner.run();
        runner.assertTransferCount(SplitXml.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitXml.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "12");
        runner.assertTransferCount(SplitXml.REL_SPLIT, 12);
        this.parseFlowFiles(runner.getFlowFilesForRelationship(SplitXml.REL_ORIGINAL));
        this.parseFlowFiles(runner.getFlowFilesForRelationship(SplitXml.REL_SPLIT));
    }

    @Test
    public void testNamespaceDeclarations() throws Exception {
        this.factory = SAXParserFactory.newInstance();
        this.factory.setNamespaceAware(true);
        this.saxParser = this.factory.newSAXParser();
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitXml());
        runner.setProperty(SplitXml.SPLIT_DEPTH, "3");
        runner.enqueue(Paths.get("src/test/resources/TestXml/namespace.xml", new String[0]));
        runner.run();
        runner.assertTransferCount(SplitXml.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitXml.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "2");
        runner.assertTransferCount(SplitXml.REL_SPLIT, 2);
        this.parseFlowFiles(runner.getFlowFilesForRelationship(SplitXml.REL_ORIGINAL));
        this.parseFlowFiles(runner.getFlowFilesForRelationship(SplitXml.REL_SPLIT));
        MockFlowFile split1 = (MockFlowFile)runner.getFlowFilesForRelationship(SplitXml.REL_SPLIT).get(0);
        split1.assertContentEquals(Paths.get("src/test/resources/TestXml/namespaceSplit1.xml", new String[0]));
        MockFlowFile split2 = (MockFlowFile)runner.getFlowFilesForRelationship(SplitXml.REL_SPLIT).get(1);
        split2.assertContentEquals(Paths.get("src/test/resources/TestXml/namespaceSplit2.xml", new String[0]));
    }

    public void parseFlowFiles(List<MockFlowFile> flowfiles) throws Exception, SAXException {
        for (MockFlowFile out : flowfiles) {
            byte[] outData = out.toByteArray();
            String outXml = new String(outData, "UTF-8");
            this.saxParser.parse(new InputSource(new StringReader(outXml)), new DefaultHandler());
        }
    }
}

