/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processors.standard.SampleRecord;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSampleRecord {
    @Test
    public void testIntervalSampling() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SampleRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SampleRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(SampleRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(SampleRecord.SAMPLING_STRATEGY, "interval");
        runner.assertNotValid();
        runner.setProperty(SampleRecord.SAMPLING_INTERVAL, "4");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        for (int i = 0; i < 100; ++i) {
            readerService.addRecord(new Object[]{UUID.randomUUID(), 48});
        }
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "25");
        runner.clearTransferState();
        runner.setProperty(SampleRecord.SAMPLING_INTERVAL, "1");
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        out = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "100");
    }

    @Test
    public void testIntervalSamplingWithNoRecords() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SampleRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SampleRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(SampleRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(SampleRecord.SAMPLING_STRATEGY, "interval");
        runner.assertNotValid();
        runner.setProperty(SampleRecord.SAMPLING_INTERVAL, "0");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        for (int i = 0; i < 100; ++i) {
            readerService.addRecord(new Object[]{UUID.randomUUID(), 48});
        }
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "0");
    }

    @Test
    public void testRangeSampling() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SampleRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SampleRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(SampleRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(SampleRecord.SAMPLING_STRATEGY, "range");
        runner.assertNotValid();
        runner.setProperty(SampleRecord.SAMPLING_RANGE, "1,4-5,98-");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        for (int i = 1; i <= 100; ++i) {
            readerService.addRecord(new Object[]{i, 5 + i});
        }
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "6");
        runner.clearTransferState();
        runner.setProperty(SampleRecord.SAMPLING_RANGE, "3");
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        out = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "1");
        out.assertContentEquals("header\n3,8\n");
        runner.clearTransferState();
        runner.setProperty(SampleRecord.SAMPLING_RANGE, "-2");
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        out = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "2");
        out.assertContentEquals("header\n1,6\n2,7\n");
        runner.clearTransferState();
        runner.setProperty(SampleRecord.SAMPLING_RANGE, "${range}");
        Map<String, String> attrs = Collections.singletonMap("range", "8,20");
        runner.enqueue("", attrs);
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        out = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "2");
        out.assertContentEquals("header\n8,13\n20,25\n");
        runner.clearTransferState();
        runner.setProperty(SampleRecord.SAMPLING_RANGE, "");
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        out = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "100");
    }

    @Test
    public void testProbabilisticSamplingWithSeed() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SampleRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SampleRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(SampleRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(SampleRecord.SAMPLING_STRATEGY, "probabilistic");
        runner.assertNotValid();
        runner.setProperty(SampleRecord.SAMPLING_PROBABILITY, "10");
        runner.setProperty(SampleRecord.RANDOM_SEED, "1");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        Random randomAge = new Random();
        for (int i = 0; i < 100; ++i) {
            readerService.addRecord(new Object[]{UUID.randomUUID(), randomAge.nextInt()});
        }
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        MockFlowFile first = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        String firstContent = new String(runner.getContentAsByteArray(first));
        runner.clearTransferState();
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        MockFlowFile second = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        String secondContent = new String(runner.getContentAsByteArray(second));
        Assertions.assertEquals((Object)firstContent, (Object)secondContent);
    }

    @Test
    public void testProbabilisticSamplingWithAllRecords() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SampleRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SampleRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(SampleRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(SampleRecord.SAMPLING_STRATEGY, "probabilistic");
        runner.assertNotValid();
        runner.setProperty(SampleRecord.SAMPLING_PROBABILITY, "100");
        RecordField nameField = new RecordField("name", RecordFieldType.STRING.getDataType());
        RecordField ageField = new RecordField("age", RecordFieldType.INT.getDataType());
        readerService.addSchemaField(nameField);
        readerService.addSchemaField(ageField);
        List<RecordField> recordFieldList = Arrays.asList(nameField, ageField);
        SimpleRecordSchema recordSchema = new SimpleRecordSchema(recordFieldList);
        Random randomAge = new Random();
        ArrayList<MapRecord> records = new ArrayList<MapRecord>(100);
        for (int i = 0; i < 100; ++i) {
            HashMap<String, Comparable<UUID>> recordMap = new HashMap<String, Comparable<UUID>>();
            UUID name = UUID.randomUUID();
            Integer age = randomAge.nextInt();
            recordMap.put("name", name);
            recordMap.put("age", age);
            records.add(new MapRecord((RecordSchema)recordSchema, recordMap));
            readerService.addRecord(new Object[]{name, age});
        }
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        MockFlowFile first = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        String[] content = new String(runner.getContentAsByteArray(first)).split(".*\n");
        for (int i = 0; i < content.length; ++i) {
            Assertions.assertEquals((Object)content[i], (Object)((Record)records.get(i)).toString());
        }
    }

    @Test
    public void testProbabilisticSamplingWithNoRecords() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SampleRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SampleRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(SampleRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(SampleRecord.SAMPLING_STRATEGY, "probabilistic");
        runner.assertNotValid();
        runner.setProperty(SampleRecord.SAMPLING_PROBABILITY, "0");
        RecordField nameField = new RecordField("name", RecordFieldType.STRING.getDataType());
        RecordField ageField = new RecordField("age", RecordFieldType.INT.getDataType());
        readerService.addSchemaField(nameField);
        readerService.addSchemaField(ageField);
        Random randomAge = new Random();
        for (int i = 0; i < 100; ++i) {
            readerService.addRecord(new Object[]{UUID.randomUUID(), randomAge.nextInt()});
        }
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        MockFlowFile first = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        String content = new String(runner.getContentAsByteArray(first));
        Assertions.assertTrue((boolean)content.isEmpty());
    }

    @Test
    public void testReservoirSampling() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SampleRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SampleRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(SampleRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(SampleRecord.SAMPLING_STRATEGY, "reservoir");
        runner.assertNotValid();
        runner.setProperty(SampleRecord.RESERVOIR_SIZE, "10");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        for (int i = 0; i < 100; ++i) {
            readerService.addRecord(new Object[]{UUID.randomUUID(), 48});
        }
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "10");
    }

    @Test
    public void testReservoirSamplingWithSeed() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SampleRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SampleRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(SampleRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(SampleRecord.SAMPLING_STRATEGY, "reservoir");
        runner.setProperty(SampleRecord.RANDOM_SEED, "1");
        runner.assertNotValid();
        runner.setProperty(SampleRecord.RESERVOIR_SIZE, "10");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        for (int i = 0; i < 100; ++i) {
            readerService.addRecord(new Object[]{UUID.randomUUID(), 48});
        }
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        MockFlowFile first = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        String firstContent = new String(runner.getContentAsByteArray(first));
        first.assertAttributeEquals("record.count", "10");
        runner.clearTransferState();
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SampleRecord.REL_SUCCESS, 1);
        runner.assertTransferCount(SampleRecord.REL_ORIGINAL, 1);
        MockFlowFile second = (MockFlowFile)runner.getFlowFilesForRelationship(SampleRecord.REL_SUCCESS).get(0);
        String secondContent = new String(runner.getContentAsByteArray(second));
        Assertions.assertEquals((Object)firstContent, (Object)secondContent);
    }
}

