/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClientService;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.DetectDuplicate;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.MockControllerServiceInitializationContext;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestDetectDuplicate {
    @Test
    public void testDuplicate() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner(DetectDuplicate.class);
        DistributedMapCacheClientImpl client = this.createClient();
        HashMap<String, String> clientProperties = new HashMap<String, String>();
        clientProperties.put(DistributedMapCacheClientService.HOSTNAME.getName(), "localhost");
        runner.addControllerService("client", (ControllerService)client, clientProperties);
        runner.setProperty(DetectDuplicate.DISTRIBUTED_CACHE_SERVICE, "client");
        runner.setProperty(DetectDuplicate.FLOWFILE_DESCRIPTION, "The original flow file");
        runner.setProperty(DetectDuplicate.AGE_OFF_DURATION, "48 hours");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hash.value", "1000");
        runner.enqueue(new byte[0], props);
        runner.enableControllerService((ControllerService)client);
        runner.run();
        runner.assertAllFlowFilesTransferred(DetectDuplicate.REL_NON_DUPLICATE, 1);
        runner.clearTransferState();
        runner.enqueue(new byte[0], props);
        runner.run();
        runner.assertAllFlowFilesTransferred(DetectDuplicate.REL_DUPLICATE, 1);
        runner.assertTransferCount(DetectDuplicate.REL_NON_DUPLICATE, 0);
        runner.assertTransferCount(DetectDuplicate.REL_FAILURE, 0);
    }

    @Test
    public void testDuplicateWithAgeOff() throws InitializationException, InterruptedException {
        TestRunner runner = TestRunners.newTestRunner(DetectDuplicate.class);
        DistributedMapCacheClientImpl client = this.createClient();
        HashMap<String, String> clientProperties = new HashMap<String, String>();
        clientProperties.put(DistributedMapCacheClientService.HOSTNAME.getName(), "localhost");
        runner.addControllerService("client", (ControllerService)client, clientProperties);
        runner.setProperty(DetectDuplicate.DISTRIBUTED_CACHE_SERVICE, "client");
        runner.setProperty(DetectDuplicate.FLOWFILE_DESCRIPTION, "The original flow file");
        runner.setProperty(DetectDuplicate.AGE_OFF_DURATION, "2 secs");
        runner.enableControllerService((ControllerService)client);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hash.value", "1000");
        runner.enqueue(new byte[0], props);
        runner.run();
        runner.assertAllFlowFilesTransferred(DetectDuplicate.REL_NON_DUPLICATE, 1);
        runner.clearTransferState();
        Thread.sleep(3000L);
        runner.enqueue(new byte[0], props);
        runner.run();
        runner.assertAllFlowFilesTransferred(DetectDuplicate.REL_NON_DUPLICATE, 1);
        runner.assertTransferCount(DetectDuplicate.REL_DUPLICATE, 0);
        runner.assertTransferCount(DetectDuplicate.REL_FAILURE, 0);
    }

    private DistributedMapCacheClientImpl createClient() throws InitializationException {
        DistributedMapCacheClientImpl client = new DistributedMapCacheClientImpl();
        MockComponentLog logger = new MockComponentLog("client", (Object)client);
        MockControllerServiceInitializationContext clientInitContext = new MockControllerServiceInitializationContext((ControllerService)client, "client", (ComponentLog)logger, (StateManager)new MockStateManager((Object)client));
        client.initialize((ControllerServiceInitializationContext)clientInitContext);
        return client;
    }

    @Test
    public void testDuplicateNoCache() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner(DetectDuplicate.class);
        DistributedMapCacheClientImpl client = this.createClient();
        HashMap<String, String> clientProperties = new HashMap<String, String>();
        clientProperties.put(DistributedMapCacheClientService.HOSTNAME.getName(), "localhost");
        runner.addControllerService("client", (ControllerService)client, clientProperties);
        runner.setProperty(DetectDuplicate.DISTRIBUTED_CACHE_SERVICE, "client");
        runner.setProperty(DetectDuplicate.FLOWFILE_DESCRIPTION, "The original flow file");
        runner.setProperty(DetectDuplicate.AGE_OFF_DURATION, "48 hours");
        runner.setProperty(DetectDuplicate.CACHE_IDENTIFIER, "false");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hash.value", "1000");
        runner.enqueue(new byte[0], props);
        runner.enableControllerService((ControllerService)client);
        runner.run();
        runner.assertAllFlowFilesTransferred(DetectDuplicate.REL_NON_DUPLICATE, 1);
        runner.clearTransferState();
        runner.setProperty(DetectDuplicate.CACHE_IDENTIFIER, "true");
        runner.enqueue(new byte[0], props);
        runner.run();
        runner.assertAllFlowFilesTransferred(DetectDuplicate.REL_NON_DUPLICATE, 1);
        runner.assertTransferCount(DetectDuplicate.REL_DUPLICATE, 0);
        runner.assertTransferCount(DetectDuplicate.REL_FAILURE, 0);
        runner.clearTransferState();
        runner.enqueue(new byte[0], props);
        runner.run();
        runner.assertAllFlowFilesTransferred(DetectDuplicate.REL_DUPLICATE, 1);
        runner.assertTransferCount(DetectDuplicate.REL_NON_DUPLICATE, 0);
        runner.assertTransferCount(DetectDuplicate.REL_FAILURE, 0);
    }

    @Test
    public void testDuplicateNoCacheWithAgeOff() throws InitializationException, InterruptedException {
        TestRunner runner = TestRunners.newTestRunner(DetectDuplicate.class);
        DistributedMapCacheClientImpl client = this.createClient();
        HashMap<String, String> clientProperties = new HashMap<String, String>();
        clientProperties.put(DistributedMapCacheClientService.HOSTNAME.getName(), "localhost");
        runner.addControllerService("client", (ControllerService)client, clientProperties);
        runner.setProperty(DetectDuplicate.DISTRIBUTED_CACHE_SERVICE, "client");
        runner.setProperty(DetectDuplicate.FLOWFILE_DESCRIPTION, "The original flow file");
        runner.setProperty(DetectDuplicate.AGE_OFF_DURATION, "2 secs");
        runner.enableControllerService((ControllerService)client);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hash.value", "1000");
        runner.enqueue(new byte[0], props);
        runner.run();
        runner.assertAllFlowFilesTransferred(DetectDuplicate.REL_NON_DUPLICATE, 1);
        runner.clearTransferState();
        Thread.sleep(3000L);
        runner.setProperty(DetectDuplicate.CACHE_IDENTIFIER, "false");
        runner.enqueue(new byte[0], props);
        runner.run();
        runner.assertAllFlowFilesTransferred(DetectDuplicate.REL_NON_DUPLICATE, 1);
        runner.assertTransferCount(DetectDuplicate.REL_DUPLICATE, 0);
        runner.assertTransferCount(DetectDuplicate.REL_FAILURE, 0);
    }

    static final class DistributedMapCacheClientImpl
    extends AbstractControllerService
    implements DistributedMapCacheClient {
        boolean exists = false;
        private Object cacheValue;

        DistributedMapCacheClientImpl() {
        }

        public void close() throws IOException {
        }

        public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        }

        protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
            ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
            props.add(DistributedMapCacheClientService.HOSTNAME);
            props.add(DistributedMapCacheClientService.COMMUNICATIONS_TIMEOUT);
            props.add(DistributedMapCacheClientService.PORT);
            props.add(DistributedMapCacheClientService.SSL_CONTEXT_SERVICE);
            return props;
        }

        public <K, V> boolean putIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
            if (this.exists) {
                return false;
            }
            this.cacheValue = value;
            this.exists = true;
            return true;
        }

        public <K, V> V getAndPutIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer, Deserializer<V> valueDeserializer) throws IOException {
            if (this.exists) {
                return (V)this.cacheValue;
            }
            this.cacheValue = value;
            this.exists = true;
            return null;
        }

        public <K> boolean containsKey(K key, Serializer<K> keySerializer) throws IOException {
            return this.exists;
        }

        public <K, V> V get(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
            if (this.exists) {
                return (V)this.cacheValue;
            }
            return null;
        }

        public <K> boolean remove(K key, Serializer<K> serializer) throws IOException {
            this.exists = false;
            return true;
        }

        public long removeByPattern(String regex) throws IOException {
            if (this.exists) {
                this.exists = false;
                return 1L;
            }
            return 0L;
        }

        public <K, V> void put(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
            this.cacheValue = value;
            this.exists = true;
        }
    }
}

