/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.processor.exception.ProcessException;

public class DBCPServiceSimpleImpl
extends AbstractControllerService
implements DBCPService {
    private String databaseLocation;
    private boolean isDerby;

    public DBCPServiceSimpleImpl(String databaseLocation) {
        this(databaseLocation, true);
    }

    public DBCPServiceSimpleImpl(String databaseLocation, boolean isDerby) {
        this.databaseLocation = databaseLocation;
        this.isDerby = isDerby;
    }

    public String getIdentifier() {
        return "dbcp";
    }

    public Connection getConnection() throws ProcessException {
        try {
            if (this.isDerby) {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                return DriverManager.getConnection("jdbc:derby:" + this.databaseLocation + ";create=true");
            }
            Path currentPath = Paths.get("", new String[0]);
            String absolutePathPrefix = currentPath.toFile().getAbsolutePath();
            String connectionString = "jdbc:h2:file:" + absolutePathPrefix + "/" + this.databaseLocation + ";DB_CLOSE_ON_EXIT=TRUE";
            return DriverManager.getConnection(connectionString, "SA", "");
        }
        catch (Exception e) {
            throw new ProcessException("getConnection failed: " + e);
        }
    }
}

