/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp.filesystem;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualFileSystem;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualPath;

public class VirtualFtpFile
implements FtpFile {
    private final VirtualPath path;
    private final VirtualFileSystem fileSystem;
    private long lastModified;

    public VirtualFtpFile(VirtualPath path, VirtualFileSystem fileSystem) throws IllegalArgumentException {
        if (path == null || fileSystem == null) {
            throw new IllegalArgumentException("File path and fileSystem cannot be null");
        }
        this.path = path;
        this.fileSystem = fileSystem;
        this.lastModified = Calendar.getInstance().getTimeInMillis();
    }

    public String getAbsolutePath() {
        return this.path.toString();
    }

    public String getName() {
        return this.path.getFileName();
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isFile() {
        return false;
    }

    public boolean doesExist() {
        return this.fileSystem.exists(this.path);
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isRemovable() {
        return true;
    }

    public String getOwnerName() {
        return "user";
    }

    public String getGroupName() {
        return "group";
    }

    public int getLinkCount() {
        return 1;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean setLastModified(long l) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("VirtualFtpFile.setLastModified()");
    }

    public long getSize() {
        return 0L;
    }

    public Object getPhysicalFile() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("VirtualFtpFile.getPhysicalFile()");
    }

    public boolean mkdir() {
        return this.fileSystem.mkdir(this.path);
    }

    public boolean delete() {
        return this.fileSystem.delete(this.path);
    }

    public boolean move(FtpFile ftpFile) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("VirtualFtpFile.move()");
    }

    public List<? extends FtpFile> listFiles() {
        List<VirtualPath> paths = this.fileSystem.listChildren(this.path);
        ArrayList<VirtualFtpFile> files = new ArrayList<VirtualFtpFile>();
        for (VirtualPath path : paths) {
            files.add(new VirtualFtpFile(path, this.fileSystem));
        }
        return files;
    }

    public OutputStream createOutputStream(long l) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("VirtualFtpFile.createOutputStream()");
    }

    public InputStream createInputStream(long l) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("VirtualFtpFile.createInputStream()");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualFtpFile)) {
            return false;
        }
        VirtualFtpFile other = (VirtualFtpFile)o;
        return this.fileSystem.equals(other.fileSystem) && this.path.equals(other.path);
    }
}

