/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"csv", "attributes", "flowfile"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Generates a CSV representation of the input FlowFile Attributes. The resulting CSV can be written to either a newly generated attribute named 'CSVAttributes' or written to the FlowFile as content.  If the attribute value contains a comma, newline or double quote, then the attribute value will be escaped with double quotes.  Any double quote characters in the attribute value are escaped with another double quote.")
@WritesAttributes(value={@WritesAttribute(attribute="CSVSchema", description="CSV representation of the Schema"), @WritesAttribute(attribute="CSVData", description="CSV representation of Attributes")})
public class AttributesToCSV
extends AbstractProcessor {
    private static final String DATA_ATTRIBUTE_NAME = "CSVData";
    private static final String SCHEMA_ATTRIBUTE_NAME = "CSVSchema";
    private static final String OUTPUT_SEPARATOR = ",";
    private static final String OUTPUT_MIME_TYPE = "text/csv";
    private static final String SPLIT_REGEX = ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    static final AllowableValue OUTPUT_OVERWRITE_CONTENT = new AllowableValue("flowfile-content", "flowfile-content", "The resulting CSV string will be placed into the content of the flowfile.Existing flowfile context will be overwritten. 'CSVData' will not be written to at all (neither null nor empty string).");
    static final AllowableValue OUTPUT_NEW_ATTRIBUTE = new AllowableValue("flowfile-attribute", "flowfile-attribute", "The resulting CSV string will be placed into a new flowfile attribute named 'CSVData'.  The content of the flowfile will not be changed.");
    public static final PropertyDescriptor ATTRIBUTES_LIST = new PropertyDescriptor.Builder().name("attribute-list").displayName("Attribute List").description("Comma separated list of attributes to be included in the resulting CSV. If this value is left empty then all existing Attributes will be included. This list of attributes is case sensitive and supports attribute names that contain commas. If an attribute specified in the list is not found it will be emitted to the resulting CSV with an empty string or null depending on the 'Null Value' property. If a core attribute is specified in this list and the 'Include Core Attributes' property is false, the core attribute will be included. The attribute list ALWAYS wins.").required(false).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor ATTRIBUTES_REGEX = new PropertyDescriptor.Builder().name("attributes-regex").displayName("Attributes Regular Expression").description("Regular expression that will be evaluated against the flow file attributes to select the matching attributes. This property can be used in combination with the attributes list property.  The final output will contain a combination of matches found in the ATTRIBUTE_LIST and ATTRIBUTE_REGEX.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true)).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).build();
    public static final PropertyDescriptor DESTINATION = new PropertyDescriptor.Builder().name("destination").displayName("Destination").description("Control if CSV value is written as a new flowfile attribute 'CSVData' or written in the flowfile content.").required(true).allowableValues(new AllowableValue[]{OUTPUT_NEW_ATTRIBUTE, OUTPUT_OVERWRITE_CONTENT}).defaultValue(OUTPUT_NEW_ATTRIBUTE.getDisplayName()).build();
    public static final PropertyDescriptor INCLUDE_CORE_ATTRIBUTES = new PropertyDescriptor.Builder().name("include-core-attributes").displayName("Include Core Attributes").description("Determines if the FlowFile org.apache.nifi.flowfile.attributes.CoreAttributes, which are contained in every FlowFile, should be included in the final CSV value generated.  Core attributes will be added to the end of the CSVData and CSVSchema strings.  The Attribute List property overrides this setting.").required(true).allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("true").build();
    public static final PropertyDescriptor NULL_VALUE_FOR_EMPTY_STRING = new PropertyDescriptor.Builder().name("null-value").displayName("Null Value").description("If true a non existing or empty attribute will be 'null' in the resulting CSV. If false an empty string will be placed in the CSV").required(true).allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("false").build();
    public static final PropertyDescriptor INCLUDE_SCHEMA = new PropertyDescriptor.Builder().name("include-schema").displayName("Include Schema").description("If true the schema (attribute names) will also be converted to a CSV string which will either be applied to a new attribute named 'CSVSchema' or applied at the first row in the content depending on the DESTINATION property setting.").required(true).allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("false").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully converted attributes to CSV").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Failed to convert attributes to CSV").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private volatile Boolean includeCoreAttributes;
    private volatile Set<String> coreAttributes;
    private volatile boolean destinationContent;
    private volatile boolean nullValForEmptyString;
    private volatile Pattern pattern;
    private volatile Boolean includeSchema;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(ATTRIBUTES_LIST);
        properties.add(ATTRIBUTES_REGEX);
        properties.add(DESTINATION);
        properties.add(INCLUDE_CORE_ATTRIBUTES);
        properties.add(NULL_VALUE_FOR_EMPTY_STRING);
        properties.add(INCLUDE_SCHEMA);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    private Map<String, String> buildAttributesMapForFlowFile(FlowFile ff, Set<String> attributes, Pattern attPattern) {
        String val;
        Map ffAttributes = ff.getAttributes();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(ffAttributes.size());
        if (!attributes.isEmpty() || attPattern != null) {
            if (!attributes.isEmpty()) {
                for (String string : attributes) {
                    val = ff.getAttribute(string);
                    if (val != null && !val.isEmpty()) {
                        result.put(string, val);
                        continue;
                    }
                    if (this.nullValForEmptyString) {
                        result.put(string, "null");
                        continue;
                    }
                    result.put(string, "");
                }
            }
            if (attPattern != null) {
                for (Map.Entry entry : ff.getAttributes().entrySet()) {
                    if (!attPattern.matcher((CharSequence)entry.getKey()).matches()) continue;
                    result.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
        } else {
            result.putAll(ffAttributes);
        }
        if (this.includeCoreAttributes.booleanValue()) {
            for (String string : this.coreAttributes) {
                val = ff.getAttribute(string);
                if (!ffAttributes.containsKey(string)) continue;
                if (!StringUtils.isEmpty((CharSequence)val)) {
                    result.put(string, val);
                    continue;
                }
                if (this.nullValForEmptyString) {
                    result.put(string, "null");
                    continue;
                }
                result.put(string, "");
            }
        } else {
            for (String string : this.coreAttributes) {
                if (attributes.contains(string)) continue;
                result.remove(string);
            }
        }
        return result;
    }

    private LinkedHashSet<String> attributeListStringToSet(String attributeList) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)attributeList)) {
            String[] ats;
            for (String str : ats = attributeList.split(SPLIT_REGEX)) {
                result.add(StringEscapeUtils.unescapeCsv((String)str.trim()));
            }
        }
        return result;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.includeCoreAttributes = context.getProperty(INCLUDE_CORE_ATTRIBUTES).asBoolean();
        this.coreAttributes = Arrays.stream(CoreAttributes.values()).map(CoreAttributes::key).collect(Collectors.toSet());
        this.destinationContent = OUTPUT_OVERWRITE_CONTENT.getValue().equals(context.getProperty(DESTINATION).getValue());
        this.nullValForEmptyString = context.getProperty(NULL_VALUE_FOR_EMPTY_STRING).asBoolean();
        this.includeSchema = context.getProperty(INCLUDE_SCHEMA).asBoolean();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        if (context.getProperty(ATTRIBUTES_REGEX).isSet()) {
            this.pattern = Pattern.compile(context.getProperty(ATTRIBUTES_REGEX).evaluateAttributeExpressions(original).getValue());
        }
        LinkedHashSet<String> attributeList = this.attributeListStringToSet(context.getProperty(ATTRIBUTES_LIST).evaluateAttributeExpressions(original).getValue());
        Map<String, String> atrList = this.buildAttributesMapForFlowFile(original, attributeList, this.pattern);
        int index = 0;
        int atrListSize = atrList.values().size() - 1;
        StringBuilder sbValues = new StringBuilder();
        for (Map.Entry<String, String> entry : atrList.entrySet()) {
            sbValues.append(StringEscapeUtils.escapeCsv((String)entry.getValue()));
            sbValues.append(index++ < atrListSize ? OUTPUT_SEPARATOR : "");
        }
        StringBuilder sbNames = new StringBuilder();
        if (this.includeSchema.booleanValue()) {
            index = 0;
            for (Map.Entry<String, String> entry : atrList.entrySet()) {
                sbNames.append(StringEscapeUtils.escapeCsv((String)entry.getKey()));
                sbNames.append(index++ < atrListSize ? OUTPUT_SEPARATOR : "");
            }
        }
        try {
            if (this.destinationContent) {
                FlowFile flowFile2 = session.write(original, (in, out) -> {
                    if (this.includeSchema.booleanValue()) {
                        sbNames.append(System.getProperty("line.separator"));
                        out.write(sbNames.toString().getBytes());
                    }
                    out.write(sbValues.toString().getBytes());
                });
                flowFile2 = session.putAttribute(flowFile2, CoreAttributes.MIME_TYPE.key(), OUTPUT_MIME_TYPE);
                session.transfer(flowFile2, REL_SUCCESS);
            } else {
                FlowFile flowFile = session.putAttribute(original, DATA_ATTRIBUTE_NAME, sbValues.toString());
                if (this.includeSchema.booleanValue()) {
                    session.putAttribute(original, SCHEMA_ATTRIBUTE_NAME, sbNames.toString());
                }
                session.transfer(flowFile, REL_SUCCESS);
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception.getMessage());
            session.transfer(original, REL_FAILURE);
        }
    }
}

