/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ssh;

import java.util.Collections;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.standard.socket.ClientConfigurationException;
import org.apache.nifi.processors.standard.socket.ClientConnectException;
import org.apache.nifi.processors.standard.ssh.StandardSSHClientProvider;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.processors.standard.util.FileTransfer;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.remote.io.socket.NetworkUtils;
import org.apache.nifi.util.MockPropertyValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StandardSSHClientProviderTest {
    private static final PropertyValue NULL_PROPERTY_VALUE = new MockPropertyValue(null);
    private static final PropertyValue BOOLEAN_TRUE_PROPERTY_VALUE = new MockPropertyValue(Boolean.TRUE.toString());
    private static final PropertyValue BOOLEAN_FALSE_PROPERTY_VALUE = new MockPropertyValue(Boolean.FALSE.toString());
    private static final PropertyValue TIMEOUT_PROPERTY_VALUE = new MockPropertyValue("2 s");
    private static final String LOCALHOST = "localhost";
    private static final PropertyValue HOSTNAME_PROPERTY = new MockPropertyValue("localhost");
    @Mock
    private PropertyContext context;
    private StandardSSHClientProvider provider;
    private int port;

    @BeforeEach
    public void setProvider() {
        Mockito.when((Object)this.context.getProperty((PropertyDescriptor)ArgumentMatchers.any())).thenReturn((Object)BOOLEAN_TRUE_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.CIPHERS_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.KEY_ALGORITHMS_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.KEY_EXCHANGE_ALGORITHMS_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.MESSAGE_AUTHENTICATION_CODES_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FileTransfer.CONNECTION_TIMEOUT)).thenReturn((Object)TIMEOUT_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FileTransfer.DATA_TIMEOUT)).thenReturn((Object)TIMEOUT_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.STRICT_HOST_KEY_CHECKING)).thenReturn((Object)BOOLEAN_FALSE_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.HOST_KEY_FILE)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FileTransfer.USE_COMPRESSION)).thenReturn((Object)BOOLEAN_FALSE_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.PROXY_CONFIGURATION_SERVICE)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.PROXY_TYPE)).thenReturn((Object)new MockPropertyValue(FTPTransfer.PROXY_TYPE_DIRECT));
        Mockito.when((Object)this.context.getProperty(FTPTransfer.PROXY_HOST)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.PROXY_PORT)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.HTTP_PROXY_USERNAME)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.HTTP_PROXY_PASSWORD)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FileTransfer.HOSTNAME)).thenReturn((Object)HOSTNAME_PROPERTY);
        this.port = NetworkUtils.getAvailableTcpPort();
        Mockito.when((Object)this.context.getProperty(FTPTransfer.PORT)).thenReturn((Object)new MockPropertyValue(Integer.toString(this.port)));
        this.provider = new StandardSSHClientProvider();
    }

    @Test
    public void testGetClientConfigurationException() {
        ClientConfigurationException exception = (ClientConfigurationException)Assertions.assertThrows(ClientConfigurationException.class, () -> this.provider.getClient(this.context, Collections.emptyMap()));
        Assertions.assertTrue((boolean)exception.getMessage().contains(LOCALHOST));
        Assertions.assertTrue((boolean)exception.getMessage().contains(Integer.toString(this.port)));
    }

    @Test
    public void testGetClientConnectException() {
        ClientConnectException exception = (ClientConnectException)Assertions.assertThrows(ClientConnectException.class, () -> this.provider.getClient(this.context, Collections.emptyMap()));
        Assertions.assertTrue((boolean)exception.getMessage().contains(LOCALHOST));
        Assertions.assertTrue((boolean)exception.getMessage().contains(Integer.toString(this.port)));
    }
}

