/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import javax.net.SocketFactory;
import org.apache.nifi.processors.standard.ftp.ProxyFTPClient;
import org.apache.nifi.remote.io.socket.NetworkUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ProxyFTPClientTest {
    @Mock
    private SocketFactory socketFactory;
    @Mock
    private Socket socket;
    @Captor
    private ArgumentCaptor<InetSocketAddress> socketAddressCaptor;
    private static final String HOST = "host.unresolved";
    private static final String WELCOME_REPLY = "220 Welcome";
    private int port;
    private ProxyFTPClient client;

    @BeforeEach
    public void setClient() {
        this.port = NetworkUtils.getAvailableTcpPort();
        this.client = new ProxyFTPClient(this.socketFactory);
    }

    @Test
    public void testConnect() throws IOException {
        Mockito.when((Object)this.socketFactory.createSocket()).thenReturn((Object)this.socket);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)new ByteArrayInputStream(WELCOME_REPLY.getBytes(StandardCharsets.US_ASCII)));
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)new ByteArrayOutputStream());
        this.client.connect(HOST, this.port);
        ((Socket)Mockito.verify((Object)this.socket)).connect((SocketAddress)this.socketAddressCaptor.capture(), ArgumentMatchers.anyInt());
        InetSocketAddress socketAddress = (InetSocketAddress)this.socketAddressCaptor.getValue();
        Assertions.assertNotNull((Object)socketAddress);
        Assertions.assertEquals((Object)HOST, (Object)socketAddress.getHostString());
        Assertions.assertEquals((int)this.port, (int)socketAddress.getPort());
    }
}

