/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.MergeContent;
import org.apache.nifi.processors.standard.SplitContent;
import org.apache.nifi.processors.standard.UnpackContent;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUnpackContent {
    private static final String FIRST_FRAGMENT_INDEX = "1";
    private static final Path dataPath = Paths.get("src/test/resources/TestUnpackContent", new String[0]);

    @Test
    public void testTar() throws IOException {
        TestRunner unpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        TestRunner autoUnpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        unpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.TAR_FORMAT.toString());
        autoUnpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.AUTO_DETECT_FORMAT.toString());
        unpackRunner.enqueue(dataPath.resolve("data.tar"));
        unpackRunner.enqueue(dataPath.resolve("data.tar"));
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        HashMap<String, String> attributes2 = new HashMap<String, String>(1);
        attributes.put("mime.type", UnpackContent.PackageFormat.TAR_FORMAT.getMimeType());
        attributes2.put("mime.type", UnpackContent.PackageFormat.X_TAR_FORMAT.getMimeType());
        autoUnpackRunner.enqueue(dataPath.resolve("data.tar"), attributes);
        autoUnpackRunner.enqueue(dataPath.resolve("data.tar"), attributes2);
        unpackRunner.run(2);
        autoUnpackRunner.run(2);
        unpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 4);
        unpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 2);
        ((MockFlowFile)unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        ((MockFlowFile)unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(1)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        unpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 4);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 2);
        ((MockFlowFile)autoUnpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        ((MockFlowFile)autoUnpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(1)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        List unpacked = unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS);
        for (MockFlowFile flowFile : unpacked) {
            String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
            String folder = flowFile.getAttribute(CoreAttributes.PATH.key());
            Path path = dataPath.resolve(folder).resolve(filename);
            Assertions.assertEquals((Object)"rw-r--r--", (Object)flowFile.getAttribute("file.permissions"));
            Assertions.assertEquals((Object)"jmcarey", (Object)flowFile.getAttribute("file.owner"));
            Assertions.assertEquals((Object)"mkpasswd", (Object)flowFile.getAttribute("file.group"));
            String modifiedTimeAsString = flowFile.getAttribute("file.lastModifiedTime");
            DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ").parse(modifiedTimeAsString);
            String creationTimeAsString = flowFile.getAttribute("file.creationTime");
            DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ").parse(creationTimeAsString);
            Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
            flowFile.assertContentEquals(path.toFile());
        }
    }

    @Test
    public void testTarWithFilter() throws IOException {
        Path path;
        String folder;
        String filename;
        TestRunner unpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        TestRunner autoUnpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        unpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.TAR_FORMAT.toString());
        unpackRunner.setProperty(UnpackContent.FILE_FILTER, "^folder/date.txt$");
        autoUnpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.AUTO_DETECT_FORMAT.toString());
        autoUnpackRunner.setProperty(UnpackContent.FILE_FILTER, "^folder/cal.txt$");
        unpackRunner.enqueue(dataPath.resolve("data.tar"));
        unpackRunner.enqueue(dataPath.resolve("data.tar"));
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        HashMap<String, String> attributes2 = new HashMap<String, String>(1);
        attributes.put("mime.type", "application/x-tar");
        attributes2.put("mime.type", "application/tar");
        autoUnpackRunner.enqueue(dataPath.resolve("data.tar"), attributes);
        autoUnpackRunner.enqueue(dataPath.resolve("data.tar"), attributes2);
        unpackRunner.run(2);
        autoUnpackRunner.run(2);
        unpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 2);
        unpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 2);
        ((MockFlowFile)unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, FIRST_FRAGMENT_INDEX);
        ((MockFlowFile)unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(1)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, FIRST_FRAGMENT_INDEX);
        unpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 2);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 2);
        ((MockFlowFile)autoUnpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, FIRST_FRAGMENT_INDEX);
        ((MockFlowFile)autoUnpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(1)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, FIRST_FRAGMENT_INDEX);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        List unpacked = unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS);
        for (MockFlowFile flowFile : unpacked) {
            filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
            folder = flowFile.getAttribute(CoreAttributes.PATH.key());
            path = dataPath.resolve(folder).resolve(filename);
            Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
            Assertions.assertEquals((Object)"date.txt", (Object)filename);
            flowFile.assertContentEquals(path.toFile());
        }
        unpacked = autoUnpackRunner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS);
        for (MockFlowFile flowFile : unpacked) {
            filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
            folder = flowFile.getAttribute(CoreAttributes.PATH.key());
            path = dataPath.resolve(folder).resolve(filename);
            Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
            Assertions.assertEquals((Object)"cal.txt", (Object)filename);
            flowFile.assertContentEquals(path.toFile());
        }
    }

    @Test
    public void testZip() throws IOException {
        TestRunner unpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        TestRunner autoUnpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        unpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.ZIP_FORMAT.toString());
        autoUnpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.AUTO_DETECT_FORMAT.toString());
        unpackRunner.enqueue(dataPath.resolve("data.zip"));
        unpackRunner.enqueue(dataPath.resolve("data.zip"));
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        attributes.put("mime.type", "application/zip");
        autoUnpackRunner.enqueue(dataPath.resolve("data.zip"), attributes);
        autoUnpackRunner.enqueue(dataPath.resolve("data.zip"), attributes);
        unpackRunner.run(2);
        autoUnpackRunner.run(2);
        unpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 4);
        unpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 2);
        ((MockFlowFile)unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        ((MockFlowFile)unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(1)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        unpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 4);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 2);
        ((MockFlowFile)autoUnpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        ((MockFlowFile)autoUnpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(1)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        List unpacked = unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS);
        for (MockFlowFile flowFile : unpacked) {
            String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
            String folder = flowFile.getAttribute(CoreAttributes.PATH.key());
            Path path = dataPath.resolve(folder).resolve(filename);
            Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
            flowFile.assertContentEquals(path.toFile());
        }
    }

    @Test
    public void testInvalidZip() throws IOException {
        TestRunner unpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        TestRunner autoUnpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        unpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.ZIP_FORMAT.toString());
        autoUnpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.AUTO_DETECT_FORMAT.toString());
        unpackRunner.enqueue(dataPath.resolve("invalid_data.zip"));
        unpackRunner.enqueue(dataPath.resolve("invalid_data.zip"));
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        attributes.put("mime.type", "application/zip");
        autoUnpackRunner.enqueue(dataPath.resolve("invalid_data.zip"), attributes);
        autoUnpackRunner.enqueue(dataPath.resolve("invalid_data.zip"), attributes);
        unpackRunner.run(2);
        autoUnpackRunner.run(2);
        unpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 2);
        unpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 0);
        unpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 0);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 2);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 0);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 0);
        List unpacked = unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_FAILURE);
        for (MockFlowFile flowFile : unpacked) {
            String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
            Path path = dataPath.resolve(filename);
            Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
            flowFile.assertContentEquals(path.toFile());
        }
    }

    @Test
    public void testZipEncryptionZipStandard() throws IOException {
        this.runZipEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
    }

    @Test
    public void testZipEncryptionAes() throws IOException {
        this.runZipEncryptionMethod(EncryptionMethod.AES);
    }

    @Test
    public void testZipEncryptionNoPasswordConfigured() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new UnpackContent());
        runner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.ZIP_FORMAT.toString());
        String password = String.class.getSimpleName();
        char[] streamPassword = password.toCharArray();
        String contents = TestRunner.class.getCanonicalName();
        byte[] zipEncrypted = this.createZipEncrypted(EncryptionMethod.AES, streamPassword, contents);
        runner.enqueue(zipEncrypted);
        runner.run();
        runner.assertTransferCount(UnpackContent.REL_FAILURE, 1);
    }

    @Test
    public void testZipWithFilter() throws IOException {
        Path path;
        String folder;
        String filename;
        TestRunner unpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        TestRunner autoUnpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        unpackRunner.setProperty(UnpackContent.FILE_FILTER, "^folder/date.txt$");
        unpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.ZIP_FORMAT.toString());
        autoUnpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.AUTO_DETECT_FORMAT.toString());
        autoUnpackRunner.setProperty(UnpackContent.FILE_FILTER, "^folder/cal.txt$");
        unpackRunner.enqueue(dataPath.resolve("data.zip"));
        unpackRunner.enqueue(dataPath.resolve("data.zip"));
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        attributes.put("mime.type", "application/zip");
        autoUnpackRunner.enqueue(dataPath.resolve("data.zip"), attributes);
        autoUnpackRunner.enqueue(dataPath.resolve("data.zip"), attributes);
        unpackRunner.run(2);
        autoUnpackRunner.run(2);
        unpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 2);
        unpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 2);
        ((MockFlowFile)unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, FIRST_FRAGMENT_INDEX);
        ((MockFlowFile)unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(1)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, FIRST_FRAGMENT_INDEX);
        unpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 2);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 2);
        ((MockFlowFile)autoUnpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, FIRST_FRAGMENT_INDEX);
        ((MockFlowFile)autoUnpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(1)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, FIRST_FRAGMENT_INDEX);
        autoUnpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        List unpacked = unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS);
        for (MockFlowFile flowFile : unpacked) {
            filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
            folder = flowFile.getAttribute(CoreAttributes.PATH.key());
            path = dataPath.resolve(folder).resolve(filename);
            Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
            Assertions.assertEquals((Object)"date.txt", (Object)filename);
            flowFile.assertContentEquals(path.toFile());
        }
        unpacked = autoUnpackRunner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS);
        for (MockFlowFile flowFile : unpacked) {
            filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
            folder = flowFile.getAttribute(CoreAttributes.PATH.key());
            path = dataPath.resolve(folder).resolve(filename);
            Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
            Assertions.assertEquals((Object)"cal.txt", (Object)filename);
            flowFile.assertContentEquals(path.toFile());
        }
    }

    @Test
    public void testFlowFileStreamV3() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new UnpackContent());
        runner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.FLOWFILE_STREAM_FORMAT_V3.toString());
        runner.enqueue(dataPath.resolve("data.flowfilev3"));
        runner.enqueue(dataPath.resolve("data.flowfilev3"));
        runner.run(2);
        runner.assertTransferCount(UnpackContent.REL_SUCCESS, 4);
        runner.assertTransferCount(UnpackContent.REL_ORIGINAL, 2);
        ((MockFlowFile)runner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        ((MockFlowFile)runner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(1)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        List unpacked = runner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS);
        for (MockFlowFile flowFile : unpacked) {
            String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
            String folder = flowFile.getAttribute(CoreAttributes.PATH.key());
            Path path = dataPath.resolve(folder).resolve(filename);
            Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
            flowFile.assertContentEquals(path.toFile());
        }
    }

    @Test
    public void testFlowFileStreamV2() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new UnpackContent());
        runner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.FLOWFILE_STREAM_FORMAT_V2.toString());
        runner.enqueue(dataPath.resolve("data.flowfilev2"));
        runner.enqueue(dataPath.resolve("data.flowfilev2"));
        runner.run(2);
        runner.assertTransferCount(UnpackContent.REL_SUCCESS, 4);
        runner.assertTransferCount(UnpackContent.REL_ORIGINAL, 2);
        ((MockFlowFile)runner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        ((MockFlowFile)runner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(1)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        List unpacked = runner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS);
        for (MockFlowFile flowFile : unpacked) {
            String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
            String folder = flowFile.getAttribute(CoreAttributes.PATH.key());
            Path path = dataPath.resolve(folder).resolve(filename);
            Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
            flowFile.assertContentEquals(path.toFile());
        }
    }

    @Test
    public void testTarThenMerge() throws IOException {
        TestRunner unpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        unpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.TAR_FORMAT.toString());
        unpackRunner.enqueue(dataPath.resolve("data.tar"));
        unpackRunner.run();
        unpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 2);
        unpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 1);
        ((MockFlowFile)unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        unpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        List unpacked = unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS);
        for (MockFlowFile flowFile : unpacked) {
            Assertions.assertEquals((Object)flowFile.getAttribute(UnpackContent.SEGMENT_ORIGINAL_FILENAME), (Object)"data");
        }
        TestRunner mergeRunner = TestRunners.newTestRunner((Processor)new MergeContent());
        mergeRunner.setProperty(MergeContent.MERGE_FORMAT, MergeContent.MERGE_FORMAT_TAR);
        mergeRunner.setProperty(MergeContent.MERGE_STRATEGY, MergeContent.MERGE_STRATEGY_DEFRAGMENT);
        mergeRunner.setProperty(MergeContent.KEEP_PATH, "true");
        mergeRunner.enqueue((FlowFile[])unpacked.toArray(new MockFlowFile[0]));
        mergeRunner.run();
        mergeRunner.assertTransferCount(MergeContent.REL_MERGED, 1);
        mergeRunner.assertTransferCount(MergeContent.REL_ORIGINAL, 2);
        mergeRunner.assertTransferCount(MergeContent.REL_FAILURE, 0);
        List packed = mergeRunner.getFlowFilesForRelationship(MergeContent.REL_MERGED);
        for (MockFlowFile flowFile : packed) {
            flowFile.assertAttributeEquals(CoreAttributes.FILENAME.key(), "data.tar");
        }
    }

    @Test
    public void testZipThenMerge() throws IOException {
        TestRunner unpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        unpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.ZIP_FORMAT.toString());
        unpackRunner.enqueue(dataPath.resolve("data.zip"));
        unpackRunner.run();
        unpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 2);
        unpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 1);
        MockFlowFile originalFlowFile = (MockFlowFile)unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_ORIGINAL).get(0);
        originalFlowFile.assertAttributeExists(SplitContent.FRAGMENT_ID);
        originalFlowFile.assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        unpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 0);
        List unpacked = unpackRunner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS);
        for (MockFlowFile flowFile : unpacked) {
            Assertions.assertEquals((Object)flowFile.getAttribute(UnpackContent.SEGMENT_ORIGINAL_FILENAME), (Object)"data");
        }
        TestRunner mergeRunner = TestRunners.newTestRunner((Processor)new MergeContent());
        mergeRunner.setProperty(MergeContent.MERGE_FORMAT, MergeContent.MERGE_FORMAT_ZIP);
        mergeRunner.setProperty(MergeContent.MERGE_STRATEGY, MergeContent.MERGE_STRATEGY_DEFRAGMENT);
        mergeRunner.setProperty(MergeContent.KEEP_PATH, "true");
        mergeRunner.enqueue((FlowFile[])unpacked.toArray(new MockFlowFile[0]));
        mergeRunner.run();
        mergeRunner.assertTransferCount(MergeContent.REL_MERGED, 1);
        mergeRunner.assertTransferCount(MergeContent.REL_ORIGINAL, 2);
        mergeRunner.assertTransferCount(MergeContent.REL_FAILURE, 0);
        List packed = mergeRunner.getFlowFilesForRelationship(MergeContent.REL_MERGED);
        for (MockFlowFile flowFile : packed) {
            flowFile.assertAttributeEquals(CoreAttributes.FILENAME.key(), "data.zip");
        }
    }

    @Test
    public void testZipHandlesBadData() throws IOException {
        TestRunner unpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        unpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.ZIP_FORMAT.toString());
        unpackRunner.enqueue(dataPath.resolve("data.tar"));
        unpackRunner.run();
        unpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 0);
        unpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 0);
        unpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 1);
    }

    @Test
    public void testTarHandlesBadData() throws IOException {
        TestRunner unpackRunner = TestRunners.newTestRunner((Processor)new UnpackContent());
        unpackRunner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.TAR_FORMAT.toString());
        unpackRunner.enqueue(dataPath.resolve("data.zip"));
        unpackRunner.run();
        unpackRunner.assertTransferCount(UnpackContent.REL_SUCCESS, 0);
        unpackRunner.assertTransferCount(UnpackContent.REL_ORIGINAL, 0);
        unpackRunner.assertTransferCount(UnpackContent.REL_FAILURE, 1);
    }

    @Test
    public void testThreadSafetyUsingAutoDetect() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new UnpackContent());
        runner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.AUTO_DETECT_FORMAT.toString());
        HashMap<String, String> attrsTar = new HashMap<String, String>(1);
        HashMap<String, String> attrsFFv3 = new HashMap<String, String>(1);
        attrsTar.put("mime.type", UnpackContent.PackageFormat.TAR_FORMAT.getMimeType());
        attrsFFv3.put("mime.type", UnpackContent.PackageFormat.FLOWFILE_STREAM_FORMAT_V3.getMimeType());
        int numThreads = 50;
        runner.setThreadCount(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            if (i % 2 == 0) {
                runner.enqueue(dataPath.resolve("data.tar"), attrsTar);
                continue;
            }
            runner.enqueue(dataPath.resolve("data.flowfilev3"), attrsFFv3);
        }
        runner.run(numThreads);
        runner.assertTransferCount(UnpackContent.REL_SUCCESS, numThreads * 2);
    }

    private void runZipEncryptionMethod(EncryptionMethod encryptionMethod) throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new UnpackContent());
        runner.setProperty(UnpackContent.PACKAGING_FORMAT, UnpackContent.PackageFormat.ZIP_FORMAT.toString());
        String password = String.class.getSimpleName();
        runner.setProperty(UnpackContent.PASSWORD, password);
        char[] streamPassword = password.toCharArray();
        String contents = TestRunner.class.getCanonicalName();
        byte[] zipEncrypted = this.createZipEncrypted(encryptionMethod, streamPassword, contents);
        runner.enqueue(zipEncrypted);
        runner.run();
        runner.assertTransferCount(UnpackContent.REL_SUCCESS, 1);
        runner.assertTransferCount(UnpackContent.REL_ORIGINAL, 1);
        MockFlowFile unpacked = (MockFlowFile)runner.getFlowFilesForRelationship(UnpackContent.REL_SUCCESS).iterator().next();
        unpacked.assertAttributeEquals("file.encryptionMethod", encryptionMethod.toString());
        unpacked.assertAttributeEquals(UnpackContent.FRAGMENT_INDEX, FIRST_FRAGMENT_INDEX);
        byte[] unpackedBytes = runner.getContentAsByteArray(unpacked);
        String unpackedContents = new String(unpackedBytes);
        Assertions.assertEquals((Object)contents, (Object)unpackedContents, (String)"Unpacked Contents not matched");
    }

    private byte[] createZipEncrypted(EncryptionMethod encryptionMethod, char[] password, String contents) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)outputStream, password);
        String name = UUID.randomUUID().toString();
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setEncryptionMethod(encryptionMethod);
        zipParameters.setEncryptFiles(true);
        zipParameters.setFileNameInZip(name);
        zipOutputStream.putNextEntry(zipParameters);
        zipOutputStream.write(contents.getBytes());
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        return outputStream.toByteArray();
    }
}

