/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.lookup.SimpleKeyValueLookupService;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.TransformXml;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestTransformXml {
    @Test
    public void testStylesheetNotFound() {
        TestRunner controller = TestRunners.newTestRunner(TransformXml.class);
        controller.setProperty(TransformXml.XSLT_FILE_NAME, "/no/path/to/math.xsl");
        controller.assertNotValid();
    }

    @Test
    public void testNonXmlContent() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        runner.setProperty(TransformXml.XSLT_FILE_NAME, "src/test/resources/TestTransformXml/math.xsl");
        HashMap attributes = new HashMap();
        runner.enqueue("not xml".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(TransformXml.REL_FAILURE);
        MockFlowFile original = (MockFlowFile)runner.getFlowFilesForRelationship(TransformXml.REL_FAILURE).get(0);
        original.assertContentEquals("not xml");
    }

    @Test
    public void testTransformMath() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        runner.setProperty("header", "Test for mod");
        runner.setProperty(TransformXml.XSLT_FILE_NAME, "src/test/resources/TestTransformXml/math.xsl");
        HashMap attributes = new HashMap();
        runner.enqueue(Paths.get("src/test/resources/TestTransformXml/math.xml", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(TransformXml.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(TransformXml.REL_SUCCESS).get(0);
        String expectedContent = new String(Files.readAllBytes(Paths.get("src/test/resources/TestTransformXml/math.html", new String[0]))).trim();
        transformed.assertContentEquals(expectedContent);
    }

    @Test
    public void testTransformCsv() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        runner.setProperty(TransformXml.XSLT_FILE_NAME, "src/test/resources/TestTransformXml/tokens.xsl");
        runner.setProperty("uuid_0", "${uuid_0}");
        runner.setProperty("uuid_1", "${uuid_1}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("uuid_0", "uuid_0");
        attributes.put("uuid_1", "uuid_1");
        StringBuilder builder = new StringBuilder();
        builder.append("<data>\n");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("src/test/resources/TestTransformXml/tokens.csv")));){
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            builder.append("</data>");
            String data = builder.toString();
            runner.enqueue(data.getBytes(), attributes);
            runner.run();
            runner.assertAllFlowFilesTransferred(TransformXml.REL_SUCCESS);
            MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(TransformXml.REL_SUCCESS).get(0);
            String expectedContent = new String(Files.readAllBytes(Paths.get("src/test/resources/TestTransformXml/tokens.xml", new String[0])));
            transformed.assertContentEquals(expectedContent);
        }
    }

    @Test
    public void testTransformExpressionLanguage() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        runner.setProperty("header", "Test for mod");
        runner.setProperty(TransformXml.XSLT_FILE_NAME, "${xslt.path}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("xslt.path", "src/test/resources/TestTransformXml/math.xsl");
        runner.enqueue(Paths.get("src/test/resources/TestTransformXml/math.xml", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(TransformXml.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(TransformXml.REL_SUCCESS).get(0);
        String expectedContent = new String(Files.readAllBytes(Paths.get("src/test/resources/TestTransformXml/math.html", new String[0]))).trim();
        transformed.assertContentEquals(expectedContent);
    }

    @Test
    public void testTransformNoCache() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        runner.setProperty("header", "Test for mod");
        runner.setProperty(TransformXml.CACHE_SIZE, "0");
        runner.setProperty(TransformXml.XSLT_FILE_NAME, "src/test/resources/TestTransformXml/math.xsl");
        runner.enqueue(Paths.get("src/test/resources/TestTransformXml/math.xml", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(TransformXml.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(TransformXml.REL_SUCCESS).get(0);
        String expectedContent = new String(Files.readAllBytes(Paths.get("src/test/resources/TestTransformXml/math.html", new String[0]))).trim();
        transformed.assertContentEquals(expectedContent);
    }

    @Test
    public void testTransformBothControllerFileNotValid() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        runner.setProperty(TransformXml.XSLT_FILE_NAME, "src/test/resources/TestTransformXml/math.xsl");
        SimpleKeyValueLookupService service = new SimpleKeyValueLookupService();
        runner.addControllerService("simple-key-value-lookup-service", (ControllerService)service);
        runner.setProperty((ControllerService)service, "key1", "value1");
        runner.enableControllerService((ControllerService)service);
        runner.assertValid((ControllerService)service);
        runner.setProperty(TransformXml.XSLT_CONTROLLER, "simple-key-value-lookup-service");
        runner.assertNotValid();
    }

    @Test
    public void testTransformNoneControllerFileNotValid() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        runner.setProperty(TransformXml.CACHE_SIZE, "0");
        runner.assertNotValid();
    }

    @Test
    public void testTransformControllerNoKey() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        SimpleKeyValueLookupService service = new SimpleKeyValueLookupService();
        runner.addControllerService("simple-key-value-lookup-service", (ControllerService)service);
        runner.setProperty((ControllerService)service, "key1", "value1");
        runner.enableControllerService((ControllerService)service);
        runner.assertValid((ControllerService)service);
        runner.setProperty(TransformXml.XSLT_CONTROLLER, "simple-key-value-lookup-service");
        runner.assertNotValid();
    }

    @Test
    public void testTransformWithController() throws IOException, InitializationException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        SimpleKeyValueLookupService service = new SimpleKeyValueLookupService();
        runner.addControllerService("simple-key-value-lookup-service", (ControllerService)service);
        runner.setProperty((ControllerService)service, "math", "<xsl:stylesheet version=\"2.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"><xsl:param name=\"header\" /><xsl:template match=\"doc\"><HTML><H1><xsl:value-of select=\"$header\"/></H1><HR/><P>Should say \"1\": <xsl:value-of select=\"5 mod 2\"/></P><P>Should say \"1\": <xsl:value-of select=\"n1 mod n2\"/></P><P>Should say \"-1\": <xsl:value-of select=\"div mod mod\"/></P><P><xsl:value-of select=\"div or ((mod)) | or\"/></P></HTML></xsl:template></xsl:stylesheet>");
        runner.enableControllerService((ControllerService)service);
        runner.assertValid((ControllerService)service);
        runner.setProperty(TransformXml.XSLT_CONTROLLER, "simple-key-value-lookup-service");
        runner.setProperty(TransformXml.XSLT_CONTROLLER_KEY, "${xslt}");
        runner.setProperty("header", "Test for mod");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("xslt", "math");
        runner.enqueue(Paths.get("src/test/resources/TestTransformXml/math.xml", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(TransformXml.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(TransformXml.REL_SUCCESS).get(0);
        String expectedContent = new String(Files.readAllBytes(Paths.get("src/test/resources/TestTransformXml/math.html", new String[0]))).trim();
        transformed.assertContentEquals(expectedContent);
    }

    @Test
    public void testTransformWithXsltNotFoundInController() throws IOException, InitializationException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        SimpleKeyValueLookupService service = new SimpleKeyValueLookupService();
        runner.addControllerService("simple-key-value-lookup-service", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.assertValid((ControllerService)service);
        runner.setProperty(TransformXml.XSLT_CONTROLLER, "simple-key-value-lookup-service");
        runner.setProperty(TransformXml.XSLT_CONTROLLER_KEY, "${xslt}");
        runner.setProperty("header", "Test for mod");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("xslt", "math");
        runner.enqueue(Paths.get("src/test/resources/TestTransformXml/math.xml", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(TransformXml.REL_FAILURE);
    }

    @Test
    public void testTransformWithControllerNoCache() throws IOException, InitializationException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        SimpleKeyValueLookupService service = new SimpleKeyValueLookupService();
        runner.addControllerService("simple-key-value-lookup-service", (ControllerService)service);
        runner.setProperty((ControllerService)service, "math", "<xsl:stylesheet version=\"2.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"><xsl:param name=\"header\" /><xsl:template match=\"doc\"><HTML><H1><xsl:value-of select=\"$header\"/></H1><HR/><P>Should say \"1\": <xsl:value-of select=\"5 mod 2\"/></P><P>Should say \"1\": <xsl:value-of select=\"n1 mod n2\"/></P><P>Should say \"-1\": <xsl:value-of select=\"div mod mod\"/></P><P><xsl:value-of select=\"div or ((mod)) | or\"/></P></HTML></xsl:template></xsl:stylesheet>");
        runner.enableControllerService((ControllerService)service);
        runner.assertValid((ControllerService)service);
        runner.setProperty(TransformXml.XSLT_CONTROLLER, "simple-key-value-lookup-service");
        runner.setProperty(TransformXml.XSLT_CONTROLLER_KEY, "${xslt}");
        runner.setProperty(TransformXml.CACHE_SIZE, "0");
        runner.setProperty("header", "Test for mod");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("xslt", "math");
        runner.enqueue(Paths.get("src/test/resources/TestTransformXml/math.xml", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(TransformXml.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(TransformXml.REL_SUCCESS).get(0);
        String expectedContent = new String(Files.readAllBytes(Paths.get("src/test/resources/TestTransformXml/math.html", new String[0]))).trim();
        transformed.assertContentEquals(expectedContent);
    }

    @Test
    public void testTransformSecureProcessingEnabledXmlWithEntity() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        runner.setProperty(TransformXml.XSLT_FILE_NAME, "src/test/resources/TestTransformXml/doc-node.xsl");
        runner.setProperty(TransformXml.INDENT_OUTPUT, Boolean.FALSE.toString());
        String input = "<!DOCTYPE doc [<!ENTITY uri SYSTEM \"http://127.0.0.1\" >]><doc>&uri;</doc>";
        runner.enqueue("<!DOCTYPE doc [<!ENTITY uri SYSTEM \"http://127.0.0.1\" >]><doc>&uri;</doc>");
        runner.run();
        runner.assertAllFlowFilesTransferred(TransformXml.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(TransformXml.REL_SUCCESS).get(0);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><doc xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"/>";
        transformed.assertContentEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?><doc xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"/>");
    }

    @Test
    public void testTransformSecureProcessingEnabledXslWithEntity() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new TransformXml());
        runner.setProperty(TransformXml.XSLT_FILE_NAME, "src/test/resources/TestTransformXml/doctype-entity-file-uri.xsl");
        runner.setProperty(TransformXml.INDENT_OUTPUT, Boolean.FALSE.toString());
        runner.enqueue(Paths.get("src/test/resources/TestTransformXml/doctype-entity-file-uri.xsl", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(TransformXml.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(TransformXml.REL_SUCCESS).get(0);
        transformed.assertContentEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }
}

