/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.TailFile;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTailFile {
    private static final Logger logger = LoggerFactory.getLogger(TestTailFile.class);
    private File file;
    private File existingFile;
    private File otherFile;
    private RandomAccessFile raf;
    private RandomAccessFile otherRaf;
    private TailFile processor;
    private TestRunner runner;

    @BeforeEach
    public void setup() throws IOException {
        System.setProperty("org.slf4j.simpleLogger.log.org.apache.nifi.processors.standard", "TRACE");
        this.clean();
        this.file = new File("target/log.txt");
        this.file.delete();
        Assertions.assertTrue((boolean)this.file.createNewFile());
        this.existingFile = new File("target/existing-log.txt");
        this.existingFile.delete();
        Assertions.assertTrue((boolean)this.existingFile.createNewFile());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.existingFile)));){
            writer.write("Line 1");
            writer.newLine();
            writer.write("Line 2");
            writer.newLine();
            writer.write("Line 3");
            writer.newLine();
            writer.flush();
        }
        File directory = new File("target/testDir");
        if (!directory.exists()) {
            Assertions.assertTrue((boolean)directory.mkdirs());
        }
        this.otherFile = new File("target/testDir/log.txt");
        this.otherFile.delete();
        Assertions.assertTrue((boolean)this.otherFile.createNewFile());
        this.processor = new TailFile();
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        this.runner.setProperty(TailFile.FILENAME, "target/log.txt");
        this.runner.assertValid();
        this.raf = new RandomAccessFile(this.file, "rw");
        this.otherRaf = new RandomAccessFile(this.otherFile, "rw");
    }

    @AfterEach
    public void cleanup() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.otherRaf != null) {
            this.otherRaf.close();
        }
        this.processor.cleanup((ProcessContext)new MockProcessContext((ConfigurableComponent)this.processor));
        File[] files = this.file.getParentFile().listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".log")) continue;
                file.delete();
            }
        }
        System.clearProperty("org.slf4j.simpleLogger.log.org.apache.nifi.processors.standard");
    }

    @Test
    public void testNULContentWithReReadOnNulFalseLeaveNul() throws Exception {
        this.runner.setProperty(TailFile.REREAD_ON_NUL, "false");
        this.testNULContentWithReReadOnNulDefault();
    }

    @Test
    public void testNULContentWithReReadOnNulDefault() throws Exception {
        String content1 = "first_line_with_nul\u0000\n";
        Integer reposition = null;
        String content2 = "second_line\n";
        List<String> expected = Arrays.asList("first_line_with_nul\u0000\n", "second_line\n");
        this.testNULContent(content1, reposition, content2, expected);
    }

    @Test
    public void testNULContentWithReReadOnNulFalseOverwriteNul() throws Exception {
        this.runner.setProperty(TailFile.REREAD_ON_NUL, "false");
        String content1 = "first_line_with_nul\u0000\n";
        Integer reposition = "first_line_with_nul".length();
        String content2 = "!!overwrite_nul_and_continue_first_line_but_end_up_in_second_line_anyway\n";
        List<String> expected = Arrays.asList("first_line_with_nul\u0000\n", "overwrite_nul_and_continue_first_line_but_end_up_in_second_line_anyway\n");
        this.testNULContent(content1, reposition, content2, expected);
    }

    @Test
    public void testNULContentWithReReadOnNulTrue() throws Exception {
        this.runner.setProperty(TailFile.REREAD_ON_NUL, "true");
        String content1 = "first_line_with_nul\u0000\n";
        Integer reposition = "first_line_with_nul".length();
        String content2 = " overwrite_nul_and_continue_first_line\n";
        List<String> expected = Arrays.asList("first_line_with_nul overwrite_nul_and_continue_first_line\n");
        this.testNULContent(content1, reposition, content2, expected);
    }

    private void testNULContent(String content1, Integer reposition, String content2, List<String> expected) throws IOException {
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_FILE.getValue());
        this.raf.write(content1.getBytes());
        this.runner.run(1, false, true);
        if (reposition != null) {
            this.raf.seek(reposition.intValue());
        }
        this.raf.write(content2.getBytes());
        this.runner.run(1, true, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, expected.size());
        List flowFiles = this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS);
        List lines = flowFiles.stream().map(MockFlowFile::toByteArray).map(String::new).collect(Collectors.toList());
        Assertions.assertEquals(expected, lines);
    }

    @Test
    public void testNULContentWhenRolledOver() throws IOException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.txt*");
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_FILE.getValue());
        this.runner.setProperty(TailFile.REREAD_ON_NUL, "true");
        this.raf.write("a\nb".getBytes());
        this.runner.run(1, false, true);
        this.raf.write(new byte[]{0, 0});
        long originalLastMod = this.file.lastModified();
        File rolledOverFile = this.rollover(0);
        this.runner.run(1, false, false);
        this.runner.assertTransferCount(TailFile.REL_SUCCESS, 1);
        try (RandomAccessFile rolledOverRAF = new RandomAccessFile(rolledOverFile, "rw");){
            rolledOverRAF.seek(3L);
            rolledOverRAF.write("c\n".getBytes());
        }
        rolledOverFile.setLastModified(originalLastMod);
        this.runner.run(1, false, false);
        this.raf.write("d\n".getBytes());
        this.runner.run(1, true, false);
        this.runner.assertTransferCount(TailFile.REL_SUCCESS, 3);
        List flowFiles = this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS);
        List lines = flowFiles.stream().map(MockFlowFile::toByteArray).map(String::new).collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList("a\n", "bc\n", "d\n"), lines);
    }

    @Test
    public void testRotateMultipleBeforeConsuming() throws IOException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.txt*");
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_FILE.getValue());
        this.raf.write("1\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        this.raf.write("1.5\n".getBytes());
        this.rollover(0);
        this.raf.write("2\n".getBytes());
        this.rollover(1);
        this.raf.write("3\n".getBytes());
        this.rollover(2);
        this.raf.write("4\n".getBytes());
        this.rollover(3);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 5);
        List flowFiles = this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS);
        Set lines = flowFiles.stream().map(MockFlowFile::toByteArray).map(String::new).collect(Collectors.toSet());
        Assertions.assertEquals((int)5, (int)lines.size());
        Assertions.assertTrue((boolean)lines.contains("1\n"));
        Assertions.assertTrue((boolean)lines.contains("1.5\n"));
        Assertions.assertTrue((boolean)lines.contains("2\n"));
        Assertions.assertTrue((boolean)lines.contains("3\n"));
        Assertions.assertTrue((boolean)lines.contains("4\n"));
        this.runner.clearTransferState();
    }

    @Test
    public void testStartPositionCurrentTime() throws IOException {
        this.raf.write("1\n".getBytes());
        this.rollover(0);
        this.raf.write("2\n".getBytes());
        this.rollover(1);
        this.raf.write("3\n4\n5\n".getBytes());
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_TIME.getValue());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("6\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0);
        out.assertContentEquals("6\n");
    }

    private File rollover(int index) throws IOException {
        this.raf.close();
        File rolledOverFile = new File(this.file.getParentFile(), this.file.getName() + "." + index + ".log");
        this.file.renameTo(rolledOverFile);
        this.raf = new RandomAccessFile(this.file, "rw");
        return rolledOverFile;
    }

    @DisabledOnOs(value={OS.WINDOWS}, disabledReason="Test requires renaming a file while a file handle is still open to it, so it won't run on Windows")
    @Test
    public void testFileWrittenToAfterRollover() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.*");
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_BEGINNING_OF_TIME.getValue());
        this.runner.setProperty(TailFile.REREAD_ON_NUL, "true");
        this.runner.setProperty(TailFile.POST_ROLLOVER_TAIL_PERIOD, "10 mins");
        this.raf.write("a\nb\n".getBytes());
        this.runner.run(1, false, true);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("a\nb\n");
        this.runner.clearTransferState();
        this.raf.write("c\n".getBytes());
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("c\n");
        this.runner.clearTransferState();
        this.raf.write("d\n".getBytes());
        File rolledFile = new File("target/log.1");
        boolean renamed = this.file.renameTo(rolledFile);
        Assertions.assertTrue((boolean)renamed);
        this.raf.getChannel().force(true);
        System.out.println("Wrote d\\n and rolled file");
        RandomAccessFile newFile = new RandomAccessFile(new File("target/log.txt"), "rw");
        newFile.write("new file\n".getBytes());
        newFile.close();
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("d\n");
        this.runner.clearTransferState();
        this.raf.write("e\nf".getBytes());
        System.out.println("Wrote e\\nf");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("e\n");
        this.runner.clearTransferState();
        this.raf.write("\n".getBytes());
        this.raf.write(0);
        this.raf.write(0);
        this.raf.write(0);
        System.out.println("Wrote \\n\\0\\0\\0");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("f\n");
        this.runner.clearTransferState();
        this.raf.setLength(this.raf.length() - 3L);
        this.raf.write("g\nh".getBytes());
        System.out.println("Truncated the NUL bytes and replaced with g\\nh");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("g\n");
        this.runner.clearTransferState();
        for (int i = 0; i < 100; ++i) {
            this.runner.run(1, false, false);
            this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
            Thread.sleep(1L);
        }
        Assertions.assertTrue((boolean)rolledFile.setLastModified(500L));
        System.out.println("Set lastModified on " + rolledFile + " to 500");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("h");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(1)).assertContentEquals("new file\n");
        this.runner.clearTransferState();
        this.raf.close();
    }

    @Test
    public void testConsumeAfterTruncationStartAtBeginningOfFile() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.txt*");
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_FILE.getValue());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("hello\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("hello\n");
        System.out.println("Ingested 6 bytes");
        this.runner.clearTransferState();
        this.raf.close();
        this.file.renameTo(new File(this.file.getParentFile(), this.file.getName() + ".previous"));
        this.raf = new RandomAccessFile(this.file, "rw");
        System.out.println("Rolled over file to " + this.file.getName() + ".previous");
        this.raf.setLength(0L);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        Thread.sleep(1000L);
        this.raf.write("HELLO\n".getBytes());
        System.out.println("Wrote out 6 bytes to tailed file");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("HELLO\n");
    }

    @Test
    public void testConsumeAfterTruncationStartAtCurrentTime() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_TIME.getValue());
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.txt*");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("hello\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("hello\n");
        this.runner.clearTransferState();
        this.raf.close();
        Assertions.assertTrue((boolean)this.file.renameTo(new File("target/log.txt.1")));
        this.raf = new RandomAccessFile(this.file, "rw");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        Thread.sleep(1000L);
        this.raf.write("HELLO\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("HELLO\n");
    }

    @Test
    public void testStartAtBeginningOfFile() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_FILE.getValue());
        this.raf.write("hello world\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("hello world\n");
    }

    @Test
    public void testStartAtCurrentTime() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_TIME.getValue());
        this.raf.write("hello world\n".getBytes());
        Thread.sleep(1000L);
        this.runner.run(100);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
    }

    @Test
    public void testStartAtBeginningOfTime() throws IOException, InterruptedException {
        this.raf.write("hello".getBytes());
        this.raf.close();
        this.file.renameTo(new File(this.file.getParentFile(), this.file.getName() + ".previous"));
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write("world\n".getBytes());
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.txt*");
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_BEGINNING_OF_TIME.getValue());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        boolean world = false;
        boolean hello = false;
        for (MockFlowFile mff : this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS)) {
            String content = new String(mff.toByteArray());
            if ("world\n".equals(content)) {
                world = true;
                continue;
            }
            if ("hello".equals(content)) {
                hello = true;
                continue;
            }
            Assertions.fail((String)("Got unexpected content: " + content));
        }
        Assertions.assertTrue((boolean)hello);
        Assertions.assertTrue((boolean)world);
    }

    @Test
    public void testRemainderOfFileRecoveredAfterRestart() throws IOException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log*.txt");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("hello\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("hello\n");
        this.runner.clearTransferState();
        this.raf.write("world".getBytes());
        this.raf.close();
        this.file.renameTo(new File("target/log1.txt"));
        this.raf = new RandomAccessFile(new File("target/log.txt"), "rw");
        this.raf.write("new file\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("world");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(1)).assertContentEquals("new file\n");
    }

    @Test
    public void testRemainderOfFileRecoveredIfRolledOverWhileRunning() throws IOException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log*.txt");
        this.runner.run(1, false, true);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("hello\n".getBytes());
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("hello\n");
        this.runner.clearTransferState();
        this.raf.write("world".getBytes());
        this.raf.close();
        this.file.renameTo(new File("target/log1.txt"));
        this.raf = new RandomAccessFile(new File("target/log.txt"), "rw");
        this.raf.write("1\n".getBytes());
        this.runner.run(1, true, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("world");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(1)).assertContentEquals("1\n");
    }

    @Test
    public void testRolloverAfterHavingReadAllData() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.*");
        this.runner.run(1, false, true);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("hello\n".getBytes());
        this.runner.run(1, true, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("hello\n");
        this.runner.clearTransferState();
        this.raf.write("world".getBytes());
        Thread.sleep(1000L);
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.close();
        this.file.renameTo(new File("target/log.1"));
        this.raf = new RandomAccessFile(new File("target/log.txt"), "rw");
        this.raf.write("1\n".getBytes());
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("world");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(1)).assertContentEquals("1\n");
    }

    @Test
    public void testRolloverWriteMoreDataThanPrevious() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.*");
        this.runner.run(1, false, true);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("hello\n".getBytes());
        this.runner.run(1, true, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("hello\n");
        this.runner.clearTransferState();
        this.raf.write("world".getBytes());
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.close();
        this.file.renameTo(new File("target/log.1"));
        this.raf = new RandomAccessFile(new File("target/log.txt"), "rw");
        this.raf.write("longer than hello\n".getBytes());
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("world");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(1)).assertContentEquals("longer than hello\n");
    }

    @Test
    public void testMultipleRolloversAfterHavingReadAllData() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.*");
        this.runner.run(1, false, true);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("hello\n".getBytes());
        this.runner.run(1, true, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("hello\n");
        this.runner.clearTransferState();
        this.raf.write("world".getBytes());
        this.runner.run(1);
        Thread.sleep(1000L);
        this.raf.close();
        this.file.renameTo(new File("target/log.2"));
        this.file = new File("target/log.txt");
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write("abc\n".getBytes());
        Thread.sleep(100L);
        this.raf.close();
        this.file.renameTo(new File("target/log.1"));
        this.file = new File("target/log.txt");
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write("1\n".getBytes());
        this.raf.close();
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 3);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("world");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(1)).assertContentEquals("abc\n");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(2)).assertContentEquals("1\n");
    }

    @Test
    public void testMultipleRolloversAfterHavingReadAllDataWhileStillRunning() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.*");
        this.runner.run(1, false, true);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("hello\n".getBytes());
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("hello\n");
        this.runner.clearTransferState();
        this.raf.write("world".getBytes());
        this.runner.run(1, false, false);
        Thread.sleep(1000L);
        this.raf.close();
        this.file.renameTo(new File("target/log.2"));
        this.file = new File("target/log.txt");
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write("abc\n".getBytes());
        Thread.sleep(100L);
        this.raf.close();
        this.file.renameTo(new File("target/log.1"));
        this.file = new File("target/log.txt");
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write("1\n".getBytes());
        this.raf.close();
        this.runner.run(1, true, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 3);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("world");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(1)).assertContentEquals("abc\n");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(2)).assertContentEquals("1\n");
    }

    @Test
    public void testMultipleRolloversWithLongerFileLength() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.*");
        this.runner.run(1, false, true);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("hello\n".getBytes());
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("hello\n");
        this.runner.clearTransferState();
        this.raf.write("world".getBytes());
        this.raf.close();
        this.file.renameTo(new File("target/log.2"));
        Thread.sleep(1200L);
        this.file = new File("target/log.txt");
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write("abc\n".getBytes());
        this.raf.close();
        this.file.renameTo(new File("target/log.1"));
        Thread.sleep(1200L);
        this.file = new File("target/log.txt");
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write("This is a longer line than the other files had.\n".getBytes());
        this.raf.close();
        this.runner.run(1, true, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 3);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("world");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(1)).assertContentEquals("abc\n");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(2)).assertContentEquals("This is a longer line than the other files had.\n");
    }

    @Test
    public void testConsumeWhenNewLineFound() throws IOException, InterruptedException {
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        Thread.sleep(1100L);
        this.raf.write("Hello, World".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("\r\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        TailFile.TailFileState state = ((TailFile.TailFileObject)((TailFile)this.runner.getProcessor()).getState().get("target/log.txt")).getState();
        Assertions.assertNotNull((Object)state);
        Assertions.assertEquals((Object)"target/log.txt", (Object)state.getFilename());
        Assertions.assertTrue((state.getTimestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
        Assertions.assertEquals((long)14L, (long)state.getPosition());
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("Hello, World\r\n");
        this.runner.clearTransferState();
        this.raf.write("12345".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.write("\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("12345\n");
        this.runner.clearTransferState();
        this.raf.write("carriage\rreturn\r".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("carriage\r");
        this.runner.clearTransferState();
        this.raf.write("\r\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("return\r\r\n");
    }

    @Test
    public void testMultiLineWaitsForRegexMatchShutdownBetweenReads() throws IOException {
        this.testMultiLineWaitsForRegexMatch(true);
    }

    @Test
    public void testMultiLineWaitsForRegexMatchWithoutShutdownBetweenReads() throws IOException {
        this.testMultiLineWaitsForRegexMatch(false);
    }

    private void testMultiLineWaitsForRegexMatch(boolean shutdownBetweenReads) throws IOException {
        this.runner.setProperty(TailFile.LINE_START_PATTERN, "<\\d>");
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.*");
        String line1 = "<1>Hello, World\n";
        String line2 = "<2>Good-bye, World\n";
        String line3 = "<3>Start of multi-line\n";
        String line4 = "<4>Last One\n";
        this.raf.write("<1>Hello, World\n".getBytes());
        this.raf.write("<2>Good-bye, World\n".getBytes());
        this.runner.run(1, shutdownBetweenReads, true);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        this.runner.clearTransferState();
        this.raf.write("<3>Start of multi-line\n".getBytes());
        this.runner.run(1, shutdownBetweenReads, shutdownBetweenReads);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        this.runner.clearTransferState();
        for (int i = 0; i < 10; ++i) {
            logger.info("i = " + i);
            this.raf.write(String.valueOf(i).getBytes());
            this.raf.write("\n".getBytes());
            this.runner.run(1, shutdownBetweenReads, shutdownBetweenReads);
            this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        }
        Map stateMap = this.runner.getStateManager().getState(Scope.LOCAL).toMap();
        Assertions.assertEquals((Object)String.valueOf("<1>Hello, World\n".length() + "<2>Good-bye, World\n".length() + "<3>Start of multi-line\n".length() + 20), stateMap.get("file.0.length"));
        Assertions.assertEquals((Object)String.valueOf("<1>Hello, World\n".length() + "<2>Good-bye, World\n".length()), stateMap.get("file.0.position"));
        this.raf.write("<4>Last One\n".getBytes());
        this.runner.run(1, shutdownBetweenReads, shutdownBetweenReads);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        MockFlowFile multiLineOutputFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0);
        multiLineOutputFile.assertContentEquals("<3>Start of multi-line\n0\n1\n2\n3\n4\n5\n6\n7\n8\n9\n");
        this.runner.clearTransferState();
        this.raf.close();
        this.file.renameTo(new File("target/log.1"));
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write(new byte[0]);
        this.runner.run(1, shutdownBetweenReads, shutdownBetweenReads);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        MockFlowFile finalOutputFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0);
        finalOutputFile.assertContentEquals("<4>Last One\n");
    }

    @Test
    public void testRolloverAndUpdateAtSameTime() throws IOException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "log.*");
        this.raf.write("hello there\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        this.runner.clearTransferState();
        this.raf.write("another".getBytes());
        this.raf.close();
        this.file.renameTo(new File("target/log.1"));
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write("new file\n".getBytes());
        this.runner.run(1, false, true);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("another");
        this.runner.clearTransferState();
        this.runner.run(1, true, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
    }

    @Test
    public void testRolloverWhenNoRollingPattern() throws IOException {
        this.raf.write("hello there\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        this.runner.clearTransferState();
        this.raf.write("another".getBytes());
        this.raf.close();
        this.file.renameTo(new File("target/log.1"));
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write("new file\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("new file\n");
        this.runner.clearTransferState();
        this.raf.close();
        this.file.renameTo(new File("target/log.2"));
        this.raf = new RandomAccessFile(this.file, "rw");
        this.raf.write("new file with longer data in the new file\n".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).get(0)).assertContentEquals("with longer data in the new file\n");
        this.runner.clearTransferState();
    }

    @Test
    public void testMultipleFiles() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.BASE_DIRECTORY, "target");
        this.runner.setProperty(TailFile.MODE, TailFile.MODE_MULTIFILE);
        Object fileRegex = File.separator.equals("/") ? "(testDir/)?log(ging)?.txt" : "(testDir" + Pattern.quote(File.separator) + ")?log(ging)?.txt";
        this.runner.setProperty(TailFile.FILENAME, (String)fileRegex);
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "${filename}.?");
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_FILE);
        this.runner.setProperty(TailFile.RECURSIVE, "true");
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        File thirdFile = new File("target/logging.txt");
        if (thirdFile.exists()) {
            thirdFile.delete();
        }
        Assertions.assertTrue((boolean)thirdFile.createNewFile());
        RandomAccessFile thirdFileRaf = new RandomAccessFile(thirdFile, "rw");
        thirdFileRaf.write("hey\n".getBytes());
        this.otherRaf.write("hi\n".getBytes());
        this.raf.write("hello\n".getBytes());
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 3);
        Optional<MockFlowFile> thirdFileFF = this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().filter(mockFlowFile -> mockFlowFile.isAttributeEqual("tailfile.original.path", thirdFile.getPath())).findFirst();
        Assertions.assertTrue((boolean)thirdFileFF.isPresent());
        thirdFileFF.get().assertContentEquals("hey\n");
        Optional<MockFlowFile> otherFileFF = this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().filter(mockFlowFile -> mockFlowFile.isAttributeEqual("tailfile.original.path", this.otherFile.getPath())).findFirst();
        Assertions.assertTrue((boolean)otherFileFF.isPresent());
        otherFileFF.get().assertContentEquals("hi\n");
        Optional<MockFlowFile> fileFF = this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().filter(mockFlowFile -> mockFlowFile.isAttributeEqual("tailfile.original.path", this.file.getPath())).findFirst();
        Assertions.assertTrue((boolean)fileFF.isPresent());
        fileFF.get().assertContentEquals("hello\n");
        this.runner.clearTransferState();
        this.otherRaf.write("world!".getBytes());
        this.raf.write("world".getBytes());
        Thread.sleep(100L);
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.close();
        this.otherRaf.close();
        thirdFileRaf.close();
        thirdFile.delete();
        this.file.renameTo(new File("target/log.1"));
        this.otherFile.renameTo(new File("target/testDir/log.1"));
        this.raf = new RandomAccessFile(new File("target/log.txt"), "rw");
        this.raf.write("1\n".getBytes());
        this.otherRaf = new RandomAccessFile(new File("target/testDir/log.txt"), "rw");
        this.otherRaf.write("2\n".getBytes());
        File fourthFile = new File("target/testDir/logging.txt");
        if (fourthFile.exists()) {
            fourthFile.delete();
        }
        Assertions.assertTrue((boolean)fourthFile.createNewFile());
        RandomAccessFile fourthFileRaf = new RandomAccessFile(fourthFile, "rw");
        fourthFileRaf.write("3\n".getBytes());
        fourthFileRaf.close();
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 5);
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("3\n")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("world!")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("2\n")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("world")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("1\n")));
    }

    @Test
    public void testDetectNewFile() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.BASE_DIRECTORY, "target");
        this.runner.setProperty(TailFile.MODE, TailFile.MODE_MULTIFILE);
        this.runner.setProperty(TailFile.LOOKUP_FREQUENCY, "1 sec");
        this.runner.setProperty(TailFile.FILENAME, "log_[0-9]*\\.txt");
        this.runner.setProperty(TailFile.RECURSIVE, "false");
        this.initializeFile("target/log_1.txt", "firstLine\n");
        Runnable task = () -> {
            try {
                this.initializeFile("target/log_2.txt", "newFile\n");
            }
            catch (Exception e) {
                Assertions.fail();
            }
        };
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.schedule(task, 2L, TimeUnit.SECONDS);
        this.runner.setRunSchedule(2000L);
        this.runner.run(3);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("firstLine\n")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("newFile\n")));
        this.runner.shutdown();
    }

    @Test
    public void testHandleRemovedFile() throws IOException {
        this.runner.setProperty(TailFile.BASE_DIRECTORY, "target");
        this.runner.setProperty(TailFile.MODE, TailFile.MODE_MULTIFILE);
        this.runner.setProperty(TailFile.LOOKUP_FREQUENCY, "1 sec");
        this.runner.setProperty(TailFile.FILENAME, "log_[0-9]*\\.txt");
        this.runner.setProperty(TailFile.RECURSIVE, "false");
        String logFile1 = Paths.get("target", "log_1.txt").toString();
        String logFile2 = Paths.get("target", "log_2.txt").toString();
        this.initializeFile(logFile1, "firstLine\n");
        this.initializeFile(logFile2, "secondLine\n");
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("firstLine\n")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("secondLine\n")));
        this.assertNumberOfStateMapEntries(2);
        this.assertFilenamesInStateMap(Arrays.asList(logFile1, logFile2));
        this.deleteFile(logFile2);
        this.runner.run(1);
        this.assertNumberOfStateMapEntries(1);
        this.assertFilenamesInStateMap(Collections.singletonList(logFile1));
        this.runner.shutdown();
    }

    @Test
    public void testMultipleFilesWithBasedirAndFilenameEL() throws IOException, InterruptedException {
        this.runner.setVariable("vrBaseDirectory", "target");
        this.runner.setProperty(TailFile.BASE_DIRECTORY, "${vrBaseDirectory}");
        this.runner.setProperty(TailFile.MODE, TailFile.MODE_MULTIFILE);
        Object fileRegex = File.separator.equals("/") ? "(testDir/)?log(ging)?.txt" : "(testDir" + Pattern.quote(File.separator) + ")?log(ging)?.txt";
        this.runner.setVariable("vrFilename", (String)fileRegex);
        this.runner.setProperty(TailFile.FILENAME, "${vrFilename}");
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "${filename}.?");
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_FILE);
        this.runner.setProperty(TailFile.RECURSIVE, "true");
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.otherRaf.write("hi\n".getBytes());
        this.raf.write("hello\n".getBytes());
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
    }

    @Test
    public void testMultipleFilesInSameDirectory() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "${filename}.?");
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_FILE);
        this.runner.setProperty(TailFile.BASE_DIRECTORY, "target");
        this.runner.setProperty(TailFile.FILENAME, "log(ging)?.txt");
        this.runner.setProperty(TailFile.MODE, TailFile.MODE_MULTIFILE);
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        File myOtherFile = new File("target/logging.txt");
        if (myOtherFile.exists()) {
            myOtherFile.delete();
        }
        Assertions.assertTrue((boolean)myOtherFile.createNewFile());
        RandomAccessFile myOtherRaf = new RandomAccessFile(myOtherFile, "rw");
        myOtherRaf.write("hey\n".getBytes());
        this.raf.write("hello\n".getBytes());
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        Optional<MockFlowFile> myOtherFileFF = this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().filter(mockFlowFile -> mockFlowFile.isAttributeEqual("tailfile.original.path", myOtherFile.getPath())).findFirst();
        Assertions.assertTrue((boolean)myOtherFileFF.isPresent());
        myOtherFileFF.get().assertContentEquals("hey\n");
        Optional<MockFlowFile> fileFF = this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().filter(mockFlowFile -> mockFlowFile.isAttributeEqual("tailfile.original.path", this.file.getPath())).findFirst();
        Assertions.assertTrue((boolean)fileFF.isPresent());
        fileFF.get().assertContentEquals("hello\n");
        this.runner.clearTransferState();
        myOtherRaf.write("guys".getBytes());
        this.raf.write("world".getBytes());
        Thread.sleep(100L);
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
        this.raf.close();
        myOtherRaf.close();
        myOtherFile.renameTo(new File("target/logging.1"));
        this.file.renameTo(new File("target/log.1"));
        this.raf = new RandomAccessFile(new File("target/log.txt"), "rw");
        this.raf.write("1\n".getBytes());
        myOtherRaf = new RandomAccessFile(new File("target/logging.txt"), "rw");
        myOtherRaf.write("2\n".getBytes());
        myOtherRaf.close();
        this.runner.run(1);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 4);
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("guys")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("2\n")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("world")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("1\n")));
    }

    @Test
    public void testMultipleFilesChangingNameStrategy() throws IOException, InterruptedException {
        this.runner.setProperty(TailFile.START_POSITION, TailFile.START_CURRENT_FILE);
        this.runner.setProperty(TailFile.MODE, TailFile.MODE_MULTIFILE);
        this.runner.setProperty(TailFile.BASE_DIRECTORY, "target");
        this.runner.setProperty(TailFile.FILENAME, ".*app-.*.log");
        this.runner.setProperty(TailFile.LOOKUP_FREQUENCY, "2s");
        this.runner.setProperty(TailFile.MAXIMUM_AGE, "5s");
        File multiChangeFirstFile = new File("target/app-2016-09-07.log");
        if (multiChangeFirstFile.exists()) {
            multiChangeFirstFile.delete();
        }
        Assertions.assertTrue((boolean)multiChangeFirstFile.createNewFile());
        RandomAccessFile multiChangeFirstRaf = new RandomAccessFile(multiChangeFirstFile, "rw");
        multiChangeFirstRaf.write("hey\n".getBytes());
        File multiChangeSndFile = new File("target/my-app-2016-09-07.log");
        if (multiChangeSndFile.exists()) {
            multiChangeSndFile.delete();
        }
        Assertions.assertTrue((boolean)multiChangeSndFile.createNewFile());
        RandomAccessFile multiChangeSndRaf = new RandomAccessFile(multiChangeSndFile, "rw");
        multiChangeSndRaf.write("hello\n".getBytes());
        this.runner.run(1, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("hello\n")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("hey\n")));
        this.runner.clearTransferState();
        multiChangeFirstRaf.write("hey2\n".getBytes());
        multiChangeSndRaf.write("hello2\n".getBytes());
        Thread.sleep(2000L);
        this.runner.run(1, false);
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 2);
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("hello2\n")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("hey2\n")));
        this.runner.clearTransferState();
        multiChangeFirstRaf.write("hey3\n".getBytes());
        multiChangeSndRaf.write("hello3\n".getBytes());
        multiChangeFirstRaf.close();
        multiChangeSndRaf.close();
        multiChangeFirstFile = new File("target/app-2016-09-08.log");
        if (multiChangeFirstFile.exists()) {
            multiChangeFirstFile.delete();
        }
        Assertions.assertTrue((boolean)multiChangeFirstFile.createNewFile());
        multiChangeFirstRaf = new RandomAccessFile(multiChangeFirstFile, "rw");
        multiChangeFirstRaf.write("hey\n".getBytes());
        multiChangeSndFile = new File("target/my-app-2016-09-08.log");
        if (multiChangeSndFile.exists()) {
            multiChangeSndFile.delete();
        }
        Assertions.assertTrue((boolean)multiChangeSndFile.createNewFile());
        multiChangeSndRaf = new RandomAccessFile(multiChangeSndFile, "rw");
        multiChangeSndRaf.write("hello\n".getBytes());
        Thread.sleep(2000L);
        this.runner.run(1);
        multiChangeFirstRaf.close();
        multiChangeSndRaf.close();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 4);
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("hello3\n")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("hello\n")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("hey3\n")));
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).stream().anyMatch(mockFlowFile -> mockFlowFile.isContentEqual("hey\n")));
        this.runner.clearTransferState();
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testMigrateFrom100To110() throws IOException {
        this.runner.setProperty(TailFile.FILENAME, "target/existing-log.txt");
        MockStateManager stateManager = this.runner.getStateManager();
        HashMap<String, String> state = new HashMap<String, String>();
        state.put("filename", "target/existing-log.txt");
        state.put("checksum", "2279929157");
        state.put("position", "14");
        state.put("timestamp", "1480639134000");
        stateManager.setState(state, Scope.LOCAL);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS).iterator().next();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bos));){
            writer.write("Line 3");
            writer.newLine();
        }
        flowFile.assertContentEquals(bos.toByteArray());
        StateMap updatedState = stateManager.getState(Scope.LOCAL);
        Assertions.assertNull((Object)updatedState.get("filename"));
        Assertions.assertNull((Object)updatedState.get("checksum"));
        Assertions.assertNull((Object)updatedState.get("position"));
        Assertions.assertNull((Object)updatedState.get("timestamp"));
        Assertions.assertEquals((Object)"target/existing-log.txt", (Object)updatedState.get("file.0.filename"));
        Assertions.assertEquals((Object)"3380848603", (Object)updatedState.get("file.0.checksum"));
        Assertions.assertEquals((Object)"21", (Object)updatedState.get("file.0.position"));
        Assertions.assertNotNull((Object)updatedState.get("file.0.timestamp"));
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(TailFile.REL_SUCCESS, 0);
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testMigrateFrom100To110FileNotFound() throws IOException {
        this.runner.setProperty(TailFile.FILENAME, "target/not-existing-log.txt");
        MockStateManager stateManager = this.runner.getStateManager();
        HashMap<String, String> state = new HashMap<String, String>();
        state.put("filename", "target/not-existing-log.txt");
        state.put("checksum", "2279929157");
        state.put("position", "14");
        state.put("timestamp", "1480639134000");
        stateManager.setState(state, Scope.LOCAL);
        this.runner.run();
        this.runner.assertTransferCount(TailFile.REL_SUCCESS, 0);
    }

    private void assertNumberOfStateMapEntries(int expectedNumberOfLogFiles) throws IOException {
        int numberOfStateKeysPerFile = 6;
        StateMap states = this.runner.getStateManager().getState(Scope.LOCAL);
        Assertions.assertEquals((int)(6 * expectedNumberOfLogFiles), (int)states.toMap().size());
    }

    private void assertFilenamesInStateMap(Collection<String> expectedFilenames) throws IOException {
        StateMap states = this.runner.getStateManager().getState(Scope.LOCAL);
        Set filenames = states.toMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith("filename")).map(Map.Entry::getValue).collect(Collectors.toSet());
        Assertions.assertEquals(new HashSet<String>(expectedFilenames), filenames);
    }

    private void cleanFiles(String directory) {
        File targetDir = new File(directory);
        if (targetDir.exists()) {
            File[] files;
            for (File file : files = targetDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("log") || name.endsWith("log");
                }
            })) {
                file.delete();
            }
        }
    }

    private void clean() {
        this.cleanFiles("target");
        this.cleanFiles("target/testDir");
    }

    private RandomAccessFile initializeFile(String path, String data) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        Assertions.assertTrue((boolean)file.createNewFile());
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.write(data.getBytes());
        randomAccessFile.close();
        return randomAccessFile;
    }

    private void deleteFile(String path) throws IOException {
        File file = new File(path);
        Assertions.assertTrue((boolean)file.delete());
    }
}

