/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.processors.standard.ReplaceText;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReplaceText {
    public TestRunner getRunner() {
        TestRunner runner = TestRunners.newTestRunner(ReplaceText.class);
        runner.setValidateExpressionUsage(false);
        return runner;
    }

    @Test
    public void testLiteralReplaceWithExpressionLanguageInSearchEntireText() {
        TestRunner runner = this.getRunner();
        runner.enqueue("Me, you, and the other", Collections.singletonMap("search.value", "you, and"));
        runner.setProperty(ReplaceText.SEARCH_VALUE, "Me, ${search.value}");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "\"Replacement\"");
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE.getValue());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("\"Replacement\" the other");
    }

    @Test
    public void testLiteralReplaceWithExpressionLanguageInReplacementEntireText() {
        TestRunner runner = this.getRunner();
        runner.enqueue("Me, you, and the other", Collections.singletonMap("replacement.value", "us"));
        runner.setProperty(ReplaceText.SEARCH_VALUE, "Me, you,");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "With ${replacement.value}");
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE.getValue());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("With us and the other");
    }

    @Test
    public void testLiteralReplaceWithExpressionLanguageInSearchLineByLine() {
        TestRunner runner = this.getRunner();
        runner.enqueue("Me, you, and the other", Collections.singletonMap("search.value", "you, and"));
        runner.setProperty(ReplaceText.SEARCH_VALUE, "Me, ${search.value}");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "\"Replacement\"");
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE.getValue());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("\"Replacement\" the other");
    }

    @Test
    public void testLiteralReplaceWithExpressionLanguageInReplacementLineByLine() {
        TestRunner runner = this.getRunner();
        runner.enqueue("Me, you, and the other", Collections.singletonMap("replacement.value", "us"));
        runner.setProperty(ReplaceText.SEARCH_VALUE, "Me, you,");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "With ${replacement.value}");
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE.getValue());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("With us and the other");
    }

    @Test
    public void testConfigurationCornerCase() throws IOException {
        TestRunner runner = this.getRunner();
        runner.run();
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(Paths.get("src/test/resources/hello.txt", new String[0]));
    }

    @Test
    public void testIterativeRegexReplace() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "\"([a-z]+?)\":\"(.*?)\"");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "\"${'$1':toUpper()}\":\"$2\"");
        runner.enqueue("{\"name\":\"Smith\",\"middle\":\"nifi\",\"firstname\":\"John\"}");
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("{\"NAME\":\"Smith\",\"MIDDLE\":\"nifi\",\"FIRSTNAME\":\"John\"}");
    }

    @Test
    public void testIterativeRegexReplaceLineByLine() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "\"([a-z]+?)\":\"(.*?)\"");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "\"${'$1':toUpper()}\":\"$2\"");
        runner.enqueue("{\"name\":\"Smith\",\"middle\":\"nifi\",\"firstname\":\"John\"}");
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("{\"NAME\":\"Smith\",\"MIDDLE\":\"nifi\",\"FIRSTNAME\":\"John\"}");
    }

    @Test
    public void testSimple() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "ell");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "lle");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Hlleo, World!".getBytes("UTF-8"));
    }

    @Test
    public void testWithEscaped$InReplacement() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(?s:^.*$)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "a\\$b");
        runner.enqueue("a$a,b,c,d");
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("a\\$b".getBytes("UTF-8"));
    }

    @Test
    public void testWithUnEscaped$InReplacement() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(?s:^.*$)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "a$b");
        runner.enqueue("a$a,b,c,d");
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("a$b".getBytes("UTF-8"));
    }

    @Test
    public void testPrependSimple() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "TEST");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.PREPEND);
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("TESTHello, World!".getBytes("UTF-8"));
    }

    @Test
    public void testPrependLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "_");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.PREPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.enqueue("hello\nthere\nmadam".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("_hello\n_there\n_madam".getBytes("UTF-8"));
    }

    @Test
    public void testPrependFirstLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "_");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.PREPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "First-Line");
        runner.enqueue("hello\nthere\nmadam".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("_hello\nthere\nmadam".getBytes("UTF-8"));
    }

    @Test
    public void testPrependLastLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "_");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.PREPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Last-Line");
        runner.enqueue("hello\nthere\nmadam".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello\nthere\n_madam".getBytes("UTF-8"));
    }

    @Test
    public void testPrependExceptFirstLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "_");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.PREPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Except-First-Line");
        runner.enqueue("hello\nthere\nmadam".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello\n_there\n_madam".getBytes("UTF-8"));
    }

    @Test
    public void testPrependExceptLastLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "_");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.PREPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Except-Last-Line");
        runner.enqueue("hello\nthere\nmadam".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("_hello\n_there\nmadam".getBytes("UTF-8"));
    }

    @Test
    public void testAppendSimple() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "TEST");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Hello, World!TEST".getBytes("UTF-8"));
    }

    @Test
    public void testAppendWithCarriageReturn() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.enqueue("hello\rthere\rsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello!\rthere!\rsir!");
    }

    @Test
    public void testAppendFirstLineWithCarriageReturn() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "First-Line");
        runner.enqueue("hello\rthere\rsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello!\rthere\rsir");
    }

    @Test
    public void testAppendExceptFirstLineWithCarriageReturn() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Except-First-Line");
        runner.enqueue("hello\rthere\rsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello\rthere!\rsir!");
    }

    @Test
    public void testAppendLastLineWithCarriageReturn() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Last-Line");
        runner.enqueue("hello\rthere\rsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello\rthere\rsir!");
    }

    @Test
    public void testAppendExceptLastLineWithCarriageReturn() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Except-Last-Line");
        runner.enqueue("hello\rthere\rsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello!\rthere!\rsir");
    }

    @Test
    public void testAppendWithNewLine() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.enqueue("hello\nthere\nsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello!\nthere!\nsir!");
    }

    @Test
    public void testAppendWithCarriageReturnNewLine() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.enqueue("hello\r\nthere\r\nsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello!\r\nthere!\r\nsir!");
    }

    @Test
    public void testAppendFirstLineWithCarriageReturnNewLine() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "First-Line");
        runner.enqueue("hello\r\nthere\r\nsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello!\r\nthere\r\nsir");
    }

    @Test
    public void testAppendLastLineWithCarriageReturnNewLine() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Last-Line");
        runner.enqueue("hello\r\nthere\r\nsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello\r\nthere\r\nsir!");
    }

    @Test
    public void testAppendExceptFistLineWithCarriageReturnNewLine() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Except-First-Line");
        runner.enqueue("hello\r\nthere\r\nsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello\r\nthere!\r\nsir!");
    }

    @Test
    public void testAppendExceptLastLineWithCarriageReturnNewLine() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "!");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Except-Last-Line");
        runner.enqueue("hello\r\nthere\r\nsir".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello!\r\nthere!\r\nsir");
    }

    @Test
    public void testLiteralSimple() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "ell");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "lle");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Hlleo, World!".getBytes("UTF-8"));
    }

    @Test
    public void testLiteralBackReference() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "ell");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "[$1]");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("H[$1]o, World!");
    }

    @Test
    public void testLiteral() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, ".ell.");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "test");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.enqueue("H.ell.o, World! .ell.".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 2);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Hello, World!");
        MockFlowFile out2 = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(1);
        out2.assertContentEquals("Htesto, World! test");
    }

    @Test
    public void testBackReference() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(ell)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "[$1]");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("H[ell]o, World!");
    }

    @Test
    public void testBackRefFollowedByNumbers() throws IOException {
        TestRunner runner = this.getRunner();
        String expected = "Hell23o, World!";
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(ell)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$123");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "notSupported");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        String actual = new String(out.toByteArray(), StandardCharsets.UTF_8);
        System.out.println(actual);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testBackRefWithNoCapturingGroup() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "ell");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$0123");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "notSupported");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        String actual = new String(out.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"Hell123o, World!", (Object)actual);
    }

    @Test
    public void testReplacementWithExpressionLanguage() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "${replaceKey}");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "GoodBye");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "H.*o");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Hello, World!");
    }

    @Test
    public void testReplacementWithExpressionLanguageIsEscaped() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(ell)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "[${abc}]");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "$1");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("H[$1]o, World!");
    }

    @Test
    public void testRegexWithExpressionLanguage() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "${replaceKey}");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${replaceValue}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "Hello");
        attributes.put("replaceValue", "Good-bye");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Good-bye, World!");
    }

    @Test
    public void testRegexWithExpressionLanguageIsEscaped() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "${replaceKey}");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${replaceValue}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "H.*o");
        attributes.put("replaceValue", "Good-bye");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Hello, World!");
    }

    @Test
    public void testBackReferenceWithTooLargeOfIndexIsEscaped() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(ell)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$1$2");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "H.*o");
        attributes.put("replaceValue", "Good-bye");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Hell$2o, World!");
    }

    @Test
    public void testBackReferenceWithInvalidReferenceIsEscaped() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(ell)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$d");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "H.*o");
        attributes.put("replaceValue", "Good-bye");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("H$do, World!");
    }

    @Test
    public void testEscapingDollarSign() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(ell)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "\\$1");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "H.*o");
        attributes.put("replaceValue", "Good-bye");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("H$1o, World!");
    }

    @Test
    public void testReplaceWithEmptyString() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(ell)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Ho, World!");
    }

    @Test
    public void testWithNoMatch() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "Z");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "Morning");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Hello, World!");
    }

    @Test
    public void testWithMultipleMatches() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "l");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "R");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("HeRRo, WorRd!");
    }

    @Test
    public void testAttributeToContent() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, ".*");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${abc}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "Good");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Good");
    }

    @Test
    public void testRoutesToFailureIfTooLarge() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "[123]");
        runner.setProperty(ReplaceText.MAX_BUFFER_SIZE, "1 b");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${abc}");
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "Good");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_FAILURE, 1);
    }

    @Test
    public void testRoutesToFailureIfLineTooLarge() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "[123]");
        runner.setProperty(ReplaceText.MAX_BUFFER_SIZE, "5 kb");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${abc}");
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "Good");
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextLineByLine/apacheLicenseOnOneLine.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_FAILURE, 1);
    }

    @Test
    public void testRoutesToSuccessIfTooLargeButRegexIsDotAsterisk() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, ".*");
        runner.setProperty(ReplaceText.MAX_BUFFER_SIZE, "1 b");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${abc}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "Good");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Good");
    }

    @Test
    public void testProblematicCase1() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, ".*");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${filename}\t${now():format(\"yyyy/MM/dd'T'HHmmss'Z'\")}\t${fileSize}\n");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "abc.txt");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        String outContent = new String(out.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)outContent.startsWith("abc.txt\t"));
        System.out.println(outContent);
        Assertions.assertTrue((boolean)outContent.endsWith("13\n"));
    }

    @Test
    public void testGetExistingContent() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(?s)(^.*)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "attribute header\n\n${filename}\n\ndata header\n\n$1\n\nfooter");
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "abc.txt");
        runner.enqueue("Hello\nWorld!".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        String outContent = new String(out.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)outContent.equals("attribute header\n\nabc.txt\n\ndata header\n\nHello\nWorld!\n\nfooter"));
        System.out.println(outContent);
    }

    @Test
    public void testReplaceWithinCurlyBraces() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, ".+");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "{ ${filename} }");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "abc.txt");
        runner.enqueue("Hello".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("{ abc.txt }");
    }

    @Test
    public void testDefaultReplacement() {
        String defaultValue = "default-replacement-value";
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "default-replacement-value");
        HashMap attributes = new HashMap();
        runner.enqueue("original-text".getBytes(StandardCharsets.UTF_8), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("default-replacement-value");
    }

    @Test
    public void testDefaultMultilineReplacement() {
        String defaultValue = "default-replacement-value";
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "default-replacement-value");
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        HashMap attributes = new HashMap();
        runner.enqueue(("original-text-line-1" + System.lineSeparator() + "original-text-line-2").getBytes(StandardCharsets.UTF_8), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("default-replacement-value");
    }

    @Test
    public void testSimpleLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "odo");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "ood");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/food.txt")));
    }

    @Test
    public void testZeroByteContentFileLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "odo");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "ood");
        File zeroByteFile = File.createTempFile("zeroByte", ".txt");
        runner.enqueue(this.translateNewLines(zeroByteFile.getPath()));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(zeroByteFile.getPath()));
    }

    @Test
    public void testPrependSimpleLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.PREPEND);
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "TEST ");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/PrependLineByLineTest.txt")));
    }

    @Test
    public void testAppendSimpleLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, " TEST");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/AppendLineByLineTest.txt")));
    }

    @Test
    public void testAppendEndlineCR() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "TEST");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.enqueue("Hello \rWorld \r".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Hello TEST\rWorld TEST\r".getBytes("UTF-8"));
    }

    @Test
    public void testAppendEndlineCRLF() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "TEST");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.enqueue("Hello \r\nWorld \r\n".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Hello TEST\r\nWorld TEST\r\n".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleLiteral() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "odo");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "ood");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/food.txt")));
    }

    @Test
    public void testLiteralBackReferenceLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "jo");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "[$1]");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/cu[$1]_Po[$1].txt")));
    }

    @Test
    public void testLiteralLineByLine() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, ".ell.");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "test");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.enqueue("H.ell.o, World! .ell. \n .ell. .ell.".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Htesto, World! test \n test test");
    }

    @Test
    public void testBackReferenceLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(DODO)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "[$1]");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/[DODO].txt")));
    }

    @Test
    public void testReplacementWithExpressionLanguageIsEscapedLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(jo)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "[${abc}]");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "$1");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/cu[$1]_Po[$1].txt")));
    }

    @Test
    public void testRegexWithExpressionLanguageLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "${replaceKey}");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${replaceValue}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "Riley");
        attributes.put("replaceValue", "Spider");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/Spider.txt")));
    }

    @Test
    public void testRegexWithExpressionLanguageIsEscapedLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "${replaceKey}");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${replaceValue}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "R.*y");
        attributes.put("replaceValue", "Spider");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/testFile.txt")));
    }

    @Test
    public void testBackReferenceWithTooLargeOfIndexIsEscapedLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(lu)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$1$2");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "R.*y");
        attributes.put("replaceValue", "Spiderman");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/Blu$2e_clu$2e.txt")));
    }

    @Test
    public void testBackReferenceWithTooLargeOfIndexIsEscapedFirstLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "First-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(H)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$1$2");
        HashMap attributes = new HashMap();
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/ReplaceFirstLine.txt")));
    }

    @Test
    public void testBackReferenceWithTooLargeOfIndexIsEscapedLastLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Last-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(O)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$1$2");
        HashMap attributes = new HashMap();
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/ReplaceLastLine.txt")));
    }

    @Test
    public void testBackReferenceWithTooLargeOfIndexIsEscapedExceptFirstLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Except-First-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(H)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$1$2");
        HashMap attributes = new HashMap();
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/ReplaceExceptFirstLine.txt")));
    }

    @Test
    public void testBackReferenceWithTooLargeOfIndexIsEscapedExceptLastLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Except-Last-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(O)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$1$2");
        HashMap attributes = new HashMap();
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/ReplaceExceptLastLine.txt")));
    }

    @Test
    public void testLiteralBackReferenceFistLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "First-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "H");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "[$1]");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/LiteralReplaceFirstLine.txt")));
    }

    @Test
    public void testLiteralBackReferenceExceptFirstLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Except-First-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "H");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "[$1]");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/LiteralReplaceExceptFirstLine.txt")));
    }

    @Test
    public void testLiteralBackReferenceLastLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Last-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "O");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "[$1]");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/LiteralReplaceLastLine.txt")));
    }

    @Test
    public void testLiteralBackReferenceExceptLastLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.LINE_BY_LINE_EVALUATION_MODE, "Except-Last-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "O");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "[$1]");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/LiteralReplaceExceptLastLine.txt")));
    }

    @Test
    public void testBackReferenceWithInvalidReferenceIsEscapedLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(ew)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$d");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "H.*o");
        attributes.put("replaceValue", "Good-bye");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/D$d_h$d.txt")));
    }

    @Test
    public void testEscapingDollarSignLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(DO)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "\\$1");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("replaceKey", "H.*o");
        attributes.put("replaceValue", "Good-bye");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/$1$1.txt")));
    }

    @Test
    public void testReplaceWithEmptyStringLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(jo)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/cu_Po.txt")));
    }

    @Test
    public void testWithNoMatchLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "Z");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "Morning");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/testFile.txt")));
    }

    @Test
    public void testWithMultipleMatchesLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "l");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "R");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(this.translateNewLines(new File("src/test/resources/TestReplaceTextLineByLine/BRue_cRue_RiRey.txt")));
    }

    @Test
    public void testAttributeToContentLineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, ".*");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${abc}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "Good");
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Good\nGood\nGood\nGood\nGood\nGood\nGood\nGood\nGood\nGood\nGood");
    }

    @Test
    public void testAttributeToContentWindows() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, ".*");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${abc}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "Good");
        runner.enqueue("<<<HEADER>>>\r\n<<BODY>>\r\n<<<FOOTER>>>\r".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("Good\r\nGood\r\nGood\r");
    }

    @Test
    public void testProblematicCase1LineByLine() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, ".*");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${filename}\t${now():format(\"yyyy/MM/dd'T'HHmmss'Z'\")}\t${fileSize}\n");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "abc.txt");
        runner.enqueue(this.translateNewLines(Paths.get("src/test/resources/TestReplaceTextLineByLine/testFile.txt", new String[0])), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        String outContent = this.translateNewLines(new String(out.toByteArray(), StandardCharsets.UTF_8));
        Assertions.assertTrue((boolean)outContent.startsWith("abc.txt\t"));
        System.out.println(outContent);
        Assertions.assertTrue((outContent.endsWith("193\n") || outContent.endsWith("203\r\n") ? 1 : 0) != 0);
    }

    @Test
    public void testGetExistingContentLineByLine() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(?s)(^.*)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "attribute header\n\n${filename}\n\ndata header\n\n$1\n\nfooter\n");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "abc.txt");
        runner.enqueue("Hello\nWorld!".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        String outContent = new String(out.toByteArray(), StandardCharsets.UTF_8);
        System.out.println(outContent);
        String expectedContent = "attribute header\n\nabc.txt\n\ndata header\n\nHello\n\n\nfooter\nattribute header\n\nabc.txt\n\ndata header\n\nWorld!\n\nfooter\n";
        Assertions.assertEquals((Object)"attribute header\n\nabc.txt\n\ndata header\n\nHello\n\n\nfooter\nattribute header\n\nabc.txt\n\ndata header\n\nWorld!\n\nfooter\n", (Object)outContent);
    }

    @Test
    public void testCapturingGroupInExpressionLanguage() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(.*?),(.*?),(\\d+.*)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$1,$2,${ '$3':toDate('ddMMMyyyy'):format('yyyy/MM/dd') }");
        String csvIn = "2006,10-01-2004,10may2004\n2007,15-05-2006,10jun2005\r\n2009,8-8-2008,10aug2008";
        String expectedCsvOut = "2006,10-01-2004,2004/05/10\n2007,15-05-2006,2005/06/10\r\n2009,8-8-2008,2008/08/10";
        runner.enqueue("2006,10-01-2004,10may2004\n2007,15-05-2006,10jun2005\r\n2009,8-8-2008,10aug2008".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("2006,10-01-2004,2004/05/10\n2007,15-05-2006,2005/06/10\r\n2009,8-8-2008,2008/08/10");
    }

    @Test
    public void testCapturingGroupInExpressionLanguage2() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(.*)/(.*?).jpg");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$1/${ '$2':substring(0,1) }.png");
        String csvIn = "1,2,3,https://123.jpg,email@mydomain.com\n3,2,1,https://321.jpg,other.email@mydomain.com";
        String expectedCsvOut = "1,2,3,https://1.png,email@mydomain.com\n3,2,1,https://3.png,other.email@mydomain.com";
        runner.enqueue("1,2,3,https://123.jpg,email@mydomain.com\n3,2,1,https://321.jpg,other.email@mydomain.com".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("1,2,3,https://1.png,email@mydomain.com\n3,2,1,https://3.png,other.email@mydomain.com");
    }

    @Test
    public void testAlwaysReplaceEntireText() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.ALWAYS_REPLACE);
        runner.setProperty(ReplaceText.SEARCH_VALUE, "i do not exist anywhere in the text");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${filename}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "abc.txt");
        runner.enqueue("Hello\nWorld!".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("abc.txt");
    }

    @Test
    public void testAlwaysReplaceLineByLine() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Line-by-Line");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.ALWAYS_REPLACE);
        runner.setProperty(ReplaceText.SEARCH_VALUE, "i do not exist anywhere in the text");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${filename}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "abc.txt");
        runner.enqueue("Hello\nWorld!\r\ntoday!\n".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("abc.txt\nabc.txt\r\nabc.txt\n");
    }

    @Test
    public void testRegexWithBadCaptureGroup() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(?s:^.*$)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${'$1':toUpper()}");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.REGEX_REPLACE);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        runner.enqueue("testing\n123".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("");
    }

    @Test
    public void testRegexWithGoodCaptureGroup() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(?s)(^.*$)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${'$1':toUpper()}");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.REGEX_REPLACE);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        runner.enqueue("testing\n123".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("TESTING\n123");
    }

    @Test
    public void testRegexNoCaptureDefaultReplacement() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(?s:^.*$)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "$1");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.REGEX_REPLACE);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        runner.enqueue("testing\n123".getBytes());
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> runner.run()));
        Assertions.assertInstanceOf(IndexOutOfBoundsException.class, (Object)((Throwable)((Object)e)).getCause());
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("java.lang.IndexOutOfBoundsException: No group 1"));
    }

    @Test
    public void testProcessorConfigurationRegexNotValid() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(?<!\\),*");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "hello");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.REGEX_REPLACE);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        runner.assertNotValid();
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.LITERAL_REPLACE);
        runner.assertValid();
        runner.enqueue("(?<!\\),*".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("hello");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "");
        runner.assertNotValid();
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.APPEND);
        runner.assertValid();
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.PREPEND);
        runner.assertValid();
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.ALWAYS_REPLACE);
        runner.assertValid();
    }

    @Test
    public void testBackReferenceEscapeWithRegexReplaceUsingEL() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(?s)(^.*$)");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${'$1':toUpper()}");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.REGEX_REPLACE);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        runner.assertValid();
        runner.enqueue("wo$rd".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals("WO$RD");
        runner.enqueue("wo$1rd".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 2);
        out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(1);
        out.assertContentEquals("WO$1RD");
        runner.enqueue("wo$1r$2d".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 3);
        out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(2);
        out.assertContentEquals("WO$1R$2D");
    }

    @Test
    public void testSubstituteVariablesWithEvaluationModeEntireText() {
        this.testSubstituteVariables("Line1: ${var1}\nLine2: ${var2}", "Line1: foo\nLine2: bar", "Entire text", this.createAttributesMap());
    }

    @Test
    public void testSubstituteVariablesWithEvaluationModeLineByLine() {
        this.testSubstituteVariables("Line1: ${var1}\nLine2: ${var2}", "Line1: foo\nLine2: bar", "Line-by-Line", this.createAttributesMap());
    }

    @Test
    public void testSubstituteVariablesWhenVariableValueMissing() {
        this.testSubstituteVariables("Line1: ${var1}\nLine2: ${var2}", "Line1: ${var1}\nLine2: ${var2}", "Entire text", Collections.emptyMap());
    }

    @Test
    public void testSubstituteVariablesWhenVariableReferenceEscaped() {
        this.testSubstituteVariables("Line1: $${var1}\nLine2: $${var2}", "Line1: ${var1}\nLine2: ${var2}", "Entire text", this.createAttributesMap());
    }

    @Test
    public void testSubstituteVariablesWhenVariableNameEmpty() {
        this.testSubstituteVariables("Line1: ${}\nLine2: ${}", "Line1: ${}\nLine2: ${}", "Entire text", this.createAttributesMap());
    }

    private void testSubstituteVariables(String inputContent, String expectedContent, String evaluationMode, Map<String, String> attributesMap) {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, evaluationMode);
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.SUBSTITUTE_VARIABLES.getValue());
        runner.enqueue(inputContent, attributesMap);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_SUCCESS).get(0);
        out.assertContentEquals(expectedContent);
    }

    private Map<String, String> createAttributesMap() {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        attributesMap.put("var1", "foo");
        attributesMap.put("var2", "bar");
        return attributesMap;
    }

    @Test
    public void testForStackOverflow() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "New text");
        runner.setProperty(ReplaceText.REPLACEMENT_STRATEGY, ReplaceText.REGEX_REPLACE);
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        runner.setProperty(ReplaceText.MAX_BUFFER_SIZE, "10 MB");
        runner.setProperty(ReplaceText.SEARCH_VALUE, "(?s)(^(A|B)*$)");
        runner.assertValid();
        char[] data = new char[1000000];
        Arrays.fill(data, 'A');
        runner.enqueue(new String(data));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_FAILURE, 1);
    }

    @Test
    public void testWithInvalidExpression() {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceText.EVALUATION_MODE, "Entire text");
        runner.setProperty(ReplaceText.SEARCH_VALUE, ".*");
        runner.setProperty(ReplaceText.REPLACEMENT_VALUE, "${date:toDate(\"yyyy/MM/dd\")}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("date", "12");
        runner.enqueue("hi", attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceText.REL_FAILURE, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceText.REL_FAILURE).get(0);
        String outContent = this.translateNewLines(new String(out.toByteArray(), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"hi", (Object)outContent);
    }

    private String translateNewLines(File file) throws IOException {
        return this.translateNewLines(file.toPath());
    }

    private String translateNewLines(Path path) throws IOException {
        byte[] data = Files.readAllBytes(path);
        String text = new String(data, StandardCharsets.UTF_8);
        return this.translateNewLines(text);
    }

    private String translateNewLines(String text) {
        String lineSeparator = System.getProperty("line.separator");
        Pattern pattern = Pattern.compile("\n", 8);
        String translated = pattern.matcher(text).replaceAll(lineSeparator);
        return translated;
    }
}

