/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.Set;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.FetchFile;
import org.apache.nifi.processors.standard.PutFile;
import org.apache.nifi.processors.standard.PutSFTP;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS}, disabledReason="Test only runs on *nix")
public class TestPutFile {
    public static final String TARGET_DIRECTORY = "target/put-file";
    private File targetDir;
    private TestRunner putFileRunner;
    private final String testFile = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "hello.txt";

    @BeforeEach
    public void prepDestDirectory() throws IOException {
        this.targetDir = new File(TARGET_DIRECTORY);
        if (!this.targetDir.exists()) {
            Files.createDirectories(this.targetDir.toPath(), new FileAttribute[0]);
            return;
        }
        this.targetDir.setReadable(true);
        this.deleteDirectoryContent(this.targetDir);
    }

    private void deleteDirectoryContent(File directory) throws IOException {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.deleteDirectoryContent(file);
            }
            Files.delete(file.toPath());
        }
    }

    @Test
    public void testCreateDirectory() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new PutFile());
        String newDir = this.targetDir.getAbsolutePath() + "/new-folder";
        runner.setProperty(PutFile.DIRECTORY, newDir);
        runner.setProperty(PutFile.CONFLICT_RESOLUTION, "replace");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Hello world!!".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        Path targetPath = Paths.get("target/put-file/new-folder/targetFile.txt", new String[0]);
        byte[] content = Files.readAllBytes(targetPath);
        Assertions.assertEquals((Object)"Hello world!!", (Object)new String(content));
    }

    @Test
    public void testCreateRelativeDirectory() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new PutFile());
        String newDir = "target/put-file/new-folder";
        runner.setProperty(PutFile.DIRECTORY, newDir);
        runner.setProperty(PutFile.CONFLICT_RESOLUTION, "replace");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Hello world!!".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        Path targetPath = Paths.get(newDir + "/targetFile.txt", new String[0]);
        byte[] content = Files.readAllBytes(targetPath);
        Assertions.assertEquals((Object)"Hello world!!", (Object)new String(content));
    }

    @Test
    public void testCreateEmptyStringDirectory() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new PutFile());
        String newDir = "";
        runner.setProperty(PutFile.DIRECTORY, newDir);
        runner.setProperty(PutFile.CONFLICT_RESOLUTION, "replace");
        runner.assertNotValid();
    }

    @Test
    public void testReplaceConflictResolution() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new PutFile());
        runner.setProperty(PutFile.DIRECTORY, this.targetDir.getAbsolutePath());
        runner.setProperty(PutFile.CONFLICT_RESOLUTION, "replace");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Hello world!!".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        Path targetPath = Paths.get("target/put-file/targetFile.txt", new String[0]);
        byte[] content = Files.readAllBytes(targetPath);
        Assertions.assertEquals((Object)"Hello world!!", (Object)new String(content));
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Another file".getBytes(), attributes);
        runner.run();
        runner.assertTransferCount(FetchFile.REL_SUCCESS, 2);
        File dir = new File(TARGET_DIRECTORY);
        Assertions.assertEquals((int)1, (int)dir.list().length);
        targetPath = Paths.get("target/put-file/targetFile.txt", new String[0]);
        content = Files.readAllBytes(targetPath);
        Assertions.assertEquals((Object)"Another file", (Object)new String(content));
    }

    @Test
    public void testIgnoreConflictResolution() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new PutFile());
        runner.setProperty(PutFile.DIRECTORY, this.targetDir.getAbsolutePath());
        runner.setProperty(PutFile.CONFLICT_RESOLUTION, "ignore");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Hello world!!".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        Path targetPath = Paths.get("target/put-file/targetFile.txt", new String[0]);
        byte[] content = Files.readAllBytes(targetPath);
        Assertions.assertEquals((Object)"Hello world!!", (Object)new String(content));
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Another file".getBytes(), attributes);
        runner.run();
        runner.assertTransferCount(FetchFile.REL_SUCCESS, 2);
        File dir = new File(TARGET_DIRECTORY);
        Assertions.assertEquals((int)1, (int)dir.list().length);
        targetPath = Paths.get("target/put-file/targetFile.txt", new String[0]);
        content = Files.readAllBytes(targetPath);
        Assertions.assertEquals((Object)"Hello world!!", (Object)new String(content));
    }

    @Test
    public void testFailConflictResolution() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new PutFile());
        runner.setProperty(PutFile.DIRECTORY, this.targetDir.getAbsolutePath());
        runner.setProperty(PutFile.CONFLICT_RESOLUTION, "fail");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Hello world!!".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        Path targetPath = Paths.get("target/put-file/targetFile.txt", new String[0]);
        byte[] content = Files.readAllBytes(targetPath);
        Assertions.assertEquals((Object)"Hello world!!", (Object)new String(content));
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Another file".getBytes(), attributes);
        runner.run();
        runner.assertTransferCount(PutFile.REL_SUCCESS, 1);
        runner.assertTransferCount(PutFile.REL_FAILURE, 1);
        runner.assertPenalizeCount(1);
    }

    @Test
    public void testMaxFileLimitReach() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new PutFile());
        runner.setProperty(PutFile.DIRECTORY, this.targetDir.getAbsolutePath());
        runner.setProperty(PutFile.CONFLICT_RESOLUTION, "replace");
        runner.setProperty(PutFile.MAX_DESTINATION_FILES, "1");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Hello world!!".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        Path targetPath = Paths.get("target/put-file/targetFile.txt", new String[0]);
        byte[] content = Files.readAllBytes(targetPath);
        Assertions.assertEquals((Object)"Hello world!!", (Object)new String(content));
        attributes.put(CoreAttributes.FILENAME.key(), "secondFile.txt");
        runner.enqueue("Hello world!!".getBytes(), attributes);
        runner.run();
        runner.assertTransferCount(PutFile.REL_FAILURE, 1);
        runner.assertPenalizeCount(1);
    }

    @Test
    public void testReplaceAndMaxFileLimitReach() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new PutFile());
        runner.setProperty(PutFile.DIRECTORY, this.targetDir.getAbsolutePath());
        runner.setProperty(PutFile.CONFLICT_RESOLUTION, "replace");
        runner.setProperty(PutFile.MAX_DESTINATION_FILES, "1");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Hello world!!".getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        Path targetPath = Paths.get("target/put-file/targetFile.txt", new String[0]);
        byte[] content = Files.readAllBytes(targetPath);
        Assertions.assertEquals((Object)"Hello world!!", (Object)new String(content));
        attributes.put(CoreAttributes.FILENAME.key(), "targetFile.txt");
        runner.enqueue("Another file".getBytes(), attributes);
        runner.run();
        runner.assertTransferCount(FetchFile.REL_SUCCESS, 2);
        File dir = new File(TARGET_DIRECTORY);
        Assertions.assertEquals((int)1, (int)dir.list().length);
        targetPath = Paths.get("target/put-file/targetFile.txt", new String[0]);
        content = Files.readAllBytes(targetPath);
        Assertions.assertEquals((Object)"Another file", (Object)new String(content));
    }

    @BeforeEach
    public void setup() throws IOException {
        this.putFileRunner = TestRunners.newTestRunner(PutFile.class);
        this.putFileRunner.setProperty(PutFile.CHANGE_OWNER, System.getProperty("user.name"));
        this.putFileRunner.setProperty(PutFile.CHANGE_PERMISSIONS, "rw-r-----");
        this.putFileRunner.setProperty(PutFile.CREATE_DIRS, "true");
        this.putFileRunner.setProperty(PutFile.DIRECTORY, "target/test/data/out/PutFile/1/2/3/4/5");
        this.putFileRunner.setValidateExpressionUsage(false);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.emptyTestDirectory();
    }

    @Test
    public void testPutFile() throws IOException {
        this.emptyTestDirectory();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "testfile.txt");
        this.putFileRunner.enqueue(Paths.get(this.testFile, new String[0]), attributes);
        this.putFileRunner.run();
        this.putFileRunner.assertTransferCount(PutSFTP.REL_SUCCESS, 1);
        Path newDirectory = Paths.get("target/test/data/out/PutFile/1/2/3/4/5", new String[0]);
        Path newFile = newDirectory.resolve("testfile.txt");
        Assertions.assertTrue((boolean)newDirectory.toAbsolutePath().toFile().exists(), (String)"New directory not created.");
        Assertions.assertTrue((boolean)newFile.toAbsolutePath().toFile().exists(), (String)"New File not created.");
        PosixFileAttributeView filePosixAttributeView = Files.getFileAttributeView(newFile.toAbsolutePath(), PosixFileAttributeView.class, new LinkOption[0]);
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)filePosixAttributeView.getOwner().getName());
        Set<PosixFilePermission> filePermissions = filePosixAttributeView.readAttributes().permissions();
        Assertions.assertTrue((boolean)filePermissions.contains((Object)PosixFilePermission.OWNER_READ));
        Assertions.assertTrue((boolean)filePermissions.contains((Object)PosixFilePermission.OWNER_WRITE));
        Assertions.assertFalse((boolean)filePermissions.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        Assertions.assertTrue((boolean)filePermissions.contains((Object)PosixFilePermission.GROUP_READ));
        Assertions.assertFalse((boolean)filePermissions.contains((Object)PosixFilePermission.GROUP_WRITE));
        Assertions.assertFalse((boolean)filePermissions.contains((Object)PosixFilePermission.GROUP_EXECUTE));
        Assertions.assertFalse((boolean)filePermissions.contains((Object)PosixFilePermission.OTHERS_READ));
        Assertions.assertFalse((boolean)filePermissions.contains((Object)PosixFilePermission.OTHERS_WRITE));
        Assertions.assertFalse((boolean)filePermissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        PosixFileAttributeView dirPosixAttributeView = Files.getFileAttributeView(newDirectory.toAbsolutePath(), PosixFileAttributeView.class, new LinkOption[0]);
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)dirPosixAttributeView.getOwner().getName());
        Set<PosixFilePermission> dirPermissions = dirPosixAttributeView.readAttributes().permissions();
        Assertions.assertTrue((boolean)dirPermissions.contains((Object)PosixFilePermission.OWNER_READ));
        Assertions.assertTrue((boolean)dirPermissions.contains((Object)PosixFilePermission.OWNER_WRITE));
        Assertions.assertTrue((boolean)dirPermissions.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        Assertions.assertTrue((boolean)dirPermissions.contains((Object)PosixFilePermission.GROUP_READ));
        Assertions.assertFalse((boolean)dirPermissions.contains((Object)PosixFilePermission.GROUP_WRITE));
        Assertions.assertTrue((boolean)dirPermissions.contains((Object)PosixFilePermission.GROUP_EXECUTE));
        Assertions.assertFalse((boolean)dirPermissions.contains((Object)PosixFilePermission.OTHERS_READ));
        Assertions.assertFalse((boolean)dirPermissions.contains((Object)PosixFilePermission.OTHERS_WRITE));
        Assertions.assertFalse((boolean)dirPermissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        this.putFileRunner.clearTransferState();
    }

    private void emptyTestDirectory() throws IOException {
        Files.walkFileTree(Paths.get("target/test/data/out/PutFile", new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

