/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.processors.standard.FetchDistributedMapCache;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFetchDistributedMapCache {
    private TestRunner runner;
    private MockCacheClient service;

    @BeforeEach
    public void setup() throws InitializationException {
        this.runner = TestRunners.newTestRunner(FetchDistributedMapCache.class);
        this.service = new MockCacheClient();
        this.runner.addControllerService("service", (ControllerService)this.service);
        this.runner.enableControllerService((ControllerService)this.service);
        this.runner.setProperty(FetchDistributedMapCache.PROP_DISTRIBUTED_CACHE_SERVICE, "service");
    }

    @Test
    public void testNoCacheKey() {
        this.runner.setProperty(FetchDistributedMapCache.PROP_CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cacheKeyAttribute", "1");
        this.runner.enqueue(new byte[0], props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(FetchDistributedMapCache.REL_NOT_FOUND, 1);
        this.runner.assertTransferCount(FetchDistributedMapCache.REL_NOT_FOUND, 1);
        this.runner.clearTransferState();
    }

    @Test
    public void testNoCacheKeyValue() {
        this.runner.setProperty(FetchDistributedMapCache.PROP_CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(FetchDistributedMapCache.REL_FAILURE, 1);
        this.runner.assertTransferCount(FetchDistributedMapCache.REL_FAILURE, 1);
        this.runner.clearTransferState();
    }

    @Test
    public void testFailingCacheService() {
        this.service.setFailOnCalls(true);
        this.runner.setProperty(FetchDistributedMapCache.PROP_CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cacheKeyAttribute", "2");
        this.runner.enqueue(new byte[0], props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(FetchDistributedMapCache.REL_FAILURE, 1);
        this.runner.assertTransferCount(FetchDistributedMapCache.REL_FAILURE, 1);
        this.service.setFailOnCalls(false);
    }

    @Test
    public void testSingleFlowFile() throws IOException {
        this.service.put("key", "value", new FetchDistributedMapCache.StringSerializer(), new FetchDistributedMapCache.StringSerializer());
        this.runner.setProperty(FetchDistributedMapCache.PROP_CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cacheKeyAttribute", "key");
        String flowFileContent = "content";
        this.runner.enqueue(flowFileContent.getBytes("UTF-8"), props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(FetchDistributedMapCache.REL_SUCCESS, 1);
        this.runner.assertTransferCount(FetchDistributedMapCache.REL_SUCCESS, 1);
        MockFlowFile outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(FetchDistributedMapCache.REL_SUCCESS).get(0);
        outputFlowFile.assertContentEquals("value");
        this.runner.clearTransferState();
    }

    @Test
    public void testSingleFlowFileToAttribute() throws IOException {
        this.service.put("key", "value", new FetchDistributedMapCache.StringSerializer(), new FetchDistributedMapCache.StringSerializer());
        this.runner.setProperty(FetchDistributedMapCache.PROP_CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        this.runner.setProperty(FetchDistributedMapCache.PROP_PUT_CACHE_VALUE_IN_ATTRIBUTE, "test");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cacheKeyAttribute", "key");
        String flowFileContent = "content";
        this.runner.enqueue(flowFileContent.getBytes("UTF-8"), props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(FetchDistributedMapCache.REL_SUCCESS, 1);
        this.runner.assertTransferCount(FetchDistributedMapCache.REL_SUCCESS, 1);
        MockFlowFile outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(FetchDistributedMapCache.REL_SUCCESS).get(0);
        outputFlowFile.assertAttributeEquals("test", "value");
        this.runner.clearTransferState();
    }

    @Test
    public void testToAttributeTooLong() throws IOException {
        this.service.put("key", "value", new FetchDistributedMapCache.StringSerializer(), new FetchDistributedMapCache.StringSerializer());
        this.runner.setProperty(FetchDistributedMapCache.PROP_CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        this.runner.setProperty(FetchDistributedMapCache.PROP_PUT_CACHE_VALUE_IN_ATTRIBUTE, "test");
        this.runner.setProperty(FetchDistributedMapCache.PROP_PUT_ATTRIBUTE_MAX_LENGTH, "3");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cacheKeyAttribute", "key");
        String flowFileContent = "content";
        this.runner.enqueue(flowFileContent.getBytes("UTF-8"), props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(FetchDistributedMapCache.REL_SUCCESS, 1);
        this.runner.assertTransferCount(FetchDistributedMapCache.REL_SUCCESS, 1);
        MockFlowFile outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(FetchDistributedMapCache.REL_SUCCESS).get(0);
        outputFlowFile.assertAttributeEquals("test", "val");
        this.runner.clearTransferState();
    }

    @Test
    public void testMultipleKeysToAttributes() throws IOException {
        this.service.put("key1", "value1", new FetchDistributedMapCache.StringSerializer(), new FetchDistributedMapCache.StringSerializer());
        this.service.put("key2", "value2", new FetchDistributedMapCache.StringSerializer(), new FetchDistributedMapCache.StringSerializer());
        this.runner.setProperty(FetchDistributedMapCache.PROP_CACHE_ENTRY_IDENTIFIER, "key1, key2");
        this.runner.assertNotValid();
        this.runner.setProperty(FetchDistributedMapCache.PROP_PUT_CACHE_VALUE_IN_ATTRIBUTE, "test");
        this.runner.assertValid();
        HashMap props = new HashMap();
        this.runner.enqueue(new byte[0], props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(FetchDistributedMapCache.REL_SUCCESS, 1);
        this.runner.assertTransferCount(FetchDistributedMapCache.REL_SUCCESS, 1);
        MockFlowFile outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(FetchDistributedMapCache.REL_SUCCESS).get(0);
        outputFlowFile.assertAttributeEquals("test.key1", "value1");
        outputFlowFile.assertAttributeEquals("test.key2", "value2");
    }

    @Test
    public void testMultipleKeysOneNotFound() throws IOException {
        this.service.put("key1", "value1", new FetchDistributedMapCache.StringSerializer(), new FetchDistributedMapCache.StringSerializer());
        this.runner.setProperty(FetchDistributedMapCache.PROP_CACHE_ENTRY_IDENTIFIER, "key1, key2");
        this.runner.assertNotValid();
        this.runner.setProperty(FetchDistributedMapCache.PROP_PUT_CACHE_VALUE_IN_ATTRIBUTE, "test");
        this.runner.assertValid();
        HashMap props = new HashMap();
        this.runner.enqueue(new byte[0], props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(FetchDistributedMapCache.REL_NOT_FOUND, 1);
        this.runner.assertTransferCount(FetchDistributedMapCache.REL_NOT_FOUND, 1);
        MockFlowFile outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(FetchDistributedMapCache.REL_NOT_FOUND).get(0);
        outputFlowFile.assertAttributeEquals("test.key1", "value1");
    }

    private class MockCacheClient
    extends AbstractControllerService
    implements DistributedMapCacheClient {
        private final ConcurrentMap<Object, Object> values = new ConcurrentHashMap<Object, Object>();
        private boolean failOnCalls = false;

        private MockCacheClient() {
        }

        public void setFailOnCalls(boolean failOnCalls) {
            this.failOnCalls = failOnCalls;
        }

        private void verifyNotFail() throws IOException {
            if (this.failOnCalls) {
                throw new IOException("Could not call to remote service because Unit Test marked service unavailable");
            }
        }

        public <K, V> boolean putIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
            this.verifyNotFail();
            Object retValue = this.values.putIfAbsent(key, value);
            return retValue == null;
        }

        public <K, V> V getAndPutIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer, Deserializer<V> valueDeserializer) throws IOException {
            this.verifyNotFail();
            return (V)this.values.putIfAbsent(key, value);
        }

        public <K> boolean containsKey(K key, Serializer<K> keySerializer) throws IOException {
            this.verifyNotFail();
            return this.values.containsKey(key);
        }

        public <K, V> void put(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
            this.verifyNotFail();
            this.values.put(key, value);
        }

        public <K, V> V get(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
            this.verifyNotFail();
            if (this.values.containsKey(key)) {
                return (V)((String)this.values.get(key)).getBytes();
            }
            return null;
        }

        public void close() throws IOException {
        }

        public <K> boolean remove(K key, Serializer<K> serializer) throws IOException {
            this.verifyNotFail();
            this.values.remove(key);
            return true;
        }

        public long removeByPattern(String regex) throws IOException {
            this.verifyNotFail();
            ArrayList removedRecords = new ArrayList();
            Pattern p = Pattern.compile(regex);
            for (Object key : this.values.keySet()) {
                Matcher m = p.matcher(key.toString());
                if (!m.matches()) continue;
                removedRecords.add(this.values.get(key));
            }
            long numRemoved = removedRecords.size();
            removedRecords.forEach(this.values::remove);
            return numRemoved;
        }
    }
}

