/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processors.standard.EvaluateJsonPath;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvaluateJsonPath {
    private static final Path JSON_SNIPPET = Paths.get("src/test/resources/TestJson/json-sample.json", new String[0]);
    private static final Path XML_SNIPPET = Paths.get("src/test/resources/TestXml/xml-snippet.xml", new String[0]);

    @Test
    public void testInvalidJsonPath() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("invalid.jsonPath", "$..");
        testRunner.assertNotValid();
    }

    @Test
    public void testUpgradeToJsonPath24() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        List<String> badInputs = Arrays.asList("LoremIpsum []", "LoremIpsum[]", "$..", "$.xyz.");
        for (String string : badInputs) {
            testRunner.setProperty("DefinitelyNotJsonPath", string);
            testRunner.enqueue(JSON_SNIPPET);
            testRunner.assertNotValid();
        }
        List<String> testWhatUsedToPass = Arrays.asList("LoremIpsum@$Q#$^Q$%Q#", "TestTest['sdfadsf']#$%#$^#$^.xyz");
        for (String old : testWhatUsedToPass) {
            testRunner.setProperty("DefinitelyNotJsonPath", old);
            testRunner.enqueue(JSON_SNIPPET);
            testRunner.assertValid();
        }
        List<String> list = Arrays.asList("$", "$.xyz", "$['xyz']", "$.*['xyz']");
        for (String good : list) {
            testRunner.setProperty("DefinitelyNotJsonPath", good);
            testRunner.enqueue(JSON_SNIPPET);
            testRunner.assertValid();
        }
        testRunner.setProperty("DefinitelyNotJsonPath", "   ");
        testRunner.assertNotValid();
    }

    @Test
    public void testInvalidJsonDocument() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateJsonPath.REL_FAILURE, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateJsonPath.REL_FAILURE).get(0);
    }

    @Test
    public void testInvalidConfiguration_destinationContent_twoPaths() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-content");
        testRunner.setProperty("JsonPath1", "$[0]._id");
        testRunner.setProperty("JsonPath2", "$[0].name");
        testRunner.assertNotValid();
    }

    @Test
    public void testInvalidConfiguration_invalidJsonPath_space() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-content");
        testRunner.setProperty("JsonPath1", "$[0]. _id");
        testRunner.assertNotValid();
    }

    @Test
    public void testConfiguration_destinationAttributes_twoPaths() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("JsonPath1", "$[0]._id");
        testRunner.setProperty("JsonPath2", "$[0].name");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
    }

    @Test
    public void testExtractPath_destinationAttribute() throws Exception {
        String jsonPathAttrKey = "JsonPath";
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        testRunner.setProperty(jsonPathAttrKey, "$[0]._id");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        Relationship expectedRel = EvaluateJsonPath.REL_MATCH;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0);
        Assertions.assertEquals((Object)"54df94072d5dbf7dc6340cc5", (Object)out.getAttribute(jsonPathAttrKey), (String)"Transferred flow file did not have the correct result");
    }

    @Test
    public void testExtractPath_destinationAttributes_twoPaths() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        testRunner.setProperty(EvaluateJsonPath.RETURN_TYPE, "json");
        String jsonPathIdAttrKey = "evaluatejson.id";
        String jsonPathNameAttrKey = "evaluatejson.name";
        testRunner.setProperty(jsonPathIdAttrKey, "$[0]._id");
        testRunner.setProperty(jsonPathNameAttrKey, "$[0].name");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        Relationship expectedRel = EvaluateJsonPath.REL_MATCH;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0);
        Assertions.assertEquals((Object)"54df94072d5dbf7dc6340cc5", (Object)out.getAttribute(jsonPathIdAttrKey), (String)"Transferred flow file did not have the correct result for id attribute");
        Assertions.assertEquals((Object)"{\"first\":\"Shaffer\",\"last\":\"Pearson\"}", (Object)out.getAttribute(jsonPathNameAttrKey), (String)"Transferred flow file did not have the correct result for name attribute");
    }

    @Test
    public void testExtractPath_destinationAttributes_twoPaths_notFound() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        String jsonPathIdAttrKey = "evaluatejson.id";
        String jsonPathNameAttrKey = "evaluatejson.name";
        testRunner.setProperty(jsonPathIdAttrKey, "$[0]._id.nonexistent");
        testRunner.setProperty(jsonPathNameAttrKey, "$[0].name.nonexistent");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        Relationship expectedRel = EvaluateJsonPath.REL_MATCH;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0);
        Assertions.assertEquals((Object)"", (Object)out.getAttribute(jsonPathIdAttrKey), (String)"Transferred flow file did not have the correct result for id attribute");
        Assertions.assertEquals((Object)"", (Object)out.getAttribute(jsonPathNameAttrKey), (String)"Transferred flow file did not have the correct result for name attribute");
    }

    @Test
    public void testExtractPath_destinationAttributes_twoPaths_oneFound() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        String jsonPathIdAttrKey = "evaluatejson.id";
        String jsonPathNameAttrKey = "evaluatejson.name";
        testRunner.setProperty(jsonPathIdAttrKey, "$[0]._id");
        testRunner.setProperty(jsonPathNameAttrKey, "$[0].name.nonexistent");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        Relationship expectedRel = EvaluateJsonPath.REL_MATCH;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0);
        Assertions.assertEquals((Object)"54df94072d5dbf7dc6340cc5", (Object)out.getAttribute(jsonPathIdAttrKey), (String)"Transferred flow file did not have the correct result for id attribute");
        Assertions.assertEquals((Object)"", (Object)out.getAttribute(jsonPathNameAttrKey), (String)"Transferred flow file did not have the correct result for name attribute");
    }

    @Test
    public void testExtractPath_destinationContent() throws Exception {
        String jsonPathAttrKey = "JsonPath";
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-content");
        testRunner.setProperty(jsonPathAttrKey, "$[0]._id");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        Relationship expectedRel = EvaluateJsonPath.REL_MATCH;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0)).assertContentEquals("54df94072d5dbf7dc6340cc5");
    }

    @Test
    public void testExtractPath_destinationContent_indefiniteResult() throws Exception {
        String jsonPathAttrKey = "friends.indefinite.id.list";
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-content");
        testRunner.setProperty(jsonPathAttrKey, "$[0].friends.[*].id");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        Relationship expectedRel = EvaluateJsonPath.REL_MATCH;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0)).assertContentEquals("[0,1,2]");
    }

    @Test
    public void testExtractPath_destinationContent_indefiniteResult_operators() throws Exception {
        String jsonPathAttrKey = "friends.indefinite.id.list";
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-content");
        testRunner.setProperty(jsonPathAttrKey, "$[0].friends[?(@.id < 3)].id");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        Relationship expectedRel = EvaluateJsonPath.REL_MATCH;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0)).assertContentEquals("[0,1,2]");
    }

    @Test
    public void testRouteUnmatched_destinationContent_noMatch() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-content");
        testRunner.setProperty("jsonPath", "$[0].nonexistent.key");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        Relationship expectedRel = EvaluateJsonPath.REL_NO_MATCH;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0)).assertContentEquals(JSON_SNIPPET);
    }

    @Test
    public void testRouteFailure_returnTypeScalar_resultArray() throws Exception {
        String jsonPathAttrKey = "friends.indefinite.id.list";
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.RETURN_TYPE, "scalar");
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-content");
        testRunner.setProperty(jsonPathAttrKey, "$[0].friends[?(@.id < 3)].id");
        testRunner.enqueue(JSON_SNIPPET);
        testRunner.run();
        Relationship expectedRel = EvaluateJsonPath.REL_FAILURE;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0)).assertContentEquals(JSON_SNIPPET);
    }

    @Test
    public void testNullInput() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.RETURN_TYPE, "json");
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("stringField", "$.stringField");
        testRunner.setProperty("missingField", "$.missingField");
        testRunner.setProperty("nullField", "$.nullField");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.write(ff, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                try (BufferedOutputStream outputStream = new BufferedOutputStream(out);){
                    ((OutputStream)outputStream).write("{\"stringField\": \"String Value\", \"nullField\": null}".getBytes(StandardCharsets.UTF_8));
                }
            }
        });
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        testRunner.assertTransferCount(EvaluateJsonPath.REL_MATCH, 1);
        FlowFile output = (FlowFile)testRunner.getFlowFilesForRelationship(EvaluateJsonPath.REL_MATCH).get(0);
        String validFieldValue = output.getAttribute("stringField");
        Assertions.assertEquals((Object)"String Value", (Object)validFieldValue);
        String missingValue = output.getAttribute("missingField");
        Assertions.assertEquals((Object)"", (Object)missingValue, (String)"Missing Value");
        String nullValue = output.getAttribute("nullField");
        Assertions.assertEquals((Object)"", (Object)nullValue, (String)"Null Value");
    }

    @Test
    public void testNullInput_nullStringRepresentation() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.RETURN_TYPE, "json");
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        testRunner.setProperty(EvaluateJsonPath.NULL_VALUE_DEFAULT_REPRESENTATION, "the string 'null'");
        testRunner.setProperty("stringField", "$.stringField");
        testRunner.setProperty("missingField", "$.missingField");
        testRunner.setProperty("nullField", "$.nullField");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.write(ff, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                try (BufferedOutputStream outputStream = new BufferedOutputStream(out);){
                    ((OutputStream)outputStream).write("{\"stringField\": \"String Value\", \"nullField\": null}".getBytes(StandardCharsets.UTF_8));
                }
            }
        });
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        testRunner.assertTransferCount(EvaluateJsonPath.REL_MATCH, 1);
        FlowFile output = (FlowFile)testRunner.getFlowFilesForRelationship(EvaluateJsonPath.REL_MATCH).get(0);
        String validFieldValue = output.getAttribute("stringField");
        Assertions.assertEquals((Object)"String Value", (Object)validFieldValue);
        String missingValue = output.getAttribute("missingField");
        Assertions.assertEquals((Object)"", (Object)missingValue, (String)"Missing Value");
        String nullValue = output.getAttribute("nullField");
        Assertions.assertEquals((Object)"null", (Object)nullValue, (String)"Null Value");
    }

    @Test
    public void testHandleAsciiControlCharacters() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateJsonPath());
        testRunner.setProperty(EvaluateJsonPath.DESTINATION, "flowfile-attribute");
        testRunner.setProperty(EvaluateJsonPath.RETURN_TYPE, "json");
        String jsonPathControlCharKey = "evaluatejson.controlcharacterpath";
        testRunner.setProperty("evaluatejson.controlcharacterpath", "$.jinxing_json.object.property");
        testRunner.enqueue(Paths.get("src/test/resources/TestJson/control-characters.json", new String[0]));
        testRunner.run();
        Relationship expectedRel = EvaluateJsonPath.REL_MATCH;
        testRunner.assertAllFlowFilesTransferred(expectedRel, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(expectedRel).get(0);
        Assertions.assertNotNull((Object)out.getAttribute("evaluatejson.controlcharacterpath"), (String)"Transferred flow file did not have the correct result for id attribute");
    }
}

