/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.Base64EncodeContent;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestBase64EncodeContent {
    @Test
    public void testRoundTrip() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new Base64EncodeContent());
        testRunner.setProperty(Base64EncodeContent.MODE, "Encode");
        testRunner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        testRunner.clearTransferState();
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(Base64EncodeContent.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(Base64EncodeContent.REL_SUCCESS).get(0);
        testRunner.assertQueueEmpty();
        testRunner.setProperty(Base64EncodeContent.MODE, "Decode");
        testRunner.enqueue(new FlowFile[]{flowFile});
        testRunner.clearTransferState();
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(Base64EncodeContent.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(Base64EncodeContent.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(new File("src/test/resources/hello.txt"));
    }

    @Test
    public void testFailDecodeNotBase64() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new Base64EncodeContent());
        testRunner.setProperty(Base64EncodeContent.MODE, "Decode");
        testRunner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        testRunner.clearTransferState();
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(Base64EncodeContent.REL_FAILURE, 1);
    }

    @Test
    public void testFailDecodeNotBase64ButIsAMultipleOfFourBytes() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new Base64EncodeContent());
        testRunner.setProperty(Base64EncodeContent.MODE, "Decode");
        testRunner.enqueue("four@@@@multiple".getBytes());
        testRunner.clearTransferState();
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(Base64EncodeContent.REL_FAILURE, 1);
    }
}

