/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.http.HttpContextMap;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.HandleHttpRequest;
import org.apache.nifi.remote.io.socket.NetworkUtils;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.web.util.ssl.SslContextUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class ITestHandleHttpRequest {
    private HandleHttpRequest processor;
    private static SSLContext keyStoreSslContext;
    private static SSLContext trustStoreSslContext;

    @BeforeAll
    public static void configureServices() throws TlsException {
        keyStoreSslContext = SslContextUtils.createKeyStoreSslContext();
        trustStoreSslContext = SslContextUtils.createTrustStoreSslContext();
    }

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.processor != null) {
            this.processor.shutdown();
        }
    }

    @Test
    @Timeout(value=30L)
    public void testRequestAddedToService() throws InitializationException {
        final CountDownLatch serverReady = new CountDownLatch(1);
        final CountDownLatch requestSent = new CountDownLatch(1);
        this.processor = this.createProcessor(serverReady, requestSent);
        final TestRunner runner = TestRunners.newTestRunner((Processor)this.processor);
        runner.setProperty(HandleHttpRequest.PORT, "0");
        MockHttpContextMap contextMap = new MockHttpContextMap();
        runner.addControllerService("http-context-map", (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpRequest.HTTP_CONTEXT_MAP, "http-context-map");
        Thread httpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    serverReady.await();
                    int port = ((HandleHttpRequest)runner.getProcessor()).getPort();
                    HttpURLConnection connection = (HttpURLConnection)new URL("http://localhost:" + port + "/my/path?query=true&value1=value1&value2=&value3&value4=apple=orange").openConnection();
                    connection.setDoOutput(false);
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("header1", "value1");
                    connection.setRequestProperty("header2", "");
                    connection.setRequestProperty("header3", "apple=orange");
                    connection.setConnectTimeout(30000);
                    connection.setReadTimeout(30000);
                    ITestHandleHttpRequest.this.sendRequest(connection, requestSent);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        httpThread.start();
        runner.run(1, false);
        runner.assertAllFlowFilesTransferred(HandleHttpRequest.REL_SUCCESS, 1);
        Assertions.assertEquals((int)1, (int)contextMap.size());
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(HandleHttpRequest.REL_SUCCESS).get(0);
        mff.assertAttributeEquals("http.query.param.query", "true");
        mff.assertAttributeEquals("http.query.param.value1", "value1");
        mff.assertAttributeEquals("http.query.param.value2", "");
        mff.assertAttributeEquals("http.query.param.value3", "");
        mff.assertAttributeEquals("http.query.param.value4", "apple=orange");
        mff.assertAttributeEquals("http.headers.header1", "value1");
        mff.assertAttributeEquals("http.headers.header3", "apple=orange");
    }

    @Test
    @Timeout(value=30L)
    public void testMultipartFormDataRequest() throws InitializationException {
        final CountDownLatch serverReady = new CountDownLatch(1);
        final CountDownLatch requestSent = new CountDownLatch(1);
        this.processor = this.createProcessor(serverReady, requestSent);
        final TestRunner runner = TestRunners.newTestRunner((Processor)this.processor);
        runner.setProperty(HandleHttpRequest.PORT, "0");
        MockHttpContextMap contextMap = new MockHttpContextMap();
        runner.addControllerService("http-context-map", (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpRequest.HTTP_CONTEXT_MAP, "http-context-map");
        Thread httpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    serverReady.await();
                    int port = ((HandleHttpRequest)runner.getProcessor()).getPort();
                    MultipartBody multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("p1", "v1").addFormDataPart("p2", "v2").addFormDataPart("file1", "my-file-text.txt", RequestBody.create((File)ITestHandleHttpRequest.this.createTextFile("Hello", "World"), (MediaType)MediaType.parse((String)"text/plain"))).addFormDataPart("file2", "my-file-data.json", RequestBody.create((File)ITestHandleHttpRequest.this.createTextFile("{ \"name\":\"John\", \"age\":30 }"), (MediaType)MediaType.parse((String)"application/json"))).addFormDataPart("file3", "my-file-binary.bin", RequestBody.create((byte[])ITestHandleHttpRequest.this.generateRandomBinaryData(), (MediaType)MediaType.parse((String)"application/octet-stream"))).build();
                    Request request = new Request.Builder().url(String.format("http://localhost:%s/my/path", port)).post((RequestBody)multipartBody).build();
                    OkHttpClient client = new OkHttpClient.Builder().readTimeout(3000L, TimeUnit.MILLISECONDS).writeTimeout(3000L, TimeUnit.MILLISECONDS).build();
                    ITestHandleHttpRequest.this.sendRequest(client, request, requestSent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        httpThread.start();
        runner.run(1, false, false);
        runner.assertAllFlowFilesTransferred(HandleHttpRequest.REL_SUCCESS, 5);
        Assertions.assertEquals((int)1, (int)contextMap.size());
        List flowFilesForRelationship = runner.getFlowFilesForRelationship(HandleHttpRequest.REL_SUCCESS);
        MockFlowFile mff = this.findFlowFile(flowFilesForRelationship, "http.multipart.name", "p1");
        String contextId = mff.getAttribute("http.context.identifier");
        mff.assertAttributeEquals("http.multipart.name", "p1");
        mff.assertAttributeExists("http.multipart.size");
        mff.assertAttributeEquals("http.multipart.fragments.sequence.number", "1");
        mff.assertAttributeEquals("http.multipart.fragments.total.number", "5");
        mff.assertAttributeExists("http.headers.multipart.content-disposition");
        mff = this.findFlowFile(flowFilesForRelationship, "http.multipart.name", "p2");
        mff.assertAttributeEquals("http.context.identifier", contextId);
        mff.assertAttributeEquals("http.multipart.name", "p2");
        mff.assertAttributeExists("http.multipart.size");
        mff.assertAttributeExists("http.multipart.fragments.sequence.number");
        mff.assertAttributeEquals("http.multipart.fragments.total.number", "5");
        mff.assertAttributeExists("http.headers.multipart.content-disposition");
        mff = this.findFlowFile(flowFilesForRelationship, "http.multipart.name", "file1");
        mff.assertAttributeEquals("http.context.identifier", contextId);
        mff.assertAttributeEquals("http.multipart.name", "file1");
        mff.assertAttributeEquals("http.multipart.filename", "my-file-text.txt");
        mff.assertAttributeEquals("http.headers.multipart.content-type", "text/plain");
        mff.assertAttributeExists("http.multipart.size");
        mff.assertAttributeExists("http.multipart.fragments.sequence.number");
        mff.assertAttributeEquals("http.multipart.fragments.total.number", "5");
        mff.assertAttributeExists("http.headers.multipart.content-disposition");
        mff = this.findFlowFile(flowFilesForRelationship, "http.multipart.name", "file2");
        mff.assertAttributeEquals("http.context.identifier", contextId);
        mff.assertAttributeEquals("http.multipart.name", "file2");
        mff.assertAttributeEquals("http.multipart.filename", "my-file-data.json");
        mff.assertAttributeEquals("http.headers.multipart.content-type", "application/json");
        mff.assertAttributeExists("http.multipart.size");
        mff.assertAttributeExists("http.multipart.fragments.sequence.number");
        mff.assertAttributeEquals("http.multipart.fragments.total.number", "5");
        mff.assertAttributeExists("http.headers.multipart.content-disposition");
        mff = this.findFlowFile(flowFilesForRelationship, "http.multipart.name", "file3");
        mff.assertAttributeEquals("http.context.identifier", contextId);
        mff.assertAttributeEquals("http.multipart.name", "file3");
        mff.assertAttributeEquals("http.multipart.filename", "my-file-binary.bin");
        mff.assertAttributeEquals("http.headers.multipart.content-type", "application/octet-stream");
        mff.assertAttributeExists("http.multipart.size");
        mff.assertAttributeExists("http.multipart.fragments.sequence.number");
        mff.assertAttributeEquals("http.multipart.fragments.total.number", "5");
        mff.assertAttributeExists("http.headers.multipart.content-disposition");
    }

    @Test
    @Timeout(value=30L)
    public void testMultipartFormDataRequestCaptureFormAttributes() throws InitializationException {
        final CountDownLatch serverReady = new CountDownLatch(1);
        final CountDownLatch requestSent = new CountDownLatch(1);
        this.processor = this.createProcessor(serverReady, requestSent);
        final TestRunner runner = TestRunners.newTestRunner((Processor)this.processor);
        runner.setProperty(HandleHttpRequest.PORT, "0");
        runner.setProperty(HandleHttpRequest.PARAMETERS_TO_ATTRIBUTES, "p1,p2");
        MockHttpContextMap contextMap = new MockHttpContextMap();
        runner.addControllerService("http-context-map", (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpRequest.HTTP_CONTEXT_MAP, "http-context-map");
        Thread httpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    serverReady.await();
                    int port = ((HandleHttpRequest)runner.getProcessor()).getPort();
                    MultipartBody multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("p1", "v1").addFormDataPart("p2", "v2").addFormDataPart("p3", "v3").build();
                    Request request = new Request.Builder().url(String.format("http://localhost:%s/my/path", port)).post((RequestBody)multipartBody).build();
                    OkHttpClient client = new OkHttpClient.Builder().readTimeout(3000L, TimeUnit.MILLISECONDS).writeTimeout(3000L, TimeUnit.MILLISECONDS).build();
                    ITestHandleHttpRequest.this.sendRequest(client, request, requestSent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        httpThread.start();
        runner.run(1, false, false);
        runner.assertAllFlowFilesTransferred(HandleHttpRequest.REL_SUCCESS, 3);
        Assertions.assertEquals((int)1, (int)contextMap.size());
        List flowFilesForRelationship = runner.getFlowFilesForRelationship(HandleHttpRequest.REL_SUCCESS);
        for (int i = 1; i < 4; ++i) {
            MockFlowFile mff = this.findFlowFile(flowFilesForRelationship, "http.multipart.name", String.format("p%d", i));
            mff.assertAttributeEquals("http.multipart.name", String.format("p%d", i));
            mff.assertAttributeExists("http.param.p1");
            mff.assertAttributeEquals("http.param.p1", "v1");
            mff.assertAttributeExists("http.param.p2");
            mff.assertAttributeEquals("http.param.p2", "v2");
            mff.assertAttributeNotExists("http.param.p3");
        }
    }

    @Test
    @Timeout(value=30L)
    public void testMultipartFormDataRequestFailToRegisterContext() throws InitializationException, InterruptedException {
        final CountDownLatch serverReady = new CountDownLatch(1);
        final CountDownLatch requestSent = new CountDownLatch(1);
        final CountDownLatch resultReady = new CountDownLatch(1);
        this.processor = this.createProcessor(serverReady, requestSent);
        final TestRunner runner = TestRunners.newTestRunner((Processor)this.processor);
        runner.setProperty(HandleHttpRequest.PORT, "0");
        MockHttpContextMap contextMap = new MockHttpContextMap();
        contextMap.setRegisterSuccessfully(false);
        runner.addControllerService("http-context-map", (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpRequest.HTTP_CONTEXT_MAP, "http-context-map");
        final AtomicInteger responseCode = new AtomicInteger(0);
        Thread httpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    serverReady.await();
                    int port = ((HandleHttpRequest)runner.getProcessor()).getPort();
                    MultipartBody multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("p1", "v1").addFormDataPart("p2", "v2").addFormDataPart("file1", "my-file-text.txt", RequestBody.create((File)ITestHandleHttpRequest.this.createTextFile("my-file-text.txt", "Hello", "World"), (MediaType)MediaType.parse((String)"text/plain"))).addFormDataPart("file2", "my-file-data.json", RequestBody.create((File)ITestHandleHttpRequest.this.createTextFile("my-file-text.txt", "{ \"name\":\"John\", \"age\":30 }"), (MediaType)MediaType.parse((String)"application/json"))).addFormDataPart("file3", "my-file-binary.bin", RequestBody.create((byte[])ITestHandleHttpRequest.this.generateRandomBinaryData(), (MediaType)MediaType.parse((String)"application/octet-stream"))).build();
                    Request request = new Request.Builder().url(String.format("http://localhost:%s/my/path", port)).post((RequestBody)multipartBody).build();
                    OkHttpClient client = new OkHttpClient.Builder().readTimeout(20000L, TimeUnit.MILLISECONDS).writeTimeout(20000L, TimeUnit.MILLISECONDS).build();
                    Callback callback = new Callback(){

                        public void onFailure(@NotNull Call call, @NotNull IOException e) {
                        }

                        public void onResponse(@NotNull Call call, @NotNull Response response) {
                            responseCode.set(response.code());
                            resultReady.countDown();
                        }
                    };
                    ITestHandleHttpRequest.this.sendRequest(client, request, callback, requestSent);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        httpThread.start();
        runner.run(1, false, false);
        resultReady.await();
        runner.assertAllFlowFilesTransferred(HandleHttpRequest.REL_SUCCESS, 0);
        Assertions.assertEquals((int)0, (int)contextMap.size());
        Assertions.assertEquals((int)503, (int)responseCode.get());
    }

    private byte[] generateRandomBinaryData() {
        byte[] bytes = new byte[100];
        new Random().nextBytes(bytes);
        return bytes;
    }

    private File createTextFile(String ... lines) throws IOException {
        File file = new File(this.getClass().getSimpleName());
        file.deleteOnExit();
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            for (String line : lines) {
                writer.println(line);
            }
        }
        return file;
    }

    protected MockFlowFile findFlowFile(List<MockFlowFile> flowFilesForRelationship, String attributeName, String attributeValue) {
        Optional<MockFlowFile> optional = flowFilesForRelationship.stream().filter(ff -> ff.getAttribute(attributeName).equals(attributeValue)).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent());
        return optional.get();
    }

    @Test
    @Timeout(value=30L)
    public void testFailToRegister() throws InitializationException, InterruptedException {
        final CountDownLatch serverReady = new CountDownLatch(1);
        final CountDownLatch requestSent = new CountDownLatch(1);
        final CountDownLatch resultReady = new CountDownLatch(1);
        this.processor = this.createProcessor(serverReady, requestSent);
        final TestRunner runner = TestRunners.newTestRunner((Processor)this.processor);
        runner.setProperty(HandleHttpRequest.PORT, "0");
        MockHttpContextMap contextMap = new MockHttpContextMap();
        runner.addControllerService("http-context-map", (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpRequest.HTTP_CONTEXT_MAP, "http-context-map");
        contextMap.setRegisterSuccessfully(false);
        final int[] responseCode = new int[1];
        Thread httpThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection connection = null;
                try {
                    serverReady.await();
                    int port = ((HandleHttpRequest)runner.getProcessor()).getPort();
                    connection = (HttpURLConnection)new URL("http://localhost:" + port + "/my/path?query=true&value1=value1&value2=&value3&value4=apple=orange").openConnection();
                    connection.setDoOutput(false);
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("header1", "value1");
                    connection.setRequestProperty("header2", "");
                    connection.setRequestProperty("header3", "apple=orange");
                    connection.setConnectTimeout(20000);
                    connection.setReadTimeout(20000);
                    ITestHandleHttpRequest.this.sendRequest(connection, requestSent);
                }
                catch (Throwable t) {
                    if (connection != null) {
                        try {
                            responseCode[0] = connection.getResponseCode();
                        }
                        catch (IOException e) {
                            responseCode[0] = -1;
                        }
                    } else {
                        responseCode[0] = -2;
                    }
                }
                finally {
                    resultReady.countDown();
                }
            }
        });
        httpThread.start();
        runner.run(1, false, false);
        resultReady.await();
        runner.assertTransferCount(HandleHttpRequest.REL_SUCCESS, 0);
        Assertions.assertEquals((int)503, (int)responseCode[0]);
    }

    @Test
    @Timeout(value=15L)
    public void testOnPrimaryNodeChangePrimaryNodeRevoked() throws Exception {
        this.processor = new HandleHttpRequest();
        TestRunner runner = TestRunners.newTestRunner((Processor)this.processor);
        int port = NetworkUtils.getAvailableTcpPort();
        runner.setProperty(HandleHttpRequest.PORT, Integer.toString(port));
        MockHttpContextMap contextMap = new MockHttpContextMap();
        String contextMapId = MockHttpContextMap.class.getSimpleName();
        runner.addControllerService(contextMapId, (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpRequest.HTTP_CONTEXT_MAP, contextMapId);
        ProcessContext processContext = (ProcessContext)Mockito.spy((Object)runner.getProcessContext());
        Mockito.when((Object)processContext.getExecutionNode()).thenReturn((Object)ExecutionNode.PRIMARY);
        this.processor.initializeServer(processContext);
        OkHttpClient client = new OkHttpClient.Builder().build();
        String url = String.format("http://localhost:%d", port);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final CountDownLatch requestCompleted = new CountDownLatch(1);
        CountDownLatch requestStarted = new CountDownLatch(1);
        final AtomicReference requestException = new AtomicReference();
        final AtomicInteger responseStatus = new AtomicInteger();
        executorService.execute(() -> {
            Request request = new Request.Builder().url(url).get().build();
            Call call = client.newCall(request);
            call.enqueue(new Callback(){

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    requestException.set(e);
                    requestCompleted.countDown();
                }

                public void onResponse(@NotNull Call call, @NotNull Response response) {
                    responseStatus.set(response.code());
                    requestCompleted.countDown();
                }
            });
            requestStarted.countDown();
        });
        requestStarted.await();
        Thread.sleep(1000L);
        this.processor.onPrimaryNodeChange(PrimaryNodeState.PRIMARY_NODE_REVOKED);
        requestCompleted.await();
        Assertions.assertNull(requestException.get(), (String)"HTTP Request Exception found");
        Assertions.assertEquals((int)503, (int)responseStatus.get(), (String)"HTTP Status not matched");
    }

    @Test
    public void testSecure() throws Exception {
        this.secureTest(false);
    }

    @Test
    public void testSecureTwoWaySsl() throws Exception {
        this.secureTest(true);
    }

    private void secureTest(final boolean twoWaySsl) throws Exception {
        final CountDownLatch serverReady = new CountDownLatch(1);
        final CountDownLatch requestSent = new CountDownLatch(1);
        this.processor = this.createProcessor(serverReady, requestSent);
        final TestRunner runner = TestRunners.newTestRunner((Processor)this.processor);
        runner.setProperty(HandleHttpRequest.PORT, "0");
        MockHttpContextMap contextMap = new MockHttpContextMap();
        runner.addControllerService("http-context-map", (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpRequest.HTTP_CONTEXT_MAP, "http-context-map");
        RestrictedSSLContextService sslContextService = (RestrictedSSLContextService)Mockito.mock(RestrictedSSLContextService.class);
        String serviceIdentifier = RestrictedSSLContextService.class.getName();
        Mockito.when((Object)sslContextService.getIdentifier()).thenReturn((Object)serviceIdentifier);
        Mockito.when((Object)sslContextService.createContext()).thenReturn((Object)keyStoreSslContext);
        runner.addControllerService(serviceIdentifier, (ControllerService)sslContextService);
        runner.enableControllerService((ControllerService)sslContextService);
        runner.setProperty(HandleHttpRequest.SSL_CONTEXT, serviceIdentifier);
        Thread httpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    serverReady.await();
                    int port = ((HandleHttpRequest)runner.getProcessor()).getPort();
                    HttpsURLConnection connection = (HttpsURLConnection)new URL("https://localhost:" + port + "/my/path?query=true&value1=value1&value2=&value3&value4=apple=orange").openConnection();
                    SSLContext clientSslContext = twoWaySsl ? keyStoreSslContext : trustStoreSslContext;
                    connection.setSSLSocketFactory(clientSslContext.getSocketFactory());
                    connection.setDoOutput(false);
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("header1", "value1");
                    connection.setRequestProperty("header2", "");
                    connection.setRequestProperty("header3", "apple=orange");
                    connection.setConnectTimeout(3000);
                    connection.setReadTimeout(3000);
                    ITestHandleHttpRequest.this.sendRequest(connection, requestSent);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        httpThread.start();
        runner.run(1, false, false);
        runner.assertAllFlowFilesTransferred(HandleHttpRequest.REL_SUCCESS, 1);
        Assertions.assertEquals((int)1, (int)contextMap.size());
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(HandleHttpRequest.REL_SUCCESS).get(0);
        mff.assertAttributeEquals("http.query.param.query", "true");
        mff.assertAttributeEquals("http.query.param.value1", "value1");
        mff.assertAttributeEquals("http.query.param.value2", "");
        mff.assertAttributeEquals("http.query.param.value3", "");
        mff.assertAttributeEquals("http.query.param.value4", "apple=orange");
        mff.assertAttributeEquals("http.headers.header1", "value1");
        mff.assertAttributeEquals("http.headers.header3", "apple=orange");
        mff.assertAttributeEquals("http.protocol", "HTTP/1.1");
    }

    private HandleHttpRequest createProcessor(final CountDownLatch serverReady, final CountDownLatch requestSent) {
        return new HandleHttpRequest(){

            synchronized void initializeServer(ProcessContext context) throws Exception {
                super.initializeServer(context);
                serverReady.countDown();
                requestSent.await();
                while (this.getRequestQueueSize() == 0) {
                    Thread.sleep(200L);
                }
            }

            void drainContainerQueue() {
            }
        };
    }

    private void sendRequest(HttpURLConnection connection, CountDownLatch requestSent) throws Exception {
        Future<InputStream> executionFuture = Executors.newSingleThreadExecutor().submit(connection::getInputStream);
        requestSent.countDown();
        executionFuture.get();
    }

    private void sendRequest(OkHttpClient client, Request request, CountDownLatch requestSent) {
        Callback callback = new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
            }
        };
        this.sendRequest(client, request, callback, requestSent);
    }

    private void sendRequest(OkHttpClient client, Request request, Callback callback, CountDownLatch requestSent) {
        client.newCall(request).enqueue(callback);
        requestSent.countDown();
    }

    private static class MockHttpContextMap
    extends AbstractControllerService
    implements HttpContextMap {
        private boolean registerSuccessfully = true;
        private final ConcurrentMap<String, HttpServletResponse> responseMap = new ConcurrentHashMap<String, HttpServletResponse>();

        private MockHttpContextMap() {
        }

        public boolean register(String identifier, HttpServletRequest request, HttpServletResponse response, AsyncContext context) {
            if (this.registerSuccessfully) {
                this.responseMap.put(identifier, response);
            }
            return this.registerSuccessfully;
        }

        public HttpServletResponse getResponse(String identifier) {
            return (HttpServletResponse)this.responseMap.get(identifier);
        }

        public void complete(String identifier) {
            this.responseMap.remove(identifier);
        }

        public int size() {
            return this.responseMap.size();
        }

        public void setRegisterSuccessfully(boolean registerSuccessfully) {
            this.registerSuccessfully = registerSuccessfully;
        }

        public long getRequestTimeout(TimeUnit timeUnit) {
            return timeUnit.convert(30000L, TimeUnit.MILLISECONDS);
        }
    }
}

