/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.db.impl.MSSQL2008DatabaseAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMSSQL2008DatabaseAdapter {
    private final DatabaseAdapter db = new MSSQL2008DatabaseAdapter();

    @Test
    public void testGeneration() {
        String sql = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "", null, null);
        String expected1 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename";
        Assertions.assertEquals((Object)expected1, (Object)sql);
        sql = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "that='some\"' value'", "", null, null);
        String expected2 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE that='some\"' value'";
        Assertions.assertEquals((Object)expected2, (Object)sql);
        sql = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "that='some\"' value'", "might DESC", null, null);
        String expected3 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE that='some\"' value' ORDER BY might DESC";
        Assertions.assertEquals((Object)expected3, (Object)sql);
        sql = this.db.getSelectStatement("database.tablename", "", "that='some\"' value'", "might DESC", null, null);
        String expected4 = "SELECT * FROM database.tablename WHERE that='some\"' value' ORDER BY might DESC";
        Assertions.assertEquals((Object)expected4, (Object)sql);
    }

    @Test
    public void testNoTableName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.db.getSelectStatement("", "some(set),of(columns),that,might,contain,methods,a.*", "", "", null, null));
    }

    @Test
    public void testTOPQuery() {
        String sql = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "", Long.valueOf(100L), null);
        String expected1 = "SELECT TOP 100 some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename";
        Assertions.assertEquals((Object)expected1, (Object)sql);
        sql = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "contain", Long.valueOf(100L), null);
        String expected2 = "SELECT TOP 100 some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename ORDER BY contain";
        Assertions.assertEquals((Object)expected2, (Object)sql);
        sql = this.db.getSelectStatement("database.tablename", "", "that='some\"' value'", "might DESC", Long.valueOf(123456L), null);
        String expected4 = "SELECT TOP 123456 * FROM database.tablename WHERE that='some\"' value' ORDER BY might DESC";
        Assertions.assertEquals((Object)expected4, (Object)sql);
    }

    @Test
    public void testPagingQuery() {
        String sql = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "contain", Long.valueOf(100L), Long.valueOf(0L));
        String expected1 = "SELECT * FROM (SELECT TOP 100 some(set),of(columns),that,might,contain,methods,a.*, ROW_NUMBER() OVER(ORDER BY contain asc) rnum FROM database.tablename ORDER BY contain) A WHERE rnum > 0 AND rnum <= 100";
        Assertions.assertEquals((Object)expected1, (Object)sql);
        sql = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "contain", Long.valueOf(10000L), Long.valueOf(123456L));
        String expected2 = "SELECT * FROM (SELECT TOP 133456 some(set),of(columns),that,might,contain,methods,a.*, ROW_NUMBER() OVER(ORDER BY contain asc) rnum FROM database.tablename ORDER BY contain) A WHERE rnum > 123456 AND rnum <= 133456";
        Assertions.assertEquals((Object)expected2, (Object)sql);
        sql = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "methods='strange'", "contain", Long.valueOf(10000L), Long.valueOf(123456L));
        String expected3 = "SELECT * FROM (SELECT TOP 133456 some(set),of(columns),that,might,contain,methods,a.*, ROW_NUMBER() OVER(ORDER BY contain asc) rnum FROM database.tablename WHERE methods='strange' ORDER BY contain) A WHERE rnum > 123456 AND rnum <= 133456";
        Assertions.assertEquals((Object)expected3, (Object)sql);
    }

    @Test
    public void testPagingQueryUsingColumnValuesForPartitioning() {
        String sql1 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "1=1", "contain", Long.valueOf(100L), Long.valueOf(0L), "contain");
        String expected1 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE 1=1 AND contain >= 0 AND contain < 100";
        Assertions.assertEquals((Object)expected1, (Object)sql1);
        String sql2 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "1=1", "contain", Long.valueOf(10000L), Long.valueOf(123456L), "contain");
        String expected2 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE 1=1 AND contain >= 123456 AND contain < 133456";
        Assertions.assertEquals((Object)expected2, (Object)sql2);
        String sql3 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "methods='strange'", "contain", Long.valueOf(10000L), Long.valueOf(123456L), "contain");
        String expected3 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE methods='strange' AND contain >= 123456 AND contain < 133456";
        Assertions.assertEquals((Object)expected3, (Object)sql3);
        String sql4 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "", Long.valueOf(100L), null, "contain");
        String expected4 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename";
        Assertions.assertEquals((Object)expected4, (Object)sql4);
    }
}

