/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.List;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.DistributeLoad;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDistributeLoad {
    @Test
    public void testDefaultRoundRobin() {
        int i;
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new DistributeLoad());
        testRunner.setProperty(DistributeLoad.NUM_RELATIONSHIPS, "100");
        for (i = 0; i < 101; ++i) {
            testRunner.enqueue(new byte[0]);
        }
        testRunner.run(101);
        testRunner.assertTransferCount("1", 2);
        for (i = 2; i <= 100; ++i) {
            testRunner.assertTransferCount(String.valueOf(i), 1);
        }
    }

    @Test
    public void testWeightedRoundRobin() {
        int i;
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new DistributeLoad());
        testRunner.setProperty(DistributeLoad.NUM_RELATIONSHIPS, "100");
        testRunner.setProperty("1", "5");
        testRunner.setProperty("2", "3");
        for (i = 0; i < 106; ++i) {
            testRunner.enqueue(new byte[0]);
        }
        testRunner.run(108);
        testRunner.assertTransferCount("1", 5);
        testRunner.assertTransferCount("2", 3);
        for (i = 3; i <= 100; ++i) {
            testRunner.assertTransferCount(String.valueOf(i), 1);
        }
    }

    @Test
    public void testValidationOnAddedProperties() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new DistributeLoad());
        testRunner.setProperty(DistributeLoad.NUM_RELATIONSHIPS, "100");
        testRunner.setProperty("1", "5");
        testRunner.setProperty("1", "0");
        testRunner.assertNotValid();
        testRunner.setProperty("1", "-1");
        testRunner.assertNotValid();
        testRunner.setProperty("1", "101");
        testRunner.setProperty("100", "5");
        testRunner.setProperty("101", "5");
        testRunner.assertNotValid();
        testRunner.setProperty("0", "5");
        testRunner.assertNotValid();
        testRunner.setProperty("-1", "5");
        testRunner.assertNotValid();
    }

    @Test
    public void testNextAvailable() {
        int i;
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new DistributeLoad());
        testRunner.setProperty(DistributeLoad.NUM_RELATIONSHIPS.getName(), "100");
        testRunner.setProperty(DistributeLoad.DISTRIBUTION_STRATEGY.getName(), DistributeLoad.STRATEGY_NEXT_AVAILABLE.getValue());
        for (i = 0; i < 99; ++i) {
            testRunner.enqueue(new byte[0]);
        }
        testRunner.setRelationshipUnavailable("50");
        testRunner.run(101);
        testRunner.assertQueueEmpty();
        for (i = 1; i <= 100; ++i) {
            System.out.println(i);
            testRunner.assertTransferCount(String.valueOf(i), i == 50 ? 0 : 1);
        }
    }

    @Test
    public void testFlowFileAttributesAdded() {
        int i;
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new DistributeLoad());
        testRunner.setProperty(DistributeLoad.NUM_RELATIONSHIPS, "100");
        testRunner.setProperty(DistributeLoad.DISTRIBUTION_STRATEGY, DistributeLoad.STRATEGY_NEXT_AVAILABLE);
        for (i = 0; i < 100; ++i) {
            testRunner.enqueue(new byte[0]);
        }
        testRunner.run(101);
        testRunner.assertQueueEmpty();
        for (i = 1; i <= 100; ++i) {
            testRunner.assertTransferCount(String.valueOf(i), 1);
            List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(String.valueOf(i));
            Assertions.assertEquals((int)1, (int)flowFilesForRelationship.size());
            MockFlowFile mockFlowFile = (MockFlowFile)flowFilesForRelationship.get(0);
            Assertions.assertEquals((Object)String.valueOf(i), (Object)mockFlowFile.getAttribute("distribute.load.relationship"));
        }
    }

    @Test
    public void testOverflow() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new DistributeLoad());
        testRunner.setProperty(DistributeLoad.NUM_RELATIONSHIPS.getName(), "3");
        testRunner.setProperty(DistributeLoad.DISTRIBUTION_STRATEGY.getName(), DistributeLoad.STRATEGY_OVERFLOW.getValue());
        for (int i = 0; i < 8; ++i) {
            testRunner.enqueue(new byte[0]);
        }
        testRunner.run(2, false);
        testRunner.assertTransferCount("1", 2);
        testRunner.assertTransferCount("2", 0);
        testRunner.assertTransferCount("3", 0);
        testRunner.clearTransferState();
        testRunner.setRelationshipUnavailable("1");
        testRunner.run(2, false);
        testRunner.assertTransferCount("1", 0);
        testRunner.assertTransferCount("2", 2);
        testRunner.assertTransferCount("3", 0);
        testRunner.clearTransferState();
        testRunner.setRelationshipAvailable("1");
        testRunner.run(2, false);
        testRunner.assertTransferCount("1", 2);
        testRunner.assertTransferCount("2", 0);
        testRunner.assertTransferCount("3", 0);
        testRunner.clearTransferState();
        testRunner.setRelationshipUnavailable("1");
        testRunner.setRelationshipUnavailable("2");
        testRunner.run(2, false);
        testRunner.assertTransferCount("1", 0);
        testRunner.assertTransferCount("2", 0);
        testRunner.assertTransferCount("3", 2);
    }
}

