/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.standard.FetchFTP;
import org.apache.nifi.processors.standard.GetFTP;
import org.apache.nifi.processors.standard.ListFileTransfer;
import org.apache.nifi.processors.standard.PutFTP;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.processors.standard.util.FileTransfer;
import org.apache.nifi.scheduling.SchedulingStrategy;

@PrimaryNodeOnly
@TriggerSerially
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"list", "ftp", "remote", "ingest", "source", "input", "files"})
@CapabilityDescription(value="Performs a listing of the files residing on an FTP server. For each file that is found on the remote server, a new FlowFile will be created with the filename attribute set to the name of the file on the remote server. This can then be used in conjunction with FetchFTP in order to fetch those files.")
@SeeAlso(value={FetchFTP.class, GetFTP.class, PutFTP.class})
@WritesAttributes(value={@WritesAttribute(attribute="ftp.remote.host", description="The hostname of the FTP Server"), @WritesAttribute(attribute="ftp.remote.port", description="The port that was connected to on the FTP Server"), @WritesAttribute(attribute="ftp.listing.user", description="The username of the user that performed the FTP Listing"), @WritesAttribute(attribute="file.owner", description="The numeric owner id of the source file"), @WritesAttribute(attribute="file.group", description="The numeric group id of the source file"), @WritesAttribute(attribute="file.permissions", description="The read/write/execute permissions of the source file"), @WritesAttribute(attribute="file.size", description="The number of bytes in the source file"), @WritesAttribute(attribute="file.lastModifiedTime", description="The timestamp of when the file in the filesystem waslast modified as 'yyyy-MM-dd'T'HH:mm:ssZ'"), @WritesAttribute(attribute="filename", description="The name of the file on the FTP Server"), @WritesAttribute(attribute="path", description="The fully qualified name of the directory on the FTP Server from which the file was pulled")})
@Stateful(scopes={Scope.CLUSTER}, description="After performing a listing of files, the timestamp of the newest file is stored. This allows the Processor to list only files that have been added or modified after this date the next time that the Processor is run. State is stored across the cluster so that this Processor can be run on Primary Node only and if a new Primary Node is selected, the new node will not duplicate the data that was listed by the previous Primary Node.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class ListFTP
extends ListFileTransfer {
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        PropertyDescriptor port = new PropertyDescriptor.Builder().fromPropertyDescriptor(UNDEFAULTED_PORT).defaultValue("21").build();
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(FILE_TRANSFER_LISTING_STRATEGY);
        properties.add(HOSTNAME);
        properties.add(port);
        properties.add(USERNAME);
        properties.add(FTPTransfer.PASSWORD);
        properties.add(REMOTE_PATH);
        properties.add(RECORD_WRITER);
        properties.add(DISTRIBUTED_CACHE_SERVICE);
        properties.add(FTPTransfer.RECURSIVE_SEARCH);
        properties.add(FTPTransfer.FOLLOW_SYMLINK);
        properties.add(FTPTransfer.FILE_FILTER_REGEX);
        properties.add(FTPTransfer.PATH_FILTER_REGEX);
        properties.add(FTPTransfer.IGNORE_DOTTED_FILES);
        properties.add(FTPTransfer.REMOTE_POLL_BATCH_SIZE);
        properties.add(FTPTransfer.CONNECTION_TIMEOUT);
        properties.add(FTPTransfer.DATA_TIMEOUT);
        properties.add(FTPTransfer.CONNECTION_MODE);
        properties.add(FTPTransfer.TRANSFER_MODE);
        properties.add(FTPTransfer.PROXY_CONFIGURATION_SERVICE);
        properties.add(FTPTransfer.PROXY_TYPE);
        properties.add(FTPTransfer.PROXY_HOST);
        properties.add(FTPTransfer.PROXY_PORT);
        properties.add(FTPTransfer.HTTP_PROXY_USERNAME);
        properties.add(FTPTransfer.HTTP_PROXY_PASSWORD);
        properties.add(FTPTransfer.BUFFER_SIZE);
        properties.add(TARGET_SYSTEM_TIMESTAMP_PRECISION);
        properties.add(ListedEntityTracker.TRACKING_STATE_CACHE);
        properties.add(ListedEntityTracker.TRACKING_TIME_WINDOW);
        properties.add(ListedEntityTracker.INITIAL_LISTING_TARGET);
        properties.add(FTPTransfer.UTF8_ENCODING);
        return properties;
    }

    @Override
    protected FileTransfer getFileTransfer(ProcessContext context) {
        return new FTPTransfer(context, this.getLogger());
    }

    @Override
    protected String getProtocolName() {
        return "ftp";
    }

    protected Scope getStateScope(PropertyContext context) {
        return Scope.CLUSTER;
    }

    protected void customValidate(ValidationContext validationContext, Collection<ValidationResult> results) {
        FTPTransfer.validateProxySpec(validationContext, results);
    }
}

