/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processors.standard.FetchFTP;
import org.apache.nifi.processors.standard.GetFTP;
import org.apache.nifi.processors.standard.ListFTP;
import org.apache.nifi.processors.standard.ListFile;
import org.apache.nifi.processors.standard.PutFTP;
import org.apache.nifi.processors.standard.PutFileTransfer;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;
import org.mockftpserver.fake.FakeFtpServer;
import org.mockftpserver.fake.UserAccount;
import org.mockftpserver.fake.filesystem.DirectoryEntry;
import org.mockftpserver.fake.filesystem.FileEntry;
import org.mockftpserver.fake.filesystem.FileSystem;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.Permissions;
import org.mockftpserver.fake.filesystem.WindowsFakeFileSystem;

public class TestFTP {
    private static final String LOCALHOST_ADDRESS = "127.0.0.1";
    final FakeFtpServer fakeFtpServer = new FakeFtpServer();
    final String username = "nifi-ftp-user";
    final String password = "Test test test chocolate";
    int ftpPort;

    @BeforeEach
    public void setUp() throws Exception {
        this.fakeFtpServer.setServerControlPort(0);
        this.fakeFtpServer.addUserAccount(new UserAccount("nifi-ftp-user", "Test test test chocolate", "c:\\data"));
        WindowsFakeFileSystem fileSystem = new WindowsFakeFileSystem();
        fileSystem.add((FileSystemEntry)new DirectoryEntry("c:\\data"));
        this.fakeFtpServer.setFileSystem((FileSystem)fileSystem);
        this.fakeFtpServer.start();
        this.ftpPort = this.fakeFtpServer.getServerControlPort();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.fakeFtpServer.stop();
    }

    @Test
    public void testValidators() {
        TestRunner runner = TestRunners.newTestRunner(PutFTP.class);
        runner.setProperty(FTPTransfer.USERNAME, "${el-username}");
        runner.setProperty(FTPTransfer.HOSTNAME, "static-hostname");
        runner.setProperty(FTPTransfer.PORT, "${el-portNumber}");
        Collection results = new HashSet();
        runner.setProperty(FTPTransfer.REMOTE_PATH, "static-remote-target");
        runner.enqueue(new byte[0]);
        ProcessContext pc = runner.getProcessContext();
        if (pc instanceof MockProcessContext) {
            results = ((MockProcessContext)pc).validate();
        }
        Assertions.assertEquals((int)0, (int)results.size());
        results = new HashSet();
        runner.setProperty(FTPTransfer.REMOTE_PATH, "${el-remote-target}");
        runner.enqueue(new byte[0]);
        pc = runner.getProcessContext();
        if (pc instanceof MockProcessContext) {
            results = ((MockProcessContext)pc).validate();
        }
        Assertions.assertEquals((int)0, (int)results.size());
        results = new HashSet();
        runner.setProperty(FTPTransfer.USERNAME, "static-username");
        runner.enqueue(new byte[0]);
        pc = runner.getProcessContext();
        if (pc instanceof MockProcessContext) {
            results = ((MockProcessContext)pc).validate();
        }
        Assertions.assertEquals((int)0, (int)results.size());
        results = new HashSet();
        runner.setProperty(FTPTransfer.USERNAME, "");
        runner.enqueue(new byte[0]);
        pc = runner.getProcessContext();
        if (pc instanceof MockProcessContext) {
            results = ((MockProcessContext)pc).validate();
        }
        Assertions.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void testPutFtp() throws IOException {
        TestRunner runner = TestRunners.newTestRunner(PutFTP.class);
        runner.setProperty(FTPTransfer.HOSTNAME, LOCALHOST_ADDRESS);
        runner.setProperty(FTPTransfer.USERNAME, "nifi-ftp-user");
        runner.setProperty(FTPTransfer.PASSWORD, "Test test test chocolate");
        runner.setProperty(FTPTransfer.PORT, Integer.toString(this.ftpPort));
        try (FileInputStream fis = new FileInputStream("src/test/resources/randombytes-1");){
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(CoreAttributes.FILENAME.key(), "randombytes-1");
            runner.enqueue((InputStream)fis, attributes);
            runner.run();
        }
        runner.assertQueueEmpty();
        runner.assertAllFlowFilesTransferred(PutFTP.REL_SUCCESS);
        FileSystem results = this.fakeFtpServer.getFileSystem();
        Assertions.assertTrue((boolean)results.exists("c:\\data\\randombytes-1"));
    }

    @Test
    public void testPutFtpProvenanceEvents() throws IOException {
        HashMap<String, String> attributes;
        TestRunner runner = TestRunners.newTestRunner(PutFTP.class);
        runner.setProperty(FTPTransfer.HOSTNAME, "localhost");
        runner.setProperty(FTPTransfer.USERNAME, "nifi-ftp-user");
        runner.setProperty(FTPTransfer.PASSWORD, "Test test test chocolate");
        runner.setProperty(FTPTransfer.PORT, Integer.toString(this.ftpPort));
        try (FileInputStream fis = new FileInputStream("src/test/resources/randombytes-1");){
            attributes = new HashMap<String, String>();
            attributes.put(CoreAttributes.FILENAME.key(), "randombytes-1");
            attributes.put("transfer-host", "localhost");
            runner.enqueue((InputStream)fis, attributes);
            runner.run();
        }
        fis = new FileInputStream("src/test/resources/hello.txt");
        try {
            attributes = new HashMap();
            attributes.put(CoreAttributes.FILENAME.key(), "hello.txt");
            attributes.put("transfer-host", LOCALHOST_ADDRESS);
            runner.enqueue((InputStream)fis, attributes);
            runner.run();
        }
        finally {
            fis.close();
        }
        runner.assertQueueEmpty();
        runner.assertTransferCount(PutFTP.REL_SUCCESS, 2);
        MockFlowFile flowFile1 = (MockFlowFile)runner.getFlowFilesForRelationship(PutFileTransfer.REL_SUCCESS).get(0);
        MockFlowFile flowFile2 = (MockFlowFile)runner.getFlowFilesForRelationship(PutFileTransfer.REL_SUCCESS).get(1);
        runner.clearProvenanceEvents();
        runner.clearTransferState();
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map1.put(CoreAttributes.FILENAME.key(), "randombytes-xx");
        map2.put(CoreAttributes.FILENAME.key(), "randombytes-yy");
        flowFile1.putAttributes(map1);
        flowFile2.putAttributes(map2);
        runner.setProperty(FTPTransfer.HOSTNAME, "${transfer-host}");
        runner.setThreadCount(1);
        runner.enqueue(new FlowFile[]{flowFile1});
        runner.enqueue(new FlowFile[]{flowFile2});
        runner.run();
        runner.assertTransferCount(PutFTP.REL_SUCCESS, 2);
        assert (((ProvenanceEventRecord)runner.getProvenanceEvents().get(0)).getTransitUri().contains("ftp://localhost"));
        assert (((ProvenanceEventRecord)runner.getProvenanceEvents().get(1)).getTransitUri().contains("ftp://127.0.0.1"));
    }

    @Test
    public void testGetFtp() {
        FileSystem results = this.fakeFtpServer.getFileSystem();
        FileEntry sampleFile = new FileEntry("c:\\data\\randombytes-2");
        sampleFile.setContents("Just some random test test test chocolate");
        results.add((FileSystemEntry)sampleFile);
        Assertions.assertTrue((boolean)results.exists("c:\\data\\randombytes-2"));
        TestRunner runner = TestRunners.newTestRunner(GetFTP.class);
        runner.setProperty(FTPTransfer.HOSTNAME, LOCALHOST_ADDRESS);
        runner.setProperty(FTPTransfer.USERNAME, "nifi-ftp-user");
        runner.setProperty(FTPTransfer.PASSWORD, "Test test test chocolate");
        runner.setProperty(FTPTransfer.PORT, Integer.toString(this.ftpPort));
        runner.setProperty(FTPTransfer.REMOTE_PATH, "/");
        runner.run();
        MockFlowFile retrievedFile = (MockFlowFile)runner.getFlowFilesForRelationship(GetFTP.REL_SUCCESS).get(0);
        retrievedFile.assertContentEquals("Just some random test test test chocolate");
    }

    @Test
    public void testFetchFtp() {
        FileSystem results = this.fakeFtpServer.getFileSystem();
        FileEntry sampleFile = new FileEntry("c:\\data\\randombytes-2");
        sampleFile.setContents("Just some random test test test chocolate");
        results.add((FileSystemEntry)sampleFile);
        Assertions.assertTrue((boolean)results.exists("c:\\data\\randombytes-2"));
        TestRunner runner = TestRunners.newTestRunner(FetchFTP.class);
        runner.setProperty(FetchFTP.HOSTNAME, "${host}");
        runner.setProperty(FetchFTP.USERNAME, "${username}");
        runner.setProperty(FTPTransfer.PASSWORD, "Test test test chocolate");
        runner.setProperty(FTPTransfer.PORT, "${port}");
        runner.setProperty(FetchFTP.REMOTE_FILENAME, "c:\\data\\randombytes-2");
        runner.setProperty(FetchFTP.COMPLETION_STRATEGY, FetchFTP.COMPLETION_MOVE);
        runner.setProperty(FetchFTP.MOVE_DESTINATION_DIR, "data");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("host", "localhost");
        attrs.put("username", "nifi-ftp-user");
        attrs.put("port", Integer.toString(this.ftpPort));
        runner.enqueue("", attrs);
        runner.run();
        MockFlowFile retrievedFile = (MockFlowFile)runner.getFlowFilesForRelationship(FetchFTP.REL_SUCCESS).get(0);
        retrievedFile.assertContentEquals("Just some random test test test chocolate");
    }

    @Test
    public void testFetchFtpFileNotFound() {
        TestRunner runner = TestRunners.newTestRunner(FetchFTP.class);
        runner.setProperty(FetchFTP.HOSTNAME, LOCALHOST_ADDRESS);
        runner.setProperty(FetchFTP.USERNAME, "nifi-ftp-user");
        runner.setProperty(FTPTransfer.PASSWORD, "Test test test chocolate");
        runner.setProperty(FTPTransfer.PORT, Integer.toString(this.ftpPort));
        runner.setProperty(FetchFTP.REMOTE_FILENAME, "remote-file-not-found");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFTP.REL_NOT_FOUND);
    }

    @Test
    public void testFetchFtpFilePermissionDenied() {
        FileSystem fs = this.fakeFtpServer.getFileSystem();
        FileEntry restrictedFileEntry = new FileEntry("c:\\data\\restricted");
        restrictedFileEntry.setPermissions(Permissions.NONE);
        fs.add((FileSystemEntry)restrictedFileEntry);
        TestRunner runner = TestRunners.newTestRunner(FetchFTP.class);
        runner.setProperty(FetchFTP.HOSTNAME, LOCALHOST_ADDRESS);
        runner.setProperty(FetchFTP.USERNAME, "nifi-ftp-user");
        runner.setProperty(FTPTransfer.PASSWORD, "Test test test chocolate");
        runner.setProperty(FTPTransfer.PORT, Integer.toString(this.ftpPort));
        runner.setProperty(FetchFTP.REMOTE_FILENAME, "restricted");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFTP.REL_PERMISSION_DENIED);
    }

    @Test
    public void testListFtpHostPortVariablesFileFound() {
        FileSystem fs = this.fakeFtpServer.getFileSystem();
        FileEntry fileEntry = new FileEntry("c:\\data\\found");
        fs.add((FileSystemEntry)fileEntry);
        TestRunner runner = TestRunners.newTestRunner(ListFTP.class);
        runner.setVariable("host", LOCALHOST_ADDRESS);
        runner.setVariable("port", Integer.toString(this.ftpPort));
        runner.setProperty(ListFTP.HOSTNAME, "${host}");
        runner.setProperty(FTPTransfer.PORT, "${port}");
        runner.setProperty(ListFTP.USERNAME, "nifi-ftp-user");
        runner.setProperty(FTPTransfer.PASSWORD, "Test test test chocolate");
        runner.setProperty(ListFile.TARGET_SYSTEM_TIMESTAMP_PRECISION, ListFile.PRECISION_MILLIS);
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(ListFTP.REL_SUCCESS, 1);
    }

    @Test
    @EnabledIfSystemProperty(named="file.encoding", matches="UTF-8", disabledReason="org.mockftpserver does not support specification of charset")
    public void testFetchFtpUnicodeFileName() {
        FileSystem fs = this.fakeFtpServer.getFileSystem();
        FileEntry sampleFile = new FileEntry("c:\\data\\\u0151\u0171\u0151\u0171.txt");
        sampleFile.setContents("Just some random test test test chocolate");
        fs.add((FileSystemEntry)sampleFile);
        TestRunner runner = TestRunners.newTestRunner(FetchFTP.class);
        runner.setProperty(FetchFTP.HOSTNAME, LOCALHOST_ADDRESS);
        runner.setProperty(FetchFTP.USERNAME, "nifi-ftp-user");
        runner.setProperty(FTPTransfer.PASSWORD, "Test test test chocolate");
        runner.setProperty(FTPTransfer.PORT, String.valueOf(this.ftpPort));
        runner.setProperty(FetchFTP.REMOTE_FILENAME, "c:\\data\\\u0151\u0171\u0151\u0171.txt");
        runner.setProperty(FetchFTP.COMPLETION_STRATEGY, FetchFTP.COMPLETION_MOVE);
        runner.setProperty(FetchFTP.MOVE_DESTINATION_DIR, "data");
        runner.setProperty(FTPTransfer.UTF8_ENCODING, "true");
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(FetchFTP.REL_SUCCESS, 1);
        MockFlowFile retrievedFile = (MockFlowFile)runner.getFlowFilesForRelationship(FetchFTP.REL_SUCCESS).get(0);
        retrievedFile.assertContentEquals("Just some random test test test chocolate");
    }

    @Test
    public void testListFtp() throws InterruptedException {
        FileSystem results = this.fakeFtpServer.getFileSystem();
        FileEntry sampleFile = new FileEntry("c:\\data\\randombytes-2");
        sampleFile.setContents("Just some random test test test chocolate");
        results.add((FileSystemEntry)sampleFile);
        Assertions.assertTrue((boolean)results.exists("c:\\data\\randombytes-2"));
        TestRunner runner = TestRunners.newTestRunner(ListFTP.class);
        runner.setProperty(ListFTP.HOSTNAME, LOCALHOST_ADDRESS);
        runner.setProperty(ListFTP.USERNAME, "nifi-ftp-user");
        runner.setProperty(FTPTransfer.PASSWORD, "Test test test chocolate");
        runner.setProperty(FTPTransfer.PORT, Integer.toString(this.ftpPort));
        runner.setProperty(ListFTP.REMOTE_PATH, "/");
        runner.setProperty(ListFile.TARGET_SYSTEM_TIMESTAMP_PRECISION, ListFile.PRECISION_MILLIS);
        runner.assertValid();
        Thread.sleep((Long)AbstractListProcessor.LISTING_LAG_MILLIS.get((Object)TimeUnit.MILLISECONDS) * 2L);
        runner.run();
        runner.assertTransferCount(FetchFTP.REL_SUCCESS, 1);
        MockFlowFile retrievedFile = (MockFlowFile)runner.getFlowFilesForRelationship(FetchFTP.REL_SUCCESS).get(0);
        runner.assertAllFlowFilesContainAttribute("ftp.remote.host");
        runner.assertAllFlowFilesContainAttribute("ftp.remote.port");
        runner.assertAllFlowFilesContainAttribute("ftp.listing.user");
        runner.assertAllFlowFilesContainAttribute("file.owner");
        runner.assertAllFlowFilesContainAttribute("file.group");
        runner.assertAllFlowFilesContainAttribute("file.permissions");
        runner.assertAllFlowFilesContainAttribute("file.size");
        runner.assertAllFlowFilesContainAttribute("file.lastModifiedTime");
        retrievedFile.assertAttributeEquals("ftp.listing.user", "nifi-ftp-user");
        retrievedFile.assertAttributeEquals("filename", "randombytes-2");
    }
}

