/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ControlRate;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestControlRate {
    private static final String ONE_SECOND_TIME_PERIOD = "1 s";
    private static final long CURRENT_TIME_INCREMENT = 1100L;
    private ConfigurableControlRate controlRate;
    private TestRunner runner;

    @BeforeEach
    public void setRunner() {
        this.controlRate = new ConfigurableControlRate();
        this.runner = TestRunners.newTestRunner((Processor)this.controlRate);
    }

    @Test
    public void testLimitExceededThenOtherLimitNotExceeded() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "flowfile count");
        this.runner.setProperty(ControlRate.MAX_RATE, "3");
        this.runner.setProperty(ControlRate.TIME_PERIOD, "1 min");
        this.runner.setProperty(ControlRate.GROUPING_ATTRIBUTE_NAME, "group");
        Map<String, String> group1 = Collections.singletonMap("group", "1");
        Map<String, String> group2 = Collections.singletonMap("group", "2");
        for (int i = 0; i < 5; ++i) {
            this.runner.enqueue("test data", group1);
        }
        this.runner.enqueue("test data", group2);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 4);
        List output = this.runner.getFlowFilesForRelationship(ControlRate.REL_SUCCESS);
        Assertions.assertEquals((long)3L, (long)output.stream().filter(ff -> ff.getAttribute("group").equals("1")).count());
        Assertions.assertEquals((long)1L, (long)output.stream().filter(ff -> ff.getAttribute("group").equals("2")).count());
    }

    @Test
    public void testFileCountRate() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "flowfile count");
        this.runner.setProperty(ControlRate.MAX_RATE, "3");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.runner.enqueue("test data 1");
        this.runner.enqueue("test data 2");
        this.runner.enqueue("test data 3");
        this.runner.enqueue("test data 4");
        this.runner.run(4, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 3);
        this.runner.clearTransferState();
        this.runner.run(50, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 0);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.incrementCurrentTime();
        this.runner.run(5);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 1);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testFileCountWithGrouping() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "flowfile count");
        this.runner.setProperty(ControlRate.MAX_RATE, "2");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.runner.setProperty(ControlRate.GROUPING_ATTRIBUTE_NAME, "group");
        this.createFlowFileWithGroup(this.runner, "one");
        this.createFlowFileWithGroup(this.runner, "two");
        this.createFlowFileWithGroup(this.runner, "one");
        this.createFlowFileWithGroup(this.runner, "two");
        this.createFlowFileWithGroup(this.runner, "one");
        this.createFlowFileWithGroup(this.runner, "two");
        this.runner.run(6, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 4);
        this.runner.clearTransferState();
        this.runner.run(50, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 0);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.incrementCurrentTime();
        this.runner.run(2);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 2);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testDataSizeRate() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "data rate");
        this.runner.setProperty(ControlRate.MAX_RATE, "20 b");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.runner.enqueue("testdata 1");
        this.runner.enqueue("testdata 2");
        this.runner.enqueue("testdata 3");
        this.runner.enqueue("testdata 4");
        this.runner.run(4, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 2);
        this.runner.clearTransferState();
        this.runner.run(50, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 0);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.incrementCurrentTime();
        this.runner.run(2, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 2);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testViaAttribute() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "attribute value");
        this.runner.setProperty(ControlRate.RATE_CONTROL_ATTRIBUTE_NAME, "count");
        this.runner.setProperty(ControlRate.MAX_RATE, "20000");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.createFlowFile(this.runner, 1000);
        this.createFlowFile(this.runner, 3000);
        this.createFlowFile(this.runner, 5000);
        this.createFlowFile(this.runner, 20000);
        this.createFlowFile(this.runner, 1000);
        this.runner.run(5, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 4);
        this.runner.clearTransferState();
        this.runner.run(50, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 0);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.incrementCurrentTime(1450L);
        this.runner.run(50, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 0);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.incrementCurrentTime(600L);
        this.runner.run();
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 1);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testAttributeDoesNotExist() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "attribute value");
        this.runner.setProperty(ControlRate.RATE_CONTROL_ATTRIBUTE_NAME, "no.such.attribute");
        this.runner.setProperty(ControlRate.MAX_RATE, "20000");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.createFlowFile(this.runner, 1000);
        this.createFlowFile(this.runner, 3000);
        this.createFlowFile(this.runner, 5000);
        this.createFlowFile(this.runner, 20000);
        this.createFlowFile(this.runner, 1000);
        this.runner.run(5, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_FAILURE, 5);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 0);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testBadAttributeRate() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "attribute value");
        this.runner.setProperty(ControlRate.RATE_CONTROL_ATTRIBUTE_NAME, "count");
        this.runner.setProperty(ControlRate.MAX_RATE, "20000");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("count", "bad string");
        this.runner.enqueue(new byte[0], attributeMap);
        this.runner.run();
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 0);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 1);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testBatchLimit() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "flowfile count");
        this.runner.setProperty(ControlRate.MAX_RATE, "5555");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        int TEST_FILE_COUNT = 1500;
        for (int i = 0; i < 1500; ++i) {
            this.runner.enqueue("test data " + i);
        }
        this.runner.run(1, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 1000);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        Assertions.assertEquals((int)500, (int)this.runner.getQueueSize().getObjectCount());
        this.runner.run(1, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 1500);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testNonExistingGroupAttribute() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "flowfile count");
        this.runner.setProperty(ControlRate.MAX_RATE, "2");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.runner.setProperty(ControlRate.GROUPING_ATTRIBUTE_NAME, "group");
        this.createFlowFileWithGroup(this.runner, "one");
        this.createFlowFile(this.runner, 1);
        this.createFlowFileWithGroup(this.runner, "one");
        this.createFlowFile(this.runner, 2);
        this.runner.run(4, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 4);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testIncreaseDataRate() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "data rate");
        this.runner.setProperty(ControlRate.MAX_RATE, "11 B");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.runner.enqueue("test data 1");
        this.runner.enqueue("test data 2");
        this.runner.enqueue("test data 3");
        this.runner.enqueue("test data 4");
        this.runner.enqueue("test data 5");
        this.runner.enqueue("test data 6");
        this.runner.run(7, true);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 1);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.runner.setProperty(ControlRate.MAX_RATE, "33 B");
        this.runner.run(7, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 3);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.incrementCurrentTime();
        this.runner.run(7, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 6);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testIncreaseFlowFileRate() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "flowfile count");
        this.runner.setProperty(ControlRate.MAX_RATE, "1");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.runner.enqueue("test data 1");
        this.runner.enqueue("test data 2");
        this.runner.enqueue("test data 3");
        this.runner.enqueue("test data 4");
        this.runner.enqueue("test data 5");
        this.runner.enqueue("test data 6");
        this.runner.run(7, true);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 1);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.runner.setProperty(ControlRate.MAX_RATE, "3");
        this.runner.run(7, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 3);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.incrementCurrentTime();
        this.runner.run(7, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 6);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testDataOrFlowFileCountLimitedByBytes() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "data rate or flowfile count");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.runner.setProperty(ControlRate.MAX_DATA_RATE, "22 B");
        this.runner.setProperty(ControlRate.MAX_COUNT_RATE, "3");
        this.runner.enqueue("test data 1");
        this.runner.enqueue("test data 2");
        this.runner.enqueue("test data 3");
        this.runner.run(4, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 2);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.runner.clearTransferState();
        this.runner.run(4, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 0);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.incrementCurrentTime(1500L);
        this.runner.run(4, false);
        this.runner.assertAllFlowFilesTransferred(ControlRate.REL_SUCCESS, 1);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testDataOrFlowFileCountLimitedByCount() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "data rate or flowfile count");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.runner.setProperty(ControlRate.MAX_DATA_RATE, "44 B");
        this.runner.setProperty(ControlRate.MAX_COUNT_RATE, "1");
        this.runner.enqueue("test data 1");
        this.runner.enqueue("test data 2");
        this.runner.enqueue("test data 3");
        this.runner.run(1, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 1);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.incrementCurrentTime(2000L);
        this.runner.run(1, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 3);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testDataOrFlowFileCountLimitedByBytesThenCount() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "data rate or flowfile count");
        this.runner.setProperty(ControlRate.TIME_PERIOD, ONE_SECOND_TIME_PERIOD);
        this.runner.setProperty(ControlRate.MAX_DATA_RATE, "22 B");
        this.runner.setProperty(ControlRate.MAX_COUNT_RATE, "5");
        this.runner.enqueue("test data 1");
        this.runner.enqueue("test data 2");
        this.runner.enqueue("test data 3");
        this.runner.enqueue("4");
        this.runner.enqueue("5");
        this.runner.enqueue("6");
        this.runner.enqueue("7");
        this.runner.enqueue("8");
        this.runner.run(10, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 2);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        this.incrementCurrentTime(1500L);
        this.runner.run(1, false);
        this.runner.assertTransferCount(ControlRate.REL_SUCCESS, 8);
        this.runner.assertTransferCount(ControlRate.REL_FAILURE, 0);
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testValidate() {
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "data rate");
        this.runner.assertNotValid();
        this.runner.setProperty(ControlRate.MAX_RATE, "1");
        this.runner.assertNotValid();
        this.runner.setProperty(ControlRate.MAX_RATE, "1 MB");
        this.runner.assertValid();
        this.runner.setProperty(ControlRate.MAX_DATA_RATE, "1 MB");
        this.runner.assertValid();
        this.runner.removeProperty(ControlRate.MAX_RATE);
        this.runner.assertNotValid();
        this.runner.clearProperties();
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "flowfile count");
        this.runner.assertNotValid();
        this.runner.setProperty(ControlRate.MAX_RATE, "1 MB");
        this.runner.assertNotValid();
        this.runner.setProperty(ControlRate.MAX_RATE, "1");
        this.runner.assertValid();
        this.runner.setProperty(ControlRate.MAX_COUNT_RATE, "1");
        this.runner.assertValid();
        this.runner.removeProperty(ControlRate.MAX_RATE);
        this.runner.assertNotValid();
        this.runner.clearProperties();
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "attribute value");
        this.runner.setProperty(ControlRate.RATE_CONTROL_ATTRIBUTE_NAME, "count");
        this.runner.assertNotValid();
        this.runner.setProperty(ControlRate.MAX_RATE, "1 MB");
        this.runner.assertNotValid();
        this.runner.setProperty(ControlRate.MAX_RATE, "1");
        this.runner.assertValid();
        this.runner.setProperty(ControlRate.MAX_COUNT_RATE, "1");
        this.runner.assertValid();
        this.runner.removeProperty(ControlRate.MAX_RATE);
        this.runner.assertNotValid();
        this.runner.setProperty(ControlRate.MAX_RATE, "1");
        this.runner.removeProperty(ControlRate.RATE_CONTROL_ATTRIBUTE_NAME);
        this.runner.assertNotValid();
        this.runner.clearProperties();
        this.runner.setProperty(ControlRate.RATE_CONTROL_CRITERIA, "data rate or flowfile count");
        this.runner.setProperty(ControlRate.MAX_DATA_RATE, "1 MB");
        this.runner.setProperty(ControlRate.MAX_COUNT_RATE, "1");
        this.runner.setProperty(ControlRate.MAX_COUNT_RATE, "2");
        this.runner.assertValid();
        this.runner.removeProperty(ControlRate.MAX_COUNT_RATE);
        this.runner.assertNotValid();
        this.runner.setProperty(ControlRate.MAX_COUNT_RATE, "1");
        this.runner.removeProperty(ControlRate.MAX_DATA_RATE);
        this.runner.assertNotValid();
        this.runner.setProperty(ControlRate.MAX_DATA_RATE, "1 MB");
        this.runner.setProperty(ControlRate.MAX_RATE, "1 MB");
        this.runner.assertValid();
    }

    private void createFlowFile(TestRunner runner, int value) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("count", String.valueOf(value));
        byte[] data = "0123456789".getBytes();
        runner.enqueue(data, attributeMap);
    }

    private void createFlowFileWithGroup(TestRunner runner, String group) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("group", group);
        runner.enqueue(new byte[0], attributeMap);
    }

    private void incrementCurrentTime() {
        this.controlRate.currentTimeMillis += 1100L;
    }

    private void incrementCurrentTime(long milliseconds) {
        this.controlRate.currentTimeMillis += milliseconds;
    }

    private static class ConfigurableControlRate
    extends ControlRate {
        private long currentTimeMillis = System.currentTimeMillis();

        private ConfigurableControlRate() {
        }

        protected long getCurrentTimeMillis() {
            return this.currentTimeMillis;
        }
    }
}

