/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.solr;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.solr.SolrUtils;
import org.apache.nifi.security.krb.KerberosAction;
import org.apache.nifi.security.krb.KerberosKeytabUser;
import org.apache.nifi.security.krb.KerberosLoginException;
import org.apache.nifi.security.krb.KerberosPasswordUser;
import org.apache.nifi.security.krb.KerberosUser;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.solr.client.solrj.SolrClient;

public abstract class SolrProcessor
extends AbstractProcessor {
    private volatile SolrClient solrClient;
    private volatile String solrLocation;
    private volatile String basicUsername;
    private volatile String basicPassword;
    private volatile boolean basicAuthEnabled = false;
    private volatile KerberosUser kerberosUser;

    @OnScheduled
    public final void onScheduled(ProcessContext context) throws IOException {
        this.solrLocation = context.getProperty(SolrUtils.SOLR_LOCATION).evaluateAttributeExpressions().getValue();
        this.basicUsername = context.getProperty(SolrUtils.BASIC_USERNAME).evaluateAttributeExpressions().getValue();
        this.basicPassword = context.getProperty(SolrUtils.BASIC_PASSWORD).evaluateAttributeExpressions().getValue();
        if (!StringUtils.isBlank((CharSequence)this.basicUsername) && !StringUtils.isBlank((CharSequence)this.basicPassword)) {
            this.basicAuthEnabled = true;
        }
        this.solrClient = this.createSolrClient(context, this.solrLocation);
        String kerberosPrincipal = context.getProperty(SolrUtils.KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String kerberosPassword = context.getProperty(SolrUtils.KERBEROS_PASSWORD).getValue();
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(SolrUtils.KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
        if (kerberosUserService != null) {
            this.kerberosUser = kerberosUserService.createKerberosUser();
        } else {
            KerberosCredentialsService kerberosCredentialsService = (KerberosCredentialsService)context.getProperty(SolrUtils.KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
            if (kerberosCredentialsService != null) {
                this.kerberosUser = this.createKerberosKeytabUser(kerberosCredentialsService);
            } else if (!StringUtils.isBlank((CharSequence)kerberosPrincipal) && !StringUtils.isBlank((CharSequence)kerberosPassword)) {
                this.kerberosUser = this.createKerberosPasswordUser(kerberosPrincipal, kerberosPassword);
            }
        }
    }

    protected KerberosUser createKerberosKeytabUser(KerberosCredentialsService kerberosCredentialsService) {
        return new KerberosKeytabUser(kerberosCredentialsService.getPrincipal(), kerberosCredentialsService.getKeytab());
    }

    protected KerberosUser createKerberosPasswordUser(String principal, String password) {
        return new KerberosPasswordUser(principal, password);
    }

    @OnStopped
    public final void closeClient() {
        if (this.solrClient != null) {
            try {
                this.solrClient.close();
            }
            catch (IOException e) {
                this.getLogger().debug("Error closing SolrClient", (Throwable)e);
            }
        }
        if (this.kerberosUser != null) {
            try {
                this.kerberosUser.logout();
                this.kerberosUser = null;
            }
            catch (KerberosLoginException e) {
                this.getLogger().debug("Error logging out keytab user", (Throwable)e);
            }
        }
    }

    public final void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        KerberosUser kerberosUser = this.getKerberosUser();
        if (kerberosUser == null) {
            this.doOnTrigger(context, session);
        } else {
            PrivilegedExceptionAction<Void> action = () -> {
                this.doOnTrigger(context, session);
                return null;
            };
            KerberosAction kerberosAction = new KerberosAction(kerberosUser, action, this.getLogger());
            try {
                kerberosAction.execute();
            }
            catch (ProcessException e) {
                context.yield();
                throw e;
            }
        }
    }

    protected abstract void doOnTrigger(ProcessContext var1, ProcessSession var2) throws ProcessException;

    protected SolrClient createSolrClient(ProcessContext context, String solrLocation) {
        return SolrUtils.createSolrClient((PropertyContext)context, solrLocation);
    }

    protected final SolrClient getSolrClient() {
        return this.solrClient;
    }

    protected final String getSolrLocation() {
        return this.solrLocation;
    }

    protected final String getUsername() {
        return this.basicUsername;
    }

    protected final String getPassword() {
        return this.basicPassword;
    }

    protected final boolean isBasicAuthEnabled() {
        return this.basicAuthEnabled;
    }

    protected final KerberosUser getKerberosUser() {
        return this.kerberosUser;
    }

    protected final Collection<ValidationResult> customValidate(ValidationContext context) {
        Collection<ValidationResult> otherProblems;
        boolean kerberosPasswordProvided;
        boolean basicPasswordProvided;
        String solrLocation;
        String collection;
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        if (SolrUtils.SOLR_TYPE_CLOUD.equals((Object)context.getProperty(SolrUtils.SOLR_TYPE).getValue()) && ((collection = context.getProperty(SolrUtils.COLLECTION).getValue()) == null || collection.trim().isEmpty())) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.COLLECTION.getName()).input(collection).valid(false).explanation("A collection must specified for Solr Type of Cloud").build());
        }
        if (SolrUtils.SOLR_TYPE_STANDARD.equals((Object)context.getProperty(SolrUtils.SOLR_TYPE).getValue()) && (solrLocation = context.getProperty(SolrUtils.SOLR_LOCATION).evaluateAttributeExpressions().getValue()) != null) {
            SSLContextService sslContextService = (SSLContextService)context.getProperty(SolrUtils.SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
            if (solrLocation.startsWith("https:") && sslContextService == null) {
                problems.add(new ValidationResult.Builder().subject(SolrUtils.SSL_CONTEXT_SERVICE.getDisplayName()).valid(false).explanation("an SSLContextService must be provided when using https").build());
            } else if (solrLocation.startsWith("http:") && sslContextService != null) {
                problems.add(new ValidationResult.Builder().subject(SolrUtils.SSL_CONTEXT_SERVICE.getDisplayName()).valid(false).explanation("an SSLContextService can not be provided when using http").build());
            }
        }
        String username = context.getProperty(SolrUtils.BASIC_USERNAME).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(SolrUtils.BASIC_PASSWORD).evaluateAttributeExpressions().getValue();
        boolean basicUsernameProvided = !StringUtils.isBlank((CharSequence)username);
        boolean bl = basicPasswordProvided = !StringUtils.isBlank((CharSequence)password);
        if (basicUsernameProvided && !basicPasswordProvided) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.BASIC_PASSWORD.getDisplayName()).valid(false).explanation("a password must be provided for the given username").build());
        }
        if (basicPasswordProvided && !basicUsernameProvided) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.BASIC_USERNAME.getDisplayName()).valid(false).explanation("a username must be provided for the given password").build());
        }
        String kerberosPrincipal = context.getProperty(SolrUtils.KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String kerberosPassword = context.getProperty(SolrUtils.KERBEROS_PASSWORD).evaluateAttributeExpressions().getValue();
        boolean kerberosPrincipalProvided = !StringUtils.isBlank((CharSequence)kerberosPrincipal);
        boolean bl2 = kerberosPasswordProvided = !StringUtils.isBlank((CharSequence)kerberosPassword);
        if (kerberosPrincipalProvided && !kerberosPasswordProvided) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.KERBEROS_PASSWORD.getDisplayName()).valid(false).explanation("a password must be provided for the given principal").build());
        }
        if (kerberosPasswordProvided && !kerberosPrincipalProvided) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.KERBEROS_PRINCIPAL.getDisplayName()).valid(false).explanation("a principal must be provided for the given password").build());
        }
        KerberosCredentialsService kerberosCredentialsService = (KerberosCredentialsService)context.getProperty(SolrUtils.KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(SolrUtils.KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
        if (kerberosCredentialsService != null && basicUsernameProvided && basicPasswordProvided) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.KERBEROS_CREDENTIALS_SERVICE.getDisplayName()).valid(false).explanation("basic auth and kerberos credential service cannot be configured at the same time").build());
        }
        if (kerberosCredentialsService != null && (kerberosPrincipalProvided || kerberosPasswordProvided)) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.KERBEROS_CREDENTIALS_SERVICE.getDisplayName()).valid(false).explanation("kerberos principal/password and kerberos credential service cannot be configured at the same time").build());
        }
        if (kerberosPrincipalProvided && kerberosPasswordProvided && basicUsernameProvided && basicPasswordProvided) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.KERBEROS_PRINCIPAL.getDisplayName()).valid(false).explanation("basic auth and kerberos principal/password cannot be configured at the same time").build());
        }
        if (kerberosUserService != null && basicUsernameProvided && basicPasswordProvided) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.KERBEROS_USER_SERVICE.getDisplayName()).valid(false).explanation("basic auth and kerberos user service cannot be configured at the same time").build());
        }
        if (kerberosUserService != null && (kerberosPrincipalProvided || kerberosPasswordProvided)) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.KERBEROS_USER_SERVICE.getDisplayName()).valid(false).explanation("kerberos principal/password and kerberos user service cannot be configured at the same time").build());
        }
        if (kerberosUserService != null && kerberosCredentialsService != null) {
            problems.add(new ValidationResult.Builder().subject(SolrUtils.KERBEROS_USER_SERVICE.getDisplayName()).valid(false).explanation("kerberos user service and kerberos credential service cannot be configured at the same time").build());
        }
        if ((otherProblems = this.additionalCustomValidation(context)) != null) {
            problems.addAll(otherProblems);
        }
        return problems;
    }

    protected Collection<ValidationResult> additionalCustomValidation(ValidationContext context) {
        return new ArrayList<ValidationResult>();
    }
}

