/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.nifi.io.nio.BufferPool;
import org.apache.nifi.io.nio.consumer.StreamConsumer;
import org.apache.nifi.io.nio.consumer.StreamConsumerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelReader
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractChannelReader.class);
    private final String uniqueId;
    private final SelectionKey key;
    private final BufferPool bufferPool;
    private final StreamConsumer consumer;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicReference<ScheduledFuture<?>> future = new AtomicReference<Object>(null);

    public AbstractChannelReader(String id, SelectionKey key, BufferPool empties, StreamConsumerFactory consumerFactory) {
        this.uniqueId = id;
        this.key = key;
        this.bufferPool = empties;
        this.consumer = consumerFactory.newInstance(id);
        this.consumer.setReturnBufferQueue(this.bufferPool);
    }

    protected void setScheduledFuture(ScheduledFuture<?> future) {
        this.future.set(future);
    }

    protected ScheduledFuture<?> getScheduledFuture() {
        return this.future.get();
    }

    protected SelectionKey getSelectionKey() {
        return this.key;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    private void closeStream() {
        if (this.isClosed.get()) {
            return;
        }
        try {
            this.isClosed.set(true);
            this.future.get().cancel(false);
            this.key.cancel();
            this.key.channel().close();
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to cleanly close stream due to " + ioe);
        }
        finally {
            this.consumer.signalEndOfStream();
        }
    }

    protected abstract int fillBuffer(SelectionKey var1, ByteBuffer var2) throws IOException;

    @Override
    public final void run() {
        if (!this.key.isValid() || this.consumer.isConsumerFinished()) {
            this.closeStream();
            return;
        }
        if (!this.key.isReadable()) {
            return;
        }
        ByteBuffer buffer = null;
        try {
            buffer = this.bufferPool.poll();
            if (buffer == null) {
                return;
            }
            int bytesRead = this.fillBuffer(this.key, buffer);
            buffer.flip();
            if (buffer.remaining() > 0) {
                this.consumer.addFilledBuffer(buffer);
                buffer = null;
            } else {
                buffer.clear();
                this.bufferPool.returnBuffer(buffer, 0);
                buffer = null;
            }
            if (bytesRead < 0) {
                this.closeStream();
            }
        }
        catch (Exception ioe) {
            this.closeStream();
            LOGGER.error("Closed channel reader " + this + " due to " + ioe);
        }
        finally {
            if (buffer != null) {
                buffer.clear();
                this.bufferPool.returnBuffer(buffer, 0);
            }
        }
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractChannelReader rhs = (AbstractChannelReader)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.uniqueId, (Object)rhs.uniqueId).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.uniqueId).toHashCode();
    }

    public final String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_FIELD_NAMES_STYLE).append((Object)this.uniqueId).toString();
    }
}

