/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.nio;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.io.nio.BufferPool;
import org.apache.nifi.io.nio.DatagramChannelReader;
import org.apache.nifi.io.nio.SocketChannelReader;
import org.apache.nifi.io.nio.consumer.StreamConsumerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelDispatcher
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelDispatcher.class);
    private final Selector serverSocketSelector;
    private final Selector socketChannelSelector;
    private final ScheduledExecutorService executor;
    private final BufferPool emptyBuffers;
    private final StreamConsumerFactory factory;
    private final AtomicLong channelReaderFrequencyMilliseconds = new AtomicLong(100L);
    private final long timeout;
    private final boolean readSingleDatagram;
    private volatile boolean stop = false;
    public static final long DEFAULT_CHANNEL_READER_PERIOD_MILLISECONDS = 100L;

    public ChannelDispatcher(Selector serverSocketSelector, Selector socketChannelSelector, ScheduledExecutorService service, StreamConsumerFactory factory, BufferPool buffers, long timeout, TimeUnit unit, boolean readSingleDatagram) {
        this.serverSocketSelector = serverSocketSelector;
        this.socketChannelSelector = socketChannelSelector;
        this.executor = service;
        this.factory = factory;
        this.emptyBuffers = buffers;
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        this.readSingleDatagram = readSingleDatagram;
    }

    public void setChannelReaderFrequency(long period, TimeUnit timeUnit) {
        this.channelReaderFrequencyMilliseconds.set(TimeUnit.MILLISECONDS.convert(period, timeUnit));
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                this.selectServerSocketKeys();
                this.selectSocketChannelKeys();
            }
            catch (Exception ex) {
                LOGGER.warn("Key selection failed: {} Normal during shutdown.", new Object[]{ex});
            }
        }
    }

    private void selectServerSocketKeys() throws IOException {
        int numSelected = this.serverSocketSelector.select(this.timeout);
        if (numSelected == 0) {
            return;
        }
        Iterator<SelectionKey> itr = this.serverSocketSelector.selectedKeys().iterator();
        while (itr.hasNext()) {
            ServerSocketChannel ssChannel;
            SocketChannel sChannel;
            SelectionKey serverSocketkey = itr.next();
            SelectableChannel channel = serverSocketkey.channel();
            SocketChannelReader reader = null;
            if (serverSocketkey.isValid() && serverSocketkey.isAcceptable() && (sChannel = (ssChannel = (ServerSocketChannel)serverSocketkey.channel()).accept()) != null) {
                sChannel.configureBlocking(false);
                SelectionKey socketChannelKey = sChannel.register(this.socketChannelSelector, 1);
                String readerId = sChannel.socket().toString();
                reader = new SocketChannelReader(readerId, socketChannelKey, this.emptyBuffers, this.factory);
                ScheduledFuture<?> readerFuture = this.executor.scheduleWithFixedDelay(reader, 10L, this.channelReaderFrequencyMilliseconds.get(), TimeUnit.MILLISECONDS);
                reader.setScheduledFuture(readerFuture);
                socketChannelKey.attach(reader);
            }
            itr.remove();
            if (reader == null || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(this + " New Connection established.  Server channel: " + channel + " Reader: " + reader);
        }
    }

    private void selectSocketChannelKeys() throws IOException {
        int numSelected = this.socketChannelSelector.select(this.timeout);
        if (numSelected == 0) {
            return;
        }
        for (SelectionKey socketChannelKey : this.socketChannelSelector.selectedKeys()) {
            SelectableChannel channel = socketChannelKey.channel();
            DatagramChannelReader reader = null;
            if (channel instanceof DatagramChannel && socketChannelKey.attachment() == null) {
                reader = new DatagramChannelReader(UUID.randomUUID().toString(), socketChannelKey, this.emptyBuffers, this.factory, this.readSingleDatagram);
                socketChannelKey.attach(reader);
                ScheduledFuture<?> readerFuture = this.executor.scheduleWithFixedDelay(reader, 10L, this.channelReaderFrequencyMilliseconds.get(), TimeUnit.MILLISECONDS);
                reader.setScheduledFuture(readerFuture);
            }
            if (reader == null || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(this + " New Connection established.  Server channel: " + channel + " Reader: " + reader);
        }
    }

    public void stop() {
        this.stop = true;
    }
}

