/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.validators;

import java.util.regex.Pattern;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class OIDValidator
implements Validator {
    public static final Pattern OID_PATTERN = Pattern.compile("[0-9+.]*");

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        ValidationResult.Builder builder = new ValidationResult.Builder();
        builder.subject(subject).input(input);
        if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
            return builder.valid(true).explanation("Contains Expression Language").build();
        }
        try {
            if (OID_PATTERN.matcher(input).matches()) {
                builder.valid(true);
            } else {
                builder.valid(false).explanation(input + " is not a valid OID");
            }
        }
        catch (IllegalArgumentException e) {
            builder.valid(false).explanation(e.getMessage());
        }
        return builder.build();
    }
}

