/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.util.Optional;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.apache.nifi.snmp.dto.ErrorStatus;
import org.apache.nifi.snmp.dto.SNMPResponseStatus;
import org.apache.nifi.snmp.dto.SNMPSingleResponse;
import org.apache.nifi.snmp.dto.SNMPValue;
import org.apache.nifi.snmp.factory.core.SNMPFactoryProvider;
import org.apache.nifi.snmp.logging.SLF4JLogFactory;
import org.apache.nifi.snmp.operations.SNMPResourceHandler;
import org.apache.nifi.snmp.processors.properties.BasicProperties;
import org.apache.nifi.snmp.processors.properties.V3SecurityProperties;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.log.LogFactory;

@RequiresInstanceClassLoading
abstract class AbstractSNMPProcessor
extends AbstractProcessor {
    private static final String NO_SUCH_OBJECT = "noSuchObject";
    public static final PropertyDescriptor AGENT_HOST;
    public static final PropertyDescriptor AGENT_PORT;
    protected volatile SNMPResourceHandler snmpResourceHandler;

    AbstractSNMPProcessor() {
    }

    @OnScheduled
    public void initSnmpManager(ProcessContext context) {
        int version = SNMPUtils.getVersion(context.getProperty(BasicProperties.SNMP_VERSION).getValue());
        String targetHost = this.getTargetHost(context);
        String targetPort = this.getTargetPort(context);
        SNMPConfiguration configuration = SNMPConfiguration.builder().setTargetHost(targetHost).setTargetPort(targetPort).setRetries(context.getProperty(BasicProperties.SNMP_RETRIES).asInteger()).setTimeoutInMs(context.getProperty(BasicProperties.SNMP_TIMEOUT).asInteger().intValue()).setVersion(version).setAuthProtocol(context.getProperty(V3SecurityProperties.SNMP_AUTH_PROTOCOL).getValue()).setAuthPassphrase(context.getProperty(V3SecurityProperties.SNMP_AUTH_PASSWORD).getValue()).setPrivacyProtocol(context.getProperty(V3SecurityProperties.SNMP_PRIVACY_PROTOCOL).getValue()).setPrivacyPassphrase(context.getProperty(V3SecurityProperties.SNMP_PRIVACY_PASSWORD).getValue()).setSecurityName(context.getProperty(V3SecurityProperties.SNMP_SECURITY_NAME).getValue()).setSecurityLevel(context.getProperty(V3SecurityProperties.SNMP_SECURITY_LEVEL).getValue()).setCommunityString(context.getProperty(BasicProperties.SNMP_COMMUNITY).getValue()).build();
        this.snmpResourceHandler = SNMPFactoryProvider.getFactory(version).createSNMPResourceHandler(configuration);
    }

    @OnStopped
    public void close() {
        if (this.snmpResourceHandler != null) {
            this.snmpResourceHandler.close();
            this.snmpResourceHandler = null;
        }
    }

    protected void handleResponse(ProcessContext context, ProcessSession processSession, FlowFile flowFile, SNMPSingleResponse response, Relationship success, Relationship failure, String provenanceAddress) {
        SNMPResponseStatus snmpResponseStatus = this.processResponse(response);
        processSession.putAllAttributes(flowFile, response.getAttributes());
        if (snmpResponseStatus.getErrorStatus() == ErrorStatus.FAILURE) {
            this.getLogger().error("SNMP request failed, response error: " + snmpResponseStatus.getErrorMessage());
            processSession.getProvenanceReporter().modifyAttributes(flowFile, response.getTargetAddress() + provenanceAddress);
            processSession.transfer(flowFile, failure);
            context.yield();
        } else {
            processSession.getProvenanceReporter().modifyAttributes(flowFile, response.getTargetAddress() + provenanceAddress);
            processSession.transfer(flowFile, success);
        }
    }

    protected SNMPResponseStatus processResponse(SNMPSingleResponse response) {
        if (response.isValid()) {
            if (response.isReportPdu()) {
                String oid = response.getVariableBindings().get(0).getOid();
                Optional<String> reportPduErrorMessage = SNMPUtils.getErrorMessage(oid);
                if (!reportPduErrorMessage.isPresent()) {
                    return new SNMPResponseStatus(String.format("Report-PDU returned, but no error message found. Please, check the OID %s in an online OID repository.", oid), ErrorStatus.FAILURE);
                }
                return new SNMPResponseStatus("Report-PDU returned. " + reportPduErrorMessage.get(), ErrorStatus.FAILURE);
            }
            return this.checkV2cV3VariableBindings(response);
        }
        String errorMessage = response.getErrorStatusText();
        return new SNMPResponseStatus(errorMessage, ErrorStatus.FAILURE);
    }

    private SNMPResponseStatus checkV2cV3VariableBindings(SNMPSingleResponse response) {
        if (response.getVersion() == 1 || response.getVersion() == 3) {
            Optional firstVariableBinding = response.getVariableBindings().stream().findFirst();
            if (firstVariableBinding.isPresent()) {
                String value = ((SNMPValue)firstVariableBinding.get()).getVariable();
                if (NO_SUCH_OBJECT.equals(value)) {
                    return new SNMPResponseStatus("OID not found.", ErrorStatus.FAILURE);
                }
            } else {
                return new SNMPResponseStatus("Empty SNMP response: no variable binding found.", ErrorStatus.FAILURE);
            }
        }
        return new SNMPResponseStatus("Successful SNMP Response", ErrorStatus.SUCCESS);
    }

    protected abstract String getTargetHost(ProcessContext var1);

    protected abstract String getTargetPort(ProcessContext var1);

    static {
        LogFactory.setLogFactory((LogFactory)new SLF4JLogFactory());
        AGENT_HOST = new PropertyDescriptor.Builder().name("snmp-hostname").displayName("SNMP Agent Hostname").description("Hostname or network address of the SNMP Agent.").required(true).defaultValue("localhost").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        AGENT_PORT = new PropertyDescriptor.Builder().name("snmp-port").displayName("SNMP Agent Port").description("Port of the SNMP Agent.").required(true).defaultValue("161").addValidator(StandardValidators.PORT_VALIDATOR).build();
    }
}

