/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.snmp.dto.SNMPSingleResponse;
import org.apache.nifi.snmp.operations.SetSNMPHandler;
import org.apache.nifi.snmp.processors.AbstractSNMPProcessor;
import org.apache.nifi.snmp.processors.properties.BasicProperties;
import org.apache.nifi.snmp.processors.properties.V3SecurityProperties;

@Tags(value={"snmp", "set", "oid"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Based on incoming FlowFile attributes, the processor will execute SNMP Set requests. When finding attributes with the name snmp$<OID>, the processor will attempt to set the value of the attribute to the corresponding OID given in the attribute name.")
@WritesAttributes(value={@WritesAttribute(attribute="snmp$<OID>", description="Response variable binding: OID (e.g. 1.3.6.1.4.1.343) and its value."), @WritesAttribute(attribute="snmp$errorIndex", description="Denotes the variable binding in which the error occured."), @WritesAttribute(attribute="snmp$errorStatus", description="The snmp4j error status of the PDU."), @WritesAttribute(attribute="snmp$errorStatusText", description="The description of error status."), @WritesAttribute(attribute="snmp$nonRepeaters", description="The number of non repeater variable bindings in a GETBULK PDU (currently not supported)."), @WritesAttribute(attribute="snmp$requestID", description="The request ID associated with the PDU."), @WritesAttribute(attribute="snmp$type", description="The snmp4j numeric representation of the type of the PDU."), @WritesAttribute(attribute="snmp$typeString", description="The name of the PDU type.")})
public class SetSNMP
extends AbstractSNMPProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that have been successfully used to perform SNMP Set are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that failed during the SNMP Set care routed to this relationship").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(AGENT_HOST, AGENT_PORT, BasicProperties.SNMP_VERSION, BasicProperties.SNMP_COMMUNITY, V3SecurityProperties.SNMP_SECURITY_LEVEL, V3SecurityProperties.SNMP_SECURITY_NAME, V3SecurityProperties.SNMP_AUTH_PROTOCOL, V3SecurityProperties.SNMP_AUTH_PASSWORD, V3SecurityProperties.SNMP_PRIVACY_PROTOCOL, V3SecurityProperties.SNMP_PRIVACY_PASSWORD, BasicProperties.SNMP_RETRIES, BasicProperties.SNMP_TIMEOUT));
    private static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    private volatile SetSNMPHandler snmpHandler;

    @OnScheduled
    public void init(ProcessContext context) {
        this.initSnmpManager(context);
        this.snmpHandler = new SetSNMPHandler(this.snmpResourceHandler);
    }

    public void onTrigger(ProcessContext context, ProcessSession processSession) {
        FlowFile flowFile = processSession.get();
        if (flowFile != null) {
            try {
                Optional<SNMPSingleResponse> optionalResponse = this.snmpHandler.set(flowFile.getAttributes());
                if (optionalResponse.isPresent()) {
                    processSession.remove(flowFile);
                    FlowFile outgoingFlowFile = processSession.create();
                    SNMPSingleResponse response = optionalResponse.get();
                    processSession.getProvenanceReporter().receive(outgoingFlowFile, "/set");
                    this.handleResponse(context, processSession, outgoingFlowFile, response, REL_SUCCESS, REL_FAILURE, "/set");
                } else {
                    this.getLogger().warn("No SNMP specific attributes found in flowfile.");
                    processSession.transfer(flowFile, REL_FAILURE);
                }
            }
            catch (IOException e) {
                this.getLogger().error("Failed to send request to the agent. Check if the agent supports the used version.");
                processSession.transfer(processSession.penalize(flowFile), REL_FAILURE);
                context.yield();
            }
        }
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @Override
    protected String getTargetHost(ProcessContext processContext) {
        return processContext.getProperty(AGENT_HOST).getValue();
    }

    @Override
    protected String getTargetPort(ProcessContext processContext) {
        return processContext.getProperty(AGENT_PORT).getValue();
    }
}

