/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.operations;

import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.snmp.processors.ListenTrapSNMP;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;

public class SNMPTrapReceiver
implements CommandResponder {
    private final ProcessSessionFactory processSessionFactory;
    private final ComponentLog logger;

    public SNMPTrapReceiver(ProcessSessionFactory processSessionFactory, ComponentLog logger) {
        this.processSessionFactory = processSessionFactory;
        this.logger = logger;
    }

    public void processPdu(CommandResponderEvent event) {
        PDU pdu = event.getPDU();
        if (this.isValidTrapPdu(pdu)) {
            ProcessSession processSession = this.processSessionFactory.createSession();
            FlowFile flowFile = this.createFlowFile(processSession, pdu);
            processSession.getProvenanceReporter().create(flowFile, event.getPeerAddress() + "/" + pdu.getRequestID());
            if (pdu.getErrorStatus() == 0) {
                processSession.transfer(flowFile, ListenTrapSNMP.REL_SUCCESS);
            } else {
                processSession.transfer(flowFile, ListenTrapSNMP.REL_FAILURE);
            }
            processSession.commitAsync();
        } else {
            this.logger.error("Request timed out or parameters are incorrect.");
        }
    }

    private FlowFile createFlowFile(ProcessSession processSession, PDU pdu) {
        FlowFile flowFile = processSession.create();
        Map<String, String> attributes = pdu instanceof PDUv1 ? SNMPUtils.getV1TrapPduAttributeMap((PDUv1)pdu) : SNMPUtils.getPduAttributeMap(pdu);
        flowFile = processSession.putAllAttributes(flowFile, attributes);
        return flowFile;
    }

    private boolean isValidTrapPdu(PDU pdu) {
        return pdu != null && (pdu.getType() == -92 || pdu.getType() == -89);
    }
}

