/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.logging;

import java.io.Serializable;
import java.util.Iterator;
import java.util.logging.Handler;
import org.slf4j.Logger;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class SLF4JLogAdapter
implements LogAdapter {
    private final Logger logger;

    public SLF4JLogAdapter(Logger logger) {
        this.logger = logger;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void debug(Serializable message) {
        if (this.isDebugEnabled()) {
            this.logger.debug("{}", (Object)message);
        }
    }

    public void info(CharSequence message) {
        if (this.isInfoEnabled()) {
            this.logger.info("{}", (Object)message);
        }
    }

    public void warn(Serializable message) {
        if (this.isWarnEnabled()) {
            this.logger.warn("{}", (Object)message);
        }
    }

    public void error(Serializable message) {
        this.logger.error("{}", (Object)message);
    }

    public void error(CharSequence message, Throwable t) {
        this.logger.error("{}", (Object)message, (Object)t);
    }

    public void fatal(Object message) {
        this.logger.error("{}", message);
    }

    public void fatal(CharSequence message, Throwable t) {
        this.logger.error("{}", (Object)message, (Object)t);
    }

    public LogLevel getEffectiveLogLevel() {
        return LogLevel.ALL;
    }

    public Iterator<Handler> getLogHandler() {
        throw new UnsupportedOperationException("Log handlers are not supported.");
    }

    public LogLevel getLogLevel() {
        return this.getEffectiveLogLevel();
    }

    public String getName() {
        return this.logger.getName();
    }

    public void setLogLevel(LogLevel logLevel) {
    }
}

