/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.operations;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.snmp.configuration.V1TrapConfiguration;
import org.apache.nifi.snmp.configuration.V2TrapConfiguration;
import org.apache.nifi.snmp.factory.trap.V1TrapPDUFactory;
import org.apache.nifi.snmp.factory.trap.V2TrapPDUFactory;
import org.apache.nifi.snmp.operations.SNMPResourceHandler;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;

public class SendTrapSNMPHandler {
    private final SNMPResourceHandler snmpResourceHandler;
    private final ComponentLog logger;
    private final V1TrapPDUFactory v1TrapPDUFactory;
    private final V2TrapPDUFactory v2TrapPDUFactory;

    public SendTrapSNMPHandler(SNMPResourceHandler snmpResourceHandler, Instant startTime, ComponentLog logger) {
        this.snmpResourceHandler = snmpResourceHandler;
        this.logger = logger;
        this.v1TrapPDUFactory = this.createV1TrapPduFactory(startTime);
        this.v2TrapPDUFactory = this.createV2TrapPduFactory(startTime);
    }

    public void sendTrap(Map<String, String> flowFileAttributes, V1TrapConfiguration trapConfiguration) throws IOException {
        PDU pdu = this.v1TrapPDUFactory.get(trapConfiguration);
        this.sendTrap(flowFileAttributes, pdu);
    }

    public void sendTrap(Map<String, String> flowFileAttributes, V2TrapConfiguration trapConfiguration) throws IOException {
        PDU pdu = this.v2TrapPDUFactory.get(trapConfiguration);
        this.sendTrap(flowFileAttributes, pdu);
    }

    private void sendTrap(Map<String, String> flowFileAttributes, PDU pdu) throws IOException {
        Target target = this.snmpResourceHandler.getTarget();
        Snmp snmpManager = this.snmpResourceHandler.getSnmpManager();
        boolean isAnyVariableAdded = SNMPUtils.addVariables(pdu, flowFileAttributes);
        if (!isAnyVariableAdded) {
            this.logger.debug("No optional SNMP specific variables found in flowfile.");
        }
        snmpManager.send(pdu, target);
    }

    V1TrapPDUFactory createV1TrapPduFactory(Instant startTime) {
        return new V1TrapPDUFactory(this.snmpResourceHandler.getTarget(), startTime);
    }

    V2TrapPDUFactory createV2TrapPduFactory(Instant startTime) {
        return new V2TrapPDUFactory(this.snmpResourceHandler.getTarget(), startTime);
    }
}

