/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.smb.common;

import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.messages.SMB2Echo;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.event.ConnectionClosed;
import com.hierynomus.smbj.event.SMBEvent;
import com.hierynomus.smbj.event.SMBEventBus;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbClient
extends SMBClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmbClient.class);
    private SMBEventBus bus;

    private SmbClient(SmbConfig config, SMBEventBus bus) {
        super(config, bus);
    }

    static SmbClient create(SmbConfig config) {
        SMBEventBus bus = new SMBEventBus();
        SmbClient client = new SmbClient(config, bus);
        client.bus = bus;
        return client;
    }

    public Connection connect(String hostname) throws IOException {
        return this.connect(hostname, 445);
    }

    public synchronized Connection connect(String hostname, int port) throws IOException {
        Connection connection = super.connect(hostname, port);
        try {
            if (!connection.release()) {
                connection.send((SMB2Packet)new SMB2Echo(connection.getNegotiatedProtocol().getDialect())).get(10L, TimeUnit.SECONDS);
            }
            connection.lease();
            return connection;
        }
        catch (Exception e) {
            LOGGER.info("Stale connection found, unregistering it and creating a new one");
            this.bus.publish((SMBEvent)new ConnectionClosed(hostname, port));
            return super.connect(hostname, port);
        }
    }
}

