/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.smb;

import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.Share;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.services.smb.SmbClientProviderService;
import org.apache.nifi.services.smb.SmbClientService;
import org.apache.nifi.services.smb.SmbjClientService;

@Tags(value={"samba, smb, cifs, files"})
@CapabilityDescription(value="Provides access to SMB Sessions with shared authentication credentials.")
public class SmbjClientProviderService
extends AbstractControllerService
implements SmbClientProviderService {
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().displayName("Hostname").name("hostname").description("The network host of the SMB file server.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor DOMAIN = new PropertyDescriptor.Builder().displayName("Domain").name("domain").description("The domain used for authentication. Optional, in most cases username and password is sufficient.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().displayName("Username").name("username").description("The username used for authentication.").required(false).defaultValue("Guest").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().displayName("Password").name("password").description("The password used for authentication.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().displayName("Port").name("port").description("Port to use for connection.").required(true).addValidator(StandardValidators.PORT_VALIDATOR).defaultValue("445").build();
    public static final PropertyDescriptor SHARE = new PropertyDescriptor.Builder().displayName("Share").name("share").description("The network share to which files should be listed from. This is the \"first folder\"after the hostname: smb://hostname:port/[share]/dir1/dir2").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor TIMEOUT = new PropertyDescriptor.Builder().displayName("Timeout").name("timeout").description("Timeout for read and write operations.").required(true).defaultValue("5 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(HOSTNAME, PORT, SHARE, USERNAME, PASSWORD, DOMAIN, TIMEOUT));
    private SMBClient smbClient;
    private AuthenticationContext authenticationContext;
    private String hostname;
    private int port;
    private String shareName;

    public SmbClientService getClient() throws IOException {
        Connection connection = null;
        try {
            connection = this.smbClient.connect(this.hostname, this.port);
            return this.connectToShare(connection);
        }
        catch (IOException e) {
            this.getLogger().debug("Closing stale connection and trying to create a new one for share " + this.getServiceLocation());
            this.closeConnection(connection);
            this.unregisterHost();
            connection = this.smbClient.connect(this.hostname, this.port);
            return this.connectToShare(connection);
        }
    }

    private SmbjClientService connectToShare(Connection connection) throws IOException {
        Share share;
        Session session;
        try {
            session = connection.authenticate(this.authenticationContext);
        }
        catch (Exception e) {
            throw new IOException("Could not create session for share " + this.getServiceLocation(), e);
        }
        try {
            share = session.connectShare(this.shareName);
        }
        catch (Exception e) {
            this.closeSession(session);
            throw new IOException("Could not connect to share " + this.getServiceLocation(), e);
        }
        if (!(share instanceof DiskShare)) {
            this.closeSession(session);
            throw new IllegalArgumentException("DiskShare not found. Share " + share.getClass().getSimpleName() + " found on " + this.getServiceLocation());
        }
        return new SmbjClientService(session, (DiskShare)share, this.getServiceLocation());
    }

    private void unregisterHost() {
        this.smbClient.getServerList().unregister(this.hostname);
    }

    private void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close(true);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Could not close connection to {}", new Object[]{this.getServiceLocation(), e});
        }
    }

    private void closeSession(Session session) {
        try {
            if (session != null) {
                session.close();
            }
        }
        catch (Exception e) {
            this.getLogger().error("Could not close session to {}", new Object[]{this.getServiceLocation(), e});
        }
    }

    public URI getServiceLocation() {
        return URI.create(String.format("smb://%s:%d/%s", this.hostname, this.port, this.shareName));
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.hostname = context.getProperty(HOSTNAME).getValue();
        this.port = context.getProperty(PORT).asInteger();
        this.shareName = context.getProperty(SHARE).getValue();
        this.smbClient = new SMBClient(SmbConfig.builder().withTimeout(context.getProperty(TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).longValue(), TimeUnit.MILLISECONDS).build());
        this.createAuthenticationContext(context);
    }

    @OnDisabled
    public void onDisabled() {
        this.smbClient.close();
        this.smbClient = null;
        this.hostname = null;
        this.port = 0;
        this.shareName = null;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    private void createAuthenticationContext(ConfigurationContext context) {
        if (context.getProperty(USERNAME).isSet()) {
            String userName = context.getProperty(USERNAME).getValue();
            String password = context.getProperty(PASSWORD).isSet() ? context.getProperty(PASSWORD).getValue() : "";
            String domainOrNull = context.getProperty(DOMAIN).isSet() ? context.getProperty(DOMAIN).getValue() : null;
            this.authenticationContext = new AuthenticationContext(userName, password.toCharArray(), domainOrNull);
        } else {
            this.authenticationContext = AuthenticationContext.anonymous();
        }
    }
}

