/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.smb;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileBasicInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import java.io.InputStream;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.smb.FetchSmb;
import org.apache.nifi.processors.smb.ListSmb;
import org.apache.nifi.processors.smb.PutSmbFile;

@TriggerWhenEmpty
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"samba, smb, cifs, files, get"})
@CapabilityDescription(value="Reads file from a samba network location to FlowFiles. Use this processor instead of a cifs mounts if share access control is important. Configure the Hostname, Share and Directory accordingly: \\\\[Hostname]\\[Share]\\[path\\to\\Directory]")
@SeeAlso(value={PutSmbFile.class, ListSmb.class, FetchSmb.class})
@WritesAttributes(value={@WritesAttribute(attribute="filename", description="The filename is set to the name of the file on the network share"), @WritesAttribute(attribute="path", description="The path is set to the relative path of the file's network share name. For example, if the input is set to \\\\hostname\\share\\tmp, files picked up from \\tmp will have the path attribute set to tmp"), @WritesAttribute(attribute="file.creationTime", description="The date and time that the file was created. May not work on all file systems"), @WritesAttribute(attribute="file.lastModifiedTime", description="The date and time that the file was last modified. May not work on all file systems"), @WritesAttribute(attribute="file.lastAccessTime", description="The date and time that the file was last accessed. May not work on all file systems"), @WritesAttribute(attribute="absolute.path", description="The full path from where a file was picked up. This includes the hostname and the share name")})
public class GetSmbFile
extends AbstractProcessor {
    public static final String SHARE_ACCESS_NONE = "none";
    public static final String SHARE_ACCESS_READ = "read";
    public static final String SHARE_ACCESS_READDELETE = "read, delete";
    public static final String SHARE_ACCESS_READWRITEDELETE = "read, write, delete";
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Hostname").description("The network host to which files should be written.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SHARE = new PropertyDescriptor.Builder().name("Share").description("The network share to which files should be written. This is the \"first folder\"after the hostname: \\\\hostname\\[share]\\dir1\\dir2").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DIRECTORY = new PropertyDescriptor.Builder().name("Directory").description("The network folder to which files should be written. This is the remaining relative path after the share: \\\\hostname\\share\\[dir1\\dir2].").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DOMAIN = new PropertyDescriptor.Builder().name("Domain").description("The domain used for authentication. Optional, in most cases username and password is sufficient.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("The username used for authentication. If no username is set then anonymous authentication is attempted.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password used for authentication. Required if Username is set.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor SHARE_ACCESS = new PropertyDescriptor.Builder().name("Share Access Strategy").description("Indicates which shared access are granted on the file during the read. None is the most restrictive, but the safest setting to prevent corruption.").required(true).defaultValue("none").allowableValues(new String[]{"none", "read", "read, delete", "read, write, delete"}).build();
    public static final PropertyDescriptor RECURSE = new PropertyDescriptor.Builder().name("Recurse Subdirectories").description("Indicates whether or not to pull files from subdirectories").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor KEEP_SOURCE_FILE = new PropertyDescriptor.Builder().name("Keep Source File").description("If true, the file is not deleted after it has been copied to the Content Repository; this causes the file to be picked up continually and is useful for testing purposes.  If not keeping original NiFi will need write permissions on the directory it is pulling from otherwise it will ignore the file.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor FILE_FILTER = new PropertyDescriptor.Builder().name("File Filter").description("Only files whose names match the given regular expression will be picked up").required(false).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor PATH_FILTER = new PropertyDescriptor.Builder().name("Path Filter").description("When " + RECURSE.getName() + " is true, then only subdirectories whose path matches the given regular expression will be scanned").required(false).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor IGNORE_HIDDEN_FILES = new PropertyDescriptor.Builder().name("Ignore Hidden Files").description("Indicates whether or not hidden files should be ignored").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    public static final PropertyDescriptor POLLING_INTERVAL = new PropertyDescriptor.Builder().name("Polling Interval").description("Indicates how long to wait before performing a directory listing").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("The maximum number of files to pull in each iteration").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("10").build();
    public static final String FILE_CREATION_TIME_ATTRIBUTE = "file.creationTime";
    public static final String FILE_LAST_MODIFY_TIME_ATTRIBUTE = "file.lastModifiedTime";
    public static final String FILE_LAST_ACCESS_TIME_ATTRIBUTE = "file.lastAccessTime";
    public static final String FILE_SIZE_ATTRIBUTE = "file.size";
    public static final String FILE_MODIFY_DATE_ATTR_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    static final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All files are routed to success").build();
    private List<PropertyDescriptor> descriptors;
    private Set<Relationship> relationships;
    private final BlockingQueue<String> fileQueue = new LinkedBlockingQueue<String>();
    private final Set<String> inProcess = new HashSet<String>();
    private final Set<String> recentlyProcessed = new HashSet<String>();
    private final Lock queueLock = new ReentrantLock();
    private final Lock listingLock = new ReentrantLock();
    private final AtomicLong queueLastUpdated = new AtomicLong(0L);
    private SMBClient smbClient = null;
    private Pattern filePattern;
    private Pattern pathPattern;
    private boolean ignoreHidden;
    private Set<SMB2ShareAccess> sharedAccess;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(HOSTNAME);
        descriptors.add(SHARE);
        descriptors.add(DIRECTORY);
        descriptors.add(DOMAIN);
        descriptors.add(USERNAME);
        descriptors.add(PASSWORD);
        descriptors.add(SHARE_ACCESS);
        descriptors.add(FILE_FILTER);
        descriptors.add(PATH_FILTER);
        descriptors.add(BATCH_SIZE);
        descriptors.add(KEEP_SOURCE_FILE);
        descriptors.add(RECURSE);
        descriptors.add(POLLING_INTERVAL);
        descriptors.add(IGNORE_HIDDEN_FILES);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(relationships);
        if (this.smbClient == null) {
            this.initSmbClient();
        }
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.initiateFilterFile(context);
        this.fileQueue.clear();
        switch (context.getProperty(SHARE_ACCESS).getValue()) {
            case "none": {
                this.sharedAccess = Collections.emptySet();
                break;
            }
            case "read": {
                this.sharedAccess = EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ);
                break;
            }
            case "read, delete": {
                this.sharedAccess = EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ, SMB2ShareAccess.FILE_SHARE_DELETE);
                break;
            }
            case "read, write, delete": {
                this.sharedAccess = EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ, SMB2ShareAccess.FILE_SHARE_WRITE, SMB2ShareAccess.FILE_SHARE_DELETE);
            }
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> set = new ArrayList<ValidationResult>();
        if (validationContext.getProperty(USERNAME).isSet() && !validationContext.getProperty(PASSWORD).isSet()) {
            set.add(new ValidationResult.Builder().explanation("Password must be set if username is supplied.").build());
        }
        return set;
    }

    private void initSmbClient() {
        this.initSmbClient(new SMBClient());
    }

    public void initSmbClient(SMBClient smbClient) {
        this.smbClient = smbClient;
    }

    private void initiateFilterFile(ProcessContext context) {
        String filePatternStr = context.getProperty(FILE_FILTER).getValue();
        this.filePattern = filePatternStr == null ? null : Pattern.compile(filePatternStr);
        String pathPatternStr = context.getProperty(PATH_FILTER).getValue();
        this.pathPattern = pathPatternStr == null ? null : Pattern.compile(pathPatternStr);
        this.ignoreHidden = context.getProperty(IGNORE_HIDDEN_FILES).asBoolean();
    }

    private boolean filterFile(String directory, String filename, long fileAttributes) {
        if (this.pathPattern != null && !this.pathPattern.matcher(directory).matches()) {
            return false;
        }
        if (this.filePattern != null && !this.filePattern.matcher(filename).matches()) {
            return false;
        }
        return !this.ignoreHidden || (fileAttributes & FileAttributes.FILE_ATTRIBUTE_HIDDEN.getValue()) == 0L;
    }

    private Set<String> performListing(DiskShare diskShare, String directory, String filter, boolean recurseSubdirectories) {
        HashSet<String> queue = new HashSet<String>();
        if (!diskShare.folderExists(directory)) {
            return queue;
        }
        List children = diskShare.list(directory);
        if (children == null) {
            return queue;
        }
        for (FileIdBothDirectoryInformation child : children) {
            String filename = child.getFileName();
            if (filename.equals(".") || filename.equals("..")) continue;
            Object fullPath = directory.isEmpty() ? filename : directory + "\\" + filename;
            long fileAttributes = child.getFileAttributes();
            if ((fileAttributes & FileAttributes.FILE_ATTRIBUTE_DIRECTORY.getValue()) != 0L) {
                if (!recurseSubdirectories) continue;
                queue.addAll(this.performListing(diskShare, (String)fullPath, filter, true));
                continue;
            }
            if (!this.filterFile(directory, filename, fileAttributes)) continue;
            queue.add((String)fullPath);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ComponentLog logger = this.getLogger();
        String hostname = context.getProperty(HOSTNAME).getValue();
        String shareName = context.getProperty(SHARE).getValue();
        String domain = context.getProperty(DOMAIN).getValue();
        String username = context.getProperty(USERNAME).getValue();
        String password = context.getProperty(PASSWORD).getValue();
        AuthenticationContext ac = null;
        ac = username != null && password != null ? new AuthenticationContext(username, password.toCharArray(), domain) : AuthenticationContext.anonymous();
        try (Connection connection = this.smbClient.connect(hostname);
             Session smbSession = connection.authenticate(ac);
             DiskShare share = (DiskShare)smbSession.connectShare(shareName);){
            String directory = context.getProperty(DIRECTORY).evaluateAttributeExpressions().getValue();
            if (directory == null) {
                directory = "";
            }
            boolean keepingSourceFile = context.getProperty(KEEP_SOURCE_FILE).asBoolean();
            String filter = context.getProperty(FILE_FILTER).getValue();
            if (this.fileQueue.size() < 100) {
                long pollingMillis = context.getProperty(POLLING_INTERVAL).asTimePeriod(TimeUnit.MILLISECONDS);
                if (this.queueLastUpdated.get() < System.currentTimeMillis() - pollingMillis && this.listingLock.tryLock()) {
                    try {
                        Set<String> listing = this.performListing(share, directory, filter, context.getProperty(RECURSE).asBoolean());
                        this.queueLock.lock();
                        try {
                            listing.removeAll(this.inProcess);
                            if (!keepingSourceFile) {
                                listing.removeAll(this.recentlyProcessed);
                            }
                            this.fileQueue.clear();
                            this.fileQueue.addAll(listing);
                            this.queueLastUpdated.set(System.currentTimeMillis());
                            this.recentlyProcessed.clear();
                            if (listing.isEmpty()) {
                                context.yield();
                            }
                        }
                        finally {
                            this.queueLock.unlock();
                        }
                    }
                    finally {
                        this.listingLock.unlock();
                    }
                }
            }
            int batchSize = context.getProperty(BATCH_SIZE).asInteger();
            ArrayList files = new ArrayList(batchSize);
            this.queueLock.lock();
            try {
                this.fileQueue.drainTo(files, batchSize);
                if (files.isEmpty()) {
                    return;
                }
                this.inProcess.addAll(files);
            }
            finally {
                this.queueLock.unlock();
            }
            ListIterator itr = files.listIterator();
            FlowFile flowFile = null;
            try {
                while (itr.hasNext()) {
                    String file = (String)itr.next();
                    String[] fileSplits = file.split("\\\\");
                    String filename = fileSplits[fileSplits.length - 1];
                    String filePath = String.join((CharSequence)"\\", Arrays.copyOf(fileSplits, fileSplits.length - 1));
                    URI uri = new URI("smb", hostname, "/" + file.replace('\\', '/'), null);
                    flowFile = session.create();
                    long importStart = System.nanoTime();
                    try (File f = share.openFile(file, EnumSet.of(AccessMask.GENERIC_READ), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), this.sharedAccess, SMB2CreateDisposition.FILE_OPEN, EnumSet.of(SMB2CreateOptions.FILE_SEQUENTIAL_ONLY));
                         InputStream is = f.getInputStream();){
                        flowFile = session.importFrom(is, flowFile);
                        long importNanos = System.nanoTime() - importStart;
                        long importMillis = TimeUnit.MILLISECONDS.convert(importNanos, TimeUnit.NANOSECONDS);
                        FileAllInformation fileInfo = f.getFileInformation();
                        FileBasicInformation fileBasicInfo = fileInfo.getBasicInformation();
                        long fileSize = fileInfo.getStandardInformation().getEndOfFile();
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        attributes.put(CoreAttributes.FILENAME.key(), filename);
                        attributes.put(CoreAttributes.PATH.key(), filePath);
                        attributes.put(CoreAttributes.ABSOLUTE_PATH.key(), "\\\\" + hostname + "\\" + shareName + "\\" + file);
                        attributes.put(FILE_CREATION_TIME_ATTRIBUTE, dateFormatter.format(fileBasicInfo.getCreationTime().toDate()));
                        attributes.put(FILE_LAST_ACCESS_TIME_ATTRIBUTE, dateFormatter.format(fileBasicInfo.getLastAccessTime().toDate()));
                        attributes.put(FILE_LAST_MODIFY_TIME_ATTRIBUTE, dateFormatter.format(fileBasicInfo.getLastWriteTime().toDate()));
                        attributes.put(FILE_SIZE_ATTRIBUTE, String.valueOf(fileSize));
                        attributes.put(HOSTNAME.getName(), hostname);
                        attributes.put(SHARE.getName(), shareName);
                        flowFile = session.putAllAttributes(flowFile, attributes);
                        session.getProvenanceReporter().receive(flowFile, uri.toString(), importMillis);
                        session.transfer(flowFile, REL_SUCCESS);
                        logger.info("added {} to flow", new Object[]{flowFile});
                    }
                    catch (SMBApiException e) {
                        if (e.getStatus() == NtStatus.STATUS_SHARING_VIOLATION) {
                            logger.info("Could not acquire sharing access for file {}", new Object[]{file});
                            if (flowFile == null) continue;
                            session.remove(flowFile);
                            continue;
                        }
                        throw e;
                    }
                    try {
                        if (!keepingSourceFile) {
                            share.rm(file);
                        }
                    }
                    catch (SMBApiException e) {
                        logger.error("Could not remove file {}", new Object[]{file});
                    }
                    if (this.isScheduled()) continue;
                    this.queueLock.lock();
                    try {
                        while (itr.hasNext()) {
                            String nextFile = (String)itr.next();
                            this.fileQueue.add(nextFile);
                            this.inProcess.remove(nextFile);
                        }
                    }
                    finally {
                        this.queueLock.unlock();
                    }
                }
                session.commitAsync();
            }
            catch (Exception e) {
                logger.error("Failed to retrieve files due to {}", (Throwable)e);
                if (flowFile != null) {
                    session.remove(flowFile);
                }
            }
            finally {
                this.queueLock.lock();
                try {
                    this.inProcess.removeAll(files);
                    this.recentlyProcessed.addAll(files);
                }
                finally {
                    this.queueLock.unlock();
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not establish smb connection because of error {}", new Object[]{e});
            context.yield();
            this.smbClient.getServerList().unregister(hostname);
        }
    }
}

