/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.slack.util;

import java.time.Duration;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.logging.ComponentLog;

public class RateLimit {
    private final AtomicLong nextRequestTime = new AtomicLong(0L);
    private final ComponentLog logger;

    public RateLimit(ComponentLog logger) {
        this.logger = logger;
    }

    public void retryAfter(Duration duration) {
        long timeOfNextRequest = System.currentTimeMillis() + duration.toMillis();
        this.nextRequestTime.getAndUpdate(currentTime -> Math.max(currentTime, timeOfNextRequest));
    }

    public boolean isLimitReached() {
        long nextTime = this.nextRequestTime.get();
        if (nextTime > 0L && System.currentTimeMillis() < nextTime) {
            this.logger.debug("Will not interact with Slack until {} due to Slack's Rate Limit", new Object[]{new Date(nextTime)});
            return true;
        }
        if (nextTime > 0L) {
            this.nextRequestTime.compareAndSet(nextTime, 0L);
        }
        return false;
    }
}

