/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.slack;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.stream.JsonParsingException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.slack.PublishSlack;
import org.apache.nifi.ssl.SSLContextService;

@Tags(value={"put", "slack", "notify"})
@CapabilityDescription(value="Sends a message to your team on slack.com")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@DynamicProperty(name="A JSON object to add to Slack's \"attachments\" JSON payload.", value="JSON-formatted string to add to Slack's payload JSON appended to the \"attachments\" JSON array.", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Converts the contents of each value specified by the Dynamic Property's value to JSON and appends it to the payload being sent to Slack.")
@DeprecationNotice(alternatives={PublishSlack.class}, reason="This Processor makes use of a Webhook URL, rather than Slack's REST API. As a result, the Processor is more difficult to configure than necessary and requires special permissions for the Slack Application / Bot. These permissions must be granted for every channel that the application is to respond to, which makes setup and maintenance difficult. Additionally, it does not make clear the differences between PutSlack and PostSlack. Each provides slightly different capabilities. PublishSlack combines the capabilities of both Processors in a simpler configuration that makes use of Slack's standard REST API.")
public class PutSlack
extends AbstractProcessor {
    public static final PropertyDescriptor WEBHOOK_URL = new PropertyDescriptor.Builder().name("webhook-url").displayName("Webhook URL").description("The POST URL provided by Slack to send messages into a channel.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.URL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).sensitive(true).build();
    public static final PropertyDescriptor WEBHOOK_TEXT = new PropertyDescriptor.Builder().name("webhook-text").displayName("Webhook Text").description("The text sent in the webhook message").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CHANNEL = new PropertyDescriptor.Builder().name("channel").displayName("Channel").description("A public channel using #channel or direct message using @username. If not specified, the default webhook channel as specified in Slack's Incoming Webhooks web interface is used.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("username").displayName("Username").description("The displayed Slack username").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ICON_URL = new PropertyDescriptor.Builder().name("icon-url").displayName("Icon URL").description("Icon URL to be used for the message").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor ICON_EMOJI = new PropertyDescriptor.Builder().name("icon-emoji").displayName("Icon Emoji").description("Icon Emoji to be used for the message. Must begin and end with a colon, e.g. :ghost:").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator((Validator)new EmojiValidator()).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("Specifies an optional SSL Context Service that, if provided, will be used to create connections").identifiesControllerService(SSLContextService.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to success after being successfully sent to Slack").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to failure if unable to be sent to Slack").build();
    private final SortedSet<PropertyDescriptor> attachments = Collections.synchronizedSortedSet(new TreeSet());
    public static final List<PropertyDescriptor> descriptors = Collections.unmodifiableList(Arrays.asList(WEBHOOK_URL, WEBHOOK_TEXT, CHANNEL, USERNAME, ICON_URL, ICON_EMOJI, SSL_CONTEXT_SERVICE));
    public static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return descriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    private String validateChannel(String channel) {
        if ((channel.startsWith("#") || channel.startsWith("@")) && channel.length() > 1) {
            return null;
        }
        return "Channel must begin with '#' or '@'";
    }

    @OnScheduled
    public void initialize(ProcessContext context) {
        this.attachments.clear();
        for (Map.Entry property : context.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)property.getKey();
            if (!descriptor.isDynamic()) continue;
            this.attachments.add(descriptor);
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        String iconEmoji;
        String iconUrl;
        String username;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        String text = context.getProperty(WEBHOOK_TEXT).evaluateAttributeExpressions(flowFile).getValue();
        if (text == null || text.isEmpty()) {
            this.getLogger().error("FlowFile should have non-empty " + WEBHOOK_TEXT.getName());
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        builder.add("text", text);
        String channel = context.getProperty(CHANNEL).evaluateAttributeExpressions(flowFile).getValue();
        if (channel != null && !channel.isEmpty()) {
            String error = this.validateChannel(channel);
            if (error == null) {
                builder.add("channel", channel);
            } else {
                this.getLogger().error("Invalid channel '{}': {}", new Object[]{channel, error});
                flowFile = session.penalize(flowFile);
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
        }
        if ((username = context.getProperty(USERNAME).evaluateAttributeExpressions(flowFile).getValue()) != null && !username.isEmpty()) {
            builder.add("username", username);
        }
        if ((iconUrl = context.getProperty(ICON_URL).evaluateAttributeExpressions(flowFile).getValue()) != null && !iconUrl.isEmpty()) {
            builder.add("icon_url", iconUrl);
        }
        if ((iconEmoji = context.getProperty(ICON_EMOJI).evaluateAttributeExpressions(flowFile).getValue()) != null && !iconEmoji.isEmpty()) {
            builder.add("icon_emoji", iconEmoji);
        }
        SSLContextService sslService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        try {
            if (!this.attachments.isEmpty()) {
                JsonArrayBuilder jsonArrayBuiler = Json.createArrayBuilder();
                for (PropertyDescriptor attachment : this.attachments) {
                    String s = context.getProperty(attachment).evaluateAttributeExpressions(flowFile).getValue();
                    JsonReader reader = Json.createReader((Reader)new StringReader(s));
                    JsonObject attachmentJson = reader.readObject();
                    jsonArrayBuiler.add((JsonValue)attachmentJson);
                }
                builder.add("attachments", jsonArrayBuiler);
            }
            JsonObject jsonObject = builder.build();
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
            jsonWriter.writeObject(jsonObject);
            jsonWriter.close();
            URL url = URI.create(context.getProperty(WEBHOOK_URL).evaluateAttributeExpressions(flowFile).getValue()).toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            if (sslService != null) {
                SSLContext sslContext = sslService.createContext();
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslContext.getSocketFactory());
            }
            DataOutputStream outputStream = new DataOutputStream(conn.getOutputStream());
            String payload = "payload=" + URLEncoder.encode(stringWriter.getBuffer().toString(), "UTF-8");
            outputStream.writeBytes(payload);
            outputStream.close();
            int responseCode = conn.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                this.getLogger().info("Successfully posted message to Slack");
                session.transfer(flowFile, REL_SUCCESS);
                session.getProvenanceReporter().send(flowFile, url.toString());
            } else {
                this.getLogger().error("Failed to post message to Slack with response code {}", new Object[]{responseCode});
                flowFile = session.penalize(flowFile);
                session.transfer(flowFile, REL_FAILURE);
                context.yield();
            }
        }
        catch (JsonParsingException e) {
            this.getLogger().error("Failed to parse JSON", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
        catch (IOException e) {
            this.getLogger().error("Failed to open connection", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            context.yield();
        }
    }

    private static class EmojiValidator
    implements Validator {
        private EmojiValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (input.startsWith(":") && input.endsWith(":") && input.length() > 2) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
            }
            return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Must begin and end with a colon").build();
        }
    }
}

