/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.avro.Schema;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.reporting.AbstractSiteToSiteReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.s2s.SiteToSiteUtils;

@Tags(value={"status", "metrics", "history", "site", "site to site"})
@CapabilityDescription(value="Publishes Status events using the Site To Site protocol.  The component type and name filter regexes form a union: only components matching both regexes will be reported.  However, all process groups are recursively searched for matching components, regardless of whether the process group matches the component filters.")
public class SiteToSiteStatusReportingTask
extends AbstractSiteToSiteReportingTask {
    static final PropertyDescriptor PLATFORM = new PropertyDescriptor.Builder().name("Platform").description("The value to use for the platform field in each status record.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("nifi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor COMPONENT_TYPE_FILTER_REGEX = new PropertyDescriptor.Builder().name("Component Type Filter Regex").description("A regex specifying which component types to report.  Any component type matching this regex will be included.  Component types are: Processor, RootProcessGroup, ProcessGroup, RemoteProcessGroup, Connection, InputPort, OutputPort").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("(Processor|ProcessGroup|RemoteProcessGroup|RootProcessGroup|Connection|InputPort|OutputPort)").addValidator(StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true)).build();
    static final PropertyDescriptor COMPONENT_NAME_FILTER_REGEX = new PropertyDescriptor.Builder().name("Component Name Filter Regex").description("A regex specifying which component names to report.  Any component name matching this regex will be included.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue(".*").addValidator(StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true)).build();
    private volatile Pattern componentTypeFilter;
    private volatile Pattern componentNameFilter;
    private volatile Map<String, String> processGroupIDToPath;

    public SiteToSiteStatusReportingTask() throws IOException {
        InputStream schema = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("schema-status.avsc");
        this.recordSchema = AvroTypeUtil.createSchema((Schema)new Schema.Parser().parse(schema));
    }

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(PLATFORM);
        properties.add(COMPONENT_TYPE_FILTER_REGEX);
        properties.add(COMPONENT_NAME_FILTER_REGEX);
        return properties;
    }

    public void onTrigger(ReportingContext context) {
        URL url;
        boolean isClustered = context.isClustered();
        String nodeId = context.getClusterNodeIdentifier();
        if (nodeId == null && isClustered) {
            this.getLogger().debug("This instance of NiFi is configured for clustering, but the Cluster Node Identifier is not yet available. Will wait for Node Identifier to be established.");
            return;
        }
        this.componentTypeFilter = Pattern.compile(context.getProperty(COMPONENT_TYPE_FILTER_REGEX).evaluateAttributeExpressions().getValue());
        this.componentNameFilter = Pattern.compile(context.getProperty(COMPONENT_NAME_FILTER_REGEX).evaluateAttributeExpressions().getValue());
        this.processGroupIDToPath = new HashMap<String, String>();
        ProcessGroupStatus procGroupStatus = context.getEventAccess().getControllerStatus();
        String rootGroupName = procGroupStatus == null ? null : procGroupStatus.getName();
        String nifiUrl = context.getProperty(SiteToSiteUtils.INSTANCE_URL).evaluateAttributeExpressions().getValue();
        try {
            url = URI.create(nifiUrl).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new AssertionError();
        }
        String hostname = url.getHost();
        String platform = context.getProperty(PLATFORM).evaluateAttributeExpressions().getValue();
        Boolean allowNullValues = context.getProperty(ALLOW_NULL_VALUES).asBoolean();
        Map config = Collections.emptyMap();
        JsonBuilderFactory factory = Json.createBuilderFactory(config);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("Z"));
        JsonArrayBuilder arrayBuilder = factory.createArrayBuilder();
        this.serializeProcessGroupStatus(arrayBuilder, factory, procGroupStatus, df, hostname, rootGroupName, platform, null, new Date(), allowNullValues);
        JsonArray jsonArray = arrayBuilder.build();
        int batchSize = context.getProperty(SiteToSiteUtils.BATCH_SIZE).asInteger();
        int fromIndex = 0;
        int toIndex = Math.min(batchSize, jsonArray.size());
        List jsonBatch = jsonArray.subList(fromIndex, toIndex);
        while (!jsonBatch.isEmpty()) {
            Transaction transaction = null;
            try {
                this.setup((PropertyContext)context);
                long start = System.nanoTime();
                transaction = this.getClient().createTransaction(TransferDirection.SEND);
                if (transaction == null) {
                    this.getLogger().debug("All destination nodes are penalized; will attempt to send data later");
                    return;
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                String transactionId = UUID.randomUUID().toString();
                attributes.put("reporting.task.transaction.id", transactionId);
                attributes.put("reporting.task.name", this.getName());
                attributes.put("reporting.task.uuid", this.getIdentifier());
                attributes.put("reporting.task.type", ((Object)((Object)this)).getClass().getSimpleName());
                attributes.put("mime.type", "application/json");
                JsonArrayBuilder jsonBatchArrayBuilder = factory.createArrayBuilder();
                for (JsonValue jsonValue : jsonBatch) {
                    jsonBatchArrayBuilder.add(jsonValue);
                }
                JsonArray jsonBatchArray = jsonBatchArrayBuilder.build();
                this.sendData(context, transaction, attributes, jsonBatchArray);
                transaction.confirm();
                transaction.complete();
                long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                this.getLogger().info("Successfully sent {} Status Records to destination in {} ms; Transaction ID = {}", new Object[]{jsonArray.size(), transferMillis, transactionId});
                fromIndex = toIndex;
                toIndex = Math.min(fromIndex + batchSize, jsonArray.size());
                jsonBatch = jsonArray.subList(fromIndex, toIndex);
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.error();
                }
                if (e instanceof ProcessException) {
                    throw (ProcessException)e;
                }
                throw new ProcessException("Failed to send Status Records to destination due to IOException:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean componentMatchesFilters(String componentType, String componentName) {
        return this.componentTypeFilter.matcher(componentType).matches() && this.componentNameFilter.matcher(componentName).matches();
    }

    private void serializeProcessGroupStatus(JsonArrayBuilder arrayBuilder, JsonBuilderFactory factory, ProcessGroupStatus status, DateFormat df, String hostname, String applicationName, String platform, ProcessGroupStatus parent, Date currentDate, Boolean allowNullValues) {
        JsonObjectBuilder builder = factory.createObjectBuilder();
        String componentType = parent == null ? "RootProcessGroup" : "ProcessGroup";
        String componentName = status.getName();
        if (parent == null) {
            this.processGroupIDToPath.put(status.getId(), "NiFi Flow");
        }
        if (this.componentMatchesFilters(componentType, componentName)) {
            this.addCommonFields(builder, df, hostname, applicationName, platform, parent, currentDate, componentType, componentName, allowNullValues);
            this.addField(builder, "componentId", status.getId(), (boolean)allowNullValues);
            this.addField(builder, "bytesRead", status.getBytesRead(), (boolean)allowNullValues);
            this.addField(builder, "bytesWritten", status.getBytesWritten(), (boolean)allowNullValues);
            this.addField(builder, "bytesReceived", status.getBytesReceived(), (boolean)allowNullValues);
            this.addField(builder, "bytesSent", status.getBytesSent(), (boolean)allowNullValues);
            this.addField(builder, "bytesTransferred", status.getBytesTransferred(), (boolean)allowNullValues);
            this.addField(builder, "flowFilesReceived", status.getFlowFilesReceived(), (boolean)allowNullValues);
            this.addField(builder, "flowFilesSent", status.getFlowFilesSent(), (boolean)allowNullValues);
            this.addField(builder, "flowFilesTransferred", status.getFlowFilesTransferred(), (boolean)allowNullValues);
            this.addField(builder, "inputContentSize", status.getInputContentSize(), (boolean)allowNullValues);
            this.addField(builder, "inputCount", status.getInputCount(), (boolean)allowNullValues);
            this.addField(builder, "outputContentSize", status.getOutputContentSize(), (boolean)allowNullValues);
            this.addField(builder, "outputCount", status.getOutputCount(), (boolean)allowNullValues);
            this.addField(builder, "queuedContentSize", status.getQueuedContentSize(), (boolean)allowNullValues);
            this.addField(builder, "activeThreadCount", status.getActiveThreadCount(), (boolean)allowNullValues);
            this.addField(builder, "terminatedThreadCount", status.getTerminatedThreadCount(), (boolean)allowNullValues);
            this.addField(builder, "queuedCount", status.getQueuedCount(), (boolean)allowNullValues);
            this.addField(builder, "versionedFlowState", status.getVersionedFlowState() == null ? null : status.getVersionedFlowState().name(), (boolean)allowNullValues);
            arrayBuilder.add((JsonValue)builder.build());
        }
        for (ProcessGroupStatus childGroupStatus : status.getProcessGroupStatus()) {
            this.processGroupIDToPath.put(childGroupStatus.getId(), this.processGroupIDToPath.get(status.getId()) + " / " + childGroupStatus.getName());
            this.serializeProcessGroupStatus(arrayBuilder, factory, childGroupStatus, df, hostname, applicationName, platform, status, currentDate, allowNullValues);
        }
        for (ProcessorStatus processorStatus : status.getProcessorStatus()) {
            this.serializeProcessorStatus(arrayBuilder, factory, processorStatus, df, hostname, applicationName, platform, status, currentDate, allowNullValues);
        }
        for (ConnectionStatus connectionStatus : status.getConnectionStatus()) {
            this.serializeConnectionStatus(arrayBuilder, factory, connectionStatus, df, hostname, applicationName, platform, status, currentDate, allowNullValues);
        }
        for (PortStatus portStatus : status.getInputPortStatus()) {
            this.serializePortStatus("InputPort", arrayBuilder, factory, portStatus, df, hostname, applicationName, platform, status, currentDate, allowNullValues);
        }
        for (PortStatus portStatus : status.getOutputPortStatus()) {
            this.serializePortStatus("OutputPort", arrayBuilder, factory, portStatus, df, hostname, applicationName, platform, status, currentDate, allowNullValues);
        }
        for (RemoteProcessGroupStatus remoteProcessGroupStatus : status.getRemoteProcessGroupStatus()) {
            this.serializeRemoteProcessGroupStatus(arrayBuilder, factory, remoteProcessGroupStatus, df, hostname, applicationName, platform, status, currentDate, allowNullValues);
        }
    }

    private void serializeRemoteProcessGroupStatus(JsonArrayBuilder arrayBuilder, JsonBuilderFactory factory, RemoteProcessGroupStatus status, DateFormat df, String hostname, String applicationName, String platform, ProcessGroupStatus parent, Date currentDate, Boolean allowNullValues) {
        JsonObjectBuilder builder = factory.createObjectBuilder();
        String componentType = "RemoteProcessGroup";
        String componentName = status.getName();
        if (this.componentMatchesFilters("RemoteProcessGroup", componentName)) {
            this.addCommonFields(builder, df, hostname, applicationName, platform, parent, currentDate, "RemoteProcessGroup", componentName, allowNullValues);
            this.addField(builder, "componentId", status.getId(), (boolean)allowNullValues);
            this.addField(builder, "activeRemotePortCount", status.getActiveRemotePortCount(), (boolean)allowNullValues);
            this.addField(builder, "activeThreadCount", status.getActiveThreadCount(), (boolean)allowNullValues);
            this.addField(builder, "inactiveRemotePortCount", status.getInactiveRemotePortCount(), (boolean)allowNullValues);
            this.addField(builder, "receivedContentSize", status.getReceivedContentSize(), (boolean)allowNullValues);
            this.addField(builder, "receivedCount", status.getReceivedCount(), (boolean)allowNullValues);
            this.addField(builder, "sentContentSize", status.getSentContentSize(), (boolean)allowNullValues);
            this.addField(builder, "sentCount", status.getSentCount(), (boolean)allowNullValues);
            this.addField(builder, "averageLineageDuration", status.getAverageLineageDuration(), (boolean)allowNullValues);
            this.addField(builder, "transmissionStatus", status.getTransmissionStatus() == null ? null : status.getTransmissionStatus().name(), (boolean)allowNullValues);
            this.addField(builder, "targetURI", status.getTargetUri(), (boolean)allowNullValues);
            arrayBuilder.add((JsonValue)builder.build());
        }
    }

    private void serializePortStatus(String componentType, JsonArrayBuilder arrayBuilder, JsonBuilderFactory factory, PortStatus status, DateFormat df, String hostname, String applicationName, String platform, ProcessGroupStatus parent, Date currentDate, Boolean allowNullValues) {
        JsonObjectBuilder builder = factory.createObjectBuilder();
        String componentName = status.getName();
        if (this.componentMatchesFilters(componentType, componentName)) {
            this.addCommonFields(builder, df, hostname, applicationName, platform, parent, currentDate, componentType, componentName, allowNullValues);
            this.addField(builder, "componentId", status.getId(), (boolean)allowNullValues);
            this.addField(builder, "activeThreadCount", status.getActiveThreadCount(), (boolean)allowNullValues);
            this.addField(builder, "bytesReceived", status.getBytesReceived(), (boolean)allowNullValues);
            this.addField(builder, "bytesSent", status.getBytesSent(), (boolean)allowNullValues);
            this.addField(builder, "flowFilesReceived", status.getFlowFilesReceived(), (boolean)allowNullValues);
            this.addField(builder, "flowFilesSent", status.getFlowFilesSent(), (boolean)allowNullValues);
            this.addField(builder, "inputBytes", status.getInputBytes(), (boolean)allowNullValues);
            this.addField(builder, "inputCount", status.getInputCount(), (boolean)allowNullValues);
            this.addField(builder, "outputBytes", status.getOutputBytes(), (boolean)allowNullValues);
            this.addField(builder, "outputCount", status.getOutputCount(), (boolean)allowNullValues);
            this.addField(builder, "runStatus", status.getRunStatus() == null ? null : status.getRunStatus().name(), (boolean)allowNullValues);
            this.addField(builder, "transmitting", status.isTransmitting(), (boolean)allowNullValues);
            arrayBuilder.add((JsonValue)builder.build());
        }
    }

    private void serializeConnectionStatus(JsonArrayBuilder arrayBuilder, JsonBuilderFactory factory, ConnectionStatus status, DateFormat df, String hostname, String applicationName, String platform, ProcessGroupStatus parent, Date currentDate, Boolean allowNullValues) {
        JsonObjectBuilder builder = factory.createObjectBuilder();
        String componentType = "Connection";
        String componentName = status.getName();
        if (this.componentMatchesFilters("Connection", componentName)) {
            this.addCommonFields(builder, df, hostname, applicationName, platform, parent, currentDate, "Connection", componentName, allowNullValues);
            this.addField(builder, "componentId", status.getId(), (boolean)allowNullValues);
            this.addField(builder, "sourceId", status.getSourceId(), (boolean)allowNullValues);
            this.addField(builder, "sourceName", status.getSourceName(), (boolean)allowNullValues);
            this.addField(builder, "destinationId", status.getDestinationId(), (boolean)allowNullValues);
            this.addField(builder, "destinationName", status.getDestinationName(), (boolean)allowNullValues);
            this.addField(builder, "maxQueuedBytes", status.getMaxQueuedBytes(), (boolean)allowNullValues);
            this.addField(builder, "maxQueuedCount", status.getMaxQueuedCount(), (boolean)allowNullValues);
            this.addField(builder, "queuedBytes", status.getQueuedBytes(), (boolean)allowNullValues);
            this.addField(builder, "queuedCount", status.getQueuedCount(), (boolean)allowNullValues);
            this.addField(builder, "inputBytes", status.getInputBytes(), (boolean)allowNullValues);
            this.addField(builder, "inputCount", status.getInputCount(), (boolean)allowNullValues);
            this.addField(builder, "outputBytes", status.getOutputBytes(), (boolean)allowNullValues);
            this.addField(builder, "outputCount", status.getOutputCount(), (boolean)allowNullValues);
            this.addField(builder, "backPressureBytesThreshold", status.getBackPressureBytesThreshold(), (boolean)allowNullValues);
            this.addField(builder, "backPressureObjectThreshold", status.getBackPressureObjectThreshold(), (boolean)allowNullValues);
            this.addField(builder, "backPressureDataSizeThreshold", status.getBackPressureDataSizeThreshold(), (boolean)allowNullValues);
            this.addField(builder, "isBackPressureEnabled", Boolean.toString(status.getBackPressureObjectThreshold() > 0L && status.getBackPressureObjectThreshold() <= (long)status.getQueuedCount() || status.getBackPressureBytesThreshold() > 0L && status.getBackPressureBytesThreshold() <= status.getQueuedBytes()), (boolean)allowNullValues);
            arrayBuilder.add((JsonValue)builder.build());
        }
    }

    private void serializeProcessorStatus(JsonArrayBuilder arrayBuilder, JsonBuilderFactory factory, ProcessorStatus status, DateFormat df, String hostname, String applicationName, String platform, ProcessGroupStatus parent, Date currentDate, Boolean allowNullValues) {
        JsonObjectBuilder builder = factory.createObjectBuilder();
        String componentType = "Processor";
        String componentName = status.getName();
        if (this.componentMatchesFilters("Processor", componentName)) {
            this.addCommonFields(builder, df, hostname, applicationName, platform, parent, currentDate, "Processor", componentName, allowNullValues);
            this.addField(builder, "componentId", status.getId(), (boolean)allowNullValues);
            this.addField(builder, "processorType", status.getType(), (boolean)allowNullValues);
            this.addField(builder, "averageLineageDurationMS", status.getAverageLineageDuration(), (boolean)allowNullValues);
            this.addField(builder, "bytesRead", status.getBytesRead(), (boolean)allowNullValues);
            this.addField(builder, "bytesWritten", status.getBytesWritten(), (boolean)allowNullValues);
            this.addField(builder, "bytesReceived", status.getBytesReceived(), (boolean)allowNullValues);
            this.addField(builder, "bytesSent", status.getBytesSent(), (boolean)allowNullValues);
            this.addField(builder, "flowFilesRemoved", status.getFlowFilesRemoved(), (boolean)allowNullValues);
            this.addField(builder, "flowFilesReceived", status.getFlowFilesReceived(), (boolean)allowNullValues);
            this.addField(builder, "flowFilesSent", status.getFlowFilesSent(), (boolean)allowNullValues);
            this.addField(builder, "inputCount", status.getInputCount(), (boolean)allowNullValues);
            this.addField(builder, "inputBytes", status.getInputBytes(), (boolean)allowNullValues);
            this.addField(builder, "outputCount", status.getOutputCount(), (boolean)allowNullValues);
            this.addField(builder, "outputBytes", status.getOutputBytes(), (boolean)allowNullValues);
            this.addField(builder, "activeThreadCount", status.getActiveThreadCount(), (boolean)allowNullValues);
            this.addField(builder, "terminatedThreadCount", status.getTerminatedThreadCount(), (boolean)allowNullValues);
            this.addField(builder, "invocations", status.getInvocations(), (boolean)allowNullValues);
            this.addField(builder, "processingNanos", status.getProcessingNanos(), (boolean)allowNullValues);
            this.addField(builder, "runStatus", status.getRunStatus() == null ? null : status.getRunStatus().name(), (boolean)allowNullValues);
            this.addField(builder, "executionNode", status.getExecutionNode() == null ? null : status.getExecutionNode().name(), (boolean)allowNullValues);
            SiteToSiteStatusReportingTask.addField(builder, factory, "counters", status.getCounters(), allowNullValues);
            arrayBuilder.add((JsonValue)builder.build());
        }
    }

    private void addCommonFields(JsonObjectBuilder builder, DateFormat df, String hostname, String applicationName, String platform, ProcessGroupStatus parent, Date currentDate, String componentType, String componentName, Boolean allowNullValues) {
        this.addField(builder, "statusId", UUID.randomUUID().toString(), (boolean)allowNullValues);
        this.addField(builder, "timestampMillis", currentDate.getTime(), (boolean)allowNullValues);
        this.addField(builder, "timestamp", df.format(currentDate), (boolean)allowNullValues);
        this.addField(builder, "actorHostname", hostname, (boolean)allowNullValues);
        this.addField(builder, "componentType", componentType, (boolean)allowNullValues);
        this.addField(builder, "componentName", componentName, (boolean)allowNullValues);
        this.addField(builder, "parentId", parent == null ? null : parent.getId(), (boolean)allowNullValues);
        this.addField(builder, "parentName", parent == null ? null : parent.getName(), (boolean)allowNullValues);
        this.addField(builder, "parentPath", parent == null ? null : this.processGroupIDToPath.get(parent.getId()), (boolean)allowNullValues);
        this.addField(builder, "platform", platform, (boolean)allowNullValues);
        this.addField(builder, "application", applicationName, (boolean)allowNullValues);
    }

    private static void addField(JsonObjectBuilder builder, JsonBuilderFactory factory, String key, Map<String, Long> values, Boolean allowNullValues) {
        if (values != null) {
            JsonObjectBuilder mapBuilder = factory.createObjectBuilder();
            for (Map.Entry<String, Long> entry : values.entrySet()) {
                if (entry.getKey() == null) continue;
                if (entry.getValue() == null) {
                    if (!allowNullValues.booleanValue()) continue;
                    mapBuilder.add(entry.getKey(), JsonValue.NULL);
                    continue;
                }
                mapBuilder.add(entry.getKey(), entry.getValue().longValue());
            }
            builder.add(key, mapBuilder);
        } else if (allowNullValues.booleanValue()) {
            builder.add(key, JsonValue.NULL);
        }
    }
}

