/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authentication.single.user;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authentication.LoginCredentials;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authentication.LoginIdentityProviderConfigurationContext;
import org.apache.nifi.authentication.LoginIdentityProviderInitializationContext;
import org.apache.nifi.authentication.annotation.LoginIdentityProviderContext;
import org.apache.nifi.authentication.exception.InvalidLoginCredentialsException;
import org.apache.nifi.authentication.exception.ProviderCreationException;
import org.apache.nifi.authentication.single.user.SingleUserCredentials;
import org.apache.nifi.authentication.single.user.encoder.BCryptPasswordEncoder;
import org.apache.nifi.authentication.single.user.encoder.PasswordEncoder;
import org.apache.nifi.authentication.single.user.writer.LoginCredentialsWriter;
import org.apache.nifi.authentication.single.user.writer.StandardLoginCredentialsWriter;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUserLoginIdentityProvider
implements LoginIdentityProvider {
    protected static final String USERNAME_PROPERTY = "Username";
    protected static final String PASSWORD_PROPERTY = "Password";
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleUserLoginIdentityProvider.class);
    private static final Base64.Encoder RANDOM_BYTE_ENCODER = Base64.getEncoder().withoutPadding();
    private static final int RANDOM_BYTE_LENGTH = 24;
    private static final long EXPIRATION = TimeUnit.HOURS.toMillis(8L);
    protected PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    private File loginIdentityProviderConfigurationFile;
    private SingleUserCredentials configuredCredentials;

    @LoginIdentityProviderContext
    public void setProperties(NiFiProperties niFiProperties) {
        this.loginIdentityProviderConfigurationFile = niFiProperties.getLoginIdentityProviderConfigurationFile();
    }

    public AuthenticationResponse authenticate(LoginCredentials credentials) throws InvalidLoginCredentialsException {
        String password = credentials.getPassword();
        if (this.isPasswordVerified(password)) {
            String username = credentials.getUsername();
            if (this.isUsernameVerified(username)) {
                return new AuthenticationResponse(username, username, EXPIRATION, this.getClass().getSimpleName());
            }
            throw new InvalidLoginCredentialsException("Username verification failed");
        }
        throw new InvalidLoginCredentialsException("Password verification failed");
    }

    public void initialize(LoginIdentityProviderInitializationContext initializationContext) {
        LOGGER.debug("Initializing Provider");
    }

    public void onConfigured(LoginIdentityProviderConfigurationContext configurationContext) throws ProviderCreationException {
        LOGGER.debug("Configuring Provider");
        String password = configurationContext.getProperty(PASSWORD_PROPERTY);
        if (password == null || password.length() == 0) {
            try {
                this.configuredCredentials = this.generateLoginCredentials();
                LOGGER.info("Updating Login Identity Providers Configuration [{}]", (Object)this.loginIdentityProviderConfigurationFile);
                LoginCredentialsWriter loginCredentialsWriter = this.getLoginCredentialsWriter();
                loginCredentialsWriter.writeLoginCredentials(this.configuredCredentials);
            }
            catch (IOException e) {
                throw new ProviderCreationException("Generating Login Credentials Failed", (Throwable)e);
            }
        } else {
            String username = configurationContext.getProperty(USERNAME_PROPERTY);
            this.configuredCredentials = new SingleUserCredentials(username, password, this.getClass().getName());
        }
    }

    public void preDestruction() {
        LOGGER.debug("Destroying Provider");
    }

    protected String generatePassword() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[24];
        secureRandom.nextBytes(bytes);
        return RANDOM_BYTE_ENCODER.encodeToString(bytes);
    }

    private LoginCredentialsWriter getLoginCredentialsWriter() {
        return new StandardLoginCredentialsWriter(this.loginIdentityProviderConfigurationFile);
    }

    private SingleUserCredentials generateLoginCredentials() throws IOException {
        String username = UUID.randomUUID().toString();
        String password = this.generatePassword();
        String separator = System.lineSeparator();
        LOGGER.info("{}{}Generated Username [{}]{}Generated Password [{}]{}", new Object[]{separator, separator, username, separator, password, separator});
        LOGGER.info("Run the following command to change credentials: nifi.sh set-single-user-credentials USERNAME PASSWORD");
        String hashedPassword = this.passwordEncoder.encode(password.toCharArray());
        return new SingleUserCredentials(username, hashedPassword, this.getClass().getName());
    }

    private boolean isPasswordVerified(String password) {
        return this.passwordEncoder.matches(password.toCharArray(), this.configuredCredentials.getPassword());
    }

    private boolean isUsernameVerified(String username) {
        return this.configuredCredentials.getUsername().equals(username);
    }
}

