/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import at.favre.lib.crypto.bcrypt.BCrypt;
import at.favre.lib.crypto.bcrypt.Radix64Encoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.nifi.security.util.crypto.AbstractSecureHasher;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.bouncycastle.shaded.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcryptSecureHasher
extends AbstractSecureHasher {
    private static final Logger logger = LoggerFactory.getLogger(BcryptSecureHasher.class);
    private static final int DEFAULT_COST = 12;
    private static final int DEFAULT_SALT_LENGTH = 16;
    private static final int MIN_COST = 4;
    private static final int MAX_COST = 31;
    private static final int MIN_SALT_LENGTH = 16;
    private final int cost;

    public BcryptSecureHasher() {
        this(12, 0);
    }

    public BcryptSecureHasher(int cost) {
        this(cost, 0);
    }

    public BcryptSecureHasher(int cost, int saltLength) {
        this.validateParameters(cost, saltLength);
        this.cost = cost;
        this.saltLength = saltLength;
    }

    private void validateParameters(Integer cost, Integer saltLength) {
        if (!BcryptSecureHasher.isCostValid(cost)) {
            logger.error("The provided cost factor {} is outside the boundary of 4 to 31.", (Object)cost);
            throw new IllegalArgumentException("Invalid cost is not within the cost factor boundary.");
        }
        this.initializeSalt(saltLength);
    }

    public static boolean isCostValid(Integer cost) {
        if (cost < 12) {
            logger.warn("The provided cost factor {} is below the recommended minimum {}.", (Object)cost, (Object)12);
        }
        return cost >= 4 && cost <= 31;
    }

    public static String convertBcryptRadix64ToMimeBase64(String radix64) {
        return CipherUtility.encodeBase64NoPadding(new Radix64Encoder.Default().decode(radix64.getBytes(StandardCharsets.UTF_8)));
    }

    public static String convertMimeBase64ToBcryptRadix64(String base64) {
        return new String(new Radix64Encoder.Default().encode(Base64.decodeBase64((String)base64)), StandardCharsets.UTF_8);
    }

    @Override
    int getDefaultSaltLength() {
        return 16;
    }

    @Override
    int getMinSaltLength() {
        return 16;
    }

    @Override
    int getMaxSaltLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    String getAlgorithmName() {
        return "Bcrypt";
    }

    @Override
    boolean acceptsEmptyInput() {
        return false;
    }

    @Override
    byte[] hash(byte[] input) {
        byte[] rawSalt = this.getSalt();
        return this.hash(input, rawSalt);
    }

    @Override
    byte[] hash(byte[] input, byte[] rawSalt) {
        logger.debug("Creating Bcrypt hash with salt [{}] ({} bytes)", (Object)Hex.toHexString((byte[])rawSalt), (Object)rawSalt.length);
        if (!this.isSaltLengthValid(rawSalt.length)) {
            throw new IllegalArgumentException("The salt length (" + rawSalt.length + " bytes) is invalid");
        }
        long startNanos = System.nanoTime();
        byte[] hash = BCrypt.withDefaults().hash(this.cost, rawSalt, input);
        long generateNanos = System.nanoTime();
        long totalDurationMillis = TimeUnit.NANOSECONDS.toMillis(generateNanos - startNanos);
        logger.debug("Generated Bcrypt hash in {} ms", (Object)totalDurationMillis);
        return hash;
    }
}

