/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key.detection;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.security.crypto.key.DerivedKey;
import org.apache.nifi.security.crypto.key.DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.DerivedKeyProvider;
import org.apache.nifi.security.crypto.key.DerivedKeySpec;
import org.apache.nifi.security.crypto.key.argon2.Argon2DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.argon2.Argon2DerivedKeyProvider;
import org.apache.nifi.security.crypto.key.bcrypt.BcryptDerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.bcrypt.BcryptDerivedKeyProvider;
import org.apache.nifi.security.crypto.key.pbkdf2.Pbkdf2DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.pbkdf2.Pbkdf2DerivedKeyProvider;
import org.apache.nifi.security.crypto.key.scrypt.ScryptDerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.scrypt.ScryptDerivedKeyProvider;

public class DetectedDerivedKeyProvider
implements DerivedKeyProvider<DerivedKeyParameterSpec> {
    private static final Map<Class<? extends DerivedKeyParameterSpec>, DerivedKeyProvider<? extends DerivedKeyParameterSpec>> providers = new LinkedHashMap<Class<? extends DerivedKeyParameterSpec>, DerivedKeyProvider<? extends DerivedKeyParameterSpec>>();

    @Override
    public DerivedKey getDerivedKey(DerivedKeySpec<DerivedKeyParameterSpec> derivedKeySpec) {
        Objects.requireNonNull(derivedKeySpec, "Specification required");
        Class<?> parameterSpecClass = derivedKeySpec.getParameterSpec().getClass();
        DerivedKeyProvider<DerivedKeyParameterSpec> derivedKeyProvider = this.findProvider(parameterSpecClass);
        return derivedKeyProvider.getDerivedKey(derivedKeySpec);
    }

    private DerivedKeyProvider<DerivedKeyParameterSpec> findProvider(Class<? extends DerivedKeyParameterSpec> parameterSpecClass) {
        Class foundSpecClass = providers.keySet().stream().filter(specClass -> specClass.isAssignableFrom(parameterSpecClass)).findFirst().orElseThrow(() -> new UnsupportedOperationException(String.format("Parameter Specification [%s] not supported", parameterSpecClass)));
        DerivedKeyProvider<DerivedKeyParameterSpec> derivedKeyProvider = providers.get(foundSpecClass);
        return derivedKeyProvider;
    }

    static {
        providers.put(Argon2DerivedKeyParameterSpec.class, new Argon2DerivedKeyProvider());
        providers.put(BcryptDerivedKeyParameterSpec.class, new BcryptDerivedKeyProvider());
        providers.put(ScryptDerivedKeyParameterSpec.class, new ScryptDerivedKeyProvider());
        providers.put(Pbkdf2DerivedKeyParameterSpec.class, new Pbkdf2DerivedKeyProvider());
    }
}

